/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm.syscall;

import com.oracle.truffle.api.dsl.CachedLanguage;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.memory.LLVMSyscallOperationNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

public abstract class LLVMAMD64SyscallMmapNode
extends LLVMSyscallOperationNode {
    private final ConditionProfile mapAnonymousProfile = ConditionProfile.createCountingProfile();

    @Override
    public final String getName() {
        return "mmap";
    }

    @Specialization
    protected long doOp(LLVMNativePointer addr, long len, long prot, long flags, long fildes, long off, @CachedLanguage LLVMLanguage language) {
        if (this.mapAnonymousProfile.profile((flags & 0x20L) != 0L)) {
            LLVMNativePointer ptr = language.getLLVMMemory().allocateMemory(this, len);
            return ptr.asNative();
        }
        return -12L;
    }

    @Specialization
    protected long doOp(long addr, long len, long prot, long flags, long fildes, long off) {
        return this.execute(LLVMNativePointer.create(addr), len, prot, flags, fildes, off);
    }
}

