/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm.syscall;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedContext;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.IntValueProfile;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.memory.LLVMSyscallOperationNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMPointerStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMPointerStoreNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public abstract class LLVMAMD64SyscallArchPrctlNode
extends LLVMSyscallOperationNode {
    private final IntValueProfile profile = IntValueProfile.createIdentityProfile();

    @Override
    public final String getName() {
        return "arch_prctl";
    }

    @Specialization
    protected long doOp(long code, long addr, @CachedContext(value=LLVMLanguage.class) LLVMContext context, @Cached(value="createAddressStoreNode()") LLVMPointerStoreNode store) {
        return this.exec(code, addr, context, store);
    }

    @Specialization
    protected long doOp(long code, LLVMPointer addr, @CachedContext(value=LLVMLanguage.class) LLVMContext context, @Cached(value="createAddressStoreNode()") LLVMPointerStoreNode store) {
        return this.exec(code, addr, context, store);
    }

    protected LLVMPointerStoreNode createAddressStoreNode() {
        CompilerAsserts.neverPartOfCompilation();
        return LLVMPointerStoreNodeGen.create(null, null);
    }

    private long exec(long code, Object addr, LLVMContext context, LLVMPointerStoreNode store) throws AssertionError {
        switch (this.profile.profile((int)code)) {
            case 4098: {
                context.setThreadLocalStorage(addr);
                break;
            }
            case 4099: {
                Object tls = context.getThreadLocalStorage();
                store.executeWithTarget(addr, tls);
                break;
            }
            default: {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError((Object)String.format("not implemented: arch_prcntl(0x%04x)", code));
            }
        }
        return 0L;
    }
}

