/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm.support;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64ToRegisterNode;

@GeneratedBy(value=LLVMAMD64ToRegisterNode.class)
public final class LLVMAMD64ToRegisterNodeFactory {

    @GeneratedBy(value=LLVMAMD64ToRegisterNode.LLVMI32ToR64.class)
    public static final class LLVMI32ToR64NodeGen
    extends LLVMAMD64ToRegisterNode.LLVMI32ToR64 {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode from_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMI32ToR64NodeGen(LLVMExpressionNode from) {
            this.from_ = from;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 0xE) == 0 && state != 0) {
                return this.executeGeneric_byte0(frameValue, state);
            }
            if ((state & 0xD) == 0 && state != 0) {
                return this.executeGeneric_short1(frameValue, state);
            }
            if ((state & 0xB) == 0 && state != 0) {
                return this.executeGeneric_int2(frameValue, state);
            }
            if ((state & 7) == 0 && state != 0) {
                return this.executeGeneric_long3(frameValue, state);
            }
            return this.executeGeneric_generic4(frameValue, state);
        }

        private Object executeGeneric_byte0(VirtualFrame frameValue, int state) {
            byte fromValue_;
            try {
                fromValue_ = this.from_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 1) != 0);
            return this.doI64(fromValue_);
        }

        private Object executeGeneric_short1(VirtualFrame frameValue, int state) {
            short fromValue_;
            try {
                fromValue_ = this.from_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.doI64(fromValue_);
        }

        private Object executeGeneric_int2(VirtualFrame frameValue, int state) {
            int fromValue_;
            try {
                fromValue_ = this.from_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 4) != 0);
            return this.doI64(fromValue_);
        }

        private Object executeGeneric_long3(VirtualFrame frameValue, int state) {
            long fromValue_;
            try {
                fromValue_ = this.from_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 8) != 0);
            return this.doI64(fromValue_);
        }

        private Object executeGeneric_generic4(VirtualFrame frameValue, int state) {
            Object fromValue_ = this.from_.executeGeneric(frameValue);
            if ((state & 1) != 0 && fromValue_ instanceof Byte) {
                byte fromValue__ = (Byte)fromValue_;
                return this.doI64(fromValue__);
            }
            if ((state & 2) != 0 && fromValue_ instanceof Short) {
                short fromValue__ = (Short)fromValue_;
                return this.doI64(fromValue__);
            }
            if ((state & 4) != 0 && fromValue_ instanceof Integer) {
                int fromValue__ = (Integer)fromValue_;
                return this.doI64(fromValue__);
            }
            if ((state & 8) != 0 && fromValue_ instanceof Long) {
                long fromValue__ = (Long)fromValue_;
                return this.doI64(fromValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromValue_);
        }

        @Override
        public long executeI64(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 0xE) == 0 && state != 0) {
                return this.executeI64_byte5(frameValue, state);
            }
            if ((state & 0xD) == 0 && state != 0) {
                return this.executeI64_short6(frameValue, state);
            }
            if ((state & 0xB) == 0 && state != 0) {
                return this.executeI64_int7(frameValue, state);
            }
            if ((state & 7) == 0 && state != 0) {
                return this.executeI64_long8(frameValue, state);
            }
            return this.executeI64_generic9(frameValue, state);
        }

        private long executeI64_byte5(VirtualFrame frameValue, int state) {
            byte fromValue_;
            try {
                fromValue_ = this.from_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 1) != 0);
            return this.doI64(fromValue_);
        }

        private long executeI64_short6(VirtualFrame frameValue, int state) {
            short fromValue_;
            try {
                fromValue_ = this.from_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.doI64(fromValue_);
        }

        private long executeI64_int7(VirtualFrame frameValue, int state) {
            int fromValue_;
            try {
                fromValue_ = this.from_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 4) != 0);
            return this.doI64(fromValue_);
        }

        private long executeI64_long8(VirtualFrame frameValue, int state) {
            long fromValue_;
            try {
                fromValue_ = this.from_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 8) != 0);
            return this.doI64(fromValue_);
        }

        private long executeI64_generic9(VirtualFrame frameValue, int state) {
            Object fromValue_ = this.from_.executeGeneric(frameValue);
            if ((state & 1) != 0 && fromValue_ instanceof Byte) {
                byte fromValue__ = (Byte)fromValue_;
                return this.doI64(fromValue__);
            }
            if ((state & 2) != 0 && fromValue_ instanceof Short) {
                short fromValue__ = (Short)fromValue_;
                return this.doI64(fromValue__);
            }
            if ((state & 4) != 0 && fromValue_ instanceof Integer) {
                int fromValue__ = (Integer)fromValue_;
                return this.doI64(fromValue__);
            }
            if ((state & 8) != 0 && fromValue_ instanceof Long) {
                long fromValue__ = (Long)fromValue_;
                return this.doI64(fromValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromValue_);
        }

        private long executeAndSpecialize(Object fromValue) {
            int state = this.state_;
            if (fromValue instanceof Byte) {
                byte fromValue_ = (Byte)fromValue;
                this.state_ = state |= 1;
                return this.doI64(fromValue_);
            }
            if (fromValue instanceof Short) {
                short fromValue_ = (Short)fromValue;
                this.state_ = state |= 2;
                return this.doI64(fromValue_);
            }
            if (fromValue instanceof Integer) {
                int fromValue_ = (Integer)fromValue;
                this.state_ = state |= 4;
                return this.doI64(fromValue_);
            }
            if (fromValue instanceof Long) {
                long fromValue_ = (Long)fromValue;
                this.state_ = state |= 8;
                return this.doI64(fromValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.from_}, new Object[]{fromValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMAMD64ToRegisterNode.LLVMI32ToR64 create(LLVMExpressionNode from) {
            return new LLVMI32ToR64NodeGen(from);
        }
    }

    @GeneratedBy(value=LLVMAMD64ToRegisterNode.LLVMI16ToR64.class)
    public static final class LLVMI16ToR64NodeGen
    extends LLVMAMD64ToRegisterNode.LLVMI16ToR64 {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode reg_;
        @Node.Child
        private LLVMExpressionNode from_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMI16ToR64NodeGen(LLVMExpressionNode reg, LLVMExpressionNode from) {
            this.reg_ = reg;
            this.from_ = from;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            long regValue_;
            int state = this.state_;
            try {
                regValue_ = this.reg_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object fromValue = this.from_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), fromValue);
            }
            if ((state & 0xE) == 0 && state != 0) {
                return this.executeGeneric_byte0(frameValue, state, regValue_);
            }
            if ((state & 0xD) == 0 && state != 0) {
                return this.executeGeneric_short1(frameValue, state, regValue_);
            }
            if ((state & 0xB) == 0 && state != 0) {
                return this.executeGeneric_int2(frameValue, state, regValue_);
            }
            if ((state & 7) == 0 && state != 0) {
                return this.executeGeneric_long3(frameValue, state, regValue_);
            }
            return this.executeGeneric_generic4(frameValue, state, regValue_);
        }

        private Object executeGeneric_byte0(VirtualFrame frameValue, int state, long regValue_) {
            byte fromValue_;
            try {
                fromValue_ = this.from_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(regValue_, ex.getResult());
            }
            assert ((state & 1) != 0);
            return this.doI64(regValue_, fromValue_);
        }

        private Object executeGeneric_short1(VirtualFrame frameValue, int state, long regValue_) {
            short fromValue_;
            try {
                fromValue_ = this.from_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(regValue_, ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.doI64(regValue_, fromValue_);
        }

        private Object executeGeneric_int2(VirtualFrame frameValue, int state, long regValue_) {
            int fromValue_;
            try {
                fromValue_ = this.from_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(regValue_, ex.getResult());
            }
            assert ((state & 4) != 0);
            return this.doI64(regValue_, fromValue_);
        }

        private Object executeGeneric_long3(VirtualFrame frameValue, int state, long regValue_) {
            long fromValue_;
            try {
                fromValue_ = this.from_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(regValue_, ex.getResult());
            }
            assert ((state & 8) != 0);
            return this.doI64(regValue_, fromValue_);
        }

        private Object executeGeneric_generic4(VirtualFrame frameValue, int state, long regValue_) {
            Object fromValue_ = this.from_.executeGeneric(frameValue);
            if ((state & 1) != 0 && fromValue_ instanceof Byte) {
                byte fromValue__ = (Byte)fromValue_;
                return this.doI64(regValue_, fromValue__);
            }
            if ((state & 2) != 0 && fromValue_ instanceof Short) {
                short fromValue__ = (Short)fromValue_;
                return this.doI64(regValue_, fromValue__);
            }
            if ((state & 4) != 0 && fromValue_ instanceof Integer) {
                int fromValue__ = (Integer)fromValue_;
                return this.doI64(regValue_, fromValue__);
            }
            if ((state & 8) != 0 && fromValue_ instanceof Long) {
                long fromValue__ = (Long)fromValue_;
                return this.doI64(regValue_, fromValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(regValue_, fromValue_);
        }

        @Override
        public long executeI64(VirtualFrame frameValue) {
            long regValue_;
            int state = this.state_;
            try {
                regValue_ = this.reg_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object fromValue = this.from_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), fromValue);
            }
            if ((state & 0xE) == 0 && state != 0) {
                return this.executeI64_byte5(frameValue, state, regValue_);
            }
            if ((state & 0xD) == 0 && state != 0) {
                return this.executeI64_short6(frameValue, state, regValue_);
            }
            if ((state & 0xB) == 0 && state != 0) {
                return this.executeI64_int7(frameValue, state, regValue_);
            }
            if ((state & 7) == 0 && state != 0) {
                return this.executeI64_long8(frameValue, state, regValue_);
            }
            return this.executeI64_generic9(frameValue, state, regValue_);
        }

        private long executeI64_byte5(VirtualFrame frameValue, int state, long regValue_) {
            byte fromValue_;
            try {
                fromValue_ = this.from_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(regValue_, ex.getResult());
            }
            assert ((state & 1) != 0);
            return this.doI64(regValue_, fromValue_);
        }

        private long executeI64_short6(VirtualFrame frameValue, int state, long regValue_) {
            short fromValue_;
            try {
                fromValue_ = this.from_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(regValue_, ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.doI64(regValue_, fromValue_);
        }

        private long executeI64_int7(VirtualFrame frameValue, int state, long regValue_) {
            int fromValue_;
            try {
                fromValue_ = this.from_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(regValue_, ex.getResult());
            }
            assert ((state & 4) != 0);
            return this.doI64(regValue_, fromValue_);
        }

        private long executeI64_long8(VirtualFrame frameValue, int state, long regValue_) {
            long fromValue_;
            try {
                fromValue_ = this.from_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(regValue_, ex.getResult());
            }
            assert ((state & 8) != 0);
            return this.doI64(regValue_, fromValue_);
        }

        private long executeI64_generic9(VirtualFrame frameValue, int state, long regValue_) {
            Object fromValue_ = this.from_.executeGeneric(frameValue);
            if ((state & 1) != 0 && fromValue_ instanceof Byte) {
                byte fromValue__ = (Byte)fromValue_;
                return this.doI64(regValue_, fromValue__);
            }
            if ((state & 2) != 0 && fromValue_ instanceof Short) {
                short fromValue__ = (Short)fromValue_;
                return this.doI64(regValue_, fromValue__);
            }
            if ((state & 4) != 0 && fromValue_ instanceof Integer) {
                int fromValue__ = (Integer)fromValue_;
                return this.doI64(regValue_, fromValue__);
            }
            if ((state & 8) != 0 && fromValue_ instanceof Long) {
                long fromValue__ = (Long)fromValue_;
                return this.doI64(regValue_, fromValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(regValue_, fromValue_);
        }

        private long executeAndSpecialize(Object regValue, Object fromValue) {
            int state = this.state_;
            if (regValue instanceof Long) {
                long regValue_ = (Long)regValue;
                if (fromValue instanceof Byte) {
                    byte fromValue_ = (Byte)fromValue;
                    this.state_ = state |= 1;
                    return this.doI64(regValue_, fromValue_);
                }
                if (fromValue instanceof Short) {
                    short fromValue_ = (Short)fromValue;
                    this.state_ = state |= 2;
                    return this.doI64(regValue_, fromValue_);
                }
                if (fromValue instanceof Integer) {
                    int fromValue_ = (Integer)fromValue;
                    this.state_ = state |= 4;
                    return this.doI64(regValue_, fromValue_);
                }
                if (fromValue instanceof Long) {
                    long fromValue_ = (Long)fromValue;
                    this.state_ = state |= 8;
                    return this.doI64(regValue_, fromValue_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.reg_, this.from_}, new Object[]{regValue, fromValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMAMD64ToRegisterNode.LLVMI16ToR64 create(LLVMExpressionNode reg, LLVMExpressionNode from) {
            return new LLVMI16ToR64NodeGen(reg, from);
        }
    }

    @GeneratedBy(value=LLVMAMD64ToRegisterNode.LLVMI8ToR64.class)
    public static final class LLVMI8ToR64NodeGen
    extends LLVMAMD64ToRegisterNode.LLVMI8ToR64 {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode reg_;
        @Node.Child
        private LLVMExpressionNode from_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMI8ToR64NodeGen(int shift, LLVMExpressionNode reg, LLVMExpressionNode from) {
            super(shift);
            this.reg_ = reg;
            this.from_ = from;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            long regValue_;
            int state = this.state_;
            try {
                regValue_ = this.reg_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object fromValue = this.from_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), fromValue);
            }
            if ((state & 0xE) == 0 && state != 0) {
                return this.executeGeneric_byte0(frameValue, state, regValue_);
            }
            if ((state & 0xD) == 0 && state != 0) {
                return this.executeGeneric_short1(frameValue, state, regValue_);
            }
            if ((state & 0xB) == 0 && state != 0) {
                return this.executeGeneric_int2(frameValue, state, regValue_);
            }
            if ((state & 7) == 0 && state != 0) {
                return this.executeGeneric_long3(frameValue, state, regValue_);
            }
            return this.executeGeneric_generic4(frameValue, state, regValue_);
        }

        private Object executeGeneric_byte0(VirtualFrame frameValue, int state, long regValue_) {
            byte fromValue_;
            try {
                fromValue_ = this.from_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(regValue_, ex.getResult());
            }
            assert ((state & 1) != 0);
            return this.doI64(regValue_, fromValue_);
        }

        private Object executeGeneric_short1(VirtualFrame frameValue, int state, long regValue_) {
            short fromValue_;
            try {
                fromValue_ = this.from_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(regValue_, ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.doI64(regValue_, fromValue_);
        }

        private Object executeGeneric_int2(VirtualFrame frameValue, int state, long regValue_) {
            int fromValue_;
            try {
                fromValue_ = this.from_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(regValue_, ex.getResult());
            }
            assert ((state & 4) != 0);
            return this.doI64(regValue_, fromValue_);
        }

        private Object executeGeneric_long3(VirtualFrame frameValue, int state, long regValue_) {
            long fromValue_;
            try {
                fromValue_ = this.from_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(regValue_, ex.getResult());
            }
            assert ((state & 8) != 0);
            return this.doI64(regValue_, fromValue_);
        }

        private Object executeGeneric_generic4(VirtualFrame frameValue, int state, long regValue_) {
            Object fromValue_ = this.from_.executeGeneric(frameValue);
            if ((state & 1) != 0 && fromValue_ instanceof Byte) {
                byte fromValue__ = (Byte)fromValue_;
                return this.doI64(regValue_, fromValue__);
            }
            if ((state & 2) != 0 && fromValue_ instanceof Short) {
                short fromValue__ = (Short)fromValue_;
                return this.doI64(regValue_, fromValue__);
            }
            if ((state & 4) != 0 && fromValue_ instanceof Integer) {
                int fromValue__ = (Integer)fromValue_;
                return this.doI64(regValue_, fromValue__);
            }
            if ((state & 8) != 0 && fromValue_ instanceof Long) {
                long fromValue__ = (Long)fromValue_;
                return this.doI64(regValue_, fromValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(regValue_, fromValue_);
        }

        @Override
        public long executeI64(VirtualFrame frameValue) {
            long regValue_;
            int state = this.state_;
            try {
                regValue_ = this.reg_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object fromValue = this.from_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), fromValue);
            }
            if ((state & 0xE) == 0 && state != 0) {
                return this.executeI64_byte5(frameValue, state, regValue_);
            }
            if ((state & 0xD) == 0 && state != 0) {
                return this.executeI64_short6(frameValue, state, regValue_);
            }
            if ((state & 0xB) == 0 && state != 0) {
                return this.executeI64_int7(frameValue, state, regValue_);
            }
            if ((state & 7) == 0 && state != 0) {
                return this.executeI64_long8(frameValue, state, regValue_);
            }
            return this.executeI64_generic9(frameValue, state, regValue_);
        }

        private long executeI64_byte5(VirtualFrame frameValue, int state, long regValue_) {
            byte fromValue_;
            try {
                fromValue_ = this.from_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(regValue_, ex.getResult());
            }
            assert ((state & 1) != 0);
            return this.doI64(regValue_, fromValue_);
        }

        private long executeI64_short6(VirtualFrame frameValue, int state, long regValue_) {
            short fromValue_;
            try {
                fromValue_ = this.from_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(regValue_, ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.doI64(regValue_, fromValue_);
        }

        private long executeI64_int7(VirtualFrame frameValue, int state, long regValue_) {
            int fromValue_;
            try {
                fromValue_ = this.from_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(regValue_, ex.getResult());
            }
            assert ((state & 4) != 0);
            return this.doI64(regValue_, fromValue_);
        }

        private long executeI64_long8(VirtualFrame frameValue, int state, long regValue_) {
            long fromValue_;
            try {
                fromValue_ = this.from_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(regValue_, ex.getResult());
            }
            assert ((state & 8) != 0);
            return this.doI64(regValue_, fromValue_);
        }

        private long executeI64_generic9(VirtualFrame frameValue, int state, long regValue_) {
            Object fromValue_ = this.from_.executeGeneric(frameValue);
            if ((state & 1) != 0 && fromValue_ instanceof Byte) {
                byte fromValue__ = (Byte)fromValue_;
                return this.doI64(regValue_, fromValue__);
            }
            if ((state & 2) != 0 && fromValue_ instanceof Short) {
                short fromValue__ = (Short)fromValue_;
                return this.doI64(regValue_, fromValue__);
            }
            if ((state & 4) != 0 && fromValue_ instanceof Integer) {
                int fromValue__ = (Integer)fromValue_;
                return this.doI64(regValue_, fromValue__);
            }
            if ((state & 8) != 0 && fromValue_ instanceof Long) {
                long fromValue__ = (Long)fromValue_;
                return this.doI64(regValue_, fromValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(regValue_, fromValue_);
        }

        private long executeAndSpecialize(Object regValue, Object fromValue) {
            int state = this.state_;
            if (regValue instanceof Long) {
                long regValue_ = (Long)regValue;
                if (fromValue instanceof Byte) {
                    byte fromValue_ = (Byte)fromValue;
                    this.state_ = state |= 1;
                    return this.doI64(regValue_, fromValue_);
                }
                if (fromValue instanceof Short) {
                    short fromValue_ = (Short)fromValue;
                    this.state_ = state |= 2;
                    return this.doI64(regValue_, fromValue_);
                }
                if (fromValue instanceof Integer) {
                    int fromValue_ = (Integer)fromValue;
                    this.state_ = state |= 4;
                    return this.doI64(regValue_, fromValue_);
                }
                if (fromValue instanceof Long) {
                    long fromValue_ = (Long)fromValue;
                    this.state_ = state |= 8;
                    return this.doI64(regValue_, fromValue_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.reg_, this.from_}, new Object[]{regValue, fromValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMAMD64ToRegisterNode.LLVMI8ToR64 create(int shift, LLVMExpressionNode reg, LLVMExpressionNode from) {
            return new LLVMI8ToR64NodeGen(shift, reg, from);
        }
    }
}

