/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64XaddNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64UpdateFlagsNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64WriteTupelNode;

@GeneratedBy(value=LLVMAMD64XaddNode.class)
public final class LLVMAMD64XaddNodeFactory {

    @GeneratedBy(value=LLVMAMD64XaddNode.LLVMAMD64XaddqNode.class)
    public static final class LLVMAMD64XaddqNodeGen
    extends LLVMAMD64XaddNode.LLVMAMD64XaddqNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMAMD64XaddqNodeGen(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdateCPZSOFlagsNode flags, LLVMAMD64WriteTupelNode out, LLVMExpressionNode left, LLVMExpressionNode right) {
            super(flags, out);
            this.left_ = left;
            this.right_ = right;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            long rightValue_;
            long leftValue_;
            int state = this.state_;
            try {
                leftValue_ = this.left_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                this.executeAndSpecialize(frameValue, ex.getResult(), rightValue);
                return;
            }
            try {
                rightValue_ = this.right_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                this.executeAndSpecialize(frameValue, leftValue_, ex.getResult());
                return;
            }
            if (state != 0) {
                this.doOp(frameValue, leftValue_, rightValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, leftValue_, rightValue_);
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object leftValue, Object rightValue) {
            int state = this.state_;
            if (leftValue instanceof Long) {
                long leftValue_ = (Long)leftValue;
                if (rightValue instanceof Long) {
                    long rightValue_ = (Long)rightValue;
                    this.state_ = state |= 1;
                    this.doOp(frameValue, leftValue_, rightValue_);
                    return;
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_}, new Object[]{leftValue, rightValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMAMD64XaddNode.LLVMAMD64XaddqNode create(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdateCPZSOFlagsNode flags, LLVMAMD64WriteTupelNode out, LLVMExpressionNode left, LLVMExpressionNode right) {
            return new LLVMAMD64XaddqNodeGen(flags, out, left, right);
        }
    }

    @GeneratedBy(value=LLVMAMD64XaddNode.LLVMAMD64XaddlNode.class)
    public static final class LLVMAMD64XaddlNodeGen
    extends LLVMAMD64XaddNode.LLVMAMD64XaddlNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMAMD64XaddlNodeGen(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdateCPZSOFlagsNode flags, LLVMAMD64WriteTupelNode out, LLVMExpressionNode left, LLVMExpressionNode right) {
            super(flags, out);
            this.left_ = left;
            this.right_ = right;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            int rightValue_;
            int leftValue_;
            int state = this.state_;
            try {
                leftValue_ = this.left_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                this.executeAndSpecialize(frameValue, ex.getResult(), rightValue);
                return;
            }
            try {
                rightValue_ = this.right_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                this.executeAndSpecialize(frameValue, leftValue_, ex.getResult());
                return;
            }
            if (state != 0) {
                this.doOp(frameValue, leftValue_, rightValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, leftValue_, rightValue_);
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object leftValue, Object rightValue) {
            int state = this.state_;
            if (leftValue instanceof Integer) {
                int leftValue_ = (Integer)leftValue;
                if (rightValue instanceof Integer) {
                    int rightValue_ = (Integer)rightValue;
                    this.state_ = state |= 1;
                    this.doOp(frameValue, leftValue_, rightValue_);
                    return;
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_}, new Object[]{leftValue, rightValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMAMD64XaddNode.LLVMAMD64XaddlNode create(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdateCPZSOFlagsNode flags, LLVMAMD64WriteTupelNode out, LLVMExpressionNode left, LLVMExpressionNode right) {
            return new LLVMAMD64XaddlNodeGen(flags, out, left, right);
        }
    }

    @GeneratedBy(value=LLVMAMD64XaddNode.LLVMAMD64XaddwNode.class)
    public static final class LLVMAMD64XaddwNodeGen
    extends LLVMAMD64XaddNode.LLVMAMD64XaddwNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMAMD64XaddwNodeGen(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdateCPZSOFlagsNode flags, LLVMAMD64WriteTupelNode out, LLVMExpressionNode left, LLVMExpressionNode right) {
            super(flags, out);
            this.left_ = left;
            this.right_ = right;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            short rightValue_;
            short leftValue_;
            int state = this.state_;
            try {
                leftValue_ = this.left_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                this.executeAndSpecialize(frameValue, ex.getResult(), rightValue);
                return;
            }
            try {
                rightValue_ = this.right_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                this.executeAndSpecialize(frameValue, leftValue_, ex.getResult());
                return;
            }
            if (state != 0) {
                this.doOp(frameValue, leftValue_, rightValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, leftValue_, rightValue_);
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object leftValue, Object rightValue) {
            int state = this.state_;
            if (leftValue instanceof Short) {
                short leftValue_ = (Short)leftValue;
                if (rightValue instanceof Short) {
                    short rightValue_ = (Short)rightValue;
                    this.state_ = state |= 1;
                    this.doOp(frameValue, leftValue_, rightValue_);
                    return;
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_}, new Object[]{leftValue, rightValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMAMD64XaddNode.LLVMAMD64XaddwNode create(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdateCPZSOFlagsNode flags, LLVMAMD64WriteTupelNode out, LLVMExpressionNode left, LLVMExpressionNode right) {
            return new LLVMAMD64XaddwNodeGen(flags, out, left, right);
        }
    }

    @GeneratedBy(value=LLVMAMD64XaddNode.LLVMAMD64XaddbNode.class)
    public static final class LLVMAMD64XaddbNodeGen
    extends LLVMAMD64XaddNode.LLVMAMD64XaddbNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMAMD64XaddbNodeGen(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdateCPZSOFlagsNode flags, LLVMAMD64WriteTupelNode out, LLVMExpressionNode left, LLVMExpressionNode right) {
            super(flags, out);
            this.left_ = left;
            this.right_ = right;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            byte rightValue_;
            byte leftValue_;
            int state = this.state_;
            try {
                leftValue_ = this.left_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                this.executeAndSpecialize(frameValue, ex.getResult(), rightValue);
                return;
            }
            try {
                rightValue_ = this.right_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                this.executeAndSpecialize(frameValue, leftValue_, ex.getResult());
                return;
            }
            if (state != 0) {
                this.doOp(frameValue, leftValue_, rightValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, leftValue_, rightValue_);
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object leftValue, Object rightValue) {
            int state = this.state_;
            if (leftValue instanceof Byte) {
                byte leftValue_ = (Byte)leftValue;
                if (rightValue instanceof Byte) {
                    byte rightValue_ = (Byte)rightValue;
                    this.state_ = state |= 1;
                    this.doOp(frameValue, leftValue_, rightValue_);
                    return;
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_}, new Object[]{leftValue, rightValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMAMD64XaddNode.LLVMAMD64XaddbNode create(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdateCPZSOFlagsNode flags, LLVMAMD64WriteTupelNode out, LLVMExpressionNode left, LLVMExpressionNode right) {
            return new LLVMAMD64XaddbNodeGen(flags, out, left, right);
        }
    }
}

