/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64WriteValueNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI16StoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI32StoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI64StoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI8StoreNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@NodeChildren(value={@NodeChild(value="rax", type=LLVMExpressionNode.class), @NodeChild(value="rdi", type=LLVMExpressionNode.class), @NodeChild(value="df", type=LLVMExpressionNode.class)})
public abstract class LLVMAMD64StosNode
extends LLVMStatementNode {
    @Node.Child
    protected LLVMStoreNode store;
    @Node.Child
    protected LLVMAMD64WriteValueNode writeRDI;

    public LLVMAMD64StosNode(LLVMAMD64WriteValueNode writeRDI) {
        this.writeRDI = writeRDI;
    }

    public static abstract class LLVMAMD64StosqNode
    extends LLVMAMD64StosNode {
        public LLVMAMD64StosqNode(LLVMAMD64WriteValueNode writeRDI) {
            super(writeRDI);
            this.store = LLVMI64StoreNodeGen.create(null, null);
        }

        @Specialization
        protected void opI8(VirtualFrame frame, long al, long rdi, boolean df) {
            this.store.executeWithTarget(LLVMNativePointer.create(rdi), al);
            this.writeRDI.execute(frame, rdi + (long)(df ? -8 : 8));
        }

        @Specialization
        protected void opI8(VirtualFrame frame, long al, LLVMPointer rdi, boolean df) {
            this.store.executeWithTarget(rdi, al);
            this.writeRDI.execute(frame, rdi.increment(df ? -8L : 8L));
        }
    }

    public static abstract class LLVMAMD64StosdNode
    extends LLVMAMD64StosNode {
        public LLVMAMD64StosdNode(LLVMAMD64WriteValueNode writeRDI) {
            super(writeRDI);
            this.store = LLVMI32StoreNodeGen.create(null, null);
        }

        @Specialization
        protected void opI8(VirtualFrame frame, int al, long rdi, boolean df) {
            this.store.executeWithTarget(LLVMNativePointer.create(rdi), al);
            this.writeRDI.execute(frame, rdi + (long)(df ? -4 : 4));
        }

        @Specialization
        protected void opI8(VirtualFrame frame, int al, LLVMPointer rdi, boolean df) {
            this.store.executeWithTarget(rdi, al);
            this.writeRDI.execute(frame, rdi.increment(df ? -4L : 4L));
        }
    }

    public static abstract class LLVMAMD64StoswNode
    extends LLVMAMD64StosNode {
        public LLVMAMD64StoswNode(LLVMAMD64WriteValueNode writeRDI) {
            super(writeRDI);
            this.store = LLVMI16StoreNodeGen.create(null, null);
        }

        @Specialization
        protected void opI8(VirtualFrame frame, short al, long rdi, boolean df) {
            this.store.executeWithTarget(LLVMNativePointer.create(rdi), al);
            this.writeRDI.execute(frame, rdi + (long)(df ? -2 : 2));
        }

        @Specialization
        protected void opI8(VirtualFrame frame, short al, LLVMPointer rdi, boolean df) {
            this.store.executeWithTarget(rdi, al);
            this.writeRDI.execute(frame, rdi.increment(df ? -2L : 2L));
        }
    }

    public static abstract class LLVMAMD64StosbNode
    extends LLVMAMD64StosNode {
        public LLVMAMD64StosbNode(LLVMAMD64WriteValueNode writeRDI) {
            super(writeRDI);
            this.store = LLVMI8StoreNodeGen.create(null, null);
        }

        @Specialization
        protected void opI8(VirtualFrame frame, byte al, long rdi, boolean df) {
            this.store.executeWithTarget(LLVMNativePointer.create(rdi), al);
            this.writeRDI.execute(frame, rdi + (long)(df ? -1 : 1));
        }

        @Specialization
        protected void opI8(VirtualFrame frame, byte al, LLVMPointer rdi, boolean df) {
            this.store.executeWithTarget(rdi, al);
            this.writeRDI.execute(frame, rdi.increment(df ? -1L : 1L));
        }
    }
}

