/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedLanguage;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameUtil;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;

@NodeChild(value="value", type=LLVMExpressionNode.class)
public abstract class LLVMAMD64PushNode
extends LLVMStatementNode {
    protected FrameSlot getStackPointerSlot() {
        CompilerAsserts.neverPartOfCompilation();
        return this.getRootNode().getFrameDescriptor().findFrameSlot((Object)"<stackpointer>");
    }

    public static abstract class LLVMAMD64PushqNode
    extends LLVMAMD64PushNode {
        @Specialization
        protected void doVoid(VirtualFrame frame, long value, @Cached(value="getStackPointerSlot()") FrameSlot slot, @CachedLanguage LLVMLanguage language) {
            LLVMMemory memory = language.getLLVMMemory();
            LLVMStack.StackPointer basePointer = (LLVMStack.StackPointer)FrameUtil.getObjectSafe((Frame)frame, (FrameSlot)slot);
            long sp = basePointer.get(this, memory);
            basePointer.set(sp -= 8L);
            memory.putI64((Node)this, sp, value);
        }
    }

    public static abstract class LLVMAMD64PushlNode
    extends LLVMAMD64PushNode {
        @Specialization
        protected void doVoid(VirtualFrame frame, int value, @Cached(value="getStackPointerSlot()") FrameSlot slot, @CachedLanguage LLVMLanguage language) {
            LLVMMemory memory = language.getLLVMMemory();
            LLVMStack.StackPointer basePointer = (LLVMStack.StackPointer)FrameUtil.getObjectSafe((Frame)frame, (FrameSlot)slot);
            long sp = basePointer.get(this, memory);
            basePointer.set(sp -= 4L);
            memory.putI32((Node)this, sp, value);
        }
    }

    public static abstract class LLVMAMD64PushwNode
    extends LLVMAMD64PushNode {
        @Specialization
        protected void doVoid(VirtualFrame frame, short value, @Cached(value="getStackPointerSlot()") FrameSlot slot, @CachedLanguage LLVMLanguage language) {
            LLVMMemory memory = language.getLLVMMemory();
            LLVMStack.StackPointer basePointer = (LLVMStack.StackPointer)FrameUtil.getObjectSafe((Frame)frame, (FrameSlot)slot);
            long sp = basePointer.get(this, memory);
            basePointer.set(sp -= 2L);
            memory.putI16((Node)this, sp, value);
        }
    }
}

