/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64IdivNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64WriteTupelNode;

@GeneratedBy(value=LLVMAMD64IdivNode.class)
public final class LLVMAMD64IdivNodeFactory {

    @GeneratedBy(value=LLVMAMD64IdivNode.LLVMAMD64IdivqNode.class)
    public static final class LLVMAMD64IdivqNodeGen
    extends LLVMAMD64IdivNode.LLVMAMD64IdivqNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode high_;
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMAMD64IdivqNodeGen(LLVMAMD64WriteTupelNode out, LLVMExpressionNode high, LLVMExpressionNode left, LLVMExpressionNode right) {
            super(out);
            this.high_ = high;
            this.left_ = left;
            this.right_ = right;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            long rightValue_;
            long leftValue_;
            long highValue_;
            int state = this.state_;
            try {
                highValue_ = this.high_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object leftValue = this.left_.executeGeneric(frameValue);
                Object rightValue = this.right_.executeGeneric(frameValue);
                this.executeAndSpecialize(frameValue, ex.getResult(), leftValue, rightValue);
                return;
            }
            try {
                leftValue_ = this.left_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                this.executeAndSpecialize(frameValue, highValue_, ex.getResult(), rightValue);
                return;
            }
            try {
                rightValue_ = this.right_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                this.executeAndSpecialize(frameValue, highValue_, leftValue_, ex.getResult());
                return;
            }
            if (state != 0) {
                this.doOp(frameValue, highValue_, leftValue_, rightValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, highValue_, leftValue_, rightValue_);
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object highValue, Object leftValue, Object rightValue) {
            int state = this.state_;
            if (highValue instanceof Long) {
                long highValue_ = (Long)highValue;
                if (leftValue instanceof Long) {
                    long leftValue_ = (Long)leftValue;
                    if (rightValue instanceof Long) {
                        long rightValue_ = (Long)rightValue;
                        this.state_ = state |= 1;
                        this.doOp(frameValue, highValue_, leftValue_, rightValue_);
                        return;
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.high_, this.left_, this.right_}, new Object[]{highValue, leftValue, rightValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMAMD64IdivNode.LLVMAMD64IdivqNode create(LLVMAMD64WriteTupelNode out, LLVMExpressionNode high, LLVMExpressionNode left, LLVMExpressionNode right) {
            return new LLVMAMD64IdivqNodeGen(out, high, left, right);
        }
    }

    @GeneratedBy(value=LLVMAMD64IdivNode.LLVMAMD64IdivlNode.class)
    public static final class LLVMAMD64IdivlNodeGen
    extends LLVMAMD64IdivNode.LLVMAMD64IdivlNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode high_;
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMAMD64IdivlNodeGen(LLVMAMD64WriteTupelNode out, LLVMExpressionNode high, LLVMExpressionNode left, LLVMExpressionNode right) {
            super(out);
            this.high_ = high;
            this.left_ = left;
            this.right_ = right;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            int rightValue_;
            int leftValue_;
            int highValue_;
            int state = this.state_;
            try {
                highValue_ = this.high_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object leftValue = this.left_.executeGeneric(frameValue);
                Object rightValue = this.right_.executeGeneric(frameValue);
                this.executeAndSpecialize(frameValue, ex.getResult(), leftValue, rightValue);
                return;
            }
            try {
                leftValue_ = this.left_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                this.executeAndSpecialize(frameValue, highValue_, ex.getResult(), rightValue);
                return;
            }
            try {
                rightValue_ = this.right_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                this.executeAndSpecialize(frameValue, highValue_, leftValue_, ex.getResult());
                return;
            }
            if (state != 0) {
                this.doOp(frameValue, highValue_, leftValue_, rightValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, highValue_, leftValue_, rightValue_);
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object highValue, Object leftValue, Object rightValue) {
            int state = this.state_;
            if (highValue instanceof Integer) {
                int highValue_ = (Integer)highValue;
                if (leftValue instanceof Integer) {
                    int leftValue_ = (Integer)leftValue;
                    if (rightValue instanceof Integer) {
                        int rightValue_ = (Integer)rightValue;
                        this.state_ = state |= 1;
                        this.doOp(frameValue, highValue_, leftValue_, rightValue_);
                        return;
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.high_, this.left_, this.right_}, new Object[]{highValue, leftValue, rightValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMAMD64IdivNode.LLVMAMD64IdivlNode create(LLVMAMD64WriteTupelNode out, LLVMExpressionNode high, LLVMExpressionNode left, LLVMExpressionNode right) {
            return new LLVMAMD64IdivlNodeGen(out, high, left, right);
        }
    }

    @GeneratedBy(value=LLVMAMD64IdivNode.LLVMAMD64IdivwNode.class)
    public static final class LLVMAMD64IdivwNodeGen
    extends LLVMAMD64IdivNode.LLVMAMD64IdivwNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode high_;
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMAMD64IdivwNodeGen(LLVMAMD64WriteTupelNode out, LLVMExpressionNode high, LLVMExpressionNode left, LLVMExpressionNode right) {
            super(out);
            this.high_ = high;
            this.left_ = left;
            this.right_ = right;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            short rightValue_;
            short leftValue_;
            short highValue_;
            int state = this.state_;
            try {
                highValue_ = this.high_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object leftValue = this.left_.executeGeneric(frameValue);
                Object rightValue = this.right_.executeGeneric(frameValue);
                this.executeAndSpecialize(frameValue, ex.getResult(), leftValue, rightValue);
                return;
            }
            try {
                leftValue_ = this.left_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                this.executeAndSpecialize(frameValue, highValue_, ex.getResult(), rightValue);
                return;
            }
            try {
                rightValue_ = this.right_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                this.executeAndSpecialize(frameValue, highValue_, leftValue_, ex.getResult());
                return;
            }
            if (state != 0) {
                this.doOp(frameValue, highValue_, leftValue_, rightValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, highValue_, leftValue_, rightValue_);
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object highValue, Object leftValue, Object rightValue) {
            int state = this.state_;
            if (highValue instanceof Short) {
                short highValue_ = (Short)highValue;
                if (leftValue instanceof Short) {
                    short leftValue_ = (Short)leftValue;
                    if (rightValue instanceof Short) {
                        short rightValue_ = (Short)rightValue;
                        this.state_ = state |= 1;
                        this.doOp(frameValue, highValue_, leftValue_, rightValue_);
                        return;
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.high_, this.left_, this.right_}, new Object[]{highValue, leftValue, rightValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMAMD64IdivNode.LLVMAMD64IdivwNode create(LLVMAMD64WriteTupelNode out, LLVMExpressionNode high, LLVMExpressionNode left, LLVMExpressionNode right) {
            return new LLVMAMD64IdivwNodeGen(out, high, left, right);
        }
    }

    @GeneratedBy(value=LLVMAMD64IdivNode.LLVMAMD64IdivbNode.class)
    public static final class LLVMAMD64IdivbNodeGen
    extends LLVMAMD64IdivNode.LLVMAMD64IdivbNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMAMD64IdivbNodeGen(LLVMExpressionNode left, LLVMExpressionNode right) {
            this.left_ = left;
            this.right_ = right;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            byte rightValue_;
            short leftValue_;
            int state = this.state_;
            try {
                leftValue_ = this.left_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue);
            }
            try {
                rightValue_ = this.right_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(leftValue_, ex.getResult());
            }
            if (state != 0) {
                return this.doOp(leftValue_, rightValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_);
        }

        @Override
        public short executeI16(VirtualFrame frameValue) {
            byte rightValue_;
            short leftValue_;
            int state = this.state_;
            try {
                leftValue_ = this.left_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object rightValue = this.right_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue);
            }
            try {
                rightValue_ = this.right_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(leftValue_, ex.getResult());
            }
            if (state != 0) {
                return this.doOp(leftValue_, rightValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_);
        }

        private short executeAndSpecialize(Object leftValue, Object rightValue) {
            int state = this.state_;
            if (leftValue instanceof Short) {
                short leftValue_ = (Short)leftValue;
                if (rightValue instanceof Byte) {
                    byte rightValue_ = (Byte)rightValue;
                    this.state_ = state |= 1;
                    return this.doOp(leftValue_, rightValue_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_}, new Object[]{leftValue, rightValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMAMD64IdivNode.LLVMAMD64IdivbNode create(LLVMExpressionNode left, LLVMExpressionNode right) {
            return new LLVMAMD64IdivbNodeGen(left, right);
        }
    }
}

