/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64BswapNode;

@GeneratedBy(value=LLVMAMD64BswapNode.class)
public final class LLVMAMD64BswapNodeFactory {

    @GeneratedBy(value=LLVMAMD64BswapNode.LLVMAMD64BswapqNode.class)
    public static final class LLVMAMD64BswapqNodeGen
    extends LLVMAMD64BswapNode.LLVMAMD64BswapqNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode data_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMAMD64BswapqNodeGen(LLVMExpressionNode data) {
            this.data_ = data;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            long dataValue_;
            int state = this.state_;
            try {
                dataValue_ = this.data_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if (state != 0) {
                return this.doI64(dataValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(dataValue_);
        }

        @Override
        public long executeI64(VirtualFrame frameValue) {
            long dataValue_;
            int state = this.state_;
            try {
                dataValue_ = this.data_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if (state != 0) {
                return this.doI64(dataValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(dataValue_);
        }

        private long executeAndSpecialize(Object dataValue) {
            int state = this.state_;
            if (dataValue instanceof Long) {
                long dataValue_ = (Long)dataValue;
                this.state_ = state |= 1;
                return this.doI64(dataValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.data_}, new Object[]{dataValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMAMD64BswapNode.LLVMAMD64BswapqNode create(LLVMExpressionNode data) {
            return new LLVMAMD64BswapqNodeGen(data);
        }
    }

    @GeneratedBy(value=LLVMAMD64BswapNode.LLVMAMD64BswaplNode.class)
    public static final class LLVMAMD64BswaplNodeGen
    extends LLVMAMD64BswapNode.LLVMAMD64BswaplNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode data_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMAMD64BswaplNodeGen(LLVMExpressionNode data) {
            this.data_ = data;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int dataValue_;
            int state = this.state_;
            try {
                dataValue_ = this.data_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if (state != 0) {
                return this.doI32(dataValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(dataValue_);
        }

        @Override
        public int executeI32(VirtualFrame frameValue) {
            int dataValue_;
            int state = this.state_;
            try {
                dataValue_ = this.data_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            if (state != 0) {
                return this.doI32(dataValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(dataValue_);
        }

        private int executeAndSpecialize(Object dataValue) {
            int state = this.state_;
            if (dataValue instanceof Integer) {
                int dataValue_ = (Integer)dataValue;
                this.state_ = state |= 1;
                return this.doI32(dataValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.data_}, new Object[]{dataValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMAMD64BswapNode.LLVMAMD64BswaplNode create(LLVMExpressionNode data) {
            return new LLVMAMD64BswaplNodeGen(data);
        }
    }
}

