/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64BsfNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64WriteBooleanNode;

@GeneratedBy(value=LLVMAMD64BsfNode.class)
public final class LLVMAMD64BsfNodeFactory {

    @GeneratedBy(value=LLVMAMD64BsfNode.LLVMAMD64BsfqNode.class)
    public static final class LLVMAMD64BsfqNodeGen
    extends LLVMAMD64BsfNode.LLVMAMD64BsfqNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode src_;
        @Node.Child
        private LLVMExpressionNode dst_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMAMD64BsfqNodeGen(LLVMAMD64WriteBooleanNode writeZFNode, LLVMExpressionNode src, LLVMExpressionNode dst) {
            super(writeZFNode);
            this.src_ = src;
            this.dst_ = dst;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            long dstValue_;
            long srcValue_;
            int state = this.state_;
            try {
                srcValue_ = this.src_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object dstValue = this.dst_.executeGeneric(frameValue);
                return this.executeAndSpecialize(frameValue, ex.getResult(), dstValue);
            }
            try {
                dstValue_ = this.dst_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(frameValue, srcValue_, ex.getResult());
            }
            if (state != 0) {
                return this.doI64(frameValue, srcValue_, dstValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, srcValue_, dstValue_);
        }

        @Override
        public long executeI64(VirtualFrame frameValue) {
            long dstValue_;
            long srcValue_;
            int state = this.state_;
            try {
                srcValue_ = this.src_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object dstValue = this.dst_.executeGeneric(frameValue);
                return this.executeAndSpecialize(frameValue, ex.getResult(), dstValue);
            }
            try {
                dstValue_ = this.dst_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(frameValue, srcValue_, ex.getResult());
            }
            if (state != 0) {
                return this.doI64(frameValue, srcValue_, dstValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, srcValue_, dstValue_);
        }

        private long executeAndSpecialize(VirtualFrame frameValue, Object srcValue, Object dstValue) {
            int state = this.state_;
            if (srcValue instanceof Long) {
                long srcValue_ = (Long)srcValue;
                if (dstValue instanceof Long) {
                    long dstValue_ = (Long)dstValue;
                    this.state_ = state |= 1;
                    return this.doI64(frameValue, srcValue_, dstValue_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.src_, this.dst_}, new Object[]{srcValue, dstValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMAMD64BsfNode.LLVMAMD64BsfqNode create(LLVMAMD64WriteBooleanNode writeZFNode, LLVMExpressionNode src, LLVMExpressionNode dst) {
            return new LLVMAMD64BsfqNodeGen(writeZFNode, src, dst);
        }
    }

    @GeneratedBy(value=LLVMAMD64BsfNode.LLVMAMD64BsflNode.class)
    public static final class LLVMAMD64BsflNodeGen
    extends LLVMAMD64BsfNode.LLVMAMD64BsflNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode src_;
        @Node.Child
        private LLVMExpressionNode dst_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMAMD64BsflNodeGen(LLVMAMD64WriteBooleanNode writeZFNode, LLVMExpressionNode src, LLVMExpressionNode dst) {
            super(writeZFNode);
            this.src_ = src;
            this.dst_ = dst;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int dstValue_;
            int srcValue_;
            int state = this.state_;
            try {
                srcValue_ = this.src_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object dstValue = this.dst_.executeGeneric(frameValue);
                return this.executeAndSpecialize(frameValue, ex.getResult(), dstValue);
            }
            try {
                dstValue_ = this.dst_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(frameValue, srcValue_, ex.getResult());
            }
            if (state != 0) {
                return this.doI32(frameValue, srcValue_, dstValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, srcValue_, dstValue_);
        }

        @Override
        public int executeI32(VirtualFrame frameValue) {
            int dstValue_;
            int srcValue_;
            int state = this.state_;
            try {
                srcValue_ = this.src_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object dstValue = this.dst_.executeGeneric(frameValue);
                return this.executeAndSpecialize(frameValue, ex.getResult(), dstValue);
            }
            try {
                dstValue_ = this.dst_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(frameValue, srcValue_, ex.getResult());
            }
            if (state != 0) {
                return this.doI32(frameValue, srcValue_, dstValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, srcValue_, dstValue_);
        }

        private int executeAndSpecialize(VirtualFrame frameValue, Object srcValue, Object dstValue) {
            int state = this.state_;
            if (srcValue instanceof Integer) {
                int srcValue_ = (Integer)srcValue;
                if (dstValue instanceof Integer) {
                    int dstValue_ = (Integer)dstValue;
                    this.state_ = state |= 1;
                    return this.doI32(frameValue, srcValue_, dstValue_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.src_, this.dst_}, new Object[]{srcValue, dstValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMAMD64BsfNode.LLVMAMD64BsflNode create(LLVMAMD64WriteBooleanNode writeZFNode, LLVMExpressionNode src, LLVMExpressionNode dst) {
            return new LLVMAMD64BsflNodeGen(writeZFNode, src, dst);
        }
    }

    @GeneratedBy(value=LLVMAMD64BsfNode.LLVMAMD64BsfwNode.class)
    public static final class LLVMAMD64BsfwNodeGen
    extends LLVMAMD64BsfNode.LLVMAMD64BsfwNode {
        private LLVMSourceLocation sourceLocation;
        private boolean statement;
        @Node.Child
        private LLVMExpressionNode src_;
        @Node.Child
        private LLVMExpressionNode dst_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMAMD64BsfwNodeGen(LLVMAMD64WriteBooleanNode writeZFNode, LLVMExpressionNode src, LLVMExpressionNode dst) {
            super(writeZFNode);
            this.src_ = src;
            this.dst_ = dst;
        }

        @Override
        public LLVMSourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public void setSourceLocation(LLVMSourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        protected boolean isStatement() {
            return this.statement;
        }

        @Override
        protected void setStatement(boolean statement) {
            this.statement = statement;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            short dstValue_;
            short srcValue_;
            int state = this.state_;
            try {
                srcValue_ = this.src_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object dstValue = this.dst_.executeGeneric(frameValue);
                return this.executeAndSpecialize(frameValue, ex.getResult(), dstValue);
            }
            try {
                dstValue_ = this.dst_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(frameValue, srcValue_, ex.getResult());
            }
            if (state != 0) {
                return this.doI16(frameValue, srcValue_, dstValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, srcValue_, dstValue_);
        }

        @Override
        public short executeI16(VirtualFrame frameValue) {
            short dstValue_;
            short srcValue_;
            int state = this.state_;
            try {
                srcValue_ = this.src_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object dstValue = this.dst_.executeGeneric(frameValue);
                return this.executeAndSpecialize(frameValue, ex.getResult(), dstValue);
            }
            try {
                dstValue_ = this.dst_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(frameValue, srcValue_, ex.getResult());
            }
            if (state != 0) {
                return this.doI16(frameValue, srcValue_, dstValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, srcValue_, dstValue_);
        }

        private short executeAndSpecialize(VirtualFrame frameValue, Object srcValue, Object dstValue) {
            int state = this.state_;
            if (srcValue instanceof Short) {
                short srcValue_ = (Short)srcValue;
                if (dstValue instanceof Short) {
                    short dstValue_ = (Short)dstValue;
                    this.state_ = state |= 1;
                    return this.doI16(frameValue, srcValue_, dstValue_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.src_, this.dst_}, new Object[]{srcValue, dstValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMAMD64BsfNode.LLVMAMD64BsfwNode create(LLVMAMD64WriteBooleanNode writeZFNode, LLVMExpressionNode src, LLVMExpressionNode dst) {
            return new LLVMAMD64BsfwNodeGen(writeZFNode, src, dst);
        }
    }
}

