/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.api;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.NodeField;
import com.oracle.truffle.api.dsl.NodeFields;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;

@NodeFields(value={@NodeField(name="sourceLocation", type=LLVMSourceLocation.class), @NodeField(name="statement", type=boolean.class)})
public abstract class LLVMInstrumentableNode
extends LLVMNode
implements InstrumentableNode {
    public abstract LLVMSourceLocation getSourceLocation();

    public abstract void setSourceLocation(LLVMSourceLocation var1);

    public final SourceSection getSourceSection() {
        LLVMSourceLocation sourceLocation = this.getSourceLocation();
        return sourceLocation == null ? null : sourceLocation.getSourceSection();
    }

    protected abstract boolean isStatement();

    protected abstract void setStatement(boolean var1);

    public boolean hasStatementTag() {
        return this.isStatement() && this.getSourceLocation() != null;
    }

    public void setHasStatementTag(boolean b) {
        CompilerAsserts.neverPartOfCompilation();
        this.setStatement(b);
    }

    public final boolean isInstrumentable() {
        return this.getSourceLocation() != null;
    }

    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == StandardTags.StatementTag.class) {
            return this.hasStatementTag();
        }
        return false;
    }
}

