/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.memory;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.config.LLVMCapability;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import java.util.function.IntBinaryOperator;
import java.util.function.LongBinaryOperator;

public abstract class LLVMMemory
implements LLVMCapability {
    @Deprecated
    public abstract void memset(Node var1, LLVMNativePointer var2, long var3, byte var5);

    @Deprecated
    public abstract void copyMemory(Node var1, long var2, long var4, long var6);

    public final void free(Node location, LLVMNativePointer address) {
        this.free(location, address.asNative());
    }

    public abstract void free(Node var1, long var2);

    public abstract LLVMNativePointer allocateMemory(Node var1, long var2);

    @Deprecated
    public abstract LLVMNativePointer reallocateMemory(Node var1, LLVMNativePointer var2, long var3);

    public final boolean getI1(Node location, LLVMNativePointer addr) {
        return this.getI1(location, addr.asNative());
    }

    public abstract boolean getI1(Node var1, long var2);

    public final byte getI8(Node location, LLVMNativePointer addr) {
        return this.getI8(location, addr.asNative());
    }

    public abstract byte getI8(Node var1, long var2);

    public final short getI16(Node location, LLVMNativePointer addr) {
        return this.getI16(location, addr.asNative());
    }

    public abstract short getI16(Node var1, long var2);

    public final int getI32(Node location, LLVMNativePointer addr) {
        return this.getI32(location, addr.asNative());
    }

    public abstract int getI32(Node var1, long var2);

    public abstract LLVMIVarBit getIVarBit(Node var1, LLVMNativePointer var2, int var3);

    public final long getI64(Node location, LLVMNativePointer addr) {
        return this.getI64(location, addr.asNative());
    }

    public abstract long getI64(Node var1, long var2);

    public final float getFloat(Node location, LLVMNativePointer addr) {
        return this.getFloat(location, addr.asNative());
    }

    public abstract float getFloat(Node var1, long var2);

    public final double getDouble(Node location, LLVMNativePointer addr) {
        return this.getDouble(location, addr.asNative());
    }

    public abstract double getDouble(Node var1, long var2);

    public abstract LLVM80BitFloat get80BitFloat(Node var1, LLVMNativePointer var2);

    public final LLVMNativePointer getPointer(Node location, LLVMNativePointer addr) {
        return this.getPointer(location, addr.asNative());
    }

    public abstract LLVMNativePointer getPointer(Node var1, long var2);

    public final void putI1(Node location, LLVMNativePointer addr, boolean value) {
        this.putI1(location, addr.asNative(), value);
    }

    public abstract void putI1(Node var1, long var2, boolean var4);

    public final void putI8(Node location, LLVMNativePointer addr, byte value) {
        this.putI8(location, addr.asNative(), value);
    }

    public abstract void putI8(Node var1, long var2, byte var4);

    public final void putI16(Node location, LLVMNativePointer addr, short value) {
        this.putI16(location, addr.asNative(), value);
    }

    public abstract void putI16(Node var1, long var2, short var4);

    public final void putI32(Node location, LLVMNativePointer addr, int value) {
        this.putI32(location, addr.asNative(), value);
    }

    public abstract void putI32(Node var1, long var2, int var4);

    public final void putI64(Node location, LLVMNativePointer addr, long value) {
        this.putI64(location, addr.asNative(), value);
    }

    public abstract void putI64(Node var1, long var2, long var4);

    public abstract void putIVarBit(Node var1, LLVMNativePointer var2, LLVMIVarBit var3);

    public final void putFloat(Node location, LLVMNativePointer addr, float value) {
        this.putFloat(location, addr.asNative(), value);
    }

    public abstract void putFloat(Node var1, long var2, float var4);

    public final void putDouble(Node location, LLVMNativePointer addr, double value) {
        this.putDouble(location, addr.asNative(), value);
    }

    public abstract void putDouble(Node var1, long var2, double var4);

    public final void put80BitFloat(Node location, LLVMNativePointer addr, LLVM80BitFloat value) {
        this.put80BitFloat(location, addr.asNative(), value);
    }

    public abstract void put80BitFloat(Node var1, long var2, LLVM80BitFloat var4);

    public final void putPointer(Node location, LLVMNativePointer addr, LLVMNativePointer value) {
        this.putPointer(location, addr.asNative(), value.asNative());
    }

    public final void putPointer(Node location, LLVMNativePointer addr, long ptrValue) {
        this.putPointer(location, addr.asNative(), ptrValue);
    }

    public final void putPointer(Node location, long ptr, LLVMNativePointer value) {
        this.putPointer(location, ptr, value.asNative());
    }

    public abstract void putPointer(Node var1, long var2, long var4);

    public final void putByteArray(Node location, LLVMNativePointer addr, byte[] bytes) {
        this.putByteArray(location, addr.asNative(), bytes);
    }

    public abstract void putByteArray(Node var1, long var2, byte[] var4);

    public abstract CMPXCHGI32 compareAndSwapI32(Node var1, LLVMNativePointer var2, int var3, int var4);

    public abstract CMPXCHGI64 compareAndSwapI64(Node var1, LLVMNativePointer var2, long var3, long var5);

    public abstract CMPXCHGI8 compareAndSwapI8(Node var1, LLVMNativePointer var2, byte var3, byte var4);

    public abstract CMPXCHGI16 compareAndSwapI16(Node var1, LLVMNativePointer var2, short var3, short var4);

    public abstract long getAndSetI64(Node var1, LLVMNativePointer var2, long var3);

    public abstract long getAndAddI64(Node var1, LLVMNativePointer var2, long var3);

    public abstract long getAndSubI64(Node var1, LLVMNativePointer var2, long var3);

    public abstract long getAndOpI64(Node var1, LLVMNativePointer var2, long var3, LongBinaryOperator var5);

    public abstract int getAndSetI32(Node var1, LLVMNativePointer var2, int var3);

    public abstract int getAndAddI32(Node var1, LLVMNativePointer var2, int var3);

    public abstract int getAndSubI32(Node var1, LLVMNativePointer var2, int var3);

    public abstract int getAndOpI32(Node var1, LLVMNativePointer var2, int var3, IntBinaryOperator var4);

    public abstract short getAndOpI16(Node var1, LLVMNativePointer var2, short var3, ShortBinaryOperator var4);

    public abstract byte getAndOpI8(Node var1, LLVMNativePointer var2, byte var3, ByteBinaryOperator var4);

    public abstract boolean getAndOpI1(Node var1, LLVMNativePointer var2, boolean var3, BooleanBinaryOperator var4);

    public abstract void fullFence();

    public abstract HandleContainer createHandleContainer(boolean var1, Assumption var2);

    @CompilerDirectives.ValueType
    public static final class CMPXCHGI64 {
        private final long value;
        private final boolean swap;

        public CMPXCHGI64(long value, boolean swap) {
            this.value = value;
            this.swap = swap;
        }

        public long getValue() {
            return this.value;
        }

        public boolean isSwap() {
            return this.swap;
        }
    }

    @CompilerDirectives.ValueType
    public static final class CMPXCHGI32 {
        private final int value;
        private final boolean swap;

        public CMPXCHGI32(int value, boolean swap) {
            this.value = value;
            this.swap = swap;
        }

        public int getValue() {
            return this.value;
        }

        public boolean isSwap() {
            return this.swap;
        }
    }

    @CompilerDirectives.ValueType
    public static final class CMPXCHGI16 {
        private final short value;
        private final boolean swap;

        public CMPXCHGI16(short value, boolean swap) {
            this.value = value;
            this.swap = swap;
        }

        public short getValue() {
            return this.value;
        }

        public boolean isSwap() {
            return this.swap;
        }
    }

    @CompilerDirectives.ValueType
    public static final class CMPXCHGI8 {
        private final byte value;
        private final boolean swap;

        public CMPXCHGI8(byte value, boolean swap) {
            this.value = value;
            this.swap = swap;
        }

        public byte getValue() {
            return this.value;
        }

        public boolean isSwap() {
            return this.swap;
        }
    }

    public static abstract class HandleContainer {
        public abstract LLVMNativePointer allocate(Node var1, Object var2);

        public abstract void free(Node var1, long var2);

        public abstract LLVMManagedPointer getValue(Node var1, long var2);

        public abstract boolean isHandle(long var1);
    }

    @FunctionalInterface
    public static interface BooleanBinaryOperator {
        public boolean apply(boolean var1, boolean var2);
    }

    @FunctionalInterface
    public static interface ByteBinaryOperator {
        public byte apply(byte var1, byte var2);
    }

    @FunctionalInterface
    public static interface ShortBinaryOperator {
        public short apply(short var1, short var2);
    }
}

