/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.nfi;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedContext;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunctionCode;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LLVMGetStackNode;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.interop.nfi.LLVMNativeConvertNode;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.memory.LLVMThreadingStack;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.types.FunctionType;

@ExportLibrary(value=InteropLibrary.class)
public final class LLVMNativeWrapper
implements TruffleObject {
    private final LLVMFunctionDescriptor descriptor;

    public LLVMNativeWrapper(LLVMFunctionDescriptor descriptor) {
        assert (descriptor.getFunctionCode().isLLVMIRFunction() || descriptor.getFunctionCode().isIntrinsicFunctionSlowPath());
        this.descriptor = descriptor;
    }

    static boolean isInstance(TruffleObject obj) {
        return obj instanceof LLVMNativeWrapper;
    }

    public String toString() {
        return this.descriptor.toString();
    }

    @ExportMessage
    boolean isExecutable() {
        return true;
    }

    @ExportMessage
    Object execute(Object[] args, @Cached CallbackHelperNode callbackHelper) {
        return callbackHelper.execute(this.descriptor, args);
    }

    @GenerateUncached
    @ImportStatic(value={LLVMLanguage.class})
    static abstract class CallbackHelperNode
    extends LLVMNode {
        CallbackHelperNode() {
        }

        abstract Object execute(LLVMFunctionDescriptor var1, Object[] var2);

        @Specialization(guards={"function == cachedFunction"})
        Object doCached(LLVMFunctionDescriptor function, Object[] args, @Cached(value="function") LLVMFunctionDescriptor cachedFunction, @Cached LLVMGetStackNode getStack, @CachedContext(value=LLVMLanguage.class) TruffleLanguage.ContextReference<LLVMContext> ctxRef, @Cached(value="createCallNode(cachedFunction)") DirectCallNode call, @Cached(value="createFromNativeNodes(cachedFunction.getLLVMFunction().getType())") LLVMNativeConvertNode[] convertArgs, @Cached(value="createToNative(cachedFunction.getLLVMFunction().getType().getReturnType())") LLVMNativeConvertNode convertRet) {
            try (LLVMStack.StackPointer stackPointer = this.newStackFrame(getStack, ctxRef);){
                Object[] preparedArgs = CallbackHelperNode.prepareCallbackArguments(stackPointer, args, convertArgs);
                Object ret = call.call(preparedArgs);
                Object object = convertRet.executeConvert(ret);
                return object;
            }
        }

        @Specialization(replaces={"doCached"})
        Object doGeneric(LLVMFunctionDescriptor function, Object[] args) {
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException("unexpected generic case in LLVMNativeCallback");
        }

        DirectCallNode createCallNode(LLVMFunctionDescriptor function) {
            RootCallTarget callTarget;
            LLVMFunctionCode functionCode = function.getFunctionCode();
            if (functionCode.isLLVMIRFunction()) {
                callTarget = functionCode.getLLVMIRFunctionSlowPath();
            } else if (functionCode.isIntrinsicFunctionSlowPath()) {
                callTarget = functionCode.getIntrinsicSlowPath().cachedCallTarget(function.getLLVMFunction().getType());
            } else {
                throw new IllegalStateException("unexpected function: " + function.toString());
            }
            return DirectCallNode.create((CallTarget)callTarget);
        }

        private LLVMStack.StackPointer newStackFrame(LLVMGetStackNode getStack, TruffleLanguage.ContextReference<LLVMContext> ctxRef) {
            LLVMThreadingStack threadingStack = ((LLVMContext)ctxRef.get()).getThreadingStack();
            return getStack.executeWithTarget(threadingStack, Thread.currentThread()).newFrame();
        }

        protected static LLVMNativeConvertNode[] createFromNativeNodes(FunctionType type) {
            LLVMNativeConvertNode[] ret = new LLVMNativeConvertNode[type.getNumberOfArguments()];
            for (int i = 0; i < type.getNumberOfArguments(); ++i) {
                ret[i] = LLVMNativeConvertNode.createFromNative(type.getArgumentType(i));
            }
            return ret;
        }

        @ExplodeLoop
        private static Object[] prepareCallbackArguments(LLVMStack.StackPointer stackPointer, Object[] arguments, LLVMNativeConvertNode[] fromNative) {
            Object[] callbackArgs = new Object[fromNative.length + 1];
            callbackArgs[0] = stackPointer;
            for (int i = 0; i < fromNative.length; ++i) {
                callbackArgs[i + 1] = fromNative[i].executeConvert(arguments[i]);
            }
            return callbackArgs;
        }
    }
}

