/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.export;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@GenerateUncached
public abstract class LLVMForeignWriteNode
extends LLVMNode {
    static final int VALUE_KIND_COUNT = LLVMInteropType.ValueKind.values().length;

    public abstract void execute(LLVMPointer var1, LLVMInteropType var2, Object var3) throws UnsupportedMessageException;

    @Specialization(guards={"type.getKind() == cachedKind"}, limit="VALUE_KIND_COUNT")
    static void doValue(LLVMPointer ptr, LLVMInteropType.Value type, Object value, @Cached(value="type.getKind()", allowUncached=true) LLVMInteropType.ValueKind cachedKind, @Cached(parameters={"cachedKind"}) LLVMStoreNode store, @Cached(value="createForeignToLLVM(type)") ForeignToLLVM toLLVM) {
        Object llvmValue = toLLVM.executeWithForeignToLLVMType(value, type.getBaseType(), cachedKind.foreignToLLVMType);
        store.executeWithTarget(ptr, llvmValue);
    }

    @Specialization
    static void doStructured(LLVMPointer ptr, LLVMInteropType.Structured type, Object value) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    LLVMStoreNode createStoreNode(LLVMInteropType.ValueKind kind) {
        CompilerAsserts.neverPartOfCompilation();
        return CommonNodeFactory.createStoreNode(kind);
    }

    protected ForeignToLLVM createForeignToLLVM(LLVMInteropType.Value type) {
        return CommonNodeFactory.createForeignToLLVM(type);
    }
}

