/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.convert;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.interop.convert.ToI64;
import com.oracle.truffle.llvm.runtime.interop.convert.ToPointer;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=ToI64.class)
public final class ToI64NodeGen
extends ToI64 {
    private static final LibraryFactory<LLVMAsForeignLibrary> L_L_V_M_AS_FOREIGN_LIBRARY_ = LibraryFactory.resolve(LLVMAsForeignLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @Node.Child
    private FromForeign0Data fromForeign0_cache;
    @Node.Child
    private InteropLibrary fromForeign1_interop_;
    @CompilerDirectives.CompilationFinal
    private BranchProfile fromForeign1_exception_;
    @Node.Child
    private FromForeignPointer0Data fromForeignPointer0_cache;
    @Node.Child
    private ToPointer fromForeignPointer1_toPointer_;
    @Node.Child
    private LLVMAsForeignLibrary fromForeignPointer1_foreigns_;

    private ToI64NodeGen() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ExplodeLoop
    public Object executeWithForeignToLLVMType(Object arg0Value, LLVMInteropType.Structured type, ForeignToLLVM.ForeignToLLVMType ftlType) {
        int state = this.state_;
        if ((state & 1) != 0 && arg0Value instanceof Integer) {
            int arg0Value_ = (Integer)arg0Value;
            return this.fromInt(arg0Value_);
        }
        if ((state & 2) != 0 && arg0Value instanceof Character) {
            char arg0Value_ = ((Character)arg0Value).charValue();
            return this.fromChar(arg0Value_);
        }
        if ((state & 4) != 0 && arg0Value instanceof Short) {
            short arg0Value_ = (Short)arg0Value;
            return this.fromShort(arg0Value_);
        }
        if ((state & 8) != 0 && arg0Value instanceof Long) {
            long arg0Value_ = (Long)arg0Value;
            return this.fromLong(arg0Value_);
        }
        if ((state & 0x10) != 0 && arg0Value instanceof Byte) {
            byte arg0Value_ = (Byte)arg0Value;
            return this.fromByte(arg0Value_);
        }
        if ((state & 0x20) != 0 && arg0Value instanceof Float) {
            float arg0Value_ = ((Float)arg0Value).floatValue();
            return this.fromFloat(arg0Value_);
        }
        if ((state & 0x40) != 0 && arg0Value instanceof Double) {
            double arg0Value_ = (Double)arg0Value;
            return this.fromDouble(arg0Value_);
        }
        if ((state & 0x80) != 0 && arg0Value instanceof Boolean) {
            boolean arg0Value_ = (Boolean)arg0Value;
            return this.fromBoolean(arg0Value_);
        }
        if ((state & 0x100) != 0 && arg0Value instanceof String) {
            String arg0Value_ = (String)arg0Value;
            return this.fromString(arg0Value_);
        }
        if ((state & 0x200) != 0 && LLVMTypes.isPointer(arg0Value)) {
            LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
            return this.fromPointer(arg0Value_);
        }
        if ((state & 0x3C00) != 0) {
            Node prev_;
            EncapsulatingNodeReference encapsulating_;
            if ((state & 0x400) != 0) {
                FromForeign0Data s11_ = this.fromForeign0_cache;
                while (s11_ != null) {
                    if (s11_.foreigns_.accepts(arg0Value) && s11_.foreigns_.isForeign(arg0Value) && s11_.interop_.isNumber(s11_.foreigns_.asForeign(arg0Value))) {
                        return this.fromForeign(arg0Value, s11_.foreigns_, s11_.interop_, s11_.exception_);
                    }
                    s11_ = s11_.next_;
                }
            }
            if ((state & 0x800) != 0) {
                encapsulating_ = EncapsulatingNodeReference.getCurrent();
                prev_ = encapsulating_.set((Node)this);
                try {
                    LLVMAsForeignLibrary fromForeign1_foreigns__ = (LLVMAsForeignLibrary)L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached(arg0Value);
                    if (fromForeign1_foreigns__.isForeign(arg0Value) && this.fromForeign1_interop_.isNumber(fromForeign1_foreigns__.asForeign(arg0Value))) {
                        Long l = this.fromForeign(arg0Value, fromForeign1_foreigns__, this.fromForeign1_interop_, this.fromForeign1_exception_);
                        return l;
                    }
                }
                finally {
                    encapsulating_.set(prev_);
                }
            }
            if ((state & 0x1000) != 0) {
                FromForeignPointer0Data s13_ = this.fromForeignPointer0_cache;
                while (s13_ != null) {
                    if (s13_.interop_.accepts(arg0Value) && s13_.foreigns_.isForeign(arg0Value) && !s13_.interop_.isNumber(arg0Value)) {
                        return this.fromForeignPointer(arg0Value, s13_.interop_, s13_.toPointer_, s13_.foreigns_);
                    }
                    s13_ = s13_.next_;
                }
            }
            if ((state & 0x2000) != 0 && this.fromForeignPointer1_foreigns_.isForeign(arg0Value)) {
                encapsulating_ = EncapsulatingNodeReference.getCurrent();
                prev_ = encapsulating_.set((Node)this);
                try {
                    InteropLibrary fromForeignPointer1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value);
                    if (!fromForeignPointer1_interop__.isNumber(arg0Value)) {
                        Object object = this.fromForeignPointer(arg0Value, fromForeignPointer1_interop__, this.fromForeignPointer1_toPointer_, this.fromForeignPointer1_foreigns_);
                        return object;
                    }
                }
                finally {
                    encapsulating_.set(prev_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ExplodeLoop
    public Object executeWithType(Object arg0Value, LLVMInteropType.Structured type) {
        int state = this.state_;
        if ((state & 1) != 0 && arg0Value instanceof Integer) {
            int arg0Value_ = (Integer)arg0Value;
            return this.fromInt(arg0Value_);
        }
        if ((state & 2) != 0 && arg0Value instanceof Character) {
            char arg0Value_ = ((Character)arg0Value).charValue();
            return this.fromChar(arg0Value_);
        }
        if ((state & 4) != 0 && arg0Value instanceof Short) {
            short arg0Value_ = (Short)arg0Value;
            return this.fromShort(arg0Value_);
        }
        if ((state & 8) != 0 && arg0Value instanceof Long) {
            long arg0Value_ = (Long)arg0Value;
            return this.fromLong(arg0Value_);
        }
        if ((state & 0x10) != 0 && arg0Value instanceof Byte) {
            byte arg0Value_ = (Byte)arg0Value;
            return this.fromByte(arg0Value_);
        }
        if ((state & 0x20) != 0 && arg0Value instanceof Float) {
            float arg0Value_ = ((Float)arg0Value).floatValue();
            return this.fromFloat(arg0Value_);
        }
        if ((state & 0x40) != 0 && arg0Value instanceof Double) {
            double arg0Value_ = (Double)arg0Value;
            return this.fromDouble(arg0Value_);
        }
        if ((state & 0x80) != 0 && arg0Value instanceof Boolean) {
            boolean arg0Value_ = (Boolean)arg0Value;
            return this.fromBoolean(arg0Value_);
        }
        if ((state & 0x100) != 0 && arg0Value instanceof String) {
            String arg0Value_ = (String)arg0Value;
            return this.fromString(arg0Value_);
        }
        if ((state & 0x200) != 0 && LLVMTypes.isPointer(arg0Value)) {
            LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
            return this.fromPointer(arg0Value_);
        }
        if ((state & 0x3C00) != 0) {
            Node prev_;
            EncapsulatingNodeReference encapsulating_;
            if ((state & 0x400) != 0) {
                FromForeign0Data s11_ = this.fromForeign0_cache;
                while (s11_ != null) {
                    if (s11_.foreigns_.accepts(arg0Value) && s11_.foreigns_.isForeign(arg0Value) && s11_.interop_.isNumber(s11_.foreigns_.asForeign(arg0Value))) {
                        return this.fromForeign(arg0Value, s11_.foreigns_, s11_.interop_, s11_.exception_);
                    }
                    s11_ = s11_.next_;
                }
            }
            if ((state & 0x800) != 0) {
                encapsulating_ = EncapsulatingNodeReference.getCurrent();
                prev_ = encapsulating_.set((Node)this);
                try {
                    LLVMAsForeignLibrary fromForeign1_foreigns__ = (LLVMAsForeignLibrary)L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached(arg0Value);
                    if (fromForeign1_foreigns__.isForeign(arg0Value) && this.fromForeign1_interop_.isNumber(fromForeign1_foreigns__.asForeign(arg0Value))) {
                        Long l = this.fromForeign(arg0Value, fromForeign1_foreigns__, this.fromForeign1_interop_, this.fromForeign1_exception_);
                        return l;
                    }
                }
                finally {
                    encapsulating_.set(prev_);
                }
            }
            if ((state & 0x1000) != 0) {
                FromForeignPointer0Data s13_ = this.fromForeignPointer0_cache;
                while (s13_ != null) {
                    if (s13_.interop_.accepts(arg0Value) && s13_.foreigns_.isForeign(arg0Value) && !s13_.interop_.isNumber(arg0Value)) {
                        return this.fromForeignPointer(arg0Value, s13_.interop_, s13_.toPointer_, s13_.foreigns_);
                    }
                    s13_ = s13_.next_;
                }
            }
            if ((state & 0x2000) != 0 && this.fromForeignPointer1_foreigns_.isForeign(arg0Value)) {
                encapsulating_ = EncapsulatingNodeReference.getCurrent();
                prev_ = encapsulating_.set((Node)this);
                try {
                    InteropLibrary fromForeignPointer1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value);
                    if (!fromForeignPointer1_interop__.isNumber(arg0Value)) {
                        Object object = this.fromForeignPointer(arg0Value, fromForeignPointer1_interop__, this.fromForeignPointer1_toPointer_, this.fromForeignPointer1_foreigns_);
                        return object;
                    }
                }
                finally {
                    encapsulating_.set(prev_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ExplodeLoop
    public Object executeWithTarget(Object arg0Value) {
        int state = this.state_;
        if ((state & 1) != 0 && arg0Value instanceof Integer) {
            int arg0Value_ = (Integer)arg0Value;
            return this.fromInt(arg0Value_);
        }
        if ((state & 2) != 0 && arg0Value instanceof Character) {
            char arg0Value_ = ((Character)arg0Value).charValue();
            return this.fromChar(arg0Value_);
        }
        if ((state & 4) != 0 && arg0Value instanceof Short) {
            short arg0Value_ = (Short)arg0Value;
            return this.fromShort(arg0Value_);
        }
        if ((state & 8) != 0 && arg0Value instanceof Long) {
            long arg0Value_ = (Long)arg0Value;
            return this.fromLong(arg0Value_);
        }
        if ((state & 0x10) != 0 && arg0Value instanceof Byte) {
            byte arg0Value_ = (Byte)arg0Value;
            return this.fromByte(arg0Value_);
        }
        if ((state & 0x20) != 0 && arg0Value instanceof Float) {
            float arg0Value_ = ((Float)arg0Value).floatValue();
            return this.fromFloat(arg0Value_);
        }
        if ((state & 0x40) != 0 && arg0Value instanceof Double) {
            double arg0Value_ = (Double)arg0Value;
            return this.fromDouble(arg0Value_);
        }
        if ((state & 0x80) != 0 && arg0Value instanceof Boolean) {
            boolean arg0Value_ = (Boolean)arg0Value;
            return this.fromBoolean(arg0Value_);
        }
        if ((state & 0x100) != 0 && arg0Value instanceof String) {
            String arg0Value_ = (String)arg0Value;
            return this.fromString(arg0Value_);
        }
        if ((state & 0x200) != 0 && LLVMTypes.isPointer(arg0Value)) {
            LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
            return this.fromPointer(arg0Value_);
        }
        if ((state & 0x3C00) != 0) {
            Node prev_;
            EncapsulatingNodeReference encapsulating_;
            if ((state & 0x400) != 0) {
                FromForeign0Data s11_ = this.fromForeign0_cache;
                while (s11_ != null) {
                    if (s11_.foreigns_.accepts(arg0Value) && s11_.foreigns_.isForeign(arg0Value) && s11_.interop_.isNumber(s11_.foreigns_.asForeign(arg0Value))) {
                        return this.fromForeign(arg0Value, s11_.foreigns_, s11_.interop_, s11_.exception_);
                    }
                    s11_ = s11_.next_;
                }
            }
            if ((state & 0x800) != 0) {
                encapsulating_ = EncapsulatingNodeReference.getCurrent();
                prev_ = encapsulating_.set((Node)this);
                try {
                    LLVMAsForeignLibrary fromForeign1_foreigns__ = (LLVMAsForeignLibrary)L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached(arg0Value);
                    if (fromForeign1_foreigns__.isForeign(arg0Value) && this.fromForeign1_interop_.isNumber(fromForeign1_foreigns__.asForeign(arg0Value))) {
                        Long l = this.fromForeign(arg0Value, fromForeign1_foreigns__, this.fromForeign1_interop_, this.fromForeign1_exception_);
                        return l;
                    }
                }
                finally {
                    encapsulating_.set(prev_);
                }
            }
            if ((state & 0x1000) != 0) {
                FromForeignPointer0Data s13_ = this.fromForeignPointer0_cache;
                while (s13_ != null) {
                    if (s13_.interop_.accepts(arg0Value) && s13_.foreigns_.isForeign(arg0Value) && !s13_.interop_.isNumber(arg0Value)) {
                        return this.fromForeignPointer(arg0Value, s13_.interop_, s13_.toPointer_, s13_.foreigns_);
                    }
                    s13_ = s13_.next_;
                }
            }
            if ((state & 0x2000) != 0 && this.fromForeignPointer1_foreigns_.isForeign(arg0Value)) {
                encapsulating_ = EncapsulatingNodeReference.getCurrent();
                prev_ = encapsulating_.set((Node)this);
                try {
                    InteropLibrary fromForeignPointer1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value);
                    if (!fromForeignPointer1_interop__.isNumber(arg0Value)) {
                        Object object = this.fromForeignPointer(arg0Value, fromForeignPointer1_interop__, this.fromForeignPointer1_toPointer_, this.fromForeignPointer1_foreigns_);
                        return object;
                    }
                }
                finally {
                    encapsulating_.set(prev_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAndSpecialize(Object arg0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            if (arg0Value instanceof Integer) {
                int arg0Value_ = (Integer)arg0Value;
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                Long l = this.fromInt(arg0Value_);
                return l;
            }
            if (arg0Value instanceof Character) {
                char arg0Value_ = ((Character)arg0Value).charValue();
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                Long l = this.fromChar(arg0Value_);
                return l;
            }
            if (arg0Value instanceof Short) {
                short arg0Value_ = (Short)arg0Value;
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                Long l = this.fromShort(arg0Value_);
                return l;
            }
            if (arg0Value instanceof Long) {
                long arg0Value_ = (Long)arg0Value;
                this.state_ = state |= 8;
                lock.unlock();
                hasLock = false;
                Long l = this.fromLong(arg0Value_);
                return l;
            }
            if (arg0Value instanceof Byte) {
                byte arg0Value_ = (Byte)arg0Value;
                this.state_ = state |= 0x10;
                lock.unlock();
                hasLock = false;
                Long l = this.fromByte(arg0Value_);
                return l;
            }
            if (arg0Value instanceof Float) {
                float arg0Value_ = ((Float)arg0Value).floatValue();
                this.state_ = state |= 0x20;
                lock.unlock();
                hasLock = false;
                Long l = this.fromFloat(arg0Value_);
                return l;
            }
            if (arg0Value instanceof Double) {
                double arg0Value_ = (Double)arg0Value;
                this.state_ = state |= 0x40;
                lock.unlock();
                hasLock = false;
                Long l = this.fromDouble(arg0Value_);
                return l;
            }
            if (arg0Value instanceof Boolean) {
                boolean arg0Value_ = (Boolean)arg0Value;
                this.state_ = state |= 0x80;
                lock.unlock();
                hasLock = false;
                Long l = this.fromBoolean(arg0Value_);
                return l;
            }
            if (arg0Value instanceof String) {
                String arg0Value_ = (String)arg0Value;
                this.state_ = state |= 0x100;
                lock.unlock();
                hasLock = false;
                Long l = this.fromString(arg0Value_);
                return l;
            }
            if (LLVMTypes.isPointer(arg0Value)) {
                LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
                this.state_ = state |= 0x200;
                lock.unlock();
                hasLock = false;
                LLVMPointer lLVMPointer = this.fromPointer(arg0Value_);
                return lLVMPointer;
            }
            if ((exclude & 1) == 0) {
                InteropLibrary interop__;
                Object foreigns__;
                int count11_ = 0;
                FromForeign0Data s11_ = this.fromForeign0_cache;
                if ((state & 0x400) != 0) {
                    while (!(s11_ == null || s11_.foreigns_.accepts(arg0Value) && s11_.foreigns_.isForeign(arg0Value) && s11_.interop_.isNumber(s11_.foreigns_.asForeign(arg0Value)))) {
                        s11_ = s11_.next_;
                        ++count11_;
                    }
                }
                if (s11_ == null && ((LLVMAsForeignLibrary)((Object)(foreigns__ = (LLVMAsForeignLibrary)super.insert((Node)L_L_V_M_AS_FOREIGN_LIBRARY_.create(arg0Value))))).isForeign(arg0Value) && (interop__ = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.createDispatched(3))).isNumber(((LLVMAsForeignLibrary)((Object)foreigns__)).asForeign(arg0Value)) && count11_ < 5) {
                    s11_ = (FromForeign0Data)super.insert((Node)new FromForeign0Data(this.fromForeign0_cache));
                    s11_.foreigns_ = (LLVMAsForeignLibrary)((Object)s11_.insertAccessor(foreigns__));
                    s11_.interop_ = s11_.insertAccessor(interop__);
                    s11_.exception_ = BranchProfile.create();
                    this.fromForeign0_cache = s11_;
                    this.state_ = state |= 0x400;
                }
                if (s11_ != null) {
                    lock.unlock();
                    hasLock = false;
                    foreigns__ = this.fromForeign(arg0Value, s11_.foreigns_, s11_.interop_, s11_.exception_);
                    return foreigns__;
                }
            }
            LLVMAsForeignLibrary fromForeign1_foreigns__ = null;
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                InteropLibrary fromForeign1_interop__;
                fromForeign1_foreigns__ = (LLVMAsForeignLibrary)L_L_V_M_AS_FOREIGN_LIBRARY_.getUncached(arg0Value);
                if (fromForeign1_foreigns__.isForeign(arg0Value) && (fromForeign1_interop__ = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.createDispatched(3))).isNumber(fromForeign1_foreigns__.asForeign(arg0Value))) {
                    this.fromForeign1_interop_ = (InteropLibrary)super.insert((Node)fromForeign1_interop__);
                    this.fromForeign1_exception_ = BranchProfile.create();
                    this.exclude_ = exclude |= 1;
                    this.fromForeign0_cache = null;
                    state &= 0xFFFFFBFF;
                    this.state_ = state |= 0x800;
                    lock.unlock();
                    hasLock = false;
                    Long l = this.fromForeign(arg0Value, fromForeign1_foreigns__, fromForeign1_interop__, this.fromForeign1_exception_);
                    return l;
                }
            }
            finally {
                encapsulating_.set(prev_);
            }
            if ((exclude & 2) == 0) {
                InteropLibrary interop__1;
                Object foreigns__1;
                int count13_ = 0;
                FromForeignPointer0Data s13_ = this.fromForeignPointer0_cache;
                if ((state & 0x1000) != 0) {
                    while (!(s13_ == null || s13_.interop_.accepts(arg0Value) && s13_.foreigns_.isForeign(arg0Value) && !s13_.interop_.isNumber(arg0Value))) {
                        s13_ = s13_.next_;
                        ++count13_;
                    }
                }
                if (s13_ == null && (foreigns__1 = (LLVMAsForeignLibrary)super.insert((Node)L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(3))).isForeign(arg0Value) && !(interop__1 = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.create(arg0Value))).isNumber(arg0Value) && count13_ < 5) {
                    s13_ = (FromForeignPointer0Data)super.insert((Node)new FromForeignPointer0Data(this.fromForeignPointer0_cache));
                    s13_.interop_ = s13_.insertAccessor(interop__1);
                    s13_.toPointer_ = s13_.insertAccessor(ToPointer.create());
                    s13_.foreigns_ = s13_.insertAccessor(foreigns__1);
                    this.fromForeignPointer0_cache = s13_;
                    this.state_ = state |= 0x1000;
                }
                if (s13_ != null) {
                    lock.unlock();
                    hasLock = false;
                    foreigns__1 = this.fromForeignPointer(arg0Value, s13_.interop_, s13_.toPointer_, s13_.foreigns_);
                    return foreigns__1;
                }
            }
            InteropLibrary fromForeignPointer1_interop__ = null;
            encapsulating_ = EncapsulatingNodeReference.getCurrent();
            prev_ = encapsulating_.set((Node)this);
            try {
                LLVMAsForeignLibrary fromForeignPointer1_foreigns__ = (LLVMAsForeignLibrary)super.insert((Node)L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(3));
                if (fromForeignPointer1_foreigns__.isForeign(arg0Value) && !(fromForeignPointer1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value)).isNumber(arg0Value)) {
                    this.fromForeignPointer1_toPointer_ = (ToPointer)super.insert((Node)ToPointer.create());
                    this.fromForeignPointer1_foreigns_ = (LLVMAsForeignLibrary)super.insert((Node)fromForeignPointer1_foreigns__);
                    this.exclude_ = exclude |= 2;
                    this.fromForeignPointer0_cache = null;
                    state &= 0xFFFFEFFF;
                    this.state_ = state |= 0x2000;
                    lock.unlock();
                    hasLock = false;
                    Object object = this.fromForeignPointer(arg0Value, fromForeignPointer1_interop__, this.fromForeignPointer1_toPointer_, fromForeignPointer1_foreigns__);
                    return object;
                }
            }
            finally {
                encapsulating_.set(prev_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            FromForeign0Data s11_ = this.fromForeign0_cache;
            FromForeignPointer0Data s13_ = this.fromForeignPointer0_cache;
            if (!(s11_ != null && s11_.next_ != null || s13_ != null && s13_.next_ != null)) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    public static ToI64 create() {
        return new ToI64NodeGen();
    }

    @GeneratedBy(value=ToI64.class)
    private static final class FromForeignPointer0Data
    extends Node {
        @Node.Child
        FromForeignPointer0Data next_;
        @Node.Child
        InteropLibrary interop_;
        @Node.Child
        ToPointer toPointer_;
        @Node.Child
        LLVMAsForeignLibrary foreigns_;

        FromForeignPointer0Data(FromForeignPointer0Data next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }

    @GeneratedBy(value=ToI64.class)
    private static final class FromForeign0Data
    extends Node {
        @Node.Child
        FromForeign0Data next_;
        @Node.Child
        LLVMAsForeignLibrary foreigns_;
        @Node.Child
        InteropLibrary interop_;
        @CompilerDirectives.CompilationFinal
        BranchProfile exception_;

        FromForeign0Data(FromForeign0Data next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

