/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.convert;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.interop.LLVMInternalTruffleObject;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.interop.convert.ToAnyLLVM;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=ToAnyLLVM.class)
public final class ToAnyLLVMNodeGen
extends ToAnyLLVM {
    private static final LibraryFactory<LLVMAsForeignLibrary> L_L_V_M_AS_FOREIGN_LIBRARY_ = LibraryFactory.resolve(LLVMAsForeignLibrary.class);
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @Node.Child
    private LLVMAsForeignLibrary fromUnknownObject_foreigns_;

    private ToAnyLLVMNodeGen() {
    }

    @Override
    public Object executeWithForeignToLLVMType(Object arg0Value, LLVMInteropType.Structured type, ForeignToLLVM.ForeignToLLVMType ftlType) {
        int state = this.state_;
        if ((state & 1) != 0 && arg0Value instanceof Integer) {
            int arg0Value_ = (Integer)arg0Value;
            return this.fromInt(arg0Value_);
        }
        if ((state & 2) != 0 && arg0Value instanceof Character) {
            char arg0Value_ = ((Character)arg0Value).charValue();
            return Character.valueOf(this.fromChar(arg0Value_));
        }
        if ((state & 4) != 0 && arg0Value instanceof Long) {
            long arg0Value_ = (Long)arg0Value;
            return this.fromLong(arg0Value_);
        }
        if ((state & 8) != 0 && arg0Value instanceof Byte) {
            byte arg0Value_ = (Byte)arg0Value;
            return this.fromByte(arg0Value_);
        }
        if ((state & 0x10) != 0 && arg0Value instanceof Short) {
            short arg0Value_ = (Short)arg0Value;
            return this.fromShort(arg0Value_);
        }
        if ((state & 0x20) != 0 && arg0Value instanceof Float) {
            float arg0Value_ = ((Float)arg0Value).floatValue();
            return Float.valueOf(this.fromFloat(arg0Value_));
        }
        if ((state & 0x40) != 0 && arg0Value instanceof Double) {
            double arg0Value_ = (Double)arg0Value;
            return this.fromDouble(arg0Value_);
        }
        if ((state & 0x80) != 0 && arg0Value instanceof Boolean) {
            boolean arg0Value_ = (Boolean)arg0Value;
            return this.fromBoolean(arg0Value_);
        }
        if ((state & 0x100) != 0 && arg0Value instanceof String) {
            String arg0Value_ = (String)arg0Value;
            return this.fromString(arg0Value_);
        }
        if ((state & 0x200) != 0 && LLVMTypes.isPointer(arg0Value)) {
            LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
            return this.fromPointer(arg0Value_);
        }
        if ((state & 0x400) != 0 && this.fromUnknownObject_foreigns_.isForeign(arg0Value)) {
            return this.fromUnknownObject(arg0Value, this.fromUnknownObject_foreigns_);
        }
        if ((state & 0x800) != 0 && arg0Value instanceof LLVMInternalTruffleObject) {
            LLVMInternalTruffleObject arg0Value_ = (LLVMInternalTruffleObject)arg0Value;
            return this.fromInternal(arg0Value_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    @Override
    public Object executeWithType(Object arg0Value, LLVMInteropType.Structured type) {
        int state = this.state_;
        if ((state & 1) != 0 && arg0Value instanceof Integer) {
            int arg0Value_ = (Integer)arg0Value;
            return this.fromInt(arg0Value_);
        }
        if ((state & 2) != 0 && arg0Value instanceof Character) {
            char arg0Value_ = ((Character)arg0Value).charValue();
            return Character.valueOf(this.fromChar(arg0Value_));
        }
        if ((state & 4) != 0 && arg0Value instanceof Long) {
            long arg0Value_ = (Long)arg0Value;
            return this.fromLong(arg0Value_);
        }
        if ((state & 8) != 0 && arg0Value instanceof Byte) {
            byte arg0Value_ = (Byte)arg0Value;
            return this.fromByte(arg0Value_);
        }
        if ((state & 0x10) != 0 && arg0Value instanceof Short) {
            short arg0Value_ = (Short)arg0Value;
            return this.fromShort(arg0Value_);
        }
        if ((state & 0x20) != 0 && arg0Value instanceof Float) {
            float arg0Value_ = ((Float)arg0Value).floatValue();
            return Float.valueOf(this.fromFloat(arg0Value_));
        }
        if ((state & 0x40) != 0 && arg0Value instanceof Double) {
            double arg0Value_ = (Double)arg0Value;
            return this.fromDouble(arg0Value_);
        }
        if ((state & 0x80) != 0 && arg0Value instanceof Boolean) {
            boolean arg0Value_ = (Boolean)arg0Value;
            return this.fromBoolean(arg0Value_);
        }
        if ((state & 0x100) != 0 && arg0Value instanceof String) {
            String arg0Value_ = (String)arg0Value;
            return this.fromString(arg0Value_);
        }
        if ((state & 0x200) != 0 && LLVMTypes.isPointer(arg0Value)) {
            LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
            return this.fromPointer(arg0Value_);
        }
        if ((state & 0x400) != 0 && this.fromUnknownObject_foreigns_.isForeign(arg0Value)) {
            return this.fromUnknownObject(arg0Value, this.fromUnknownObject_foreigns_);
        }
        if ((state & 0x800) != 0 && arg0Value instanceof LLVMInternalTruffleObject) {
            LLVMInternalTruffleObject arg0Value_ = (LLVMInternalTruffleObject)arg0Value;
            return this.fromInternal(arg0Value_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    @Override
    public Object executeWithTarget(Object arg0Value) {
        int state = this.state_;
        if ((state & 1) != 0 && arg0Value instanceof Integer) {
            int arg0Value_ = (Integer)arg0Value;
            return this.fromInt(arg0Value_);
        }
        if ((state & 2) != 0 && arg0Value instanceof Character) {
            char arg0Value_ = ((Character)arg0Value).charValue();
            return Character.valueOf(this.fromChar(arg0Value_));
        }
        if ((state & 4) != 0 && arg0Value instanceof Long) {
            long arg0Value_ = (Long)arg0Value;
            return this.fromLong(arg0Value_);
        }
        if ((state & 8) != 0 && arg0Value instanceof Byte) {
            byte arg0Value_ = (Byte)arg0Value;
            return this.fromByte(arg0Value_);
        }
        if ((state & 0x10) != 0 && arg0Value instanceof Short) {
            short arg0Value_ = (Short)arg0Value;
            return this.fromShort(arg0Value_);
        }
        if ((state & 0x20) != 0 && arg0Value instanceof Float) {
            float arg0Value_ = ((Float)arg0Value).floatValue();
            return Float.valueOf(this.fromFloat(arg0Value_));
        }
        if ((state & 0x40) != 0 && arg0Value instanceof Double) {
            double arg0Value_ = (Double)arg0Value;
            return this.fromDouble(arg0Value_);
        }
        if ((state & 0x80) != 0 && arg0Value instanceof Boolean) {
            boolean arg0Value_ = (Boolean)arg0Value;
            return this.fromBoolean(arg0Value_);
        }
        if ((state & 0x100) != 0 && arg0Value instanceof String) {
            String arg0Value_ = (String)arg0Value;
            return this.fromString(arg0Value_);
        }
        if ((state & 0x200) != 0 && LLVMTypes.isPointer(arg0Value)) {
            LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
            return this.fromPointer(arg0Value_);
        }
        if ((state & 0x400) != 0 && this.fromUnknownObject_foreigns_.isForeign(arg0Value)) {
            return this.fromUnknownObject(arg0Value, this.fromUnknownObject_foreigns_);
        }
        if ((state & 0x800) != 0 && arg0Value instanceof LLVMInternalTruffleObject) {
            LLVMInternalTruffleObject arg0Value_ = (LLVMInternalTruffleObject)arg0Value;
            return this.fromInternal(arg0Value_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    private Object executeAndSpecialize(Object arg0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            if (arg0Value instanceof Integer) {
                int arg0Value_ = (Integer)arg0Value;
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                Integer n = this.fromInt(arg0Value_);
                return n;
            }
            if (arg0Value instanceof Character) {
                char arg0Value_ = ((Character)arg0Value).charValue();
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                Character c = Character.valueOf(this.fromChar(arg0Value_));
                return c;
            }
            if (arg0Value instanceof Long) {
                long arg0Value_ = (Long)arg0Value;
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                Long l = this.fromLong(arg0Value_);
                return l;
            }
            if (arg0Value instanceof Byte) {
                byte arg0Value_ = (Byte)arg0Value;
                this.state_ = state |= 8;
                lock.unlock();
                hasLock = false;
                Byte by = this.fromByte(arg0Value_);
                return by;
            }
            if (arg0Value instanceof Short) {
                short arg0Value_ = (Short)arg0Value;
                this.state_ = state |= 0x10;
                lock.unlock();
                hasLock = false;
                Short s = this.fromShort(arg0Value_);
                return s;
            }
            if (arg0Value instanceof Float) {
                float arg0Value_ = ((Float)arg0Value).floatValue();
                this.state_ = state |= 0x20;
                lock.unlock();
                hasLock = false;
                Float f = Float.valueOf(this.fromFloat(arg0Value_));
                return f;
            }
            if (arg0Value instanceof Double) {
                double arg0Value_ = (Double)arg0Value;
                this.state_ = state |= 0x40;
                lock.unlock();
                hasLock = false;
                Double d = this.fromDouble(arg0Value_);
                return d;
            }
            if (arg0Value instanceof Boolean) {
                boolean arg0Value_ = (Boolean)arg0Value;
                this.state_ = state |= 0x80;
                lock.unlock();
                hasLock = false;
                Boolean bl = this.fromBoolean(arg0Value_);
                return bl;
            }
            if (arg0Value instanceof String) {
                String arg0Value_ = (String)arg0Value;
                this.state_ = state |= 0x100;
                lock.unlock();
                hasLock = false;
                String string = this.fromString(arg0Value_);
                return string;
            }
            if (LLVMTypes.isPointer(arg0Value)) {
                LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
                this.state_ = state |= 0x200;
                lock.unlock();
                hasLock = false;
                LLVMPointer lLVMPointer = this.fromPointer(arg0Value_);
                return lLVMPointer;
            }
            LLVMAsForeignLibrary fromUnknownObject_foreigns__ = (LLVMAsForeignLibrary)super.insert((Node)L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(3));
            if (fromUnknownObject_foreigns__.isForeign(arg0Value)) {
                this.fromUnknownObject_foreigns_ = (LLVMAsForeignLibrary)super.insert((Node)fromUnknownObject_foreigns__);
                this.state_ = state |= 0x400;
                lock.unlock();
                hasLock = false;
                LLVMManagedPointer lLVMManagedPointer = this.fromUnknownObject(arg0Value, fromUnknownObject_foreigns__);
                return lLVMManagedPointer;
            }
            if (arg0Value instanceof LLVMInternalTruffleObject) {
                LLVMInternalTruffleObject arg0Value_ = (LLVMInternalTruffleObject)arg0Value;
                this.state_ = state |= 0x800;
                lock.unlock();
                hasLock = false;
                LLVMManagedPointer lLVMManagedPointer = this.fromInternal(arg0Value_);
                return lLVMManagedPointer;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static ToAnyLLVM create() {
        return new ToAnyLLVMNodeGen();
    }
}

