/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.interop.LLVMDataEscapeNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropAccessNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropAccessNodeGen;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropWriteNode;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMInteropWriteNode.class)
public final class LLVMInteropWriteNodeGen
extends LLVMInteropWriteNode {
    private static final Uncached UNCACHED = new Uncached();
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @Node.Child
    private LLVMInteropAccessNode knownType_access_;
    @Node.Child
    private LLVMInteropWriteNode.WriteLocationNode knownType_write_;
    @Node.Child
    private LLVMInteropWriteNode.WriteLocationNode unknownType_write_;

    private LLVMInteropWriteNodeGen() {
    }

    @Override
    public void execute(LLVMInteropType.Structured arg0Value, Object arg1Value, long arg2Value, Object arg3Value, ForeignToLLVM.ForeignToLLVMType arg4Value) {
        int state = this.state_;
        if (state != 0) {
            if ((state & 1) != 0 && arg0Value != null) {
                this.doKnownType(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, this.knownType_access_, this.knownType_write_);
                return;
            }
            if ((state & 2) != 0 && arg0Value == null) {
                this.doUnknownType(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, this.unknownType_write_);
                return;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
    }

    private void executeAndSpecialize(LLVMInteropType.Structured arg0Value, Object arg1Value, long arg2Value, Object arg3Value, ForeignToLLVM.ForeignToLLVMType arg4Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            if (arg0Value != null) {
                this.knownType_access_ = (LLVMInteropAccessNode)super.insert((Node)LLVMInteropAccessNode.create());
                this.knownType_write_ = (LLVMInteropWriteNode.WriteLocationNode)super.insert((Node)WriteLocationNodeGen.create());
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                this.doKnownType(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, this.knownType_access_, this.knownType_write_);
                return;
            }
            if (arg0Value == null) {
                this.unknownType_write_ = (LLVMInteropWriteNode.WriteLocationNode)super.insert((Node)WriteLocationNodeGen.create());
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                this.doUnknownType(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, this.unknownType_write_);
                return;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value, arg3Value, arg4Value});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static LLVMInteropWriteNode create() {
        return new LLVMInteropWriteNodeGen();
    }

    public static LLVMInteropWriteNode getUncached() {
        return UNCACHED;
    }

    @GeneratedBy(value=LLVMInteropWriteNode.ConvertOutgoingNode.class)
    static final class ConvertOutgoingNodeGen
    extends LLVMInteropWriteNode.ConvertOutgoingNode {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @Node.Child
        private KnownTypeData knownType_cache;
        @Node.Child
        private UnknownTypeData unknownType_cache;

        private ConvertOutgoingNodeGen() {
        }

        @Override
        @ExplodeLoop
        Object execute(Object arg0Value, LLVMInteropType.Value arg1Value, ForeignToLLVM.ForeignToLLVMType arg2Value) {
            int state = this.state_;
            if (state != 0) {
                if ((state & 1) != 0 && arg1Value != null) {
                    KnownTypeData s1_ = this.knownType_cache;
                    while (s1_ != null) {
                        if (s1_.cachedOutgoingType_ == arg1Value.kind.foreignToLLVMType && arg2Value.getSizeInBytes() == s1_.cachedOutgoingType_.getSizeInBytes()) {
                            return this.doKnownType(arg0Value, arg1Value, arg2Value, s1_.cachedOutgoingType_, s1_.dataEscape_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 2) != 0) {
                    UnknownTypeData s2_ = this.unknownType_cache;
                    while (s2_ != null) {
                        if (LLVMInteropWriteNode.ConvertOutgoingNode.typeMismatch(arg1Value, s2_.cachedType_) && s2_.cachedType_ == arg2Value) {
                            return this.doUnknownType(arg0Value, arg1Value, arg2Value, s2_.cachedType_, s2_.dataEscape_);
                        }
                        s2_ = s2_.next_;
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        private Object executeAndSpecialize(Object arg0Value, LLVMInteropType.Value arg1Value, ForeignToLLVM.ForeignToLLVMType arg2Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                ForeignToLLVM.ForeignToLLVMType cachedType__;
                if (arg1Value != null) {
                    Object cachedOutgoingType__;
                    int count1_ = 0;
                    KnownTypeData s1_ = this.knownType_cache;
                    if ((state & 1) != 0) {
                        while (s1_ != null && (s1_.cachedOutgoingType_ != arg1Value.kind.foreignToLLVMType || arg2Value.getSizeInBytes() != s1_.cachedOutgoingType_.getSizeInBytes())) {
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null) {
                        cachedOutgoingType__ = arg1Value.kind.foreignToLLVMType;
                        if (arg2Value.getSizeInBytes() == cachedOutgoingType__.getSizeInBytes() && count1_ < 3) {
                            s1_ = (KnownTypeData)super.insert((Node)new KnownTypeData(this.knownType_cache));
                            s1_.cachedOutgoingType_ = cachedOutgoingType__;
                            s1_.dataEscape_ = s1_.insertAccessor(LLVMDataEscapeNode.create(cachedOutgoingType__));
                            this.knownType_cache = s1_;
                            this.state_ = state |= 1;
                        }
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        cachedOutgoingType__ = this.doKnownType(arg0Value, arg1Value, arg2Value, s1_.cachedOutgoingType_, s1_.dataEscape_);
                        return cachedOutgoingType__;
                    }
                }
                int count2_ = 0;
                UnknownTypeData s2_ = this.unknownType_cache;
                if ((state & 2) != 0) {
                    while (!(s2_ == null || LLVMInteropWriteNode.ConvertOutgoingNode.typeMismatch(arg1Value, s2_.cachedType_) && s2_.cachedType_ == arg2Value)) {
                        s2_ = s2_.next_;
                        ++count2_;
                    }
                }
                if (s2_ == null && LLVMInteropWriteNode.ConvertOutgoingNode.typeMismatch(arg1Value, cachedType__ = arg2Value) && count2_ < 3) {
                    s2_ = (UnknownTypeData)super.insert((Node)new UnknownTypeData(this.unknownType_cache));
                    s2_.cachedType_ = cachedType__;
                    s2_.dataEscape_ = s2_.insertAccessor(LLVMDataEscapeNode.create(arg2Value));
                    this.unknownType_cache = s2_;
                    this.state_ = state |= 2;
                }
                if (s2_ != null) {
                    lock.unlock();
                    hasLock = false;
                    Object object = this.doUnknownType(arg0Value, arg1Value, arg2Value, s2_.cachedType_, s2_.dataEscape_);
                    return object;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                KnownTypeData s1_ = this.knownType_cache;
                UnknownTypeData s2_ = this.unknownType_cache;
                if (!(s1_ != null && s1_.next_ != null || s2_ != null && s2_.next_ != null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMInteropWriteNode.ConvertOutgoingNode create() {
            return new ConvertOutgoingNodeGen();
        }

        public static LLVMInteropWriteNode.ConvertOutgoingNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=LLVMInteropWriteNode.ConvertOutgoingNode.class)
        private static final class Uncached
        extends LLVMInteropWriteNode.ConvertOutgoingNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            Object execute(Object arg0Value, LLVMInteropType.Value arg1Value, ForeignToLLVM.ForeignToLLVMType arg2Value) {
                if (arg1Value != null && arg2Value.getSizeInBytes() == arg1Value.kind.foreignToLLVMType.getSizeInBytes()) {
                    return this.doKnownType(arg0Value, arg1Value, arg2Value, arg1Value.kind.foreignToLLVMType, LLVMDataEscapeNode.getUncached(arg1Value.kind.foreignToLLVMType));
                }
                if (LLVMInteropWriteNode.ConvertOutgoingNode.typeMismatch(arg1Value, arg2Value)) {
                    return this.doUnknownType(arg0Value, arg1Value, arg2Value, arg2Value, LLVMDataEscapeNode.getUncached(arg2Value));
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            public boolean isAdoptable() {
                return false;
            }
        }

        @GeneratedBy(value=LLVMInteropWriteNode.ConvertOutgoingNode.class)
        private static final class UnknownTypeData
        extends Node {
            @Node.Child
            UnknownTypeData next_;
            @CompilerDirectives.CompilationFinal
            ForeignToLLVM.ForeignToLLVMType cachedType_;
            @Node.Child
            LLVMDataEscapeNode dataEscape_;

            UnknownTypeData(UnknownTypeData next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }

        @GeneratedBy(value=LLVMInteropWriteNode.ConvertOutgoingNode.class)
        private static final class KnownTypeData
        extends Node {
            @Node.Child
            KnownTypeData next_;
            @CompilerDirectives.CompilationFinal
            ForeignToLLVM.ForeignToLLVMType cachedOutgoingType_;
            @Node.Child
            LLVMDataEscapeNode dataEscape_;

            KnownTypeData(KnownTypeData next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMInteropWriteNode.ReinterpretLLVMAsLong.class)
    static final class ReinterpretLLVMAsLongNodeGen
    extends LLVMInteropWriteNode.ReinterpretLLVMAsLong {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @Node.Child
        private LLVMDataEscapeNode i16_dataEscape_;
        @Node.Child
        private LLVMDataEscapeNode i32_dataEscape_;
        @Node.Child
        private LLVMDataEscapeNode i64_dataEscape_;

        private ReinterpretLLVMAsLongNodeGen() {
        }

        @Override
        long executeWithWriteType(Object arg0Value, ForeignToLLVM.ForeignToLLVMType arg1Value) {
            int state = this.state_;
            if (state != 0) {
                if ((state & 1) != 0 && arg1Value.getSizeInBytes() == 2) {
                    return this.doI16(arg0Value, arg1Value, this.i16_dataEscape_);
                }
                if ((state & 2) != 0 && arg1Value.getSizeInBytes() == 4) {
                    return this.doI32(arg0Value, arg1Value, this.i32_dataEscape_);
                }
                if ((state & 4) != 0 && arg1Value.getSizeInBytes() == 8) {
                    return this.doI64(arg0Value, arg1Value, this.i64_dataEscape_);
                }
                if ((state & 8) != 0 && ReinterpretLLVMAsLongNodeGen.fallbackGuard_(state, arg0Value, arg1Value)) {
                    return this.fallback(arg0Value, arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long executeAndSpecialize(Object arg0Value, ForeignToLLVM.ForeignToLLVMType arg1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (arg1Value.getSizeInBytes() == 2) {
                    this.i16_dataEscape_ = (LLVMDataEscapeNode)super.insert((Node)LLVMDataEscapeNode.create(ForeignToLLVM.ForeignToLLVMType.I16));
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    long l = this.doI16(arg0Value, arg1Value, this.i16_dataEscape_);
                    return l;
                }
                if (arg1Value.getSizeInBytes() == 4) {
                    this.i32_dataEscape_ = (LLVMDataEscapeNode)super.insert((Node)LLVMDataEscapeNode.create(ForeignToLLVM.ForeignToLLVMType.I32));
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    long l = this.doI32(arg0Value, arg1Value, this.i32_dataEscape_);
                    return l;
                }
                if (arg1Value.getSizeInBytes() == 8) {
                    this.i64_dataEscape_ = (LLVMDataEscapeNode)super.insert((Node)LLVMDataEscapeNode.create(ForeignToLLVM.ForeignToLLVMType.I64));
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    long l = this.doI64(arg0Value, arg1Value, this.i64_dataEscape_);
                    return l;
                }
                this.state_ = state |= 8;
                lock.unlock();
                hasLock = false;
                long l = this.fallback(arg0Value, arg1Value);
                return l;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        private static boolean fallbackGuard_(int state, Object arg0Value, ForeignToLLVM.ForeignToLLVMType arg1Value) {
            if ((state & 1) == 0 && arg1Value.getSizeInBytes() == 2) {
                return false;
            }
            if ((state & 2) == 0 && arg1Value.getSizeInBytes() == 4) {
                return false;
            }
            return (state & 4) != 0 || arg1Value.getSizeInBytes() != 8;
        }

        public static LLVMInteropWriteNode.ReinterpretLLVMAsLong create() {
            return new ReinterpretLLVMAsLongNodeGen();
        }

        public static LLVMInteropWriteNode.ReinterpretLLVMAsLong getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=LLVMInteropWriteNode.ReinterpretLLVMAsLong.class)
        private static final class Uncached
        extends LLVMInteropWriteNode.ReinterpretLLVMAsLong {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            long executeWithWriteType(Object arg0Value, ForeignToLLVM.ForeignToLLVMType arg1Value) {
                if (arg1Value.getSizeInBytes() == 2) {
                    return this.doI16(arg0Value, arg1Value, LLVMDataEscapeNode.getUncached(ForeignToLLVM.ForeignToLLVMType.I16));
                }
                if (arg1Value.getSizeInBytes() == 4) {
                    return this.doI32(arg0Value, arg1Value, LLVMDataEscapeNode.getUncached(ForeignToLLVM.ForeignToLLVMType.I32));
                }
                if (arg1Value.getSizeInBytes() == 8) {
                    return this.doI64(arg0Value, arg1Value, LLVMDataEscapeNode.getUncached(ForeignToLLVM.ForeignToLLVMType.I64));
                }
                return this.fallback(arg0Value, arg1Value);
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            public boolean isAdoptable() {
                return false;
            }
        }
    }

    @GeneratedBy(value=LLVMInteropWriteNode.WriteLocationNode.class)
    static final class WriteLocationNodeGen
    extends LLVMInteropWriteNode.WriteLocationNode {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @Node.Child
        private WriteMember0Data writeMember0_cache;
        @Node.Child
        private LLVMInteropWriteNode.ConvertOutgoingNode writeMember1_convertOutgoing_;
        @CompilerDirectives.CompilationFinal
        private BranchProfile writeMember1_exception_;
        @Node.Child
        private WriteArrayElementTypeMatch0Data writeArrayElementTypeMatch0_cache;
        @Node.Child
        private LLVMInteropWriteNode.ConvertOutgoingNode writeArrayElementTypeMatch1_convertOutgoing_;
        @CompilerDirectives.CompilationFinal
        private BranchProfile writeArrayElementTypeMatch1_exception_;
        @Node.Child
        private WriteArrayElementToI80Data writeArrayElementToI80_cache;
        @Node.Child
        private LLVMInteropWriteNode.ReinterpretLLVMAsLong writeArrayElementToI81_toLong_;
        @CompilerDirectives.CompilationFinal
        private BranchProfile writeArrayElementToI81_exception_;

        private WriteLocationNodeGen() {
        }

        @Override
        @ExplodeLoop
        void execute(Object arg0Value, LLVMInteropAccessNode.AccessLocation arg1Value, Object arg2Value, ForeignToLLVM.ForeignToLLVMType arg3Value) {
            int state = this.state_;
            if (state != 0) {
                if ((state & 3) != 0 && arg0Value instanceof String) {
                    String arg0Value_ = (String)arg0Value;
                    if ((state & 1) != 0) {
                        WriteMember0Data s1_ = this.writeMember0_cache;
                        while (s1_ != null) {
                            if (s1_.interop_.accepts(arg1Value.base)) {
                                this.writeMember(arg0Value_, arg1Value, arg2Value, arg3Value, s1_.interop_, s1_.convertOutgoing_, s1_.exception_);
                                return;
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state & 2) != 0) {
                        this.writeMember1Boundary(state, arg0Value_, arg1Value, arg2Value, arg3Value);
                        return;
                    }
                }
                if ((state & 0x3C) != 0 && arg0Value instanceof Long) {
                    int writeArrayElementToI81_writeTypeSizeInBytes__;
                    ForeignToLLVM.ForeignToLLVMType writeArrayElementToI81_locationType__;
                    long arg0Value_ = (Long)arg0Value;
                    if ((state & 4) != 0) {
                        WriteArrayElementTypeMatch0Data s3_ = this.writeArrayElementTypeMatch0_cache;
                        while (s3_ != null) {
                            if (s3_.interop_.accepts(arg1Value.base) && LLVMInteropWriteNode.WriteLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg3Value)) {
                                this.writeArrayElementTypeMatch(arg0Value_, arg1Value, arg2Value, arg3Value, s3_.interop_, s3_.convertOutgoing_, s3_.exception_);
                                return;
                            }
                            s3_ = s3_.next_;
                        }
                    }
                    if ((state & 8) != 0 && LLVMInteropWriteNode.WriteLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg3Value)) {
                        this.writeArrayElementTypeMatch1Boundary(state, arg0Value_, arg1Value, arg2Value, arg3Value);
                        return;
                    }
                    if ((state & 0x10) != 0) {
                        WriteArrayElementToI80Data s5_ = this.writeArrayElementToI80_cache;
                        while (s5_ != null) {
                            int writeTypeSizeInBytes__;
                            ForeignToLLVM.ForeignToLLVMType locationType__;
                            if (s5_.interop_.accepts(arg1Value.base) && !LLVMInteropWriteNode.WriteLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg3Value) && (locationType__ = arg1Value.type.getKind().foreignToLLVMType).isI8() && (writeTypeSizeInBytes__ = arg3Value.getSizeInBytes()) > 1) {
                                this.writeArrayElementToI8(arg0Value_, arg1Value, arg2Value, arg3Value, s5_.interop_, s5_.toLong_, s5_.exception_, locationType__, writeTypeSizeInBytes__);
                                return;
                            }
                            s5_ = s5_.next_;
                        }
                    }
                    if ((state & 0x20) != 0 && !LLVMInteropWriteNode.WriteLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg3Value) && (writeArrayElementToI81_locationType__ = arg1Value.type.getKind().foreignToLLVMType).isI8() && (writeArrayElementToI81_writeTypeSizeInBytes__ = arg3Value.getSizeInBytes()) > 1) {
                        this.writeArrayElementToI81Boundary(state, arg0Value_, arg1Value, arg2Value, arg3Value);
                        return;
                    }
                }
                if ((state & 0x40) != 0 && WriteLocationNodeGen.fallbackGuard_(state, arg0Value, arg1Value, arg2Value, arg3Value)) {
                    this.fallback(arg0Value, arg1Value, arg2Value, arg3Value);
                    return;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private void writeMember1Boundary(int state, String arg0Value_, LLVMInteropAccessNode.AccessLocation arg1Value, Object arg2Value, ForeignToLLVM.ForeignToLLVMType arg3Value) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                InteropLibrary writeMember1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value.base);
                this.writeMember(arg0Value_, arg1Value, arg2Value, arg3Value, writeMember1_interop__, this.writeMember1_convertOutgoing_, this.writeMember1_exception_);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private void writeArrayElementTypeMatch1Boundary(int state, long arg0Value_, LLVMInteropAccessNode.AccessLocation arg1Value, Object arg2Value, ForeignToLLVM.ForeignToLLVMType arg3Value) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                InteropLibrary writeArrayElementTypeMatch1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value.base);
                this.writeArrayElementTypeMatch(arg0Value_, arg1Value, arg2Value, arg3Value, writeArrayElementTypeMatch1_interop__, this.writeArrayElementTypeMatch1_convertOutgoing_, this.writeArrayElementTypeMatch1_exception_);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private void writeArrayElementToI81Boundary(int state, long arg0Value_, LLVMInteropAccessNode.AccessLocation arg1Value, Object arg2Value, ForeignToLLVM.ForeignToLLVMType arg3Value) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                InteropLibrary writeArrayElementToI81_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value.base);
                ForeignToLLVM.ForeignToLLVMType writeArrayElementToI81_locationType__ = arg1Value.type.getKind().foreignToLLVMType;
                int writeArrayElementToI81_writeTypeSizeInBytes__ = arg3Value.getSizeInBytes();
                this.writeArrayElementToI8(arg0Value_, arg1Value, arg2Value, arg3Value, writeArrayElementToI81_interop__, this.writeArrayElementToI81_toLong_, this.writeArrayElementToI81_exception_, writeArrayElementToI81_locationType__, writeArrayElementToI81_writeTypeSizeInBytes__);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void executeAndSpecialize(Object arg0Value, LLVMInteropAccessNode.AccessLocation arg1Value, Object arg2Value, ForeignToLLVM.ForeignToLLVMType arg3Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                block33: {
                    long arg0Value_;
                    block38: {
                        WriteArrayElementTypeMatch0Data s3_;
                        int count3_;
                        block39: {
                            block40: {
                                String arg0Value_2;
                                block35: {
                                    WriteMember0Data s1_;
                                    int count1_;
                                    block36: {
                                        block37: {
                                            block34: {
                                                if (!(arg0Value instanceof String)) break block34;
                                                arg0Value_2 = (String)arg0Value;
                                                if ((exclude & 1) != 0) break block35;
                                                count1_ = 0;
                                                s1_ = this.writeMember0_cache;
                                                if ((state & 1) == 0) break block36;
                                                break block37;
                                            }
                                            if (!(arg0Value instanceof Long)) break block33;
                                            arg0Value_ = (Long)arg0Value;
                                            if ((exclude & 2) != 0) break block38;
                                            count3_ = 0;
                                            s3_ = this.writeArrayElementTypeMatch0_cache;
                                            if ((state & 4) == 0) break block39;
                                            break block40;
                                        }
                                        while (s1_ != null && !s1_.interop_.accepts(arg1Value.base)) {
                                            s1_ = s1_.next_;
                                            ++count1_;
                                        }
                                    }
                                    if (s1_ == null && count1_ < 3) {
                                        s1_ = (WriteMember0Data)super.insert((Node)new WriteMember0Data(this.writeMember0_cache));
                                        s1_.interop_ = (InteropLibrary)s1_.insertAccessor(INTEROP_LIBRARY_.create(arg1Value.base));
                                        s1_.convertOutgoing_ = s1_.insertAccessor(ConvertOutgoingNodeGen.create());
                                        s1_.exception_ = BranchProfile.create();
                                        this.writeMember0_cache = s1_;
                                        this.state_ = state |= 1;
                                    }
                                    if (s1_ != null) {
                                        lock.unlock();
                                        hasLock = false;
                                        this.writeMember(arg0Value_2, arg1Value, arg2Value, arg3Value, s1_.interop_, s1_.convertOutgoing_, s1_.exception_);
                                        return;
                                    }
                                }
                                InteropLibrary writeMember1_interop__ = null;
                                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                                Node prev_ = encapsulating_.set((Node)this);
                                try {
                                    writeMember1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value.base);
                                    this.writeMember1_convertOutgoing_ = (LLVMInteropWriteNode.ConvertOutgoingNode)super.insert((Node)ConvertOutgoingNodeGen.create());
                                    this.writeMember1_exception_ = BranchProfile.create();
                                    this.exclude_ = exclude |= 1;
                                    this.writeMember0_cache = null;
                                    state &= 0xFFFFFFFE;
                                    this.state_ = state |= 2;
                                    lock.unlock();
                                    hasLock = false;
                                    this.writeMember(arg0Value_2, arg1Value, arg2Value, arg3Value, writeMember1_interop__, this.writeMember1_convertOutgoing_, this.writeMember1_exception_);
                                    return;
                                }
                                finally {
                                    encapsulating_.set(prev_);
                                }
                            }
                            while (!(s3_ == null || s3_.interop_.accepts(arg1Value.base) && LLVMInteropWriteNode.WriteLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg3Value))) {
                                s3_ = s3_.next_;
                                ++count3_;
                            }
                        }
                        if (s3_ == null && LLVMInteropWriteNode.WriteLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg3Value) && count3_ < 3) {
                            s3_ = (WriteArrayElementTypeMatch0Data)super.insert((Node)new WriteArrayElementTypeMatch0Data(this.writeArrayElementTypeMatch0_cache));
                            s3_.interop_ = (InteropLibrary)s3_.insertAccessor(INTEROP_LIBRARY_.create(arg1Value.base));
                            s3_.convertOutgoing_ = s3_.insertAccessor(ConvertOutgoingNodeGen.create());
                            s3_.exception_ = BranchProfile.create();
                            this.writeArrayElementTypeMatch0_cache = s3_;
                            this.state_ = state |= 4;
                        }
                        if (s3_ != null) {
                            lock.unlock();
                            hasLock = false;
                            this.writeArrayElementTypeMatch(arg0Value_, arg1Value, arg2Value, arg3Value, s3_.interop_, s3_.convertOutgoing_, s3_.exception_);
                            return;
                        }
                    }
                    InteropLibrary writeArrayElementTypeMatch1_interop__ = null;
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set((Node)this);
                    try {
                        if (LLVMInteropWriteNode.WriteLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg3Value)) {
                            writeArrayElementTypeMatch1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value.base);
                            this.writeArrayElementTypeMatch1_convertOutgoing_ = (LLVMInteropWriteNode.ConvertOutgoingNode)super.insert((Node)ConvertOutgoingNodeGen.create());
                            this.writeArrayElementTypeMatch1_exception_ = BranchProfile.create();
                            this.exclude_ = exclude |= 2;
                            this.writeArrayElementTypeMatch0_cache = null;
                            state &= 0xFFFFFFFB;
                            this.state_ = state |= 8;
                            lock.unlock();
                            hasLock = false;
                            this.writeArrayElementTypeMatch(arg0Value_, arg1Value, arg2Value, arg3Value, writeArrayElementTypeMatch1_interop__, this.writeArrayElementTypeMatch1_convertOutgoing_, this.writeArrayElementTypeMatch1_exception_);
                            return;
                        }
                    }
                    finally {
                        encapsulating_.set(prev_);
                    }
                    int writeTypeSizeInBytes__ = 0;
                    ForeignToLLVM.ForeignToLLVMType locationType__ = null;
                    if ((exclude & 4) == 0) {
                        int count5_ = 0;
                        WriteArrayElementToI80Data s5_ = this.writeArrayElementToI80_cache;
                        if ((state & 0x10) != 0) {
                            while (!(s5_ == null || s5_.interop_.accepts(arg1Value.base) && !LLVMInteropWriteNode.WriteLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg3Value) && (locationType__ = arg1Value.type.getKind().foreignToLLVMType).isI8() && (writeTypeSizeInBytes__ = arg3Value.getSizeInBytes()) > 1)) {
                                s5_ = s5_.next_;
                                ++count5_;
                            }
                        }
                        if (s5_ == null && !LLVMInteropWriteNode.WriteLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg3Value) && (locationType__ = arg1Value.type.getKind().foreignToLLVMType).isI8() && (writeTypeSizeInBytes__ = arg3Value.getSizeInBytes()) > 1 && count5_ < 3) {
                            s5_ = (WriteArrayElementToI80Data)super.insert((Node)new WriteArrayElementToI80Data(this.writeArrayElementToI80_cache));
                            s5_.interop_ = (InteropLibrary)s5_.insertAccessor(INTEROP_LIBRARY_.create(arg1Value.base));
                            s5_.toLong_ = s5_.insertAccessor(ReinterpretLLVMAsLongNodeGen.create());
                            s5_.exception_ = BranchProfile.create();
                            this.writeArrayElementToI80_cache = s5_;
                            this.state_ = state |= 0x10;
                        }
                        if (s5_ != null) {
                            lock.unlock();
                            hasLock = false;
                            this.writeArrayElementToI8(arg0Value_, arg1Value, arg2Value, arg3Value, s5_.interop_, s5_.toLong_, s5_.exception_, locationType__, writeTypeSizeInBytes__);
                            return;
                        }
                    }
                    int writeArrayElementToI81_writeTypeSizeInBytes__ = 0;
                    ForeignToLLVM.ForeignToLLVMType writeArrayElementToI81_locationType__ = null;
                    InteropLibrary writeArrayElementToI81_interop__ = null;
                    EncapsulatingNodeReference encapsulating_2 = EncapsulatingNodeReference.getCurrent();
                    Node prev_2 = encapsulating_2.set((Node)this);
                    try {
                        if (!LLVMInteropWriteNode.WriteLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg3Value) && (writeArrayElementToI81_locationType__ = arg1Value.type.getKind().foreignToLLVMType).isI8() && (writeArrayElementToI81_writeTypeSizeInBytes__ = arg3Value.getSizeInBytes()) > 1) {
                            writeArrayElementToI81_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value.base);
                            this.writeArrayElementToI81_toLong_ = (LLVMInteropWriteNode.ReinterpretLLVMAsLong)super.insert((Node)ReinterpretLLVMAsLongNodeGen.create());
                            this.writeArrayElementToI81_exception_ = BranchProfile.create();
                            this.exclude_ = exclude |= 4;
                            this.writeArrayElementToI80_cache = null;
                            state &= 0xFFFFFFEF;
                            this.state_ = state |= 0x20;
                            lock.unlock();
                            hasLock = false;
                            this.writeArrayElementToI8(arg0Value_, arg1Value, arg2Value, arg3Value, writeArrayElementToI81_interop__, this.writeArrayElementToI81_toLong_, this.writeArrayElementToI81_exception_, writeArrayElementToI81_locationType__, writeArrayElementToI81_writeTypeSizeInBytes__);
                            return;
                        }
                    }
                    finally {
                        encapsulating_2.set(prev_2);
                    }
                }
                this.state_ = state |= 0x40;
                lock.unlock();
                hasLock = false;
                this.fallback(arg0Value, arg1Value, arg2Value, arg3Value);
                return;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                WriteMember0Data s1_ = this.writeMember0_cache;
                WriteArrayElementTypeMatch0Data s3_ = this.writeArrayElementTypeMatch0_cache;
                WriteArrayElementToI80Data s5_ = this.writeArrayElementToI80_cache;
                if (!(s1_ != null && s1_.next_ != null || s3_ != null && s3_.next_ != null || s5_ != null && s5_.next_ != null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        private static boolean fallbackGuard_(int state, Object arg0Value, LLVMInteropAccessNode.AccessLocation arg1Value, Object arg2Value, ForeignToLLVM.ForeignToLLVMType arg3Value) {
            if ((state & 2) == 0 && arg0Value instanceof String) {
                return false;
            }
            if (arg0Value instanceof Long) {
                if ((state & 8) == 0 && LLVMInteropWriteNode.WriteLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg3Value)) {
                    return false;
                }
                if ((state & 0x20) == 0 && !LLVMInteropWriteNode.WriteLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg3Value) && arg1Value.type.getKind().foreignToLLVMType.isI8() && arg3Value.getSizeInBytes() > 1) {
                    return false;
                }
            }
            return true;
        }

        public static LLVMInteropWriteNode.WriteLocationNode create() {
            return new WriteLocationNodeGen();
        }

        public static LLVMInteropWriteNode.WriteLocationNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=LLVMInteropWriteNode.WriteLocationNode.class)
        private static final class Uncached
        extends LLVMInteropWriteNode.WriteLocationNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            void execute(Object arg0Value, LLVMInteropAccessNode.AccessLocation arg1Value, Object arg2Value, ForeignToLLVM.ForeignToLLVMType arg3Value) {
                if (arg0Value instanceof String) {
                    String arg0Value_ = (String)arg0Value;
                    this.writeMember(arg0Value_, arg1Value, arg2Value, arg3Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value.base), ConvertOutgoingNodeGen.getUncached(), BranchProfile.getUncached());
                    return;
                }
                if (arg0Value instanceof Long) {
                    long arg0Value_ = (Long)arg0Value;
                    if (LLVMInteropWriteNode.WriteLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg3Value)) {
                        this.writeArrayElementTypeMatch(arg0Value_, arg1Value, arg2Value, arg3Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value.base), ConvertOutgoingNodeGen.getUncached(), BranchProfile.getUncached());
                        return;
                    }
                    if (!LLVMInteropWriteNode.WriteLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg3Value) && arg1Value.type.getKind().foreignToLLVMType.isI8() && arg3Value.getSizeInBytes() > 1) {
                        this.writeArrayElementToI8(arg0Value_, arg1Value, arg2Value, arg3Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value.base), ReinterpretLLVMAsLongNodeGen.getUncached(), BranchProfile.getUncached(), arg1Value.type.getKind().foreignToLLVMType, arg3Value.getSizeInBytes());
                        return;
                    }
                }
                this.fallback(arg0Value, arg1Value, arg2Value, arg3Value);
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            public boolean isAdoptable() {
                return false;
            }
        }

        @GeneratedBy(value=LLVMInteropWriteNode.WriteLocationNode.class)
        private static final class WriteArrayElementToI80Data
        extends Node {
            @Node.Child
            WriteArrayElementToI80Data next_;
            @Node.Child
            InteropLibrary interop_;
            @Node.Child
            LLVMInteropWriteNode.ReinterpretLLVMAsLong toLong_;
            @CompilerDirectives.CompilationFinal
            BranchProfile exception_;

            WriteArrayElementToI80Data(WriteArrayElementToI80Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }

        @GeneratedBy(value=LLVMInteropWriteNode.WriteLocationNode.class)
        private static final class WriteArrayElementTypeMatch0Data
        extends Node {
            @Node.Child
            WriteArrayElementTypeMatch0Data next_;
            @Node.Child
            InteropLibrary interop_;
            @Node.Child
            LLVMInteropWriteNode.ConvertOutgoingNode convertOutgoing_;
            @CompilerDirectives.CompilationFinal
            BranchProfile exception_;

            WriteArrayElementTypeMatch0Data(WriteArrayElementTypeMatch0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }

        @GeneratedBy(value=LLVMInteropWriteNode.WriteLocationNode.class)
        private static final class WriteMember0Data
        extends Node {
            @Node.Child
            WriteMember0Data next_;
            @Node.Child
            InteropLibrary interop_;
            @Node.Child
            LLVMInteropWriteNode.ConvertOutgoingNode convertOutgoing_;
            @CompilerDirectives.CompilationFinal
            BranchProfile exception_;

            WriteMember0Data(WriteMember0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMInteropWriteNode.class)
    private static final class Uncached
    extends LLVMInteropWriteNode {
        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void execute(LLVMInteropType.Structured arg0Value, Object arg1Value, long arg2Value, Object arg3Value, ForeignToLLVM.ForeignToLLVMType arg4Value) {
            if (arg0Value != null) {
                this.doKnownType(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, LLVMInteropAccessNodeGen.getUncached(), WriteLocationNodeGen.getUncached());
                return;
            }
            if (arg0Value == null) {
                this.doUnknownType(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, WriteLocationNodeGen.getUncached());
                return;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value, arg3Value, arg4Value});
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }
}

