/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.LLVMDataEscapeNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropAccessNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropWriteNodeGen;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;

@GenerateUncached
public abstract class LLVMInteropWriteNode
extends LLVMNode {
    public static LLVMInteropWriteNode create() {
        return LLVMInteropWriteNodeGen.create();
    }

    public abstract void execute(LLVMInteropType.Structured var1, Object var2, long var3, Object var5, ForeignToLLVM.ForeignToLLVMType var6);

    @Specialization(guards={"type != null"})
    void doKnownType(LLVMInteropType.Structured type, Object foreign, long offset, Object value, ForeignToLLVM.ForeignToLLVMType writeType, @Cached LLVMInteropAccessNode access, @Cached WriteLocationNode write) {
        LLVMInteropAccessNode.AccessLocation location = access.execute(type, foreign, offset);
        write.execute(location.identifier, location, value, writeType);
    }

    @Specialization(guards={"type == null"})
    void doUnknownType(LLVMInteropType.Structured type, Object foreign, long offset, Object value, ForeignToLLVM.ForeignToLLVMType writeType, @Cached WriteLocationNode write) {
        LLVMInteropAccessNode.AccessLocation location = new LLVMInteropAccessNode.AccessLocation(foreign, Long.divideUnsigned(offset, writeType.getSizeInBytes()), null);
        write.execute(location.identifier, location, value, writeType);
    }

    @GenerateUncached
    static abstract class ConvertOutgoingNode
    extends LLVMNode {
        ConvertOutgoingNode() {
        }

        abstract Object execute(Object var1, LLVMInteropType.Value var2, ForeignToLLVM.ForeignToLLVMType var3);

        @Specialization(limit="3", guards={"outgoingType != null", "cachedOutgoingType == outgoingType.kind.foreignToLLVMType", "type.getSizeInBytes() == cachedOutgoingType.getSizeInBytes()"})
        Object doKnownType(Object value, LLVMInteropType.Value outgoingType, ForeignToLLVM.ForeignToLLVMType type, @Cached(value="outgoingType.kind.foreignToLLVMType") ForeignToLLVM.ForeignToLLVMType cachedOutgoingType, @Cached(parameters={"cachedOutgoingType"}) LLVMDataEscapeNode dataEscape) {
            return dataEscape.executeWithType(value, outgoingType.baseType);
        }

        static boolean typeMismatch(LLVMInteropType.Value outgoingType, ForeignToLLVM.ForeignToLLVMType writeType) {
            if (outgoingType == null) {
                return true;
            }
            return outgoingType.getSize() != (long)writeType.getSizeInBytes();
        }

        @Specialization(limit="3", guards={"typeMismatch(outgoingType, cachedType)", "cachedType == type"})
        Object doUnknownType(Object value, LLVMInteropType.Value outgoingType, ForeignToLLVM.ForeignToLLVMType type, @Cached(value="type") ForeignToLLVM.ForeignToLLVMType cachedType, @Cached(parameters={"type"}) LLVMDataEscapeNode dataEscape) {
            return dataEscape.executeWithTarget(value);
        }
    }

    @ImportStatic(value={ForeignToLLVM.ForeignToLLVMType.class})
    @GenerateUncached
    static abstract class ReinterpretLLVMAsLong
    extends LLVMNode {
        ReinterpretLLVMAsLong() {
        }

        abstract long executeWithWriteType(Object var1, ForeignToLLVM.ForeignToLLVMType var2);

        @Specialization(guards={"writeType.getSizeInBytes() == 2"})
        long doI16(Object value, ForeignToLLVM.ForeignToLLVMType writeType, @Cached(parameters={"I16"}) LLVMDataEscapeNode dataEscape) {
            return ((Short)dataEscape.executeWithTarget(value)).shortValue();
        }

        @Specialization(guards={"writeType.getSizeInBytes() == 4"})
        long doI32(Object value, ForeignToLLVM.ForeignToLLVMType writeType, @Cached(parameters={"I32"}) LLVMDataEscapeNode dataEscape) {
            return ((Integer)dataEscape.executeWithTarget(value)).intValue();
        }

        @Specialization(guards={"writeType.getSizeInBytes() == 8"})
        long doI64(Object value, ForeignToLLVM.ForeignToLLVMType writeType, @Cached(parameters={"I64"}) LLVMDataEscapeNode dataEscape) {
            return (Long)dataEscape.executeWithTarget(value);
        }

        @Fallback
        long fallback(Object value, ForeignToLLVM.ForeignToLLVMType writeType) {
            CompilerDirectives.transferToInterpreter();
            throw new LLVMPolyglotException((Node)this, "Unexpected access type %s", new Object[]{writeType});
        }
    }

    @GenerateUncached
    static abstract class WriteLocationNode
    extends LLVMNode {
        WriteLocationNode() {
        }

        abstract void execute(Object var1, LLVMInteropAccessNode.AccessLocation var2, Object var3, ForeignToLLVM.ForeignToLLVMType var4);

        @Specialization(limit="3")
        void writeMember(String identifier, LLVMInteropAccessNode.AccessLocation location, Object value, ForeignToLLVM.ForeignToLLVMType writeType, @CachedLibrary(value="location.base") InteropLibrary interop, @Cached ConvertOutgoingNode convertOutgoing, @Cached BranchProfile exception) {
            assert (identifier == location.identifier);
            try {
                interop.writeMember(location.base, identifier, convertOutgoing.execute(value, location.type, writeType));
            }
            catch (UnsupportedMessageException ex) {
                exception.enter();
                throw new LLVMPolyglotException((Node)this, "Can not write member '%s'.", identifier);
            }
            catch (UnknownIdentifierException ex) {
                exception.enter();
                throw new LLVMPolyglotException((Node)this, "Member '%s' not found.", identifier);
            }
            catch (UnsupportedTypeException ex) {
                exception.enter();
                throw new LLVMPolyglotException((Node)this, "Wrong type writing to member '%s'.", identifier);
            }
        }

        @Specialization(guards={"isLocationTypeNullOrSameSize(location, writeType)"}, limit="3")
        void writeArrayElementTypeMatch(long identifier, LLVMInteropAccessNode.AccessLocation location, Object value, ForeignToLLVM.ForeignToLLVMType writeType, @CachedLibrary(value="location.base") InteropLibrary interop, @Cached ConvertOutgoingNode convertOutgoing, @Cached BranchProfile exception) {
            assert (identifier == (Long)location.identifier);
            long idx = identifier;
            try {
                interop.writeArrayElement(location.base, idx, convertOutgoing.execute(value, location.type, writeType));
            }
            catch (InvalidArrayIndexException ex) {
                exception.enter();
                throw new LLVMPolyglotException((Node)this, "Invalid array index %d.", idx);
            }
            catch (UnsupportedMessageException ex) {
                exception.enter();
                throw new LLVMPolyglotException((Node)this, "Can not write array element %d.", idx);
            }
            catch (UnsupportedTypeException ex) {
                exception.enter();
                throw new LLVMPolyglotException((Node)this, "Wrong type writing to array element %d.", idx);
            }
        }

        @Specialization(guards={"!isLocationTypeNullOrSameSize(location, writeType)", "locationType.isI8()", "writeTypeSizeInBytes > 1"}, limit="3")
        void writeArrayElementToI8(long identifier, LLVMInteropAccessNode.AccessLocation location, Object value, ForeignToLLVM.ForeignToLLVMType writeType, @CachedLibrary(value="location.base") InteropLibrary interop, @Cached ReinterpretLLVMAsLong toLong, @Cached BranchProfile exception, @Bind(value="location.type.getKind().foreignToLLVMType") ForeignToLLVM.ForeignToLLVMType locationType, @Bind(value="writeType.getSizeInBytes()") int writeTypeSizeInBytes) {
            assert (identifier == (Long)location.identifier);
            long idx = identifier;
            try {
                long longValue = toLong.executeWithWriteType(value, writeType);
                int i = 0;
                while (i < writeTypeSizeInBytes) {
                    interop.writeArrayElement(location.base, idx, (Object)((byte)longValue));
                    longValue >>= 8;
                    ++i;
                    ++idx;
                }
            }
            catch (InvalidArrayIndexException ex) {
                exception.enter();
                throw new LLVMPolyglotException((Node)this, "Invalid array index %d.", idx);
            }
            catch (UnsupportedMessageException ex) {
                exception.enter();
                throw new LLVMPolyglotException((Node)this, "Can not write array element %d.", idx);
            }
            catch (UnsupportedTypeException ex) {
                exception.enter();
                throw new LLVMPolyglotException((Node)this, "Wrong type writing to array element %d.", idx);
            }
        }

        @Fallback
        void fallback(Object identifier, LLVMInteropAccessNode.AccessLocation location, Object value, ForeignToLLVM.ForeignToLLVMType writeType) {
            assert (location.type != null);
            throw new LLVMPolyglotException((Node)this, "Cannot write object '%s' of size %d byte(s) to foreign object of element size %d", value, writeType.getSizeInBytes(), location.type.getKind().foreignToLLVMType.getSizeInBytes());
        }

        static boolean isLocationTypeNullOrSameSize(LLVMInteropAccessNode.AccessLocation location, ForeignToLLVM.ForeignToLLVMType accessType) {
            return location.type == null || location.type.getKind().foreignToLLVMType.getSizeInBytes() == accessType.getSizeInBytes();
        }
    }
}

