/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropAccessNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropAccessNodeGen;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropReadNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.interop.convert.ToLLVM;
import com.oracle.truffle.llvm.runtime.interop.convert.ToLLVMNodeGen;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMInteropReadNode.class)
public final class LLVMInteropReadNodeGen
extends LLVMInteropReadNode {
    private static final Uncached UNCACHED = new Uncached();
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @Node.Child
    private LLVMInteropAccessNode knownType_access_;
    @Node.Child
    private LLVMInteropReadNode.ReadLocationNode knownType_read_;
    @Node.Child
    private LLVMInteropReadNode.ReadLocationNode unknownType_read_;

    private LLVMInteropReadNodeGen() {
    }

    @Override
    public Object execute(LLVMInteropType.Structured arg0Value, Object arg1Value, long arg2Value, ForeignToLLVM.ForeignToLLVMType arg3Value) {
        int state = this.state_;
        if (state != 0) {
            if ((state & 1) != 0 && arg0Value != null) {
                return this.doKnownType(arg0Value, arg1Value, arg2Value, arg3Value, this.knownType_access_, this.knownType_read_);
            }
            if ((state & 2) != 0 && arg0Value == null) {
                return this.doUnknownType(arg0Value, arg1Value, arg2Value, arg3Value, this.unknownType_read_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
    }

    private Object executeAndSpecialize(LLVMInteropType.Structured arg0Value, Object arg1Value, long arg2Value, ForeignToLLVM.ForeignToLLVMType arg3Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            if (arg0Value != null) {
                this.knownType_access_ = (LLVMInteropAccessNode)super.insert((Node)LLVMInteropAccessNode.create());
                this.knownType_read_ = (LLVMInteropReadNode.ReadLocationNode)super.insert((Node)ReadLocationNodeGen.create());
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                Object object = this.doKnownType(arg0Value, arg1Value, arg2Value, arg3Value, this.knownType_access_, this.knownType_read_);
                return object;
            }
            if (arg0Value == null) {
                this.unknownType_read_ = (LLVMInteropReadNode.ReadLocationNode)super.insert((Node)ReadLocationNodeGen.create());
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                Object object = this.doUnknownType(arg0Value, arg1Value, arg2Value, arg3Value, this.unknownType_read_);
                return object;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value, arg3Value});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static LLVMInteropReadNode create() {
        return new LLVMInteropReadNodeGen();
    }

    public static LLVMInteropReadNode getUncached() {
        return UNCACHED;
    }

    @GeneratedBy(value=LLVMInteropReadNode.ReinterpretLongAsLLVM.class)
    static final class ReinterpretLongAsLLVMNodeGen
    extends LLVMInteropReadNode.ReinterpretLongAsLLVM {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_;

        private ReinterpretLongAsLLVMNodeGen() {
        }

        @Override
        Object executeWithAccessType(long arg0Value, ForeignToLLVM.ForeignToLLVMType arg1Value) {
            int state = this.state_;
            if (state != 0) {
                if ((state & 1) != 0 && arg1Value.isI16()) {
                    return this.toI16(arg0Value, arg1Value);
                }
                if ((state & 2) != 0 && arg1Value.isI32()) {
                    return this.toI32(arg0Value, arg1Value);
                }
                if ((state & 4) != 0 && arg1Value.isI64()) {
                    return this.toI64(arg0Value, arg1Value);
                }
                if ((state & 8) != 0 && arg1Value.isFloat()) {
                    return Float.valueOf(this.toFloat(arg0Value, arg1Value));
                }
                if ((state & 0x10) != 0 && arg1Value.isDouble()) {
                    return this.toDouble(arg0Value, arg1Value);
                }
                if ((state & 0x20) != 0 && arg1Value.isPointer()) {
                    return this.toPointer(arg0Value, arg1Value);
                }
                if ((state & 0x40) != 0 && ReinterpretLongAsLLVMNodeGen.fallbackGuard_(state, arg0Value, arg1Value)) {
                    return this.fallback(arg0Value, arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private Object executeAndSpecialize(long arg0Value, ForeignToLLVM.ForeignToLLVMType arg1Value) {
            int state = this.state_;
            if (arg1Value.isI16()) {
                this.state_ = state |= 1;
                return this.toI16(arg0Value, arg1Value);
            }
            if (arg1Value.isI32()) {
                this.state_ = state |= 2;
                return this.toI32(arg0Value, arg1Value);
            }
            if (arg1Value.isI64()) {
                this.state_ = state |= 4;
                return this.toI64(arg0Value, arg1Value);
            }
            if (arg1Value.isFloat()) {
                this.state_ = state |= 8;
                return Float.valueOf(this.toFloat(arg0Value, arg1Value));
            }
            if (arg1Value.isDouble()) {
                this.state_ = state |= 0x10;
                return this.toDouble(arg0Value, arg1Value);
            }
            if (arg1Value.isPointer()) {
                this.state_ = state |= 0x20;
                return this.toPointer(arg0Value, arg1Value);
            }
            this.state_ = state |= 0x40;
            return this.fallback(arg0Value, arg1Value);
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        private static boolean fallbackGuard_(int state, long arg0Value, ForeignToLLVM.ForeignToLLVMType arg1Value) {
            if ((state & 1) == 0 && arg1Value.isI16()) {
                return false;
            }
            if ((state & 2) == 0 && arg1Value.isI32()) {
                return false;
            }
            if ((state & 4) == 0 && arg1Value.isI64()) {
                return false;
            }
            if ((state & 8) == 0 && arg1Value.isFloat()) {
                return false;
            }
            if ((state & 0x10) == 0 && arg1Value.isDouble()) {
                return false;
            }
            return (state & 0x20) != 0 || !arg1Value.isPointer();
        }

        public static LLVMInteropReadNode.ReinterpretLongAsLLVM create() {
            return new ReinterpretLongAsLLVMNodeGen();
        }

        public static LLVMInteropReadNode.ReinterpretLongAsLLVM getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=LLVMInteropReadNode.ReinterpretLongAsLLVM.class)
        private static final class Uncached
        extends LLVMInteropReadNode.ReinterpretLongAsLLVM {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            Object executeWithAccessType(long arg0Value, ForeignToLLVM.ForeignToLLVMType arg1Value) {
                if (arg1Value.isI16()) {
                    return this.toI16(arg0Value, arg1Value);
                }
                if (arg1Value.isI32()) {
                    return this.toI32(arg0Value, arg1Value);
                }
                if (arg1Value.isI64()) {
                    return this.toI64(arg0Value, arg1Value);
                }
                if (arg1Value.isFloat()) {
                    return Float.valueOf(this.toFloat(arg0Value, arg1Value));
                }
                if (arg1Value.isDouble()) {
                    return this.toDouble(arg0Value, arg1Value);
                }
                if (arg1Value.isPointer()) {
                    return this.toPointer(arg0Value, arg1Value);
                }
                return this.fallback(arg0Value, arg1Value);
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            public boolean isAdoptable() {
                return false;
            }
        }
    }

    @GeneratedBy(value=LLVMInteropReadNode.ReadLocationNode.class)
    static final class ReadLocationNodeGen
    extends LLVMInteropReadNode.ReadLocationNode {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @Node.Child
        private ReadMember0Data readMember0_cache;
        @Node.Child
        private ToLLVM readMember1_toLLVM_;
        @CompilerDirectives.CompilationFinal
        private BranchProfile readMember1_exception_;
        @Node.Child
        private ReadArrayElementTypeMatch0Data readArrayElementTypeMatch0_cache;
        @Node.Child
        private ToLLVM readArrayElementTypeMatch1_toLLVM_;
        @CompilerDirectives.CompilationFinal
        private BranchProfile readArrayElementTypeMatch1_exception_;
        @Node.Child
        private ReadArrayElementFromI80Data readArrayElementFromI80_cache;
        @Node.Child
        private ReadArrayElementFromI81Data readArrayElementFromI81_cache;

        private ReadLocationNodeGen() {
        }

        @Override
        @ExplodeLoop
        Object execute(Object arg0Value, LLVMInteropAccessNode.AccessLocation arg1Value, ForeignToLLVM.ForeignToLLVMType arg2Value) {
            int state = this.state_;
            if (state != 0) {
                if ((state & 3) != 0 && arg0Value instanceof String) {
                    String arg0Value_ = (String)arg0Value;
                    if ((state & 1) != 0) {
                        ReadMember0Data s1_ = this.readMember0_cache;
                        while (s1_ != null) {
                            if (s1_.interop_.accepts(arg1Value.base)) {
                                return this.readMember(arg0Value_, arg1Value, arg2Value, s1_.interop_, s1_.toLLVM_, s1_.exception_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state & 2) != 0) {
                        return this.readMember1Boundary(state, arg0Value_, arg1Value, arg2Value);
                    }
                }
                if ((state & 0x3C) != 0 && arg0Value instanceof Long) {
                    ReadArrayElementFromI81Data s6_;
                    int accessTypeSizeInBytes__;
                    ForeignToLLVM.ForeignToLLVMType locationType__;
                    long arg0Value_ = (Long)arg0Value;
                    if ((state & 4) != 0) {
                        ReadArrayElementTypeMatch0Data s3_ = this.readArrayElementTypeMatch0_cache;
                        while (s3_ != null) {
                            if (s3_.interop_.accepts(arg1Value.base) && LLVMInteropReadNode.ReadLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg2Value)) {
                                return this.readArrayElementTypeMatch(arg0Value_, arg1Value, arg2Value, s3_.interop_, s3_.toLLVM_, s3_.exception_);
                            }
                            s3_ = s3_.next_;
                        }
                    }
                    if ((state & 8) != 0 && LLVMInteropReadNode.ReadLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg2Value)) {
                        return this.readArrayElementTypeMatch1Boundary(state, arg0Value_, arg1Value, arg2Value);
                    }
                    if ((state & 0x10) != 0) {
                        ReadArrayElementFromI80Data s5_ = this.readArrayElementFromI80_cache;
                        while (s5_ != null) {
                            if (s5_.interop_.accepts(arg1Value.base) && !LLVMInteropReadNode.ReadLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg2Value) && (locationType__ = arg1Value.type.getKind().foreignToLLVMType).isI8() && (accessTypeSizeInBytes__ = arg2Value.getSizeInBytes()) > 1) {
                                return this.readArrayElementFromI8(arg0Value_, arg1Value, arg2Value, s5_.interop_, s5_.toLLVM_, s5_.fromLongToLLVM_, s5_.exception_, s5_.outOfBounds_, locationType__, accessTypeSizeInBytes__);
                            }
                            s5_ = s5_.next_;
                        }
                    }
                    if ((state & 0x20) != 0 && (s6_ = this.readArrayElementFromI81_cache) != null && !LLVMInteropReadNode.ReadLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg2Value) && (locationType__ = arg1Value.type.getKind().foreignToLLVMType).isI8() && (accessTypeSizeInBytes__ = arg2Value.getSizeInBytes()) > 1) {
                        return this.readArrayElementFromI81Boundary(state, s6_, arg0Value_, arg1Value, arg2Value);
                    }
                }
                if ((state & 0x40) != 0 && ReadLocationNodeGen.fallbackGuard_(state, arg0Value, arg1Value, arg2Value)) {
                    return this.fallback(arg0Value, arg1Value, arg2Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object readMember1Boundary(int state, String arg0Value_, LLVMInteropAccessNode.AccessLocation arg1Value, ForeignToLLVM.ForeignToLLVMType arg2Value) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                InteropLibrary readMember1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value.base);
                Object object = this.readMember(arg0Value_, arg1Value, arg2Value, readMember1_interop__, this.readMember1_toLLVM_, this.readMember1_exception_);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object readArrayElementTypeMatch1Boundary(int state, long arg0Value_, LLVMInteropAccessNode.AccessLocation arg1Value, ForeignToLLVM.ForeignToLLVMType arg2Value) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                InteropLibrary readArrayElementTypeMatch1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value.base);
                Object object = this.readArrayElementTypeMatch(arg0Value_, arg1Value, arg2Value, readArrayElementTypeMatch1_interop__, this.readArrayElementTypeMatch1_toLLVM_, this.readArrayElementTypeMatch1_exception_);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object readArrayElementFromI81Boundary(int state, ReadArrayElementFromI81Data s6_, long arg0Value_, LLVMInteropAccessNode.AccessLocation arg1Value, ForeignToLLVM.ForeignToLLVMType arg2Value) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                InteropLibrary interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value.base);
                ForeignToLLVM.ForeignToLLVMType locationType__ = arg1Value.type.getKind().foreignToLLVMType;
                int accessTypeSizeInBytes__ = arg2Value.getSizeInBytes();
                Object object = this.readArrayElementFromI8(arg0Value_, arg1Value, arg2Value, interop__, s6_.toLLVM_, s6_.fromLongToLLVM_, s6_.exception_, s6_.outOfBounds_, locationType__, accessTypeSizeInBytes__);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Object executeAndSpecialize(Object arg0Value, LLVMInteropAccessNode.AccessLocation arg1Value, ForeignToLLVM.ForeignToLLVMType arg2Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                block33: {
                    long arg0Value_;
                    block38: {
                        ReadArrayElementTypeMatch0Data s3_;
                        int count3_;
                        block39: {
                            block40: {
                                String arg0Value_2;
                                block35: {
                                    ReadMember0Data s1_;
                                    int count1_;
                                    block36: {
                                        block37: {
                                            block34: {
                                                if (!(arg0Value instanceof String)) break block34;
                                                arg0Value_2 = (String)arg0Value;
                                                if ((exclude & 1) != 0) break block35;
                                                count1_ = 0;
                                                s1_ = this.readMember0_cache;
                                                if ((state & 1) == 0) break block36;
                                                break block37;
                                            }
                                            if (!(arg0Value instanceof Long)) break block33;
                                            arg0Value_ = (Long)arg0Value;
                                            if ((exclude & 2) != 0) break block38;
                                            count3_ = 0;
                                            s3_ = this.readArrayElementTypeMatch0_cache;
                                            if ((state & 4) == 0) break block39;
                                            break block40;
                                        }
                                        while (s1_ != null && !s1_.interop_.accepts(arg1Value.base)) {
                                            s1_ = s1_.next_;
                                            ++count1_;
                                        }
                                    }
                                    if (s1_ == null && count1_ < 3) {
                                        s1_ = (ReadMember0Data)super.insert((Node)new ReadMember0Data(this.readMember0_cache));
                                        s1_.interop_ = (InteropLibrary)s1_.insertAccessor(INTEROP_LIBRARY_.create(arg1Value.base));
                                        s1_.toLLVM_ = s1_.insertAccessor(ToLLVMNodeGen.create());
                                        s1_.exception_ = BranchProfile.create();
                                        this.readMember0_cache = s1_;
                                        this.state_ = state |= 1;
                                    }
                                    if (s1_ != null) {
                                        lock.unlock();
                                        hasLock = false;
                                        Object object = this.readMember(arg0Value_2, arg1Value, arg2Value, s1_.interop_, s1_.toLLVM_, s1_.exception_);
                                        return object;
                                    }
                                }
                                InteropLibrary readMember1_interop__ = null;
                                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                                Node prev_ = encapsulating_.set((Node)this);
                                try {
                                    readMember1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value.base);
                                    this.readMember1_toLLVM_ = (ToLLVM)super.insert((Node)ToLLVMNodeGen.create());
                                    this.readMember1_exception_ = BranchProfile.create();
                                    this.exclude_ = exclude |= 1;
                                    this.readMember0_cache = null;
                                    state &= 0xFFFFFFFE;
                                    this.state_ = state |= 2;
                                    lock.unlock();
                                    hasLock = false;
                                    Object object = this.readMember(arg0Value_2, arg1Value, arg2Value, readMember1_interop__, this.readMember1_toLLVM_, this.readMember1_exception_);
                                    return object;
                                }
                                finally {
                                    encapsulating_.set(prev_);
                                }
                            }
                            while (!(s3_ == null || s3_.interop_.accepts(arg1Value.base) && LLVMInteropReadNode.ReadLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg2Value))) {
                                s3_ = s3_.next_;
                                ++count3_;
                            }
                        }
                        if (s3_ == null && LLVMInteropReadNode.ReadLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg2Value) && count3_ < 3) {
                            s3_ = (ReadArrayElementTypeMatch0Data)super.insert((Node)new ReadArrayElementTypeMatch0Data(this.readArrayElementTypeMatch0_cache));
                            s3_.interop_ = (InteropLibrary)s3_.insertAccessor(INTEROP_LIBRARY_.create(arg1Value.base));
                            s3_.toLLVM_ = s3_.insertAccessor(ToLLVMNodeGen.create());
                            s3_.exception_ = BranchProfile.create();
                            this.readArrayElementTypeMatch0_cache = s3_;
                            this.state_ = state |= 4;
                        }
                        if (s3_ != null) {
                            lock.unlock();
                            hasLock = false;
                            Object object = this.readArrayElementTypeMatch(arg0Value_, arg1Value, arg2Value, s3_.interop_, s3_.toLLVM_, s3_.exception_);
                            return object;
                        }
                    }
                    InteropLibrary readArrayElementTypeMatch1_interop__ = null;
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set((Node)this);
                    try {
                        if (LLVMInteropReadNode.ReadLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg2Value)) {
                            readArrayElementTypeMatch1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value.base);
                            this.readArrayElementTypeMatch1_toLLVM_ = (ToLLVM)super.insert((Node)ToLLVMNodeGen.create());
                            this.readArrayElementTypeMatch1_exception_ = BranchProfile.create();
                            this.exclude_ = exclude |= 2;
                            this.readArrayElementTypeMatch0_cache = null;
                            state &= 0xFFFFFFFB;
                            this.state_ = state |= 8;
                            lock.unlock();
                            hasLock = false;
                            Object object = this.readArrayElementTypeMatch(arg0Value_, arg1Value, arg2Value, readArrayElementTypeMatch1_interop__, this.readArrayElementTypeMatch1_toLLVM_, this.readArrayElementTypeMatch1_exception_);
                            return object;
                        }
                    }
                    finally {
                        encapsulating_.set(prev_);
                    }
                    int accessTypeSizeInBytes__ = 0;
                    ForeignToLLVM.ForeignToLLVMType locationType__ = null;
                    if ((exclude & 4) == 0) {
                        int count5_ = 0;
                        ReadArrayElementFromI80Data s5_ = this.readArrayElementFromI80_cache;
                        if ((state & 0x10) != 0) {
                            while (!(s5_ == null || s5_.interop_.accepts(arg1Value.base) && !LLVMInteropReadNode.ReadLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg2Value) && (locationType__ = arg1Value.type.getKind().foreignToLLVMType).isI8() && (accessTypeSizeInBytes__ = arg2Value.getSizeInBytes()) > 1)) {
                                s5_ = s5_.next_;
                                ++count5_;
                            }
                        }
                        if (s5_ == null && !LLVMInteropReadNode.ReadLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg2Value) && (locationType__ = arg1Value.type.getKind().foreignToLLVMType).isI8() && (accessTypeSizeInBytes__ = arg2Value.getSizeInBytes()) > 1 && count5_ < 3) {
                            s5_ = (ReadArrayElementFromI80Data)super.insert((Node)new ReadArrayElementFromI80Data(this.readArrayElementFromI80_cache));
                            s5_.interop_ = (InteropLibrary)s5_.insertAccessor(INTEROP_LIBRARY_.create(arg1Value.base));
                            s5_.toLLVM_ = s5_.insertAccessor(ToLLVMNodeGen.create());
                            s5_.fromLongToLLVM_ = s5_.insertAccessor(ReinterpretLongAsLLVMNodeGen.create());
                            s5_.exception_ = BranchProfile.create();
                            s5_.outOfBounds_ = BranchProfile.create();
                            this.readArrayElementFromI80_cache = s5_;
                            this.state_ = state |= 0x10;
                        }
                        if (s5_ != null) {
                            lock.unlock();
                            hasLock = false;
                            Object object = this.readArrayElementFromI8(arg0Value_, arg1Value, arg2Value, s5_.interop_, s5_.toLLVM_, s5_.fromLongToLLVM_, s5_.exception_, s5_.outOfBounds_, locationType__, accessTypeSizeInBytes__);
                            return object;
                        }
                    }
                    accessTypeSizeInBytes__ = 0;
                    locationType__ = null;
                    InteropLibrary interop__ = null;
                    EncapsulatingNodeReference encapsulating_2 = EncapsulatingNodeReference.getCurrent();
                    Node prev_2 = encapsulating_2.set((Node)this);
                    try {
                        if (!LLVMInteropReadNode.ReadLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg2Value) && (locationType__ = arg1Value.type.getKind().foreignToLLVMType).isI8() && (accessTypeSizeInBytes__ = arg2Value.getSizeInBytes()) > 1) {
                            ReadArrayElementFromI81Data s6_ = (ReadArrayElementFromI81Data)super.insert((Node)new ReadArrayElementFromI81Data());
                            interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value.base);
                            s6_.toLLVM_ = s6_.insertAccessor(ToLLVMNodeGen.create());
                            s6_.fromLongToLLVM_ = s6_.insertAccessor(ReinterpretLongAsLLVMNodeGen.create());
                            s6_.exception_ = BranchProfile.create();
                            s6_.outOfBounds_ = BranchProfile.create();
                            this.readArrayElementFromI81_cache = s6_;
                            this.exclude_ = exclude |= 4;
                            this.readArrayElementFromI80_cache = null;
                            state &= 0xFFFFFFEF;
                            this.state_ = state |= 0x20;
                            lock.unlock();
                            hasLock = false;
                            Object object = this.readArrayElementFromI8(arg0Value_, arg1Value, arg2Value, interop__, s6_.toLLVM_, s6_.fromLongToLLVM_, s6_.exception_, s6_.outOfBounds_, locationType__, accessTypeSizeInBytes__);
                            return object;
                        }
                    }
                    finally {
                        encapsulating_2.set(prev_2);
                    }
                }
                this.state_ = state |= 0x40;
                lock.unlock();
                hasLock = false;
                Object object = this.fallback(arg0Value, arg1Value, arg2Value);
                return object;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                ReadMember0Data s1_ = this.readMember0_cache;
                ReadArrayElementTypeMatch0Data s3_ = this.readArrayElementTypeMatch0_cache;
                ReadArrayElementFromI80Data s5_ = this.readArrayElementFromI80_cache;
                if (!(s1_ != null && s1_.next_ != null || s3_ != null && s3_.next_ != null || s5_ != null && s5_.next_ != null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        private static boolean fallbackGuard_(int state, Object arg0Value, LLVMInteropAccessNode.AccessLocation arg1Value, ForeignToLLVM.ForeignToLLVMType arg2Value) {
            if ((state & 2) == 0 && arg0Value instanceof String) {
                return false;
            }
            if (arg0Value instanceof Long) {
                if ((state & 8) == 0 && LLVMInteropReadNode.ReadLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg2Value)) {
                    return false;
                }
                if ((state & 0x20) == 0 && !LLVMInteropReadNode.ReadLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg2Value) && arg1Value.type.getKind().foreignToLLVMType.isI8() && arg2Value.getSizeInBytes() > 1) {
                    return false;
                }
            }
            return true;
        }

        public static LLVMInteropReadNode.ReadLocationNode create() {
            return new ReadLocationNodeGen();
        }

        public static LLVMInteropReadNode.ReadLocationNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=LLVMInteropReadNode.ReadLocationNode.class)
        private static final class Uncached
        extends LLVMInteropReadNode.ReadLocationNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            Object execute(Object arg0Value, LLVMInteropAccessNode.AccessLocation arg1Value, ForeignToLLVM.ForeignToLLVMType arg2Value) {
                if (arg0Value instanceof String) {
                    String arg0Value_ = (String)arg0Value;
                    return this.readMember(arg0Value_, arg1Value, arg2Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value.base), ToLLVMNodeGen.getUncached(), BranchProfile.getUncached());
                }
                if (arg0Value instanceof Long) {
                    long arg0Value_ = (Long)arg0Value;
                    if (LLVMInteropReadNode.ReadLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg2Value)) {
                        return this.readArrayElementTypeMatch(arg0Value_, arg1Value, arg2Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value.base), ToLLVMNodeGen.getUncached(), BranchProfile.getUncached());
                    }
                    if (!LLVMInteropReadNode.ReadLocationNode.isLocationTypeNullOrSameSize(arg1Value, arg2Value) && arg1Value.type.getKind().foreignToLLVMType.isI8() && arg2Value.getSizeInBytes() > 1) {
                        return this.readArrayElementFromI8(arg0Value_, arg1Value, arg2Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value.base), ToLLVMNodeGen.getUncached(), ReinterpretLongAsLLVMNodeGen.getUncached(), BranchProfile.getUncached(), BranchProfile.getUncached(), arg1Value.type.getKind().foreignToLLVMType, arg2Value.getSizeInBytes());
                    }
                }
                return this.fallback(arg0Value, arg1Value, arg2Value);
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            public boolean isAdoptable() {
                return false;
            }
        }

        @GeneratedBy(value=LLVMInteropReadNode.ReadLocationNode.class)
        private static final class ReadArrayElementFromI81Data
        extends Node {
            @Node.Child
            ToLLVM toLLVM_;
            @Node.Child
            LLVMInteropReadNode.ReinterpretLongAsLLVM fromLongToLLVM_;
            @CompilerDirectives.CompilationFinal
            BranchProfile exception_;
            @CompilerDirectives.CompilationFinal
            BranchProfile outOfBounds_;

            ReadArrayElementFromI81Data() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }

        @GeneratedBy(value=LLVMInteropReadNode.ReadLocationNode.class)
        private static final class ReadArrayElementFromI80Data
        extends Node {
            @Node.Child
            ReadArrayElementFromI80Data next_;
            @Node.Child
            InteropLibrary interop_;
            @Node.Child
            ToLLVM toLLVM_;
            @Node.Child
            LLVMInteropReadNode.ReinterpretLongAsLLVM fromLongToLLVM_;
            @CompilerDirectives.CompilationFinal
            BranchProfile exception_;
            @CompilerDirectives.CompilationFinal
            BranchProfile outOfBounds_;

            ReadArrayElementFromI80Data(ReadArrayElementFromI80Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }

        @GeneratedBy(value=LLVMInteropReadNode.ReadLocationNode.class)
        private static final class ReadArrayElementTypeMatch0Data
        extends Node {
            @Node.Child
            ReadArrayElementTypeMatch0Data next_;
            @Node.Child
            InteropLibrary interop_;
            @Node.Child
            ToLLVM toLLVM_;
            @CompilerDirectives.CompilationFinal
            BranchProfile exception_;

            ReadArrayElementTypeMatch0Data(ReadArrayElementTypeMatch0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }

        @GeneratedBy(value=LLVMInteropReadNode.ReadLocationNode.class)
        private static final class ReadMember0Data
        extends Node {
            @Node.Child
            ReadMember0Data next_;
            @Node.Child
            InteropLibrary interop_;
            @Node.Child
            ToLLVM toLLVM_;
            @CompilerDirectives.CompilationFinal
            BranchProfile exception_;

            ReadMember0Data(ReadMember0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMInteropReadNode.class)
    private static final class Uncached
    extends LLVMInteropReadNode {
        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object execute(LLVMInteropType.Structured arg0Value, Object arg1Value, long arg2Value, ForeignToLLVM.ForeignToLLVMType arg3Value) {
            if (arg0Value != null) {
                return this.doKnownType(arg0Value, arg1Value, arg2Value, arg3Value, LLVMInteropAccessNodeGen.getUncached(), ReadLocationNodeGen.getUncached());
            }
            if (arg0Value == null) {
                return this.doUnknownType(arg0Value, arg1Value, arg2Value, arg3Value, ReadLocationNodeGen.getUncached());
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value, arg3Value});
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }
}

