/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.utilities.FinalBitSet;
import com.oracle.truffle.llvm.runtime.interop.LLVMTypedForeignObject;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.spi.NativeTypeLibrary;

@GeneratedBy(value=LLVMTypedForeignObject.TypedForeignWrapper.class)
final class TypedForeignWrapperGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<NativeTypeLibrary> NATIVE_TYPE_LIBRARY_ = LibraryFactory.resolve(NativeTypeLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    private TypedForeignWrapperGen() {
    }

    static {
        LibraryExport.register(LLVMTypedForeignObject.TypedForeignWrapper.class, (LibraryExport[])new LibraryExport[]{new NativeTypeLibraryExports(), new LLVMAsForeignLibraryExports(), new InteropLibraryExports()});
    }

    @GeneratedBy(value=LLVMTypedForeignObject.TypedForeignWrapper.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        static final FinalBitSet ENABLED_MESSAGES = InteropLibraryExports.createMessageBitSet((LibraryFactory)TypedForeignWrapperGen.access$500(), (String[])new String[0]);

        private InteropLibraryExports() {
            super(InteropLibrary.class, LLVMTypedForeignObject.TypedForeignWrapper.class, false);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMTypedForeignObject.TypedForeignWrapper);
            InteropLibrary uncached = (InteropLibrary)InteropLibraryExports.createDelegate((LibraryFactory)INTEROP_LIBRARY_, (Library)new Uncached(receiver));
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMTypedForeignObject.TypedForeignWrapper);
            return (InteropLibrary)InteropLibraryExports.createDelegate((LibraryFactory)INTEROP_LIBRARY_, (Library)new Cached(receiver));
        }

        @GeneratedBy(value=LLVMTypedForeignObject.TypedForeignWrapper.class)
        private static final class Uncached
        extends InteropLibrary
        implements LibraryExport.DelegateExport {
            private final Class<? extends LLVMTypedForeignObject.TypedForeignWrapper> receiverClass_;

            Uncached(Object receiver) {
                this.receiverClass_ = ((LLVMTypedForeignObject.TypedForeignWrapper)receiver).getClass();
            }

            public FinalBitSet getDelegateExportMessages() {
                return ENABLED_MESSAGES;
            }

            public Object readDelegateExport(Object receiver_) {
                return ((LLVMTypedForeignObject.TypedForeignWrapper)receiver_).delegate;
            }

            public Library getDelegateExportLibrary(Object delegate_) {
                return INTEROP_LIBRARY_.getUncached(delegate_);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver.getClass() == this.receiverClass_;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }
        }

        @GeneratedBy(value=LLVMTypedForeignObject.TypedForeignWrapper.class)
        private static final class Cached
        extends InteropLibrary
        implements LibraryExport.DelegateExport {
            @Node.Child
            private InteropLibrary receiverDelegateInteropLibrary_;
            private final Class<? extends LLVMTypedForeignObject.TypedForeignWrapper> receiverClass_;

            Cached(Object originalReceiver) {
                LLVMTypedForeignObject.TypedForeignWrapper receiver = (LLVMTypedForeignObject.TypedForeignWrapper)originalReceiver;
                this.receiverDelegateInteropLibrary_ = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.create(receiver.delegate));
                this.receiverClass_ = receiver.getClass();
            }

            public FinalBitSet getDelegateExportMessages() {
                return ENABLED_MESSAGES;
            }

            public Object readDelegateExport(Object receiver_) {
                return ((LLVMTypedForeignObject.TypedForeignWrapper)CompilerDirectives.castExact((Object)receiver_, this.receiverClass_)).delegate;
            }

            public Library getDelegateExportLibrary(Object delegate) {
                return this.receiverDelegateInteropLibrary_;
            }

            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                if (receiver.getClass() != this.receiverClass_) {
                    return false;
                }
                return this.receiverDelegateInteropLibrary_.accepts(((LLVMTypedForeignObject.TypedForeignWrapper)receiver).delegate);
            }
        }
    }

    @GeneratedBy(value=LLVMTypedForeignObject.TypedForeignWrapper.class)
    private static final class LLVMAsForeignLibraryExports
    extends LibraryExport<LLVMAsForeignLibrary> {
        private LLVMAsForeignLibraryExports() {
            super(LLVMAsForeignLibrary.class, LLVMTypedForeignObject.TypedForeignWrapper.class, false);
        }

        protected LLVMAsForeignLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMTypedForeignObject.TypedForeignWrapper);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected LLVMAsForeignLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMTypedForeignObject.TypedForeignWrapper);
            return new Cached(receiver);
        }

        @GeneratedBy(value=LLVMTypedForeignObject.TypedForeignWrapper.class)
        private static final class Uncached
        extends LLVMAsForeignLibrary {
            private final Class<? extends LLVMTypedForeignObject.TypedForeignWrapper> receiverClass_;

            Uncached(Object receiver) {
                this.receiverClass_ = ((LLVMTypedForeignObject.TypedForeignWrapper)receiver).getClass();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver.getClass() == this.receiverClass_;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isForeign(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMTypedForeignObject.TypedForeignWrapper)receiver).isForeign();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object asForeign(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMTypedForeignObject.TypedForeignWrapper)receiver).asForeign();
            }
        }

        @GeneratedBy(value=LLVMTypedForeignObject.TypedForeignWrapper.class)
        private static final class Cached
        extends LLVMAsForeignLibrary {
            private final Class<? extends LLVMTypedForeignObject.TypedForeignWrapper> receiverClass_;

            Cached(Object originalReceiver) {
                LLVMTypedForeignObject.TypedForeignWrapper receiver = (LLVMTypedForeignObject.TypedForeignWrapper)originalReceiver;
                this.receiverClass_ = receiver.getClass();
            }

            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver.getClass() == this.receiverClass_;
            }

            @Override
            public boolean isForeign(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMTypedForeignObject.TypedForeignWrapper)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).isForeign();
            }

            @Override
            public Object asForeign(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMTypedForeignObject.TypedForeignWrapper)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).asForeign();
            }
        }
    }

    @GeneratedBy(value=LLVMTypedForeignObject.TypedForeignWrapper.class)
    private static final class NativeTypeLibraryExports
    extends LibraryExport<NativeTypeLibrary> {
        private NativeTypeLibraryExports() {
            super(NativeTypeLibrary.class, LLVMTypedForeignObject.TypedForeignWrapper.class, false);
        }

        protected NativeTypeLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMTypedForeignObject.TypedForeignWrapper);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected NativeTypeLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMTypedForeignObject.TypedForeignWrapper);
            return new Cached(receiver);
        }

        @GeneratedBy(value=LLVMTypedForeignObject.TypedForeignWrapper.class)
        private static final class Uncached
        extends NativeTypeLibrary {
            private final Class<? extends LLVMTypedForeignObject.TypedForeignWrapper> receiverClass_;

            Uncached(Object receiver) {
                this.receiverClass_ = ((LLVMTypedForeignObject.TypedForeignWrapper)receiver).getClass();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver.getClass() == this.receiverClass_;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasNativeType(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject.TypedForeignWrapper arg0Value = (LLVMTypedForeignObject.TypedForeignWrapper)arg0Value_;
                return arg0Value.hasNativeType((NativeTypeLibrary)NATIVE_TYPE_LIBRARY_.getUncached(arg0Value.delegate));
            }

            @CompilerDirectives.TruffleBoundary
            public Object getNativeType(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject.TypedForeignWrapper arg0Value = (LLVMTypedForeignObject.TypedForeignWrapper)arg0Value_;
                return arg0Value.getNativeType((NativeTypeLibrary)NATIVE_TYPE_LIBRARY_.getUncached(arg0Value.delegate));
            }
        }

        @GeneratedBy(value=LLVMTypedForeignObject.TypedForeignWrapper.class)
        private static final class Cached
        extends NativeTypeLibrary {
            @Node.Child
            private NativeTypeLibrary receiverDelegateNativeTypeLibrary_;
            private final Class<? extends LLVMTypedForeignObject.TypedForeignWrapper> receiverClass_;

            Cached(Object originalReceiver) {
                LLVMTypedForeignObject.TypedForeignWrapper receiver = (LLVMTypedForeignObject.TypedForeignWrapper)originalReceiver;
                this.receiverDelegateNativeTypeLibrary_ = (NativeTypeLibrary)super.insert((Node)NATIVE_TYPE_LIBRARY_.create(receiver.delegate));
                this.receiverClass_ = receiver.getClass();
            }

            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                if (receiver.getClass() != this.receiverClass_) {
                    return false;
                }
                return this.receiverDelegateNativeTypeLibrary_.accepts(((LLVMTypedForeignObject.TypedForeignWrapper)receiver).delegate);
            }

            public boolean hasNativeType(Object arg0Value_) {
                assert (arg0Value_.getClass() == this.receiverClass_) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject.TypedForeignWrapper arg0Value = (LLVMTypedForeignObject.TypedForeignWrapper)CompilerDirectives.castExact((Object)arg0Value_, this.receiverClass_);
                NativeTypeLibrary hasNativeTypeNode__nativeTypes__ = this.receiverDelegateNativeTypeLibrary_;
                return arg0Value.hasNativeType(hasNativeTypeNode__nativeTypes__);
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            public Object getNativeType(Object arg0Value_) {
                assert (arg0Value_.getClass() == this.receiverClass_) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject.TypedForeignWrapper arg0Value = (LLVMTypedForeignObject.TypedForeignWrapper)CompilerDirectives.castExact((Object)arg0Value_, this.receiverClass_);
                NativeTypeLibrary getNativeTypeNode__nativeTypes__ = this.receiverDelegateNativeTypeLibrary_;
                return arg0Value.getNativeType(getNativeTypeNode__nativeTypes__);
            }
        }
    }
}

