/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.utilities.FinalBitSet;
import com.oracle.truffle.llvm.runtime.interop.LLVMInternalTruffleObject;
import com.oracle.truffle.llvm.runtime.interop.LLVMTypedForeignObject;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.spi.NativeTypeLibrary;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMTypedForeignObject.class)
final class LLVMTypedForeignObjectGen {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<LLVMManagedReadLibrary> L_L_V_M_MANAGED_READ_LIBRARY_ = LibraryFactory.resolve(LLVMManagedReadLibrary.class);
    private static final LibraryFactory<LLVMManagedWriteLibrary> L_L_V_M_MANAGED_WRITE_LIBRARY_ = LibraryFactory.resolve(LLVMManagedWriteLibrary.class);
    private static final LibraryFactory<NativeTypeLibrary> NATIVE_TYPE_LIBRARY_ = LibraryFactory.resolve(NativeTypeLibrary.class);

    private LLVMTypedForeignObjectGen() {
    }

    static {
        LibraryExport.register(LLVMTypedForeignObject.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports(), new LLVMManagedReadLibraryExports(), new LLVMManagedWriteLibraryExports(), new NativeTypeLibraryExports(), new LLVMAsForeignLibraryExports()});
    }

    @GeneratedBy(value=LLVMTypedForeignObject.class)
    private static final class LLVMAsForeignLibraryExports
    extends LibraryExport<LLVMAsForeignLibrary> {
        private static final Uncached UNCACHED = new Uncached();
        private static final Cached CACHE = new Cached();

        private LLVMAsForeignLibraryExports() {
            super(LLVMAsForeignLibrary.class, LLVMTypedForeignObject.class, false);
        }

        protected LLVMAsForeignLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMTypedForeignObject);
            Uncached uncached = UNCACHED;
            return uncached;
        }

        protected LLVMAsForeignLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMTypedForeignObject);
            return CACHE;
        }

        @GeneratedBy(value=LLVMTypedForeignObject.class)
        private static final class Uncached
        extends LLVMAsForeignLibrary {
            Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LLVMTypedForeignObject) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LLVMTypedForeignObject;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isForeign(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMTypedForeignObject)receiver).isForeign();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object asForeign(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMTypedForeignObject)receiver).asForeign();
            }
        }

        @GeneratedBy(value=LLVMTypedForeignObject.class)
        private static final class Cached
        extends LLVMAsForeignLibrary {
            Cached() {
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LLVMTypedForeignObject) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LLVMTypedForeignObject;
            }

            public boolean isAdoptable() {
                return false;
            }

            @Override
            public boolean isForeign(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMTypedForeignObject)receiver).isForeign();
            }

            @Override
            public Object asForeign(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMTypedForeignObject)receiver).asForeign();
            }
        }
    }

    @GeneratedBy(value=LLVMTypedForeignObject.class)
    private static final class NativeTypeLibraryExports
    extends LibraryExport<NativeTypeLibrary> {
        private NativeTypeLibraryExports() {
            super(NativeTypeLibrary.class, LLVMTypedForeignObject.class, false);
        }

        protected NativeTypeLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMTypedForeignObject);
            Uncached uncached = new Uncached();
            return uncached;
        }

        protected NativeTypeLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMTypedForeignObject);
            return new Cached(receiver);
        }

        @GeneratedBy(value=LLVMTypedForeignObject.class)
        private static final class Uncached
        extends NativeTypeLibrary {
            Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LLVMTypedForeignObject) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LLVMTypedForeignObject;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public Object getNativeType(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                if (((NativeTypeLibrary)NATIVE_TYPE_LIBRARY_.getUncached(arg0Value.foreign.delegate)).hasNativeType(arg0Value.foreign.delegate)) {
                    return LLVMTypedForeignObject.GetNativeType.getType(arg0Value, (NativeTypeLibrary)NATIVE_TYPE_LIBRARY_.getUncached(arg0Value.foreign.delegate));
                }
                if (!((NativeTypeLibrary)NATIVE_TYPE_LIBRARY_.getUncached(arg0Value.foreign.delegate)).hasNativeType(arg0Value.foreign.delegate)) {
                    return LLVMTypedForeignObject.GetNativeType.doFallback(arg0Value, (NativeTypeLibrary)NATIVE_TYPE_LIBRARY_.getUncached(arg0Value.foreign.delegate));
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasNativeType(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                return arg0Value.hasNativeType((NativeTypeLibrary)NATIVE_TYPE_LIBRARY_.getUncached(arg0Value.foreign.delegate));
            }
        }

        @GeneratedBy(value=LLVMTypedForeignObject.class)
        private static final class Cached
        extends NativeTypeLibrary {
            @Node.Child
            private NativeTypeLibrary receiverForeignDelegateNativeTypeLibrary_;
            @CompilerDirectives.CompilationFinal
            private volatile int state_;

            Cached(Object originalReceiver) {
                LLVMTypedForeignObject receiver = (LLVMTypedForeignObject)originalReceiver;
                this.receiverForeignDelegateNativeTypeLibrary_ = (NativeTypeLibrary)super.insert((Node)NATIVE_TYPE_LIBRARY_.create(receiver.foreign.delegate));
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LLVMTypedForeignObject) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                if (!(receiver instanceof LLVMTypedForeignObject)) {
                    return false;
                }
                return this.receiverForeignDelegateNativeTypeLibrary_.accepts(((LLVMTypedForeignObject)receiver).foreign.delegate);
            }

            public Object getNativeType(Object arg0Value_) {
                assert (arg0Value_ instanceof LLVMTypedForeignObject) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                int state = this.state_;
                if (state != 0) {
                    NativeTypeLibrary getNativeType_fallback0_typeLibrary__;
                    NativeTypeLibrary getNativeType_getType_typeLibrary__;
                    if ((state & 1) != 0 && (getNativeType_getType_typeLibrary__ = this.receiverForeignDelegateNativeTypeLibrary_).hasNativeType(arg0Value.foreign.delegate)) {
                        return LLVMTypedForeignObject.GetNativeType.getType(arg0Value, getNativeType_getType_typeLibrary__);
                    }
                    if ((state & 2) != 0 && !(getNativeType_fallback0_typeLibrary__ = this.receiverForeignDelegateNativeTypeLibrary_).hasNativeType(arg0Value.foreign.delegate)) {
                        return LLVMTypedForeignObject.GetNativeType.doFallback(arg0Value, getNativeType_fallback0_typeLibrary__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.getNativeTypeAndSpecialize(arg0Value);
            }

            private Object getNativeTypeAndSpecialize(LLVMTypedForeignObject arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    NativeTypeLibrary getNativeType_getType_typeLibrary__ = null;
                    getNativeType_getType_typeLibrary__ = this.receiverForeignDelegateNativeTypeLibrary_;
                    if (getNativeType_getType_typeLibrary__.hasNativeType(arg0Value.foreign.delegate)) {
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        Object object = LLVMTypedForeignObject.GetNativeType.getType(arg0Value, getNativeType_getType_typeLibrary__);
                        return object;
                    }
                    NativeTypeLibrary getNativeType_fallback0_typeLibrary__ = null;
                    getNativeType_fallback0_typeLibrary__ = this.receiverForeignDelegateNativeTypeLibrary_;
                    if (!getNativeType_fallback0_typeLibrary__.hasNativeType(arg0Value.foreign.delegate)) {
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        LLVMInteropType.Structured structured = LLVMTypedForeignObject.GetNativeType.doFallback(arg0Value, getNativeType_fallback0_typeLibrary__);
                        return structured;
                    }
                    throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                int state = this.state_;
                if (state == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state & state - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            public boolean hasNativeType(Object arg0Value_) {
                assert (arg0Value_ instanceof LLVMTypedForeignObject) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                NativeTypeLibrary hasNativeTypeNode__nativeTypes__ = this.receiverForeignDelegateNativeTypeLibrary_;
                return arg0Value.hasNativeType(hasNativeTypeNode__nativeTypes__);
            }
        }
    }

    @GeneratedBy(value=LLVMTypedForeignObject.class)
    private static final class LLVMManagedWriteLibraryExports
    extends LibraryExport<LLVMManagedWriteLibrary> {
        private static final Uncached UNCACHED = new Uncached();

        private LLVMManagedWriteLibraryExports() {
            super(LLVMManagedWriteLibrary.class, LLVMTypedForeignObject.class, false);
        }

        protected LLVMManagedWriteLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMTypedForeignObject);
            Uncached uncached = UNCACHED;
            return uncached;
        }

        protected LLVMManagedWriteLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMTypedForeignObject);
            return new Cached(receiver);
        }

        @GeneratedBy(value=LLVMTypedForeignObject.class)
        private static final class Uncached
        extends LLVMManagedWriteLibrary {
            Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LLVMTypedForeignObject) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LLVMTypedForeignObject;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isWritable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMTypedForeignObject)receiver).isAccessible();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeI8(Object arg0Value_, long arg1Value, byte arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                arg0Value.writeI8(arg1Value, arg2Value, (LLVMManagedWriteLibrary)L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached((Object)arg0Value.foreign));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeI16(Object arg0Value_, long arg1Value, short arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                arg0Value.writeI16(arg1Value, arg2Value, (LLVMManagedWriteLibrary)L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached((Object)arg0Value.foreign));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeI32(Object arg0Value_, long arg1Value, int arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                arg0Value.writeI32(arg1Value, arg2Value, (LLVMManagedWriteLibrary)L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached((Object)arg0Value.foreign));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeI64(Object arg0Value_, long arg1Value, long arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                arg0Value.writeI64(arg1Value, arg2Value, (LLVMManagedWriteLibrary)L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached((Object)arg0Value.foreign));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeFloat(Object arg0Value_, long arg1Value, float arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                arg0Value.writeFloat(arg1Value, arg2Value, (LLVMManagedWriteLibrary)L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached((Object)arg0Value.foreign));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeGenericI64(Object arg0Value_, long arg1Value, Object arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                arg0Value.writeGenericI64(arg1Value, arg2Value, (LLVMManagedWriteLibrary)L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached((Object)arg0Value.foreign));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeDouble(Object arg0Value_, long arg1Value, double arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                arg0Value.writeDouble(arg1Value, arg2Value, (LLVMManagedWriteLibrary)L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached((Object)arg0Value.foreign));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writePointer(Object arg0Value_, long arg1Value, LLVMPointer arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                arg0Value.writePointer(arg1Value, arg2Value, (LLVMManagedWriteLibrary)L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached((Object)arg0Value.foreign));
            }
        }

        @GeneratedBy(value=LLVMTypedForeignObject.class)
        private static final class Cached
        extends LLVMManagedWriteLibrary {
            @Node.Child
            private LLVMManagedWriteLibrary receiverForeignLLVMManagedWriteLibrary_;

            Cached(Object originalReceiver) {
                LLVMTypedForeignObject receiver = (LLVMTypedForeignObject)originalReceiver;
                this.receiverForeignLLVMManagedWriteLibrary_ = (LLVMManagedWriteLibrary)super.insert((Node)L_L_V_M_MANAGED_WRITE_LIBRARY_.create((Object)receiver.foreign));
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LLVMTypedForeignObject) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                if (!(receiver instanceof LLVMTypedForeignObject)) {
                    return false;
                }
                return this.receiverForeignLLVMManagedWriteLibrary_.accepts(((LLVMTypedForeignObject)receiver).foreign);
            }

            @Override
            public boolean isWritable(Object receiver) {
                assert (receiver instanceof LLVMTypedForeignObject) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMTypedForeignObject)receiver).isAccessible();
            }

            @Override
            public void writeI8(Object arg0Value_, long arg1Value, byte arg2Value) {
                assert (arg0Value_ instanceof LLVMTypedForeignObject) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                LLVMManagedWriteLibrary writeI8Node__writeLibrary__ = this.receiverForeignLLVMManagedWriteLibrary_;
                arg0Value.writeI8(arg1Value, arg2Value, writeI8Node__writeLibrary__);
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public void writeI16(Object arg0Value_, long arg1Value, short arg2Value) {
                assert (arg0Value_ instanceof LLVMTypedForeignObject) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                LLVMManagedWriteLibrary writeI16Node__writeLibrary__ = this.receiverForeignLLVMManagedWriteLibrary_;
                arg0Value.writeI16(arg1Value, arg2Value, writeI16Node__writeLibrary__);
            }

            @Override
            public void writeI32(Object arg0Value_, long arg1Value, int arg2Value) {
                assert (arg0Value_ instanceof LLVMTypedForeignObject) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                LLVMManagedWriteLibrary writeI32Node__writeLibrary__ = this.receiverForeignLLVMManagedWriteLibrary_;
                arg0Value.writeI32(arg1Value, arg2Value, writeI32Node__writeLibrary__);
            }

            @Override
            public void writeI64(Object arg0Value_, long arg1Value, long arg2Value) {
                assert (arg0Value_ instanceof LLVMTypedForeignObject) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                LLVMManagedWriteLibrary writeI64Node__writeLibrary__ = this.receiverForeignLLVMManagedWriteLibrary_;
                arg0Value.writeI64(arg1Value, arg2Value, writeI64Node__writeLibrary__);
            }

            @Override
            public void writeFloat(Object arg0Value_, long arg1Value, float arg2Value) {
                assert (arg0Value_ instanceof LLVMTypedForeignObject) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                LLVMManagedWriteLibrary writeFloatNode__writeLibrary__ = this.receiverForeignLLVMManagedWriteLibrary_;
                arg0Value.writeFloat(arg1Value, arg2Value, writeFloatNode__writeLibrary__);
            }

            @Override
            public void writeGenericI64(Object arg0Value_, long arg1Value, Object arg2Value) {
                assert (arg0Value_ instanceof LLVMTypedForeignObject) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                LLVMManagedWriteLibrary writeGenericI64Node__writeLibrary__ = this.receiverForeignLLVMManagedWriteLibrary_;
                arg0Value.writeGenericI64(arg1Value, arg2Value, writeGenericI64Node__writeLibrary__);
            }

            @Override
            public void writeDouble(Object arg0Value_, long arg1Value, double arg2Value) {
                assert (arg0Value_ instanceof LLVMTypedForeignObject) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                LLVMManagedWriteLibrary writeDoubleNode__writeLibrary__ = this.receiverForeignLLVMManagedWriteLibrary_;
                arg0Value.writeDouble(arg1Value, arg2Value, writeDoubleNode__writeLibrary__);
            }

            @Override
            public void writePointer(Object arg0Value_, long arg1Value, LLVMPointer arg2Value) {
                assert (arg0Value_ instanceof LLVMTypedForeignObject) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                LLVMManagedWriteLibrary writePointerNode__writeLibrary__ = this.receiverForeignLLVMManagedWriteLibrary_;
                arg0Value.writePointer(arg1Value, arg2Value, writePointerNode__writeLibrary__);
            }
        }
    }

    @GeneratedBy(value=LLVMTypedForeignObject.class)
    private static final class LLVMManagedReadLibraryExports
    extends LibraryExport<LLVMManagedReadLibrary> {
        private static final Uncached UNCACHED = new Uncached();

        private LLVMManagedReadLibraryExports() {
            super(LLVMManagedReadLibrary.class, LLVMTypedForeignObject.class, false);
        }

        protected LLVMManagedReadLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMTypedForeignObject);
            Uncached uncached = UNCACHED;
            return uncached;
        }

        protected LLVMManagedReadLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMTypedForeignObject);
            return new Cached(receiver);
        }

        @GeneratedBy(value=LLVMTypedForeignObject.class)
        private static final class Uncached
        extends LLVMManagedReadLibrary {
            Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LLVMTypedForeignObject) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LLVMTypedForeignObject;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isReadable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMTypedForeignObject)receiver).isAccessible();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public byte readI8(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                return arg0Value.readI8(arg1Value, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached((Object)arg0Value.foreign));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public short readI16(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                return arg0Value.readI16(arg1Value, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached((Object)arg0Value.foreign));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int readI32(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                return arg0Value.readI32(arg1Value, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached((Object)arg0Value.foreign));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public float readFloat(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                return arg0Value.readFloat(arg1Value, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached((Object)arg0Value.foreign));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public double readDouble(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                return arg0Value.readDouble(arg1Value, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached((Object)arg0Value.foreign));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public LLVMPointer readPointer(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                return arg0Value.readPointer(arg1Value, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached((Object)arg0Value.foreign));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long readI64(Object arg0Value_, long arg1Value) throws UnexpectedResultException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                return arg0Value.readI64(arg1Value, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached((Object)arg0Value.foreign));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object readGenericI64(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                return arg0Value.readGenericI64(arg1Value, (LLVMManagedReadLibrary)L_L_V_M_MANAGED_READ_LIBRARY_.getUncached((Object)arg0Value.foreign));
            }
        }

        @GeneratedBy(value=LLVMTypedForeignObject.class)
        private static final class Cached
        extends LLVMManagedReadLibrary {
            @Node.Child
            private LLVMManagedReadLibrary receiverForeignLLVMManagedReadLibrary_;

            Cached(Object originalReceiver) {
                LLVMTypedForeignObject receiver = (LLVMTypedForeignObject)originalReceiver;
                this.receiverForeignLLVMManagedReadLibrary_ = (LLVMManagedReadLibrary)super.insert((Node)L_L_V_M_MANAGED_READ_LIBRARY_.create((Object)receiver.foreign));
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LLVMTypedForeignObject) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                if (!(receiver instanceof LLVMTypedForeignObject)) {
                    return false;
                }
                return this.receiverForeignLLVMManagedReadLibrary_.accepts(((LLVMTypedForeignObject)receiver).foreign);
            }

            @Override
            public boolean isReadable(Object receiver) {
                assert (receiver instanceof LLVMTypedForeignObject) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMTypedForeignObject)receiver).isAccessible();
            }

            @Override
            public byte readI8(Object arg0Value_, long arg1Value) {
                assert (arg0Value_ instanceof LLVMTypedForeignObject) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                LLVMManagedReadLibrary readI8Node__readLibrary__ = this.receiverForeignLLVMManagedReadLibrary_;
                return arg0Value.readI8(arg1Value, readI8Node__readLibrary__);
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public short readI16(Object arg0Value_, long arg1Value) {
                assert (arg0Value_ instanceof LLVMTypedForeignObject) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                LLVMManagedReadLibrary readI16Node__readLibrary__ = this.receiverForeignLLVMManagedReadLibrary_;
                return arg0Value.readI16(arg1Value, readI16Node__readLibrary__);
            }

            @Override
            public int readI32(Object arg0Value_, long arg1Value) {
                assert (arg0Value_ instanceof LLVMTypedForeignObject) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                LLVMManagedReadLibrary readI32Node__readLibrary__ = this.receiverForeignLLVMManagedReadLibrary_;
                return arg0Value.readI32(arg1Value, readI32Node__readLibrary__);
            }

            @Override
            public float readFloat(Object arg0Value_, long arg1Value) {
                assert (arg0Value_ instanceof LLVMTypedForeignObject) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                LLVMManagedReadLibrary readFloatNode__readLibrary__ = this.receiverForeignLLVMManagedReadLibrary_;
                return arg0Value.readFloat(arg1Value, readFloatNode__readLibrary__);
            }

            @Override
            public double readDouble(Object arg0Value_, long arg1Value) {
                assert (arg0Value_ instanceof LLVMTypedForeignObject) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                LLVMManagedReadLibrary readDoubleNode__readLibrary__ = this.receiverForeignLLVMManagedReadLibrary_;
                return arg0Value.readDouble(arg1Value, readDoubleNode__readLibrary__);
            }

            @Override
            public LLVMPointer readPointer(Object arg0Value_, long arg1Value) {
                assert (arg0Value_ instanceof LLVMTypedForeignObject) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                LLVMManagedReadLibrary readPointerNode__readLibrary__ = this.receiverForeignLLVMManagedReadLibrary_;
                return arg0Value.readPointer(arg1Value, readPointerNode__readLibrary__);
            }

            @Override
            public long readI64(Object arg0Value_, long arg1Value) throws UnexpectedResultException {
                assert (arg0Value_ instanceof LLVMTypedForeignObject) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                LLVMManagedReadLibrary readI64Node__readLibrary__ = this.receiverForeignLLVMManagedReadLibrary_;
                return arg0Value.readI64(arg1Value, readI64Node__readLibrary__);
            }

            @Override
            public Object readGenericI64(Object arg0Value_, long arg1Value) {
                assert (arg0Value_ instanceof LLVMTypedForeignObject) : "Invalid library usage. Library does not accept given receiver.";
                LLVMTypedForeignObject arg0Value = (LLVMTypedForeignObject)arg0Value_;
                LLVMManagedReadLibrary readGenericI64Node__readLibrary__ = this.receiverForeignLLVMManagedReadLibrary_;
                return arg0Value.readGenericI64(arg1Value, readGenericI64Node__readLibrary__);
            }
        }
    }

    @GeneratedBy(value=LLVMTypedForeignObject.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        static final FinalBitSet ENABLED_MESSAGES = InteropLibraryExports.createMessageBitSet((LibraryFactory)LLVMTypedForeignObjectGen.access$500(), (String[])new String[]{"hasLanguage", "getLanguage", "toDisplayString"});
        private static final Uncached UNCACHED = new Uncached();

        private InteropLibraryExports() {
            super(InteropLibrary.class, LLVMTypedForeignObject.class, false);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMTypedForeignObject);
            InteropLibrary uncached = (InteropLibrary)InteropLibraryExports.createDelegate((LibraryFactory)INTEROP_LIBRARY_, (Library)UNCACHED);
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMTypedForeignObject);
            return (InteropLibrary)InteropLibraryExports.createDelegate((LibraryFactory)INTEROP_LIBRARY_, (Library)new Cached(receiver));
        }

        @GeneratedBy(value=LLVMTypedForeignObject.class)
        private static final class Uncached
        extends InteropLibrary
        implements LibraryExport.DelegateExport {
            Uncached() {
            }

            public FinalBitSet getDelegateExportMessages() {
                return ENABLED_MESSAGES;
            }

            public Object readDelegateExport(Object receiver_) {
                return ((LLVMTypedForeignObject)receiver_).foreign;
            }

            public Library getDelegateExportLibrary(Object delegate_) {
                return INTEROP_LIBRARY_.getUncached(delegate_);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LLVMTypedForeignObject) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LLVMTypedForeignObject;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasLanguage(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMInternalTruffleObject)receiver).hasLanguage();
            }

            @CompilerDirectives.TruffleBoundary
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMInternalTruffleObject)receiver).getLanguage();
            }

            @CompilerDirectives.TruffleBoundary
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMInternalTruffleObject)receiver).toDisplayString(allowSideEffects);
            }
        }

        @GeneratedBy(value=LLVMTypedForeignObject.class)
        private static final class Cached
        extends InteropLibrary
        implements LibraryExport.DelegateExport {
            @Node.Child
            private InteropLibrary receiverForeignInteropLibrary_;

            Cached(Object originalReceiver) {
                LLVMTypedForeignObject receiver = (LLVMTypedForeignObject)originalReceiver;
                this.receiverForeignInteropLibrary_ = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.create((Object)receiver.foreign));
            }

            public FinalBitSet getDelegateExportMessages() {
                return ENABLED_MESSAGES;
            }

            public Object readDelegateExport(Object receiver_) {
                return ((LLVMTypedForeignObject)receiver_).foreign;
            }

            public Library getDelegateExportLibrary(Object delegate) {
                return this.receiverForeignInteropLibrary_;
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LLVMTypedForeignObject) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                if (!(receiver instanceof LLVMTypedForeignObject)) {
                    return false;
                }
                return this.receiverForeignInteropLibrary_.accepts((Object)((LLVMTypedForeignObject)receiver).foreign);
            }

            public boolean hasLanguage(Object receiver) {
                assert (receiver instanceof LLVMTypedForeignObject) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMTypedForeignObject)receiver).hasLanguage();
            }

            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (receiver instanceof LLVMTypedForeignObject) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMTypedForeignObject)receiver).getLanguage();
            }

            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (receiver instanceof LLVMTypedForeignObject) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMTypedForeignObject)receiver).toDisplayString(allowSideEffects);
            }
        }
    }
}

