/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunctionCode;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LLVMGetStackNode;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceFunctionType;
import com.oracle.truffle.llvm.runtime.interop.LLVMDataEscapeNode;
import com.oracle.truffle.llvm.runtime.interop.LLVMForeignCallNodeFactory;
import com.oracle.truffle.llvm.runtime.interop.LLVMGetInteropParamNode;
import com.oracle.truffle.llvm.runtime.interop.LLVMGetInteropPrimitiveParamNode;
import com.oracle.truffle.llvm.runtime.interop.LLVMGetInteropStructParamNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.memory.LLVMThreadingStack;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.types.FunctionType;
import com.oracle.truffle.llvm.runtime.types.Type;

public class LLVMForeignCallNode
extends RootNode {
    @CompilerDirectives.CompilationFinal
    private TruffleLanguage.ContextReference<LLVMContext> ctxRef;
    private final LLVMInteropType.Structured returnBaseType;
    @Node.Child
    LLVMGetStackNode getStack;
    @Node.Child
    DirectCallNode callNode;
    @Node.Child
    LLVMDataEscapeNode prepareValueForEscape;
    @Node.Child
    PackForeignArgumentsNode packArguments;

    public LLVMForeignCallNode(LLVMLanguage language, LLVMFunctionDescriptor function, LLVMInteropType interopType, LLVMSourceFunctionType sourceType) {
        super((TruffleLanguage)language);
        this.returnBaseType = LLVMForeignCallNode.getReturnBaseType(interopType);
        this.getStack = LLVMGetStackNode.create();
        this.callNode = DirectCallNode.create((CallTarget)LLVMForeignCallNode.getCallTarget(function));
        this.callNode.forceInlining();
        this.prepareValueForEscape = LLVMDataEscapeNode.create(function.getLLVMFunction().getType().getReturnType());
        this.packArguments = LLVMForeignCallNodeFactory.PackForeignArgumentsNodeGen.create(function.getLLVMFunction().getType(), interopType, sourceType);
    }

    public boolean isInternal() {
        return true;
    }

    public Object execute(VirtualFrame frame) {
        Object result;
        if (this.ctxRef == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.ctxRef = this.lookupContextReference(LLVMLanguage.class);
        }
        LLVMThreadingStack threadingStack = ((LLVMContext)this.ctxRef.get()).getThreadingStack();
        LLVMStack stack = this.getStack.executeWithTarget(threadingStack, Thread.currentThread());
        try (LLVMStack.StackPointer stackPointer = stack.newFrame();){
            result = this.callNode.call(this.packArguments.execute(frame.getArguments(), stackPointer));
        }
        catch (ArityException ex) {
            throw LLVMForeignCallNode.silenceException(RuntimeException.class, (Exception)((Object)ex));
        }
        return this.prepareValueForEscape.executeWithType(result, this.returnBaseType);
    }

    private static LLVMInteropType.Structured getReturnBaseType(LLVMInteropType functionType) {
        LLVMInteropType returnType;
        if (functionType instanceof LLVMInteropType.Function && (returnType = ((LLVMInteropType.Function)functionType).getReturnType()) instanceof LLVMInteropType.Value) {
            return ((LLVMInteropType.Value)returnType).getBaseType();
        }
        return null;
    }

    static CallTarget getCallTarget(LLVMFunctionDescriptor descriptor) {
        LLVMFunctionCode functionCode = descriptor.getFunctionCode();
        if (functionCode.isLLVMIRFunction()) {
            return functionCode.getLLVMIRFunctionSlowPath();
        }
        if (functionCode.isIntrinsicFunctionSlowPath()) {
            return functionCode.getIntrinsicSlowPath().cachedCallTarget(descriptor.getLLVMFunction().getType());
        }
        CompilerDirectives.transferToInterpreter();
        throw new AssertionError((Object)("native function not supported at this point: " + functionCode.getFunction()));
    }

    private static <E extends Exception> RuntimeException silenceException(Class<E> type, Exception ex) throws E {
        throw ex;
    }

    static abstract class PackForeignArgumentsNode
    extends LLVMNode {
        @Node.Children
        final LLVMGetInteropParamNode[] toLLVM;
        final int numberOfSourceArguments;

        abstract Object[] execute(Object[] var1, LLVMStack.StackPointer var2) throws ArityException;

        public static PackForeignArgumentsNode create(FunctionType bitcodeFunctionType, LLVMInteropType interopType, LLVMSourceFunctionType sourceType) {
            int numberOfBitcodeParams = bitcodeFunctionType.getNumberOfArguments();
            LLVMGetInteropParamNode[] toLLVM = new LLVMGetInteropParamNode[numberOfBitcodeParams];
            if (interopType instanceof LLVMInteropType.Function) {
                assert (sourceType != null) : "A function interop type without debug information is not supported";
                LLVMInteropType.Function interopFunctionType = (LLVMInteropType.Function)interopType;
                int prevIdx = -1;
                for (int bitcodeArgIdx = 0; bitcodeArgIdx < numberOfBitcodeParams; ++bitcodeArgIdx) {
                    Type bitcodeParameterType = bitcodeFunctionType.getArgumentType(bitcodeArgIdx);
                    LLVMSourceFunctionType.SourceArgumentInformation bitcodeParameterInfo = sourceType.getSourceArgumentInformation(bitcodeArgIdx);
                    assert (toLLVM[bitcodeArgIdx] == null);
                    if (bitcodeParameterInfo == null) {
                        int currentIdx = prevIdx + 1;
                        LLVMInteropType interopParameterType = interopFunctionType.getParameter(currentIdx);
                        toLLVM[bitcodeArgIdx] = interopParameterType instanceof LLVMInteropType.Value ? LLVMGetInteropPrimitiveParamNode.create(currentIdx, (LLVMInteropType.Value)interopParameterType) : (interopParameterType instanceof LLVMInteropType.Structured ? LLVMGetInteropPrimitiveParamNode.create(currentIdx, LLVMInteropType.Value.pointer((LLVMInteropType.Structured)interopParameterType, 8L)) : LLVMGetInteropPrimitiveParamNode.create(currentIdx, ForeignToLLVM.convert(bitcodeParameterType)));
                        prevIdx = currentIdx;
                        continue;
                    }
                    int sourceArgIndex = bitcodeParameterInfo.getSourceArgIndex();
                    LLVMInteropType targetObjectType = interopFunctionType.getParameter(sourceArgIndex);
                    LLVMInteropType.Struct targetObjectStructType = (LLVMInteropType.Struct)targetObjectType;
                    assert (bitcodeParameterInfo.getBitcodeArgIndex() == (long)bitcodeArgIdx);
                    Type targetMemberType = bitcodeFunctionType.getArgumentType(bitcodeArgIdx);
                    assert (targetMemberType == bitcodeParameterType);
                    if (Long.compareUnsigned(sourceArgIndex, numberOfBitcodeParams) >= 0) {
                        CompilerDirectives.transferToInterpreter();
                        throw new ArrayIndexOutOfBoundsException(String.format("Source argument index (%s) is out of bitcode parameters list bounds (which is of length %s)", Long.toUnsignedString(sourceArgIndex), Integer.toUnsignedString(numberOfBitcodeParams)));
                    }
                    int offsetInBytes = bitcodeParameterInfo.getOffset() / 8;
                    toLLVM[bitcodeArgIdx] = LLVMGetInteropStructParamNode.create(targetObjectStructType, sourceArgIndex, offsetInBytes, ForeignToLLVM.convert(targetMemberType));
                    prevIdx = sourceArgIndex;
                }
            } else {
                assert (sourceType == null);
                for (int i = 0; i < numberOfBitcodeParams; ++i) {
                    toLLVM[i] = LLVMGetInteropPrimitiveParamNode.create(i, ForeignToLLVM.convert(bitcodeFunctionType.getArgumentType(i)));
                }
            }
            return LLVMForeignCallNodeFactory.PackForeignArgumentsNodeGen.create(toLLVM, sourceType);
        }

        PackForeignArgumentsNode(LLVMGetInteropParamNode[] toLLVM, LLVMSourceFunctionType sourceType) {
            this.toLLVM = toLLVM;
            this.numberOfSourceArguments = sourceType == null ? toLLVM.length : sourceType.getNumberOfParameters();
        }

        @ExplodeLoop
        @Specialization
        Object[] packNonVarargs(Object[] arguments, LLVMStack.StackPointer stackPointer, @Cached BranchProfile exceptionProfile) throws ArityException {
            if (arguments.length < this.numberOfSourceArguments) {
                exceptionProfile.enter();
                throw ArityException.create((int)this.numberOfSourceArguments, (int)arguments.length);
            }
            Object[] packedArguments = new Object[1 + this.toLLVM.length];
            packedArguments[0] = stackPointer;
            for (int i = 0; i < this.toLLVM.length; ++i) {
                packedArguments[i + 1] = this.toLLVM[i].execute(arguments);
            }
            return packedArguments;
        }
    }
}

