/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.floating;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedLanguage;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.NFIContextExtension;
import com.oracle.truffle.llvm.runtime.floating.BinaryHelper;
import com.oracle.truffle.llvm.runtime.floating.DoubleHelper;
import com.oracle.truffle.llvm.runtime.floating.FloatHelper;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloatFactory;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMArithmetic;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

@CompilerDirectives.ValueType
public final class LLVM80BitFloat
implements LLVMArithmetic {
    private static final int BIT_TO_HEX_FACTOR = 4;
    public static final int BIT_WIDTH = 80;
    public static final int BYTE_WIDTH = 10;
    private static final int EXPONENT_BIT_WIDTH = 15;
    private static final int FRACTION_BIT_WIDTH = 64;
    private static final int HEX_DIGITS_FRACTION = 16;
    private static final byte UNDEFINED_FLOAT_TO_BYTE_VALUE = 0;
    private static final short UNDEFINED_FLOAT_TO_SHORT_VALUE = 0;
    private static final int UNDEFINED_FLOAT_TO_INT_VALUE = Integer.MIN_VALUE;
    private static final long UNDEFINED_FLOAT_TO_LONG_VALUE = Long.MIN_VALUE;
    private static final long UNDEFINED_DOUBLE_VALUE = Long.MIN_VALUE;
    public static final int ALL_ONE_EXPONENT = Short.MAX_VALUE;
    private static final LLVM80BitFloat DOUBLE_MINUS_INFINITY_CONVERSION_NUMBER = LLVM80BitFloat.fromRawValues(true, Short.MAX_VALUE, Long.MIN_VALUE);
    private static final LLVM80BitFloat DOUBLE_INFINITY_CONVERSION_NUMBER = LLVM80BitFloat.fromRawValues(false, Short.MAX_VALUE, Long.MIN_VALUE);
    private static final LLVM80BitFloat DOUBLE_NAN_CONVERSION_NUMBER = LLVM80BitFloat.fromRawValues(false, Short.MAX_VALUE, -4611686018427387904L);
    private static final LLVM80BitFloat POSITIVE_ZERO = new LLVM80BitFloat(false, 0, 0L);
    private static final LLVM80BitFloat NEGATIVE_ZERO = new LLVM80BitFloat(true, 0, 0L);
    private static final LLVM80BitFloat POSITIVE_INFINITY = new LLVM80BitFloat(false, Short.MAX_VALUE, LLVM80BitFloat.bit(63L));
    private static final LLVM80BitFloat NEGATIVE_INFINITY = new LLVM80BitFloat(true, Short.MAX_VALUE, LLVM80BitFloat.bit(63L));
    private static final int EXPLICIT_LEADING_ONE_BITS = 1;
    private static final int EXPONENT_BIAS = 16383;
    private static final int FLOAT_EXPONENT_BIAS = 127;
    private final boolean sign;
    private final int biasedExponent;
    private final long fraction;

    public String toString() {
        return LLVM80BitFloat.toLLVMString(this);
    }

    @CompilerDirectives.TruffleBoundary
    public String toDebugString() {
        return String.format("sign: %s\nexponent: %s\nfraction: %s %s\n", this.getSign(), LLVM80BitFloat.getBinaryString(15, this.getExponent()), LLVM80BitFloat.getBinaryString(64, this.getFraction()), LLVM80BitFloat.getHexString(16, this.getFraction()));
    }

    @CompilerDirectives.TruffleBoundary
    public static String toLLVMString(LLVM80BitFloat value) {
        if (value.isQNaN()) {
            return "QNaN";
        }
        if (value.isSNaN()) {
            return "SNaN";
        }
        if (value.isInfinity()) {
            return "INF";
        }
        short exponent = value.getExponent();
        if (value.getSign()) {
            exponent = (short)(exponent | 0x8000);
        }
        long fraction = value.getFraction();
        return String.format("0xK%4x%16x", exponent, fraction).replace(' ', '0');
    }

    @CompilerDirectives.TruffleBoundary
    private static String getBinaryString(int bitWidth, long number) {
        return String.format("%" + bitWidth + "s", Long.toBinaryString(number)).replace(" ", "0");
    }

    @CompilerDirectives.TruffleBoundary
    private static String getHexString(int bitWidth, long number) {
        return String.format("%" + bitWidth + "x", number).replace(" ", "0");
    }

    public LLVM80BitFloat(boolean sign, int exponent, long fraction) {
        this.sign = sign;
        this.biasedExponent = exponent;
        this.fraction = fraction;
    }

    private LLVM80BitFloat(LLVM80BitFloat value) {
        this.sign = value.sign;
        this.biasedExponent = value.biasedExponent;
        this.fraction = value.fraction;
    }

    private int getUnbiasedExponent() {
        return this.biasedExponent - 16383;
    }

    public static LLVM80BitFloat createPositiveZero() {
        if (CompilerDirectives.inCompiledCode()) {
            return new LLVM80BitFloat(false, 0, 0L);
        }
        return POSITIVE_ZERO;
    }

    private static long bit(int i) {
        return 1 << i;
    }

    public static long bit(long i) {
        return 1L << (int)i;
    }

    public static LLVM80BitFloat fromLong(long val) {
        if (val == 0L) {
            return LLVM80BitFloat.createPositiveZero();
        }
        boolean sign = val < 0L;
        return LLVM80BitFloat.fromLong(Math.abs(val), sign);
    }

    private static LLVM80BitFloat fromLong(long val, boolean sign) {
        int leadingOnePosition = 64 - Long.numberOfLeadingZeros(val);
        int exponent = 16383 + (leadingOnePosition - 1);
        long fractionMask = leadingOnePosition == 64 || leadingOnePosition == 63 ? -1L : (1L << leadingOnePosition + 1) - 1L;
        long maskedFractionValue = val & fractionMask;
        long fraction = maskedFractionValue << 64 - leadingOnePosition;
        return new LLVM80BitFloat(sign, exponent, fraction);
    }

    public static LLVM80BitFloat fromUnsignedLong(long val) {
        if (val == 0L) {
            return new LLVM80BitFloat(POSITIVE_ZERO);
        }
        return LLVM80BitFloat.fromLong(val, false);
    }

    public static LLVM80BitFloat fromUnsignedInt(int val) {
        if (val == 0) {
            return new LLVM80BitFloat(POSITIVE_ZERO);
        }
        return LLVM80BitFloat.fromLong((long)val & 0xFFFFFFFFL, false);
    }

    public static LLVM80BitFloat fromInt(int val) {
        if (val == 0) {
            return new LLVM80BitFloat(POSITIVE_ZERO);
        }
        boolean sign = val < 0;
        return LLVM80BitFloat.fromInt(val, sign);
    }

    private static LLVM80BitFloat fromInt(int val, boolean sign) {
        int posVal = Math.abs(val);
        int leadingOnePosition = 32 - Integer.numberOfLeadingZeros(posVal);
        int exponent = 16383 + (leadingOnePosition - 1);
        long fractionMask = (1L << leadingOnePosition + 1) - 1L;
        long maskedFractionValue = (long)posVal & fractionMask;
        long fraction = maskedFractionValue << 64 - leadingOnePosition;
        return new LLVM80BitFloat(sign, exponent, fraction);
    }

    private static boolean getBit(int position, long posVal) {
        long l = posVal >>> position;
        return (l & 1L) != 0L;
    }

    public boolean isZero() {
        return this.isPositiveZero() || this.isNegativeZero();
    }

    private boolean isPositiveZero() {
        return this.equals(POSITIVE_ZERO);
    }

    private boolean isNegativeZero() {
        return this.equals(NEGATIVE_ZERO);
    }

    public static LLVM80BitFloat fromFloat(float val) {
        boolean sign;
        boolean bl = sign = val < 0.0f;
        if (FloatHelper.isPositiveZero(val)) {
            return new LLVM80BitFloat(POSITIVE_ZERO);
        }
        if (FloatHelper.isNegativeZero(val)) {
            return new LLVM80BitFloat(NEGATIVE_ZERO);
        }
        if (FloatHelper.isPositiveInfinty(val)) {
            return new LLVM80BitFloat(DOUBLE_INFINITY_CONVERSION_NUMBER);
        }
        if (FloatHelper.isNegativeInfinity(val)) {
            return new LLVM80BitFloat(DOUBLE_MINUS_INFINITY_CONVERSION_NUMBER);
        }
        if (FloatHelper.isNaN(val)) {
            return new LLVM80BitFloat(DOUBLE_NAN_CONVERSION_NUMBER);
        }
        int rawValue = Float.floatToRawIntBits(val);
        int floatExponent = FloatHelper.getUnbiasedExponent(val);
        int biasedExponent = floatExponent + 16383;
        long leadingOne = Long.MIN_VALUE;
        long floatFraction = rawValue & FloatHelper.FRACTION_MASK;
        long shiftedFloatFraction = floatFraction << 40;
        long fraction = shiftedFloatFraction | leadingOne;
        return LLVM80BitFloat.fromRawValues(sign, biasedExponent, fraction);
    }

    public static LLVM80BitFloat fromDouble(double val) {
        boolean sign;
        boolean bl = sign = val < 0.0;
        if (DoubleHelper.isPositiveZero(val)) {
            return new LLVM80BitFloat(POSITIVE_ZERO);
        }
        if (DoubleHelper.isNegativeZero(val)) {
            return new LLVM80BitFloat(NEGATIVE_ZERO);
        }
        if (DoubleHelper.isPositiveInfinty(val)) {
            return new LLVM80BitFloat(DOUBLE_INFINITY_CONVERSION_NUMBER);
        }
        if (DoubleHelper.isNegativeInfinity(val)) {
            return new LLVM80BitFloat(DOUBLE_MINUS_INFINITY_CONVERSION_NUMBER);
        }
        if (DoubleHelper.isNaN(val)) {
            return new LLVM80BitFloat(DOUBLE_NAN_CONVERSION_NUMBER);
        }
        long rawValue = Double.doubleToRawLongBits(val);
        int doubleExponent = DoubleHelper.getUnbiasedExponent(val);
        int biasedExponent = doubleExponent + 16383;
        long leadingOne = Long.MIN_VALUE;
        long doubleFraction = rawValue & DoubleHelper.FRACTION_MASK;
        long shiftedDoubleFraction = doubleFraction << 11;
        long fraction = shiftedDoubleFraction | leadingOne;
        return LLVM80BitFloat.fromRawValues(sign, biasedExponent, fraction);
    }

    private long getFractionAsLong() {
        return this.fraction >>> 64 - this.getUnbiasedExponent() - 1;
    }

    private long compareNoSign(LLVM80BitFloat val) {
        if (this.getExponent() != val.getExponent()) {
            return this.getExponent() - val.getExponent();
        }
        return this.getFraction() - val.getFraction();
    }

    private LLVM80BitFloat add2(LLVM80BitFloat right) {
        long resultHi;
        long overFlowLowerPart;
        long resultLo;
        short leftExponent = this.getExponent();
        short rightExponent = right.getExponent();
        long leftFraction = this.getFraction();
        long rightFraction = right.getFraction();
        int shiftAmount = Math.abs(leftExponent - rightExponent);
        if (leftExponent < rightExponent) {
            leftFraction >>>= shiftAmount;
            leftExponent = rightExponent;
        } else {
            rightFraction >>>= shiftAmount;
            rightExponent = leftExponent;
        }
        boolean newSign = this.getSign() == right.getSign() ? this.getSign() : (this.compareNoSign(right) < 0L ? right.getSign() : this.getSign());
        boolean addition = this.getSign() == right.getSign();
        long leftFractionLowerPart = leftFraction & (long)BinaryHelper.getBitMask(32);
        long rightFractionLowerPart = rightFraction & (long)BinaryHelper.getBitMask(32);
        long leftFractionHigherPart = leftFraction >>> 32;
        long rightFractionHigherPart = rightFraction >>> 32;
        if (addition) {
            resultLo = -leftFractionLowerPart + rightFractionLowerPart;
            overFlowLowerPart = resultLo >>> 32;
            resultHi = leftFractionHigherPart + rightFractionHigherPart + overFlowLowerPart;
        } else if (this.getSign()) {
            resultLo = -leftFractionLowerPart + rightFractionLowerPart;
            overFlowLowerPart = resultLo >>> 32;
            resultHi = -leftFractionHigherPart - rightFractionHigherPart - overFlowLowerPart;
        } else {
            resultLo = leftFractionLowerPart - rightFractionLowerPart;
            overFlowLowerPart = resultLo >>> 32;
            resultHi = leftFractionHigherPart - rightFractionHigherPart - overFlowLowerPart;
        }
        int overFlow = (int)(resultHi >>> 32);
        if (overFlow > 0) {
            long lostBits = (resultHi >>>= overFlow) & (long)overFlow;
            long shiftedLostBits = lostBits << 32 - overFlow;
            resultLo = resultLo >>> overFlow | shiftedLostBits;
        }
        int newExponent = leftExponent + overFlow;
        long newFraction = resultLo + resultHi << 32;
        return LLVM80BitFloat.fromRawValues(newSign, newExponent, newFraction);
    }

    public LLVM80BitFloat abs() {
        return LLVM80BitFloat.fromRawValues(false, this.biasedExponent, this.fraction);
    }

    public boolean isPositiveInfinity() {
        return POSITIVE_INFINITY.equals(this);
    }

    public boolean isNegativeInfinity() {
        return NEGATIVE_INFINITY.equals(this);
    }

    public boolean isInfinity() {
        return this.isPositiveInfinity() || this.isNegativeInfinity();
    }

    public boolean isSNaN() {
        if (this.getExponent() == Short.MAX_VALUE && LLVM80BitFloat.getBit(63, this.getFraction()) && !LLVM80BitFloat.getBit(62, this.getFraction())) {
            return (this.getFraction() & 0x3FFFFFFFFFFFFFFFL) != 0L;
        }
        return false;
    }

    public boolean isQNaN() {
        if (this.getExponent() == Short.MAX_VALUE) {
            if (LLVM80BitFloat.getBit(63, this.getFraction())) {
                if (LLVM80BitFloat.getBit(62, this.getFraction())) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public boolean isNaN() {
        return this.isSNaN() || this.isQNaN();
    }

    public boolean isOrdered() {
        return !this.isNaN();
    }

    int compareOrdered(LLVM80BitFloat val) {
        if (this.isNegativeInfinity()) {
            if (val.isNegativeInfinity()) {
                return 0;
            }
            return -1;
        }
        if (val.isNegativeInfinity()) {
            if (this.isNegativeInfinity()) {
                return 0;
            }
            return 1;
        }
        if (this.getSign() == val.getSign()) {
            int expDifference = this.getExponent() - val.getExponent();
            if (expDifference == 0) {
                long fractionDifference = this.getFraction() - val.getFraction();
                if (fractionDifference == 0L) {
                    return 0;
                }
                if (fractionDifference < 0L) {
                    return -1;
                }
                return 1;
            }
            return expDifference;
        }
        if (this.isZero() && val.isZero()) {
            return 0;
        }
        if (this.getSign()) {
            return -1;
        }
        return 1;
    }

    public short getExponent() {
        return (short)this.biasedExponent;
    }

    public long getFraction() {
        return this.fraction;
    }

    public long getFractionWithoutImplicitZero() {
        return this.fraction << 1;
    }

    public boolean getSign() {
        return this.sign;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LLVM80BitFloat)) {
            return false;
        }
        LLVM80BitFloat other = (LLVM80BitFloat)obj;
        return this.getSign() == other.getSign() && this.getExponent() == other.getExponent() && this.getFraction() == other.getFraction();
    }

    public int hashCode() {
        return Arrays.hashCode(this.getBytes());
    }

    public byte[] getBytesBigEndian() {
        byte[] array = new byte[10];
        ByteBuffer bb = ByteBuffer.wrap(array);
        bb.order(ByteOrder.BIG_ENDIAN);
        short signWithExponent = this.getExponent();
        short signBit = this.sign ? (short)LLVM80BitFloat.bit(15) : (short)0;
        signWithExponent = (short)(signWithExponent | signBit);
        bb.putShort(signWithExponent);
        bb.putLong(this.getFraction());
        return array;
    }

    public byte[] getBytes() {
        byte[] array = new byte[10];
        ByteBuffer bb = ByteBuffer.wrap(array);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        short signWithExponent = this.getExponent();
        short signBit = this.sign ? (short)LLVM80BitFloat.bit(15) : (short)0;
        signWithExponent = (short)(signWithExponent | signBit);
        bb.putLong(this.getFraction());
        bb.putShort(signWithExponent);
        return array;
    }

    public static LLVM80BitFloat fromBytesBigEndian(byte[] bytes) {
        assert (bytes.length == 10);
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        bb.order(ByteOrder.BIG_ENDIAN);
        short readShort = bb.getShort();
        int exponent = readShort & BinaryHelper.getBitMask(15);
        long fraction = bb.getLong();
        boolean signSet = LLVM80BitFloat.getBit(16, readShort);
        return LLVM80BitFloat.fromRawValues(signSet, exponent, fraction);
    }

    public static LLVM80BitFloat fromBytes(byte[] bytes) {
        assert (bytes.length == 10);
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        long fraction = bb.getLong();
        short readShort = bb.getShort();
        int exponent = readShort & BinaryHelper.getBitMask(15);
        boolean signSet = LLVM80BitFloat.getBit(16, readShort);
        return LLVM80BitFloat.fromRawValues(signSet, exponent, fraction);
    }

    public byte getByteValue() {
        if (this.isNaN() || this.isInfinity()) {
            return 0;
        }
        long value = this.getFractionAsLong();
        return (byte)(this.sign ? -value : value);
    }

    public short getShortValue() {
        if (this.isNaN() || this.isInfinity()) {
            return 0;
        }
        long value = this.getFractionAsLong();
        return (short)(this.sign ? -value : value);
    }

    public int getIntValue() {
        if (this.isNaN() || this.isInfinity()) {
            return Integer.MIN_VALUE;
        }
        int value = (int)this.getFractionAsLong();
        return this.sign ? -value : value;
    }

    public long getLongValue() {
        if (this.isNaN() || this.isInfinity()) {
            return Long.MIN_VALUE;
        }
        long value = this.getFractionAsLong();
        return this.sign ? -value : value;
    }

    public float getFloatValue() {
        if (this.isPositiveZero()) {
            return 0.0f;
        }
        if (this.isNegativeZero()) {
            return -0.0f;
        }
        if (this.isPositiveInfinity()) {
            return Float.POSITIVE_INFINITY;
        }
        if (this.isNegativeInfinity()) {
            return Float.NEGATIVE_INFINITY;
        }
        if (this.isNaN()) {
            return Float.NaN;
        }
        int floatExponent = this.getUnbiasedExponent() + 127;
        long longFraction = this.getFractionWithoutImplicitZero() >>> 41;
        int floatFraction = (int)longFraction;
        int shiftedSignBit = (this.getSign() ? 1 : 0) << 31;
        int shiftedExponent = floatExponent << 23;
        int rawVal = floatFraction | shiftedExponent | shiftedSignBit;
        return Float.intBitsToFloat(rawVal);
    }

    public double getDoubleValue() {
        if (this.isPositiveZero()) {
            return 0.0;
        }
        if (this.isNegativeZero()) {
            return -0.0;
        }
        if (this.isPositiveInfinity()) {
            return Double.POSITIVE_INFINITY;
        }
        if (this.isNegativeInfinity()) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this.isNaN()) {
            return Double.NaN;
        }
        int doubleExponent = this.getUnbiasedExponent() + 1023;
        long doubleFraction = this.getFractionWithoutImplicitZero() >>> 12;
        long shiftedSignBit = (this.getSign() ? 1L : 0L) << 63;
        long shiftedExponent = (long)doubleExponent << 52;
        long rawVal = doubleFraction | shiftedExponent | shiftedSignBit;
        return Double.longBitsToDouble(rawVal);
    }

    public LLVM80BitFloat negate() {
        return new LLVM80BitFloat(!this.getSign(), this.getExponent(), this.getFraction());
    }

    public static LLVM80BitFloat fromByte(byte from) {
        return LLVM80BitFloat.fromInt(from);
    }

    public static LLVM80BitFloat fromUnsignedByte(byte from) {
        return LLVM80BitFloat.fromInt(from & 0xFF);
    }

    public static LLVM80BitFloat fromUnsignedShort(short from) {
        return LLVM80BitFloat.fromUnsignedInt(from & 0xFFFF);
    }

    public static LLVM80BitFloat fromShort(short from) {
        return LLVM80BitFloat.fromInt(from);
    }

    public static LLVM80BitFloat fromRawValues(boolean sign, int exp, long fraction) {
        return new LLVM80BitFloat(sign, exp, fraction);
    }

    @ExplodeLoop
    public static boolean areOrdered(LLVM80BitFloat ... vals) {
        CompilerAsserts.compilationConstant((Object)vals.length);
        for (LLVM80BitFloat val : vals) {
            if (val.isOrdered()) continue;
            return false;
        }
        return true;
    }

    public static int compare(LLVM80BitFloat val1, LLVM80BitFloat val2) {
        return val1.compareOrdered(val2);
    }

    @Override
    public LLVMArithmetic.LLVMArithmeticOpNode createAddNode() {
        return new LLVM80BitFloatOpNode("add");
    }

    @Override
    public LLVMArithmetic.LLVMArithmeticOpNode createSubNode() {
        return new LLVM80BitFloatOpNode("sub");
    }

    @Override
    public LLVMArithmetic.LLVMArithmeticOpNode createMulNode() {
        return new LLVM80BitFloatOpNode("mul");
    }

    @Override
    public LLVMArithmetic.LLVMArithmeticOpNode createDivNode() {
        return new LLVM80BitFloatOpNode("div");
    }

    @Override
    public LLVMArithmetic.LLVMArithmeticOpNode createRemNode() {
        return new LLVM80BitFloatOpNode("mod");
    }

    @Override
    public LLVMArithmetic.LLVMArithmeticCompareNode createCmpNode() {
        return new LLVMArithmetic.LLVMArithmeticCompareNode(){

            @Override
            public int execute(Object x, Object y) {
                LLVM80BitFloat a = (LLVM80BitFloat)x;
                LLVM80BitFloat b = (LLVM80BitFloat)y;
                return LLVM80BitFloat.compare(a, b);
            }

            @Override
            public boolean canCompute(Object x, Object y) {
                return x instanceof LLVM80BitFloat && y instanceof LLVM80BitFloat;
            }
        };
    }

    private static class LLVM80BitFloatOpNode
    extends LLVMArithmetic.LLVMArithmeticOpNode {
        @Node.Child
        private LLVM80BitFloatNativeCallNode node;

        LLVM80BitFloatOpNode(String op) {
            this.node = LLVM80BitFloatFactory.LLVM80BitFloatNativeCallNodeGen.create(op);
        }

        @Override
        public boolean canCompute(Object x, Object y) {
            return x instanceof LLVM80BitFloat && y instanceof LLVM80BitFloat;
        }

        @Override
        public LLVM80BitFloat execute(Object x, Object y) {
            LLVM80BitFloat a = (LLVM80BitFloat)x;
            LLVM80BitFloat b = (LLVM80BitFloat)y;
            return this.node.execute(a, b);
        }
    }

    protected static abstract class LLVM80BitFloatNativeCallNode
    extends LLVMNode {
        private final String name;

        public LLVM80BitFloatNativeCallNode(String name) {
            this.name = name;
        }

        protected TruffleObject createFunction() {
            LLVMContext context = (LLVMContext)this.lookupContextReference(LLVMLanguage.class).get();
            NFIContextExtension nfiContextExtension = context.getContextExtensionOrNull(NFIContextExtension.class);
            return nfiContextExtension == null ? null : nfiContextExtension.getNativeFunction(context, "__sulong_fp80_" + this.name, "(UINT64,UINT64,UINT64):VOID");
        }

        public abstract LLVM80BitFloat execute(LLVM80BitFloat var1, LLVM80BitFloat var2);

        @Specialization(guards={"function != null"})
        protected LLVM80BitFloat doCall(LLVM80BitFloat x, LLVM80BitFloat y, @Cached(value="createFunction()") TruffleObject function, @CachedLibrary(value="function") InteropLibrary nativeExecute, @CachedLanguage LLVMLanguage language) {
            LLVMNativePointer mem;
            LLVMMemory memory = language.getLLVMMemory();
            LLVMNativePointer ptrX = mem = memory.allocateMemory(this, 48L);
            LLVMNativePointer ptrY = ptrX.increment(16L);
            LLVMNativePointer ptrZ = ptrY.increment(16L);
            memory.put80BitFloat((Node)this, ptrX, x);
            memory.put80BitFloat((Node)this, ptrY, y);
            try {
                LLVM80BitFloat z;
                nativeExecute.execute((Object)function, new Object[]{ptrZ.asNative(), ptrX.asNative(), ptrY.asNative()});
                LLVM80BitFloat lLVM80BitFloat = z = memory.get80BitFloat(this, ptrZ);
                return lLVM80BitFloat;
            }
            catch (InteropException e) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError((Object)e);
            }
            finally {
                memory.free((Node)this, mem);
            }
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected LLVM80BitFloat doCall(LLVM80BitFloat x, LLVM80BitFloat y) {
            double result;
            double xDouble = x.getDoubleValue();
            double yDouble = y.getDoubleValue();
            switch (this.name) {
                case "add": {
                    result = xDouble + yDouble;
                    break;
                }
                case "sub": {
                    result = xDouble - yDouble;
                    break;
                }
                case "mul": {
                    result = xDouble * yDouble;
                    break;
                }
                case "div": {
                    result = xDouble / yDouble;
                    break;
                }
                case "mod": {
                    result = xDouble % yDouble;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("unexpected 80 bit float operation: " + this.name));
                }
            }
            return LLVM80BitFloat.fromDouble(result);
        }

        @Override
        public String toString() {
            return "fp80 " + this.name;
        }
    }
}

