/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.debug.type;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class LLVMSourceFunctionType
extends LLVMSourceType {
    private final List<LLVMSourceType> types;
    private ArrayList<SourceArgumentInformation> sourceArgumentInformationList;

    @CompilerDirectives.TruffleBoundary
    public LLVMSourceFunctionType(List<LLVMSourceType> types) {
        super(0L, 0L, 0L, null);
        assert (types != null);
        this.types = types;
        this.setName(() -> {
            CompilerDirectives.transferToInterpreter();
            StringBuilder nameBuilder = new StringBuilder(this.getReturnType().getName()).append("(");
            List<LLVMSourceType> params = this.getParameterTypes();
            if (params.size() > 0) {
                nameBuilder.append(params.get(0).getName());
            }
            for (int i = 1; i < params.size(); ++i) {
                nameBuilder.append(", ").append(params.get(i).getName());
            }
            if (!this.isVarArgs()) {
                nameBuilder.append(")");
            } else if (this.getParameterTypes().size() == 0) {
                nameBuilder.append("...)");
            } else {
                nameBuilder.append(", ...)");
            }
            return nameBuilder.toString();
        });
    }

    @CompilerDirectives.TruffleBoundary
    public LLVMSourceType getReturnType() {
        if (this.types.size() > 0) {
            return this.types.get(0);
        }
        return LLVMSourceType.VOID;
    }

    @CompilerDirectives.TruffleBoundary
    public int getNumberOfParameters() {
        return Math.max(0, this.types.size() - 1);
    }

    @CompilerDirectives.TruffleBoundary
    public List<LLVMSourceType> getParameterTypes() {
        if (this.types.size() <= 1) {
            return Collections.emptyList();
        }
        return this.types.subList(1, this.types.size() - (this.isVarArgs() ? 1 : 0));
    }

    @CompilerDirectives.TruffleBoundary
    public boolean isVarArgs() {
        return this.types.size() > 1 && this.types.get(this.types.size() - 1) == LLVMSourceType.VOID;
    }

    @Override
    public LLVMSourceType getOffset(long newOffset) {
        return this;
    }

    public void attachSourceArgumentInformation(int bitcodeArgIndex, int sourceArgIndex, int offset, int size) {
        if (this.sourceArgumentInformationList == null) {
            this.sourceArgumentInformationList = new ArrayList();
        }
        LLVMSourceFunctionType.ensureCapacity(this.sourceArgumentInformationList, bitcodeArgIndex + 1);
        if (this.sourceArgumentInformationList.get(bitcodeArgIndex) == null) {
            this.sourceArgumentInformationList.set(bitcodeArgIndex, new SourceArgumentInformation(bitcodeArgIndex, sourceArgIndex, offset, size));
        } else {
            this.sourceArgumentInformationList.set(bitcodeArgIndex, SourceArgumentInformation.INVALID);
        }
    }

    private static void ensureCapacity(ArrayList<?> list, int capacity) {
        for (int diff = capacity - list.size(); diff > 0; --diff) {
            list.add(null);
        }
    }

    public SourceArgumentInformation getSourceArgumentInformation(int index) {
        if (this.sourceArgumentInformationList == null || index >= this.sourceArgumentInformationList.size()) {
            return null;
        }
        SourceArgumentInformation info = this.sourceArgumentInformationList.get(index);
        if (SourceArgumentInformation.INVALID.equals(info)) {
            return null;
        }
        return info;
    }

    public static final class SourceArgumentInformation {
        private final int bitcodeArgIndex;
        private final int sourceArgIndex;
        private final int offset;
        private final int size;
        private static final SourceArgumentInformation INVALID = new SourceArgumentInformation(-1, -1, -1, -1);

        SourceArgumentInformation(int bitcodeArgIndex, int sourceArgIndex, int offset, int size) {
            this.bitcodeArgIndex = bitcodeArgIndex;
            this.sourceArgIndex = sourceArgIndex;
            this.offset = offset;
            this.size = size;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SourceArgumentInformation that = (SourceArgumentInformation)o;
            return this.bitcodeArgIndex == that.bitcodeArgIndex && this.sourceArgIndex == that.sourceArgIndex && this.offset == that.offset && this.size == that.size;
        }

        public int hashCode() {
            return Objects.hash(this.bitcodeArgIndex, this.sourceArgIndex, this.offset, this.size);
        }

        public String toString() {
            return "SourceArgumentInformation(bcArgIdx=" + this.bitcodeArgIndex + ", srcArgIdx=" + this.sourceArgIndex + ", offset=" + this.offset + ", size=" + this.size + ')';
        }

        public long getBitcodeArgIndex() {
            return this.bitcodeArgIndex;
        }

        public int getSourceArgIndex() {
            return this.sourceArgIndex;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getSize() {
            return this.size;
        }
    }
}

