/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Scope;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.llvm.runtime.debug.LLVMDebuggerValue;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes.DebugExprFunctionCallNode;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes.DebugExprFunctionCallNodeGen;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes.DebugExpressionPair;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes.MemberAccessible;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.parser.DebugExprException;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.parser.DebugExprType;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import java.util.Collection;
import java.util.List;
import org.graalvm.collections.Pair;

public abstract class DebugExprVarNode
extends LLVMExpressionNode
implements MemberAccessible {
    static final Scope[] NO_SCOPES = new Scope[0];
    private final String name;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final Scope[] scopes;

    DebugExprVarNode(String name, Collection<Scope> scopes) {
        this.name = name;
        this.scopes = scopes.toArray(NO_SCOPES);
    }

    @CompilerDirectives.TruffleBoundary
    private Pair<Object, DebugExprType> findMemberAndType() {
        InteropLibrary library = (InteropLibrary)InteropLibrary.getFactory().getUncached();
        for (Scope scope : this.scopes) {
            Object vars = scope.getVariables();
            try {
                if (!library.isMemberReadable(vars, this.name)) continue;
                Object member = library.readMember(vars, this.name);
                LLVMDebuggerValue ldv = (LLVMDebuggerValue)member;
                Object metaObj = ldv.resolveMetaObject();
                DebugExprType type = DebugExprType.getTypeFromSymbolTableMetaObject(metaObj);
                return Pair.create((Object)member, (Object)type);
            }
            catch (ClassCastException e) {
                throw DebugExprException.create(this, "\"%s\" cannot be casted to a LLVMDebuggerValue", this.name);
            }
            catch (UnsupportedMessageException e) {
                throw DebugExprException.symbolNotFound(this, this.name, null);
            }
            catch (UnknownIdentifierException e) {
                throw DebugExprException.symbolNotFound(this, e.getUnknownIdentifier(), null);
            }
        }
        return Pair.create(null, (Object)DebugExprType.getVoidType());
    }

    @Override
    public DebugExprType getType() {
        return (DebugExprType)this.findMemberAndType().getRight();
    }

    @Override
    public Object getMember() {
        return this.findMemberAndType().getLeft();
    }

    public String getName() {
        return this.name;
    }

    @Specialization
    public Object doVariable() {
        Object value;
        Pair<Object, DebugExprType> pair = this.findMemberAndType();
        if (pair.getLeft() == null) {
            throw DebugExprException.symbolNotFound(this, this.name, null);
        }
        Object member = pair.getLeft();
        DebugExprType type = (DebugExprType)pair.getRight();
        if (type != null && member != null && (value = type.parse(member)) != null) {
            return value;
        }
        throw DebugExprException.symbolNotFound(this, this.name, null);
    }

    public DebugExprFunctionCallNode createFunctionCall(List<DebugExpressionPair> arguments, Collection<Scope> globalScopes) {
        return DebugExprFunctionCallNodeGen.create(this.name, arguments, globalScopes.toArray(NO_SCOPES));
    }
}

