/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.llvm.runtime.debug.LLVMDebuggerValue;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes.MemberAccessible;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.parser.DebugExprException;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.parser.DebugExprType;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import org.graalvm.collections.Pair;

@NodeInfo(shortName=".")
public abstract class DebugExprObjectMemberNode
extends LLVMExpressionNode
implements MemberAccessible {
    @Node.Child
    private LLVMExpressionNode baseNode;
    private final String fieldName;

    public DebugExprObjectMemberNode(LLVMExpressionNode baseNode, String fieldName) {
        this.fieldName = fieldName;
        this.baseNode = baseNode;
    }

    @Override
    public DebugExprType getType() {
        if (this.baseNode instanceof MemberAccessible) {
            Object baseMember = ((MemberAccessible)((Object)this.baseNode)).getMember();
            return (DebugExprType)this.findMemberAndType(baseMember).getRight();
        }
        throw DebugExprException.create(this, "member access not possible for %s.%s", new Object[]{this.baseNode, this.fieldName});
    }

    @Override
    public Object getMember() {
        if (this.baseNode instanceof MemberAccessible) {
            Object baseMember = ((MemberAccessible)((Object)this.baseNode)).getMember();
            return this.findMemberAndType(baseMember).getLeft();
        }
        throw DebugExprException.create(this, "member access not possible for %s.%s", new Object[]{this.baseNode, this.fieldName});
    }

    public String getFieldName() {
        return this.fieldName;
    }

    private Pair<Object, DebugExprType> findMemberAndType(Object baseMember) {
        InteropLibrary library = (InteropLibrary)InteropLibrary.getFactory().getUncached();
        if (baseMember != null && library.isMemberExisting(baseMember, this.fieldName)) {
            try {
                Object member = library.readMember(baseMember, this.fieldName);
                LLVMDebuggerValue ldv = (LLVMDebuggerValue)member;
                Object metaObj = ldv.resolveMetaObject();
                DebugExprType type = DebugExprType.getTypeFromSymbolTableMetaObject(metaObj);
                return Pair.create((Object)member, (Object)type);
            }
            catch (UnsupportedMessageException e1) {
                throw DebugExprException.symbolNotFound(this, this.fieldName, baseMember);
            }
            catch (UnknownIdentifierException e1) {
                throw DebugExprException.symbolNotFound(this, e1.getUnknownIdentifier(), baseMember);
            }
            catch (ClassCastException e1) {
                throw DebugExprException.symbolNotFound(this, this.fieldName, baseMember);
            }
        }
        throw DebugExprException.symbolNotFound(this, this.fieldName, baseMember);
    }

    @Specialization
    Object doObjectMember(VirtualFrame frame) {
        Object baseMember = this.baseNode.executeGeneric(frame);
        Pair<Object, DebugExprType> pair = this.findMemberAndType(baseMember);
        Object member = pair.getLeft();
        if (member != null) {
            return ((DebugExprType)pair.getRight()).parse(member);
        }
        throw DebugExprException.symbolNotFound(this, this.fieldName, baseMember);
    }
}

