/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes.DebugExprNotNode;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;

@GeneratedBy(value=DebugExprNotNode.class)
public final class DebugExprNotNodeGen
extends DebugExprNotNode {
    private LLVMSourceLocation sourceLocation;
    private boolean statement;
    @Node.Child
    private LLVMExpressionNode child_;
    @CompilerDirectives.CompilationFinal
    private int state_;

    private DebugExprNotNodeGen(LLVMExpressionNode child) {
        this.child_ = child;
    }

    @Override
    public LLVMSourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    @Override
    public void setSourceLocation(LLVMSourceLocation sourceLocation) {
        this.sourceLocation = sourceLocation;
    }

    @Override
    protected boolean isStatement() {
        return this.statement;
    }

    @Override
    protected void setStatement(boolean statement) {
        this.statement = statement;
    }

    @Override
    public Object executeWithTarget(Object childValue) {
        int state = this.state_;
        if ((state & 1) != 0 && childValue instanceof Boolean) {
            boolean childValue_ = (Boolean)childValue;
            return this.flip(childValue_);
        }
        if ((state & 2) != 0 && childValue instanceof Byte) {
            byte childValue_ = (Byte)childValue;
            return this.flip(childValue_);
        }
        if ((state & 4) != 0 && childValue instanceof Short) {
            short childValue_ = (Short)childValue;
            return this.flip(childValue_);
        }
        if ((state & 8) != 0 && childValue instanceof Character) {
            char childValue_ = ((Character)childValue).charValue();
            return Character.valueOf(this.flip(childValue_));
        }
        if ((state & 0x10) != 0 && childValue instanceof Integer) {
            int childValue_ = (Integer)childValue;
            return this.flip(childValue_);
        }
        if ((state & 0x20) != 0 && childValue instanceof Long) {
            long childValue_ = (Long)childValue;
            return this.flip(childValue_);
        }
        if ((state & 0x40) != 0 && DebugExprNotNodeGen.fallbackGuard_(state, childValue)) {
            return this.typeError(childValue);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(childValue);
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state = this.state_;
        if ((state & 0x7E) == 0 && state != 0) {
            return this.executeGeneric_boolean0(frameValue, state);
        }
        if ((state & 0x7D) == 0 && state != 0) {
            return this.executeGeneric_byte1(frameValue, state);
        }
        if ((state & 0x7B) == 0 && state != 0) {
            return this.executeGeneric_short2(frameValue, state);
        }
        if ((state & 0x6F) == 0 && state != 0) {
            return this.executeGeneric_int3(frameValue, state);
        }
        if ((state & 0x5F) == 0 && state != 0) {
            return this.executeGeneric_long4(frameValue, state);
        }
        return this.executeGeneric_generic5(frameValue, state);
    }

    private Object executeGeneric_boolean0(VirtualFrame frameValue, int state) {
        boolean childValue_;
        try {
            childValue_ = this.child_.executeI1(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state & 1) != 0);
        return this.flip(childValue_);
    }

    private Object executeGeneric_byte1(VirtualFrame frameValue, int state) {
        byte childValue_;
        try {
            childValue_ = this.child_.executeI8(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state & 2) != 0);
        return this.flip(childValue_);
    }

    private Object executeGeneric_short2(VirtualFrame frameValue, int state) {
        short childValue_;
        try {
            childValue_ = this.child_.executeI16(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state & 4) != 0);
        return this.flip(childValue_);
    }

    private Object executeGeneric_int3(VirtualFrame frameValue, int state) {
        int childValue_;
        try {
            childValue_ = this.child_.executeI32(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state & 0x10) != 0);
        return this.flip(childValue_);
    }

    private Object executeGeneric_long4(VirtualFrame frameValue, int state) {
        long childValue_;
        try {
            childValue_ = this.child_.executeI64(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state & 0x20) != 0);
        return this.flip(childValue_);
    }

    private Object executeGeneric_generic5(VirtualFrame frameValue, int state) {
        Object childValue_ = this.child_.executeGeneric(frameValue);
        if ((state & 1) != 0 && childValue_ instanceof Boolean) {
            boolean childValue__ = (Boolean)childValue_;
            return this.flip(childValue__);
        }
        if ((state & 2) != 0 && childValue_ instanceof Byte) {
            byte childValue__ = (Byte)childValue_;
            return this.flip(childValue__);
        }
        if ((state & 4) != 0 && childValue_ instanceof Short) {
            short childValue__ = (Short)childValue_;
            return this.flip(childValue__);
        }
        if ((state & 8) != 0 && childValue_ instanceof Character) {
            char childValue__ = ((Character)childValue_).charValue();
            return Character.valueOf(this.flip(childValue__));
        }
        if ((state & 0x10) != 0 && childValue_ instanceof Integer) {
            int childValue__ = (Integer)childValue_;
            return this.flip(childValue__);
        }
        if ((state & 0x20) != 0 && childValue_ instanceof Long) {
            long childValue__ = (Long)childValue_;
            return this.flip(childValue__);
        }
        if ((state & 0x40) != 0 && DebugExprNotNodeGen.fallbackGuard_(state, childValue_)) {
            return this.typeError(childValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(childValue_);
    }

    @Override
    public boolean executeI1(VirtualFrame frameValue) throws UnexpectedResultException {
        boolean childValue_;
        int state = this.state_;
        if ((state & 0x40) != 0) {
            return LLVMTypesGen.expectBoolean(this.executeGeneric(frameValue));
        }
        try {
            childValue_ = this.child_.executeI1(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return LLVMTypesGen.expectBoolean(this.executeAndSpecialize(ex.getResult()));
        }
        if ((state & 1) != 0) {
            return this.flip(childValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return LLVMTypesGen.expectBoolean(this.executeAndSpecialize(childValue_));
    }

    @Override
    public byte executeI8(VirtualFrame frameValue) throws UnexpectedResultException {
        byte childValue_;
        int state = this.state_;
        if ((state & 0x40) != 0) {
            return LLVMTypesGen.expectByte(this.executeGeneric(frameValue));
        }
        try {
            childValue_ = this.child_.executeI8(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return LLVMTypesGen.expectByte(this.executeAndSpecialize(ex.getResult()));
        }
        if ((state & 2) != 0) {
            return this.flip(childValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return LLVMTypesGen.expectByte(this.executeAndSpecialize(childValue_));
    }

    @Override
    public int executeI32(VirtualFrame frameValue) throws UnexpectedResultException {
        int childValue_;
        int state = this.state_;
        if ((state & 0x40) != 0) {
            return LLVMTypesGen.expectInteger(this.executeGeneric(frameValue));
        }
        try {
            childValue_ = this.child_.executeI32(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return LLVMTypesGen.expectInteger(this.executeAndSpecialize(ex.getResult()));
        }
        if ((state & 0x10) != 0) {
            return this.flip(childValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return LLVMTypesGen.expectInteger(this.executeAndSpecialize(childValue_));
    }

    @Override
    public long executeI64(VirtualFrame frameValue) throws UnexpectedResultException {
        long childValue_;
        int state = this.state_;
        if ((state & 0x40) != 0) {
            return LLVMTypesGen.expectLong(this.executeGeneric(frameValue));
        }
        try {
            childValue_ = this.child_.executeI64(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult()));
        }
        if ((state & 0x20) != 0) {
            return this.flip(childValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return LLVMTypesGen.expectLong(this.executeAndSpecialize(childValue_));
    }

    @Override
    public short executeI16(VirtualFrame frameValue) throws UnexpectedResultException {
        short childValue_;
        int state = this.state_;
        if ((state & 0x40) != 0) {
            return LLVMTypesGen.expectShort(this.executeGeneric(frameValue));
        }
        try {
            childValue_ = this.child_.executeI16(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return LLVMTypesGen.expectShort(this.executeAndSpecialize(ex.getResult()));
        }
        if ((state & 4) != 0) {
            return this.flip(childValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return LLVMTypesGen.expectShort(this.executeAndSpecialize(childValue_));
    }

    private Object executeAndSpecialize(Object childValue) {
        int state = this.state_;
        if (childValue instanceof Boolean) {
            boolean childValue_ = (Boolean)childValue;
            this.state_ = state |= 1;
            return this.flip(childValue_);
        }
        if (childValue instanceof Byte) {
            byte childValue_ = (Byte)childValue;
            this.state_ = state |= 2;
            return this.flip(childValue_);
        }
        if (childValue instanceof Short) {
            short childValue_ = (Short)childValue;
            this.state_ = state |= 4;
            return this.flip(childValue_);
        }
        if (childValue instanceof Character) {
            char childValue_ = ((Character)childValue).charValue();
            this.state_ = state |= 8;
            return Character.valueOf(this.flip(childValue_));
        }
        if (childValue instanceof Integer) {
            int childValue_ = (Integer)childValue;
            this.state_ = state |= 0x10;
            return this.flip(childValue_);
        }
        if (childValue instanceof Long) {
            long childValue_ = (Long)childValue;
            this.state_ = state |= 0x20;
            return this.flip(childValue_);
        }
        this.state_ = state |= 0x40;
        return this.typeError(childValue);
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    private static boolean fallbackGuard_(int state, Object childValue) {
        if ((state & 1) == 0 && childValue instanceof Boolean) {
            return false;
        }
        if ((state & 2) == 0 && childValue instanceof Byte) {
            return false;
        }
        if ((state & 4) == 0 && childValue instanceof Short) {
            return false;
        }
        if ((state & 8) == 0 && childValue instanceof Character) {
            return false;
        }
        if ((state & 0x10) == 0 && childValue instanceof Integer) {
            return false;
        }
        return (state & 0x20) != 0 || !(childValue instanceof Long);
    }

    public static DebugExprNotNode create(LLVMExpressionNode child) {
        return new DebugExprNotNodeGen(child);
    }
}

