/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExecutableNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.debug.LLVMDebuggerValue;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.parser.DebugExprException;
import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;

public class DebugExprExecutableNode
extends ExecutableNode {
    @Node.Child
    LLVMExpressionNode root;

    public DebugExprExecutableNode(LLVMExpressionNode root) {
        super((TruffleLanguage)LLVMLanguage.getLanguage());
        this.root = root;
    }

    @CompilerDirectives.TruffleBoundary
    private static String valueOf(Object objectToDisplay) {
        return String.valueOf(objectToDisplay);
    }

    public Object execute(VirtualFrame frame) {
        try {
            Object objectToDisplay = this.root.executeGeneric(frame);
            if (objectToDisplay instanceof LLVMDebuggerValue) {
                return objectToDisplay;
            }
            return DebugExprExecutableNode.valueOf(objectToDisplay);
        }
        catch (DebugExprException | LLVMParserException e) {
            return e.getMessage();
        }
    }
}

