/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.SulongLibrary;
import com.oracle.truffle.llvm.runtime.SulongLibraryFactory;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=SulongLibrary.class)
final class SulongLibraryGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    private SulongLibraryGen() {
    }

    static {
        LibraryExport.register(SulongLibrary.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports()});
    }

    @GeneratedBy(value=SulongLibrary.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, SulongLibrary.class, false);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof SulongLibrary);
            Uncached uncached = new Uncached();
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof SulongLibrary);
            return new Cached();
        }

        @GeneratedBy(value=SulongLibrary.class)
        private static final class Uncached
        extends InteropLibrary {
            Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof SulongLibrary) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof SulongLibrary;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public Object execute(Object arg0Value_, Object ... arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                SulongLibrary arg0Value = (SulongLibrary)arg0Value_;
                return SulongLibrary.Execute.doGeneric(arg0Value, arg1Value, IndirectCallNode.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public Object readMember(Object arg0Value_, String arg1Value) throws UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                SulongLibrary arg0Value = (SulongLibrary)arg0Value_;
                return arg0Value.readMember(arg1Value, SulongLibraryFactory.LookupNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public Object invokeMember(Object arg0Value_, String arg1Value, Object ... arg2Value) throws ArityException, UnknownIdentifierException, UnsupportedTypeException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                SulongLibrary arg0Value = (SulongLibrary)arg0Value_;
                return arg0Value.invokeMember(arg1Value, arg2Value, SulongLibraryFactory.LookupNodeGen.getUncached(), (InteropLibrary)INTEROP_LIBRARY_.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasMembers(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((SulongLibrary)receiver).hasMembers();
            }

            @CompilerDirectives.TruffleBoundary
            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((SulongLibrary)receiver).getMembers(includeInternal);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                SulongLibrary arg0Value = (SulongLibrary)arg0Value_;
                return arg0Value.memberExists(arg1Value, SulongLibraryFactory.LookupNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberInvocable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                SulongLibrary arg0Value = (SulongLibrary)arg0Value_;
                return arg0Value.memberExists(arg1Value, SulongLibraryFactory.LookupNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isExecutable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((SulongLibrary)receiver).isExecutable();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasLanguage(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((SulongLibrary)receiver).hasLanguage();
            }

            @CompilerDirectives.TruffleBoundary
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((SulongLibrary)receiver).getLanguage();
            }

            @CompilerDirectives.TruffleBoundary
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((SulongLibrary)receiver).toDisplayString(allowSideEffects);
            }
        }

        @GeneratedBy(value=SulongLibrary.class)
        private static final class Cached
        extends InteropLibrary {
            @CompilerDirectives.CompilationFinal
            private volatile int state_;
            @CompilerDirectives.CompilationFinal
            private volatile int exclude_;
            @Node.Child
            private SulongLibrary.LookupNode lookup;
            @Node.Child
            private ExecuteCachedData execute_cached_cache;
            @Node.Child
            private IndirectCallNode execute_generic_call_;
            @Node.Child
            private InteropLibrary invokeMemberNode__interop_;

            Cached() {
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof SulongLibrary) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof SulongLibrary;
            }

            @ExplodeLoop
            public Object execute(Object arg0Value_, Object ... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                SulongLibrary arg0Value = (SulongLibrary)arg0Value_;
                int state = this.state_;
                if ((state & 3) != 0) {
                    if ((state & 1) != 0) {
                        ExecuteCachedData s1_ = this.execute_cached_cache;
                        while (s1_ != null) {
                            if (arg0Value == s1_.cachedLibrary_) {
                                return SulongLibrary.Execute.doCached(arg0Value, arg1Value, s1_.cachedLibrary_, s1_.call_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state & 2) != 0) {
                        return SulongLibrary.Execute.doGeneric(arg0Value, arg1Value, this.execute_generic_call_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object executeAndSpecialize(SulongLibrary arg0Value, Object[] arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                int exclude = this.exclude_;
                try {
                    if (exclude == 0) {
                        int count1_ = 0;
                        ExecuteCachedData s1_ = this.execute_cached_cache;
                        if ((state & 1) != 0) {
                            while (s1_ != null && arg0Value != s1_.cachedLibrary_) {
                                s1_ = s1_.next_;
                                ++count1_;
                            }
                        }
                        if (s1_ == null && count1_ < 3) {
                            s1_ = (ExecuteCachedData)super.insert((Node)new ExecuteCachedData(this.execute_cached_cache));
                            s1_.cachedLibrary_ = arg0Value;
                            s1_.call_ = s1_.insertAccessor(SulongLibrary.Execute.createMainCall(s1_.cachedLibrary_));
                            this.execute_cached_cache = s1_;
                            this.state_ = state |= 1;
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            Object object = SulongLibrary.Execute.doCached(arg0Value, arg1Value, s1_.cachedLibrary_, s1_.call_);
                            return object;
                        }
                    }
                    this.execute_generic_call_ = (IndirectCallNode)super.insert((Node)IndirectCallNode.create());
                    this.exclude_ = exclude |= 1;
                    this.execute_cached_cache = null;
                    state &= 0xFFFFFFFE;
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    Object object = SulongLibrary.Execute.doGeneric(arg0Value, arg1Value, this.execute_generic_call_);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                ExecuteCachedData s1_;
                int state = this.state_;
                if ((state & 3) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state & 3 & (state & 3) - 1) == 0 && ((s1_ = this.execute_cached_cache) == null || s1_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                SulongLibrary arg0Value = (SulongLibrary)arg0Value_;
                int state = this.state_;
                if ((state & 4) != 0) {
                    return arg0Value.readMember(arg1Value, this.lookup);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readMemberNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object readMemberNode_AndSpecialize(SulongLibrary arg0Value, String arg1Value) throws UnknownIdentifierException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.lookup == null) {
                        this.lookup = (SulongLibrary.LookupNode)super.insert((Node)SulongLibraryFactory.LookupNodeGen.create());
                    }
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    Object object = arg0Value.readMember(arg1Value, this.lookup);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public Object invokeMember(Object arg0Value_, String arg1Value, Object ... arg2Value) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                SulongLibrary arg0Value = (SulongLibrary)arg0Value_;
                int state = this.state_;
                if ((state & 8) != 0) {
                    return arg0Value.invokeMember(arg1Value, arg2Value, this.lookup, this.invokeMemberNode__interop_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.invokeMemberNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object invokeMemberNode_AndSpecialize(SulongLibrary arg0Value, String arg1Value, Object[] arg2Value) throws ArityException, UnknownIdentifierException, UnsupportedTypeException, UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.lookup == null) {
                        this.lookup = (SulongLibrary.LookupNode)super.insert((Node)SulongLibraryFactory.LookupNodeGen.create());
                    }
                    this.invokeMemberNode__interop_ = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.createDispatched(1));
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    Object object = arg0Value.invokeMember(arg1Value, arg2Value, this.lookup, this.invokeMemberNode__interop_);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean hasMembers(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((SulongLibrary)receiver).hasMembers();
            }

            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((SulongLibrary)receiver).getMembers(includeInternal);
            }

            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                SulongLibrary arg0Value = (SulongLibrary)arg0Value_;
                int state = this.state_;
                if ((state & 0x10) != 0) {
                    return arg0Value.memberExists(arg1Value, this.lookup);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.memberExistsNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean memberExistsNode_AndSpecialize(SulongLibrary arg0Value, String arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    if (this.lookup == null) {
                        this.lookup = (SulongLibrary.LookupNode)super.insert((Node)SulongLibraryFactory.LookupNodeGen.create());
                    }
                    this.state_ = state |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = arg0Value.memberExists(arg1Value, this.lookup);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isMemberInvocable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                SulongLibrary arg0Value = (SulongLibrary)arg0Value_;
                int state = this.state_;
                if ((state & 0x10) != 0) {
                    return arg0Value.memberExists(arg1Value, this.lookup);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.memberExistsNode_AndSpecialize(arg0Value, arg1Value);
            }

            public boolean isExecutable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((SulongLibrary)receiver).isExecutable();
            }

            public boolean hasLanguage(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((SulongLibrary)receiver).hasLanguage();
            }

            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((SulongLibrary)receiver).getLanguage();
            }

            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((SulongLibrary)receiver).toDisplayString(allowSideEffects);
            }

            @GeneratedBy(value=SulongLibrary.class)
            private static final class ExecuteCachedData
            extends Node {
                @Node.Child
                ExecuteCachedData next_;
                @CompilerDirectives.CompilationFinal
                SulongLibrary cachedLibrary_;
                @Node.Child
                DirectCallNode call_;

                ExecuteCachedData(ExecuteCachedData next_) {
                    this.next_ = next_;
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return (T)super.insert(node);
                }
            }
        }
    }
}

