/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.llvm.runtime.ContextExtension;
import com.oracle.truffle.llvm.runtime.ExternalLibrary;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LibraryLocator;
import com.oracle.truffle.llvm.runtime.except.LLVMLinkerException;
import com.oracle.truffle.llvm.runtime.interop.nfi.LLVMNativeWrapper;
import com.oracle.truffle.llvm.runtime.types.FunctionType;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.types.VoidType;
import java.nio.file.Path;
import java.util.List;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;

public final class NFIContextExtension
implements ContextExtension {
    private static final InteropLibrary INTEROP = (InteropLibrary)InteropLibrary.getFactory().getUncached();
    @CompilerDirectives.CompilationFinal
    private TruffleObject defaultLibraryHandle;
    private boolean internalLibrariesAdded = false;
    private final ExternalLibrary defaultLibrary;
    private final EconomicMap<ExternalLibrary, TruffleObject> libraryHandles = EconomicMap.create();
    private final TruffleLanguage.Env env;

    public NFIContextExtension(TruffleLanguage.Env env) {
        this.env = env;
        this.defaultLibrary = ExternalLibrary.externalFromName("NativeDefault", true);
    }

    @Override
    public void initialize() {
        assert (!this.isInitialized());
        this.defaultLibraryHandle = this.loadDefaultLibrary();
    }

    public boolean isInitialized() {
        return this.defaultLibraryHandle != null;
    }

    public NativePointerIntoLibrary getNativeHandle(LLVMContext context, String name) {
        CompilerAsserts.neverPartOfCompilation();
        try {
            NativeLookupResult result = this.getNativeDataObjectOrNull(context, name);
            if (result != null) {
                long pointer = INTEROP.asPointer((Object)result.getObject());
                return new NativePointerIntoLibrary(result.getLibrary(), pointer);
            }
            return null;
        }
        catch (UnsupportedMessageException e) {
            throw new IllegalStateException(e);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public TruffleObject createNativeWrapper(LLVMFunctionDescriptor descriptor) {
        TruffleObject wrapper = null;
        try {
            String signature = this.getNativeSignature(descriptor.getLLVMFunction().getType(), 0);
            TruffleObject createNativeWrapper = this.getNativeFunction(descriptor.getContext(), "createNativeWrapper", String.format("(env, %s):object", signature));
            try {
                wrapper = (TruffleObject)INTEROP.execute((Object)createNativeWrapper, new Object[]{new LLVMNativeWrapper(descriptor)});
            }
            catch (InteropException ex) {
                throw new AssertionError((Object)ex);
            }
        }
        catch (UnsupportedNativeTypeException unsupportedNativeTypeException) {
            // empty catch block
        }
        return wrapper;
    }

    private void addLibraries(LLVMContext context) {
        CompilerAsserts.neverPartOfCompilation();
        if (!this.internalLibrariesAdded) {
            context.addInternalLibrary("libsulong-native." + NFIContextExtension.getNativeLibrarySuffix(), "<default nfi library>");
            this.internalLibrariesAdded = true;
        }
        List<ExternalLibrary> libraries = context.getExternalLibraries(lib -> lib.isNative());
        for (ExternalLibrary l : libraries) {
            this.addLibrary(l, context);
        }
    }

    private void addLibrary(ExternalLibrary lib, LLVMContext context) throws UnsatisfiedLinkError {
        CompilerAsserts.neverPartOfCompilation();
        if (!this.libraryHandles.containsKey((Object)lib) && !NFIContextExtension.handleSpecialLibraries(lib)) {
            try {
                this.libraryHandles.put((Object)lib, (Object)this.loadLibrary(lib, context));
            }
            catch (UnsatisfiedLinkError e) {
                System.err.println(lib.toString() + " not found!\n" + e.getMessage());
                throw e;
            }
        }
    }

    public static String getNativeLibrarySuffix() {
        if (System.getProperty("os.name").toLowerCase().contains("mac")) {
            return "dylib";
        }
        return "so";
    }

    private static boolean handleSpecialLibraries(ExternalLibrary lib) {
        Path fileNamePath = lib.getPath().getFileName();
        if (fileNamePath == null) {
            throw new IllegalArgumentException("Filename path of " + lib.getPath() + " is null");
        }
        String fileName = fileNamePath.toString().trim();
        return fileName.startsWith("libc.") || fileName.startsWith("libSystem.");
    }

    private TruffleObject loadLibrary(ExternalLibrary lib, LLVMContext context) {
        CompilerAsserts.neverPartOfCompilation();
        String libName = lib.getPath().toString();
        return this.loadLibrary(libName, false, null, context, lib);
    }

    private TruffleObject loadLibrary(String libName, boolean optional, String flags, LLVMContext context, Object file) {
        LibraryLocator.traceLoadNative(context, file);
        String loadExpression = flags == null ? String.format("load \"%s\"", libName) : String.format("load(%s) \"%s\"", flags, libName);
        Source source = Source.newBuilder((String)"nfi", (CharSequence)loadExpression, (String)("(load " + libName + ")")).internal(true).build();
        try {
            return (TruffleObject)this.env.parseInternal(source, new String[0]).call(new Object[0]);
        }
        catch (UnsatisfiedLinkError ex) {
            if (optional) {
                return null;
            }
            throw ex;
        }
    }

    private TruffleObject loadDefaultLibrary() {
        CompilerAsserts.neverPartOfCompilation();
        Source source = Source.newBuilder((String)"nfi", (CharSequence)"default", (String)"default").internal(true).build();
        try {
            return (TruffleObject)this.env.parseInternal(source, new String[0]).call(new Object[0]);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private static TruffleObject getNativeFunctionOrNull(TruffleObject library, String name) {
        CompilerAsserts.neverPartOfCompilation();
        if (!INTEROP.isMemberReadable((Object)library, name)) {
            return null;
        }
        try {
            return (TruffleObject)INTEROP.readMember((Object)library, name);
        }
        catch (UnknownIdentifierException ex) {
            return null;
        }
        catch (InteropException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private String getNativeType(Type type) throws UnsupportedNativeTypeException {
        if (type instanceof FunctionType) {
            return this.getNativeSignature((FunctionType)type, 0);
        }
        if (type instanceof PointerType && ((PointerType)type).getPointeeType() instanceof FunctionType) {
            FunctionType functionType = (FunctionType)((PointerType)type).getPointeeType();
            return this.getNativeSignature(functionType, 0);
        }
        if (type instanceof PointerType) {
            return "POINTER";
        }
        if (type instanceof PrimitiveType) {
            PrimitiveType primitiveType = (PrimitiveType)type;
            PrimitiveType.PrimitiveKind kind = primitiveType.getPrimitiveKind();
            switch (kind) {
                case I1: 
                case I8: {
                    return "SINT8";
                }
                case I16: {
                    return "SINT16";
                }
                case I32: {
                    return "SINT32";
                }
                case I64: {
                    return "SINT64";
                }
                case FLOAT: {
                    return "FLOAT";
                }
                case DOUBLE: {
                    return "DOUBLE";
                }
            }
            throw new UnsupportedNativeTypeException(primitiveType);
        }
        if (type instanceof VoidType) {
            return "VOID";
        }
        throw new UnsupportedNativeTypeException(type);
    }

    private String[] getNativeArgumentTypes(FunctionType functionType, int skipArguments) throws UnsupportedNativeTypeException {
        String[] types = new String[functionType.getNumberOfArguments() - skipArguments];
        for (int i = skipArguments; i < functionType.getNumberOfArguments(); ++i) {
            types[i - skipArguments] = this.getNativeType(functionType.getArgumentType(i));
        }
        return types;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NativeLookupResult getNativeFunctionOrNull(LLVMContext context, String name) {
        CompilerAsserts.neverPartOfCompilation();
        EconomicMap<ExternalLibrary, TruffleObject> economicMap = this.libraryHandles;
        synchronized (economicMap) {
            TruffleObject symbol;
            this.addLibraries(context);
            MapCursor cursor = this.libraryHandles.getEntries();
            while (cursor.advance()) {
                symbol = NFIContextExtension.getNativeFunctionOrNull((TruffleObject)cursor.getValue(), name);
                if (symbol == null) continue;
                return new NativeLookupResult((ExternalLibrary)cursor.getKey(), symbol);
            }
            symbol = NFIContextExtension.getNativeFunctionOrNull(this.defaultLibraryHandle, name);
            if (symbol != null) {
                assert (this.isInitialized());
                return new NativeLookupResult(this.defaultLibrary, symbol);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NativeLookupResult getNativeDataObjectOrNull(LLVMContext context, String name) {
        CompilerAsserts.neverPartOfCompilation();
        EconomicMap<ExternalLibrary, TruffleObject> economicMap = this.libraryHandles;
        synchronized (economicMap) {
            TruffleObject symbol;
            this.addLibraries(context);
            MapCursor cursor = this.libraryHandles.getEntries();
            while (cursor.advance()) {
                symbol = NFIContextExtension.getNativeDataObjectOrNull((TruffleObject)cursor.getValue(), name);
                if (symbol == null) continue;
                return new NativeLookupResult((ExternalLibrary)cursor.getKey(), symbol);
            }
            symbol = NFIContextExtension.getNativeDataObjectOrNull(this.defaultLibraryHandle, name);
            if (symbol != null) {
                assert (this.isInitialized());
                return new NativeLookupResult(this.defaultLibrary, symbol);
            }
            return null;
        }
    }

    private static TruffleObject getNativeDataObjectOrNull(TruffleObject libraryHandle, String name) {
        try {
            TruffleObject symbol = (TruffleObject)INTEROP.readMember((Object)libraryHandle, name);
            if (symbol != null && 0L != INTEROP.asPointer((Object)symbol)) {
                return symbol;
            }
            return null;
        }
        catch (UnknownIdentifierException ex) {
            return null;
        }
        catch (InteropException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static TruffleObject bindNativeFunction(TruffleObject symbol, String signature) {
        CompilerAsserts.neverPartOfCompilation();
        try {
            return (TruffleObject)INTEROP.invokeMember((Object)symbol, "bind", new Object[]{signature});
        }
        catch (InteropException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public TruffleObject getNativeFunction(LLVMContext context, String name, String signature) {
        CompilerAsserts.neverPartOfCompilation();
        NativeLookupResult result = this.getNativeFunctionOrNull(context, name);
        if (result != null) {
            return NFIContextExtension.bindNativeFunction(result.getObject(), signature);
        }
        throw new LLVMLinkerException(String.format("External function %s cannot be found.", name));
    }

    public String getNativeSignature(FunctionType type, int skipArguments) throws UnsupportedNativeTypeException {
        CompilerAsserts.neverPartOfCompilation();
        CompilerAsserts.neverPartOfCompilation();
        String nativeRet = this.getNativeType(type.getReturnType());
        String[] argTypes = this.getNativeArgumentTypes(type, skipArguments);
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (String a : argTypes) {
            sb.append(a);
            sb.append(",");
        }
        if (argTypes.length > 0) {
            sb.setCharAt(sb.length() - 1, ')');
        } else {
            sb.append(')');
        }
        sb.append(":");
        sb.append(nativeRet);
        return sb.toString();
    }

    public static final class NativePointerIntoLibrary {
        private final ExternalLibrary library;
        private final long address;

        public NativePointerIntoLibrary(ExternalLibrary library, long address) {
            this.library = library;
            this.address = address;
        }

        public ExternalLibrary getLibrary() {
            return this.library;
        }

        public long getAddress() {
            return this.address;
        }
    }

    public static final class NativeLookupResult {
        private final ExternalLibrary library;
        private final TruffleObject object;

        public NativeLookupResult(ExternalLibrary library, TruffleObject object) {
            this.library = library;
            this.object = object;
        }

        public ExternalLibrary getLibrary() {
            return this.library;
        }

        public TruffleObject getObject() {
            return this.object;
        }
    }

    public static class UnsupportedNativeTypeException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final Type type;

        UnsupportedNativeTypeException(Type type) {
            super("unsupported type " + type + " in native interop");
            this.type = type;
        }

        public Type getType() {
            return this.type;
        }
    }
}

