/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.llvm.runtime.ExternalLibrary;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.except.LLVMIllegalSymbolIndexException;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;

public abstract class LLVMSymbol {
    @CompilerDirectives.CompilationFinal
    private String name;
    @CompilerDirectives.CompilationFinal
    private ExternalLibrary library;
    private final int moduleId;
    private final int symbolIndex;
    private final boolean exported;
    static final LLVMSymbol[] EMPTY = new LLVMSymbol[0];
    public static final int INVALID_INDEX = -1;
    public static final int INVALID_ID = -1;
    public static final int MISCFUNCTION_ID = 0;
    private static int miscFunctionIndex = 0;

    public LLVMSymbol(String name, ExternalLibrary library, int bitcodeID, int symbolIndex, boolean exported) {
        this.name = name;
        this.library = library;
        this.moduleId = bitcodeID;
        this.symbolIndex = symbolIndex;
        this.exported = exported;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ExternalLibrary getLibrary() {
        return this.library;
    }

    public void setLibrary(ExternalLibrary library) {
        this.library = library;
    }

    public static int getMiscSymbolIndex() {
        int index = miscFunctionIndex++;
        return index;
    }

    public String getKind() {
        return this.getClass().getSimpleName();
    }

    public boolean isExported() {
        return this.exported;
    }

    public int getSymbolIndex(boolean illegalOK) {
        if (this.symbolIndex >= 0 || illegalOK) {
            return this.symbolIndex;
        }
        CompilerDirectives.transferToInterpreter();
        throw new LLVMIllegalSymbolIndexException("Invalid function index: " + this.symbolIndex);
    }

    public int getBitcodeID(boolean illegalOK) {
        if (this.moduleId >= 0 || illegalOK) {
            return this.moduleId;
        }
        CompilerDirectives.transferToInterpreter();
        throw new LLVMIllegalSymbolIndexException("Invalid function ID: " + this.moduleId);
    }

    public boolean hasValidIndexAndID() {
        return this.symbolIndex >= 0 && this.moduleId >= 0;
    }

    public abstract boolean isDefined();

    public abstract boolean isGlobalVariable();

    public abstract boolean isFunction();

    public abstract boolean isAlias();

    public abstract LLVMFunction asFunction();

    public abstract LLVMGlobal asGlobalVariable();
}

