/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.LLVMGetStackNode;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.memory.LLVMThreadingStack;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMGetStackNode.class)
public final class LLVMGetStackNodeGen
extends LLVMGetStackNode {
    private static final Uncached UNCACHED = new Uncached();
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @CompilerDirectives.CompilationFinal
    private CachedData cached_cache;

    private LLVMGetStackNodeGen() {
    }

    @Override
    @ExplodeLoop
    public LLVMStack executeWithTarget(LLVMThreadingStack arg0Value, Thread arg1Value) {
        int state = this.state_;
        if (state != 0) {
            if ((state & 1) != 0) {
                CachedData s1_ = this.cached_cache;
                while (s1_ != null) {
                    if (arg1Value == s1_.cachedThread_) {
                        return this.cached(arg0Value, arg1Value, s1_.cachedThread_, s1_.cachedStack_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state & 2) != 0) {
                return LLVMGetStackNode.generic(arg0Value, arg1Value);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LLVMStack executeAndSpecialize(LLVMThreadingStack arg0Value, Thread arg1Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            if (exclude == 0) {
                int count1_ = 0;
                CachedData s1_ = this.cached_cache;
                if ((state & 1) != 0) {
                    while (s1_ != null && arg1Value != s1_.cachedThread_) {
                        s1_ = s1_.next_;
                        ++count1_;
                    }
                }
                if (s1_ == null && count1_ < 3) {
                    s1_ = new CachedData(this.cached_cache);
                    s1_.cachedThread_ = arg1Value;
                    s1_.cachedStack_ = this.getStack(arg0Value, s1_.cachedThread_);
                    this.cached_cache = s1_;
                    this.state_ = state |= 1;
                }
                if (s1_ != null) {
                    lock.unlock();
                    hasLock = false;
                    LLVMStack lLVMStack = this.cached(arg0Value, arg1Value, s1_.cachedThread_, s1_.cachedStack_);
                    return lLVMStack;
                }
            }
            this.exclude_ = exclude |= 1;
            this.cached_cache = null;
            state &= 0xFFFFFFFE;
            this.state_ = state |= 2;
            lock.unlock();
            hasLock = false;
            LLVMStack lLVMStack = LLVMGetStackNode.generic(arg0Value, arg1Value);
            return lLVMStack;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        CachedData s1_;
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0 && ((s1_ = this.cached_cache) == null || s1_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static LLVMGetStackNode create() {
        return new LLVMGetStackNodeGen();
    }

    public static LLVMGetStackNode getUncached() {
        return UNCACHED;
    }

    @GeneratedBy(value=LLVMGetStackNode.class)
    private static final class Uncached
    extends LLVMGetStackNode {
        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public LLVMStack executeWithTarget(LLVMThreadingStack arg0Value, Thread arg1Value) {
            return LLVMGetStackNode.generic(arg0Value, arg1Value);
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    @GeneratedBy(value=LLVMGetStackNode.class)
    private static final class CachedData {
        @CompilerDirectives.CompilationFinal
        CachedData next_;
        @CompilerDirectives.CompilationFinal
        Thread cachedThread_;
        @CompilerDirectives.CompilationFinal
        LLVMStack cachedStack_;

        CachedData(CachedData next_) {
            this.next_ = next_;
        }
    }
}

