/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMFunctionCode;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceFunctionType;
import com.oracle.truffle.llvm.runtime.interop.LLVMForeignCallNode;
import com.oracle.truffle.llvm.runtime.interop.LLVMInternalTruffleObject;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.memory.LLVMNativeMemory;

@ExportLibrary(value=InteropLibrary.class)
public final class LLVMFunctionDescriptor
extends LLVMInternalTruffleObject
implements Comparable<LLVMFunctionDescriptor> {
    private static final long SULONG_FUNCTION_POINTER_TAG = -4981268375154982912L;
    private final LLVMContext context;
    private final LLVMFunction llvmFunction;
    private final LLVMFunctionCode functionCode;
    @CompilerDirectives.CompilationFinal
    private TruffleObject nativeWrapper;
    @CompilerDirectives.CompilationFinal
    private long nativePointer;
    private CallTarget foreignCallTarget;
    static final /* synthetic */ boolean $assertionsDisabled;

    CallTarget getForeignCallTarget() {
        if (this.foreignCallTarget == null) {
            CompilerDirectives.transferToInterpreter();
            LLVMSourceFunctionType sourceType = this.functionCode.getFunction().getSourceType();
            LLVMInteropType interopType = this.context.getInteropType(sourceType);
            LLVMForeignCallNode foreignCall = new LLVMForeignCallNode(this.context.getLanguage(), this, interopType, sourceType);
            this.foreignCallTarget = Truffle.getRuntime().createCallTarget((RootNode)foreignCall);
            if (!$assertionsDisabled && this.foreignCallTarget == null) {
                throw new AssertionError();
            }
        }
        return this.foreignCallTarget;
    }

    private static long tagSulongFunctionPointer(int id) {
        return (long)id | 0xBADEFACE00000000L;
    }

    public LLVMFunction getLLVMFunction() {
        return this.llvmFunction;
    }

    public LLVMFunctionCode getFunctionCode() {
        return this.functionCode;
    }

    public LLVMFunctionDescriptor(LLVMContext context, LLVMFunction llvmFunction) {
        CompilerAsserts.neverPartOfCompilation();
        this.context = context;
        this.functionCode = new LLVMFunctionCode(context, llvmFunction);
        this.llvmFunction = llvmFunction;
    }

    public String toString() {
        return String.format("function@%d '%s'", this.llvmFunction.getSymbolIndex(true), this.llvmFunction.getName());
    }

    @Override
    public int compareTo(LLVMFunctionDescriptor o) {
        int otherIndex = o.llvmFunction.getSymbolIndex(true);
        int otherID = o.llvmFunction.getBitcodeID(true);
        int index = this.llvmFunction.getSymbolIndex(true);
        int id = this.llvmFunction.getBitcodeID(true);
        if (id == otherID) {
            return Long.compare(index, otherIndex);
        }
        throw new IllegalStateException("Comparing functions from different bitcode files.");
    }

    public LLVMContext getContext() {
        return this.context;
    }

    @ExportMessage
    long asPointer() throws UnsupportedMessageException {
        if (this.isPointer()) {
            return this.nativePointer;
        }
        CompilerDirectives.transferToInterpreter();
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    boolean isPointer() {
        return this.nativeWrapper != null;
    }

    @ExportMessage
    LLVMFunctionDescriptor toNative() {
        if (this.nativeWrapper == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.nativeWrapper = this.functionCode.getFunction().createNativeWrapper(this);
            try {
                this.nativePointer = ((InteropLibrary)InteropLibrary.getFactory().getUncached()).asPointer((Object)this.nativeWrapper);
            }
            catch (UnsupportedMessageException ex) {
                this.nativePointer = LLVMFunctionDescriptor.tagSulongFunctionPointer(this.llvmFunction.getSymbolIndex(true));
            }
        }
        return this;
    }

    @ExportMessage
    boolean isExecutable() {
        return true;
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    @ExportMessage
    Object getMembers(boolean includeInternal) {
        return new FunctionMembers();
    }

    @ExportMessage
    boolean isMemberInvocable(String member) {
        return "bind".equals(member);
    }

    @ExportMessage
    Object invokeMember(String member, Object[] args) throws UnknownIdentifierException {
        if ("bind".equals(member)) {
            return this;
        }
        throw UnknownIdentifierException.create((String)member);
    }

    static {
        boolean bl = $assertionsDisabled = !LLVMFunctionDescriptor.class.desiredAssertionStatus();
        if (!$assertionsDisabled && !LLVMNativeMemory.isCommonHandleMemory(-4981268375154982912L)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && LLVMNativeMemory.isDerefHandleMemory(-4981268375154982912L)) {
            throw new AssertionError();
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class FunctionMembers
    implements TruffleObject {
        FunctionMembers() {
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        @ExportMessage
        long getArraySize() {
            return 1L;
        }

        @ExportMessage
        boolean isArrayElementReadable(long index) {
            return index == 0L;
        }

        @ExportMessage
        Object readArrayElement(long index) throws InvalidArrayIndexException {
            if (index == 0L) {
                return "bind";
            }
            throw InvalidArrayIndexException.create((long)index);
        }
    }

    @ExportMessage
    static class Execute {
        Execute() {
        }

        @Specialization(limit="5", guards={"self == cachedSelf"})
        static Object doCached(LLVMFunctionDescriptor self, Object[] args, @Cached(value="self") LLVMFunctionDescriptor cachedSelf, @Cached(value="create(cachedSelf.getForeignCallTarget())") DirectCallNode call) {
            return call.call(args);
        }

        @Specialization(replaces={"doCached"})
        static Object doPolymorphic(LLVMFunctionDescriptor self, Object[] args, @Cached IndirectCallNode call) {
            return call.call(self.getForeignCallTarget(), args);
        }
    }
}

