/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.utilities.AssumedValue;
import com.oracle.truffle.llvm.runtime.ExternalLibrary;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMFunctionCodeFactory;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LLVMIntrinsicProvider;
import com.oracle.truffle.llvm.runtime.NFIContextExtension;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceFunctionType;
import com.oracle.truffle.llvm.runtime.except.LLVMLinkerException;
import com.oracle.truffle.llvm.runtime.memory.LLVMNativeMemory;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.types.FunctionType;
import java.util.HashMap;
import java.util.Map;

public class LLVMFunctionCode {
    private static final long SULONG_FUNCTION_POINTER_TAG = -4981268375154982912L;
    private final AssumedValue<Function> function;
    private final LLVMContext context;
    private final LLVMFunction llvmFunction;
    static final /* synthetic */ boolean $assertionsDisabled;

    public LLVMFunctionCode(LLVMContext context, LLVMFunction llvmFunction) {
        this.context = context;
        this.llvmFunction = llvmFunction;
        this.function = new AssumedValue("LLVMFunctionRuntime.initialFunction", (Object)llvmFunction.getFunction());
    }

    private static long tagSulongFunctionPointer(int id) {
        return (long)id | 0xBADEFACE00000000L;
    }

    public void resolveIfLazyLLVMIRFunction() {
        CompilerAsserts.neverPartOfCompilation();
        if (this.getFunction() instanceof LazyLLVMIRFunction) {
            this.getFunction().resolve(this);
            if (!$assertionsDisabled && !(this.getFunction() instanceof LLVMIRFunction)) {
                throw new AssertionError();
            }
        }
    }

    public boolean isLLVMIRFunction() {
        Function currentFunction = this.getFunction();
        return currentFunction instanceof LLVMIRFunction || currentFunction instanceof LazyLLVMIRFunction;
    }

    public boolean isIntrinsicFunctionSlowPath() {
        CompilerAsserts.neverPartOfCompilation();
        return this.isIntrinsicFunction(LLVMFunctionCodeFactory.ResolveFunctionNodeGen.getUncached());
    }

    public boolean isIntrinsicFunction(ResolveFunctionNode resolve) {
        return resolve.execute(this.getFunction(), this) instanceof IntrinsicFunction;
    }

    public boolean isNativeFunctionSlowPath() {
        CompilerAsserts.neverPartOfCompilation();
        return this.isNativeFunction(LLVMFunctionCodeFactory.ResolveFunctionNodeGen.getUncached());
    }

    public boolean isNativeFunction(ResolveFunctionNode resolve) {
        return resolve.execute(this.getFunction(), this) instanceof NativeFunction;
    }

    public boolean isDefined() {
        return !(this.getFunction() instanceof UnresolvedFunction);
    }

    public void define(LLVMIntrinsicProvider intrinsicProvider, NodeFactory nodeFactory) {
        Intrinsic intrinsification = new Intrinsic(intrinsicProvider, this.llvmFunction.getName(), nodeFactory);
        this.define(intrinsicProvider.getLibrary(), new IntrinsicFunction(intrinsification, this.getFunction().getSourceType()), true);
    }

    public void define(ExternalLibrary lib, Function newFunction) {
        this.define(lib, newFunction, false);
    }

    private void define(ExternalLibrary lib, Function newFunction, boolean allowReplace) {
        if (!($assertionsDisabled || lib != null && newFunction != null)) {
            throw new AssertionError();
        }
        if (this.isDefined() && !allowReplace) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError((Object)("Found multiple definitions of function " + this.llvmFunction.getName() + "."));
        }
        this.llvmFunction.setLibrary(lib);
        this.setFunction(newFunction);
    }

    public RootCallTarget getLLVMIRFunctionSlowPath() {
        CompilerAsserts.neverPartOfCompilation();
        return this.getLLVMIRFunction(LLVMFunctionCodeFactory.ResolveFunctionNodeGen.getUncached());
    }

    public RootCallTarget getLLVMIRFunction(ResolveFunctionNode resolve) {
        Function fn = resolve.execute(this.getFunction(), this);
        return ((LLVMIRFunction)fn).callTarget;
    }

    public Intrinsic getIntrinsicSlowPath() {
        CompilerAsserts.neverPartOfCompilation();
        return this.getIntrinsic(LLVMFunctionCodeFactory.ResolveFunctionNodeGen.getUncached());
    }

    public Intrinsic getIntrinsic(ResolveFunctionNode resolve) {
        Function fn = resolve.execute(this.getFunction(), this);
        return ((IntrinsicFunction)fn).intrinsic;
    }

    public TruffleObject getNativeFunctionSlowPath() {
        CompilerAsserts.neverPartOfCompilation();
        return this.getNativeFunction(LLVMFunctionCodeFactory.ResolveFunctionNodeGen.getUncached());
    }

    public TruffleObject getNativeFunction(ResolveFunctionNode resolve) {
        Function fn = resolve.execute(this.getFunction(), this);
        TruffleObject nativeFunction = ((NativeFunction)fn).nativeFunction;
        if (nativeFunction == null) {
            CompilerDirectives.transferToInterpreter();
            throw new LLVMLinkerException("Native function " + fn.toString() + " not found");
        }
        return nativeFunction;
    }

    private void setFunction(Function newFunction) {
        this.function.set((Object)newFunction);
    }

    public Function getFunction() {
        return (Function)this.function.get();
    }

    public LLVMContext getContext() {
        return this.context;
    }

    public LLVMFunction getLLVMFunction() {
        return this.llvmFunction;
    }

    static {
        boolean bl = $assertionsDisabled = !LLVMFunctionCode.class.desiredAssertionStatus();
        if (!$assertionsDisabled && !LLVMNativeMemory.isCommonHandleMemory(-4981268375154982912L)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && LLVMNativeMemory.isDerefHandleMemory(-4981268375154982912L)) {
            throw new AssertionError();
        }
    }

    public static final class NativeFunction
    extends Function {
        private final TruffleObject nativeFunction;

        public NativeFunction(TruffleObject nativeFunction) {
            this.nativeFunction = nativeFunction;
        }

        @Override
        TruffleObject createNativeWrapper(LLVMFunctionDescriptor descriptor) {
            return this.nativeFunction;
        }
    }

    public static final class IntrinsicFunction
    extends ManagedFunction {
        private final Intrinsic intrinsic;
        private final LLVMSourceFunctionType sourceType;

        public IntrinsicFunction(Intrinsic intrinsic, LLVMSourceFunctionType sourceType) {
            this.intrinsic = intrinsic;
            this.sourceType = sourceType;
        }

        @Override
        LLVMSourceFunctionType getSourceType() {
            return this.sourceType;
        }
    }

    public static final class UnresolvedFunction
    extends Function {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void resolve(LLVMFunctionCode descriptor) {
            LLVMContext context;
            CompilerAsserts.neverPartOfCompilation();
            LLVMContext lLVMContext = context = descriptor.getContext();
            synchronized (lLVMContext) {
                NFIContextExtension.NativeLookupResult nativeFunction;
                if (descriptor.getFunction() != this) {
                    return;
                }
                NFIContextExtension nfiContextExtension = context.getContextExtensionOrNull(NFIContextExtension.class);
                LLVMIntrinsicProvider intrinsicProvider = context.getLanguage().getCapability(LLVMIntrinsicProvider.class);
                assert (!intrinsicProvider.isIntrinsified(descriptor.getLLVMFunction().getName()));
                if (nfiContextExtension != null && (nativeFunction = nfiContextExtension.getNativeFunctionOrNull(context, descriptor.getLLVMFunction().getName())) != null) {
                    descriptor.define(nativeFunction.getLibrary(), new NativeFunction(nativeFunction.getObject()));
                    return;
                }
            }
            throw new LLVMLinkerException(String.format("External function %s cannot be found.", descriptor.getLLVMFunction().getName()));
        }

        @Override
        TruffleObject createNativeWrapper(LLVMFunctionDescriptor descriptor) {
            CompilerAsserts.neverPartOfCompilation();
            this.resolve(descriptor.getFunctionCode());
            return descriptor.getFunctionCode().getFunction().createNativeWrapper(descriptor);
        }
    }

    public static final class LLVMIRFunction
    extends ManagedFunction {
        private final RootCallTarget callTarget;
        private final LLVMSourceFunctionType sourceType;

        public LLVMIRFunction(RootCallTarget callTarget, LLVMSourceFunctionType sourceType) {
            this.callTarget = callTarget;
            this.sourceType = sourceType;
        }

        @Override
        LLVMSourceFunctionType getSourceType() {
            return this.sourceType;
        }
    }

    public static final class LazyLLVMIRFunction
    extends ManagedFunction {
        private final LazyToTruffleConverter converter;

        public LazyLLVMIRFunction(LazyToTruffleConverter converter) {
            this.converter = converter;
        }

        @Override
        void resolve(LLVMFunctionCode descriptor) {
            RootCallTarget callTarget = this.converter.convert();
            LLVMSourceFunctionType sourceType = this.converter.getSourceType();
            descriptor.setFunction(new LLVMIRFunction(callTarget, sourceType));
        }

        @Override
        LLVMSourceFunctionType getSourceType() {
            return this.converter.getSourceType();
        }
    }

    static abstract class ManagedFunction
    extends Function {
        ManagedFunction() {
        }

        @Override
        TruffleObject createNativeWrapper(LLVMFunctionDescriptor descriptor) {
            CompilerAsserts.neverPartOfCompilation();
            TruffleObject wrapper = null;
            LLVMNativePointer pointer = null;
            NFIContextExtension nfiContextExtension = descriptor.getContext().getContextExtensionOrNull(NFIContextExtension.class);
            if (nfiContextExtension != null && (wrapper = nfiContextExtension.createNativeWrapper(descriptor)) != null) {
                try {
                    pointer = LLVMNativePointer.create(((InteropLibrary)InteropLibrary.getFactory().getUncached()).asPointer((Object)wrapper));
                }
                catch (UnsupportedMessageException e) {
                    CompilerDirectives.transferToInterpreter();
                    throw new AssertionError((Object)e);
                }
            }
            if (wrapper == null) {
                pointer = LLVMNativePointer.create(LLVMFunctionCode.tagSulongFunctionPointer(descriptor.getLLVMFunction().getSymbolIndex(false)));
                wrapper = pointer;
            }
            descriptor.getContext().registerFunctionPointer(pointer, descriptor);
            return wrapper;
        }
    }

    @GenerateUncached
    public static abstract class ResolveFunctionNode
    extends LLVMNode {
        abstract Function execute(Function var1, LLVMFunctionCode var2);

        @CompilerDirectives.TruffleBoundary
        @Specialization
        Function doLazyLLVMIRFunction(LazyLLVMIRFunction function, LLVMFunctionCode descriptor) {
            function.resolve(descriptor);
            return descriptor.getFunction();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        Function doUnresolvedFunction(UnresolvedFunction function, LLVMFunctionCode descriptor) {
            function.resolve(descriptor);
            return descriptor.getFunction();
        }

        private static boolean resolveDoesNothing(Function function, LLVMFunctionCode descriptor) {
            function.resolve(descriptor);
            return descriptor.getFunction() == function;
        }

        @Fallback
        Function doOther(Function function, LLVMFunctionCode descriptor) {
            assert (ResolveFunctionNode.resolveDoesNothing(function, descriptor));
            return function;
        }
    }

    public static abstract class Function {
        void resolve(LLVMFunctionCode descriptor) {
            CompilerAsserts.neverPartOfCompilation();
        }

        abstract TruffleObject createNativeWrapper(LLVMFunctionDescriptor var1);

        LLVMSourceFunctionType getSourceType() {
            return null;
        }
    }

    public static interface LazyToTruffleConverter {
        public RootCallTarget convert();

        public LLVMSourceFunctionType getSourceType();
    }

    public static final class Intrinsic {
        private final String intrinsicName;
        private final Map<FunctionType, RootCallTarget> overloadingMap;
        private final LLVMIntrinsicProvider provider;
        private final NodeFactory nodeFactory;

        public Intrinsic(LLVMIntrinsicProvider provider, String name, NodeFactory nodeFactory) {
            this.intrinsicName = name;
            this.overloadingMap = new HashMap<FunctionType, RootCallTarget>();
            this.provider = provider;
            this.nodeFactory = nodeFactory;
        }

        public RootCallTarget cachedCallTarget(FunctionType type) {
            if (this.exists(type)) {
                return this.get(type);
            }
            return this.generateTarget(type);
        }

        @CompilerDirectives.TruffleBoundary
        private boolean exists(FunctionType type) {
            return this.overloadingMap.containsKey(type);
        }

        @CompilerDirectives.TruffleBoundary
        private RootCallTarget get(FunctionType type) {
            return this.overloadingMap.get(type);
        }

        private RootCallTarget generateTarget(FunctionType type) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            RootCallTarget newTarget = this.provider.generateIntrinsicTarget(this.intrinsicName, type.getArgumentTypes(), this.nodeFactory);
            assert (newTarget != null);
            this.overloadingMap.put(type, newTarget);
            return newTarget;
        }
    }
}

