/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.llvm.runtime.ExternalLibrary;
import com.oracle.truffle.llvm.runtime.LLVMFunctionCode;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;
import com.oracle.truffle.llvm.runtime.types.FunctionType;

public final class LLVMFunction
extends LLVMSymbol {
    private final FunctionType type;
    private final LLVMFunctionCode.Function function;
    public static final LLVMFunction[] EMPTY = new LLVMFunction[0];

    public static LLVMFunction create(String name, ExternalLibrary library, LLVMFunctionCode.Function function, FunctionType type, int bitcodeID, int symbolIndex, boolean exported) {
        return new LLVMFunction(name, library, function, type, bitcodeID, symbolIndex, exported);
    }

    public LLVMFunction(String name, ExternalLibrary library, LLVMFunctionCode.Function function, FunctionType type, int bitcodeID, int symbolIndex, boolean exported) {
        super(name, library, bitcodeID, symbolIndex, exported);
        this.type = type;
        this.function = function;
    }

    public FunctionType getType() {
        return this.type;
    }

    public LLVMFunctionCode.Function getFunction() {
        return this.function;
    }

    @Override
    public boolean isDefined() {
        return !(this.getFunction() instanceof LLVMFunctionCode.UnresolvedFunction);
    }

    @Override
    public boolean isFunction() {
        return true;
    }

    @Override
    public boolean isGlobalVariable() {
        return false;
    }

    @Override
    public boolean isAlias() {
        return false;
    }

    @Override
    public LLVMFunction asFunction() {
        return this;
    }

    @Override
    public LLVMGlobal asGlobalVariable() {
        throw new IllegalStateException("Function " + this.getName() + " is not a global variable.");
    }
}

