/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.llvm.runtime.ArithmeticOperation;
import com.oracle.truffle.llvm.runtime.CompareOperator;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.LLVMUnsupportedException;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMDebugGlobalVariable;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceType;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugManagedValue;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugObject;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugObjectBuilder;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugValue;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMSourceTypeFactory;
import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.interop.convert.ToAnyLLVMNodeGen;
import com.oracle.truffle.llvm.runtime.interop.convert.ToDoubleNodeGen;
import com.oracle.truffle.llvm.runtime.interop.convert.ToFloatNodeGen;
import com.oracle.truffle.llvm.runtime.interop.convert.ToI16NodeGen;
import com.oracle.truffle.llvm.runtime.interop.convert.ToI1NodeGen;
import com.oracle.truffle.llvm.runtime.interop.convert.ToI32NodeGen;
import com.oracle.truffle.llvm.runtime.interop.convert.ToI64NodeGen;
import com.oracle.truffle.llvm.runtime.interop.convert.ToI8NodeGen;
import com.oracle.truffle.llvm.runtime.interop.convert.ToPointer;
import com.oracle.truffle.llvm.runtime.interop.convert.ToVoidLLVMNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.cast.LLVMTo80BitFloatingNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.cast.LLVMToAddressNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.cast.LLVMToDoubleNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.cast.LLVMToFloatNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.cast.LLVMToI16NodeGen;
import com.oracle.truffle.llvm.runtime.nodes.cast.LLVMToI1NodeGen;
import com.oracle.truffle.llvm.runtime.nodes.cast.LLVMToI32NodeGen;
import com.oracle.truffle.llvm.runtime.nodes.cast.LLVMToI64NodeGen;
import com.oracle.truffle.llvm.runtime.nodes.cast.LLVMToI8NodeGen;
import com.oracle.truffle.llvm.runtime.nodes.cast.LLVMToVarINodeGen;
import com.oracle.truffle.llvm.runtime.nodes.cast.LLVMToVectorNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.cast.LLVMToVectorZeroExtNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMCallNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug.LLVMDebugSimpleObjectBuilder;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug.LLVMDebugTrapNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug.LLVMToDebugDeclaration;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug.LLVMToDebugValueNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.literals.LLVMSimpleLiteralNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMVectorizedGetElementPtrNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDirectLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDirectLoadNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDoubleLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDoubleLoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMFloatLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMFloatLoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI16LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI16LoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI1LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI1LoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI32LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI32LoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI64LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI64LoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI8LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI8LoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMLoadVectorNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMDoubleStoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMFloatStoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI16StoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI1StoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI32StoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI64StoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI8StoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMPointerStoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMAbstractCompareNode;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMArithmeticNode;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMArithmeticNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMCompareNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMPointerCompareNode;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMVectorArithmeticNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMVectorCompareNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMAccessSymbolNode;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMUnsupportedInstructionNode;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMValueProfilingNode;
import com.oracle.truffle.llvm.runtime.nodes.vars.LLVMReadNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.vars.LLVMReadVectorNodeFactory;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.types.AggregateType;
import com.oracle.truffle.llvm.runtime.types.ArrayType;
import com.oracle.truffle.llvm.runtime.types.FunctionType;
import com.oracle.truffle.llvm.runtime.types.MetaType;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.StructureType;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.types.VariableBitWidthType;
import com.oracle.truffle.llvm.runtime.types.VectorType;
import com.oracle.truffle.llvm.runtime.types.VoidType;
import com.oracle.truffle.llvm.runtime.vector.LLVMVector;
import java.math.BigInteger;

public class CommonNodeFactory {
    public static LLVMLoadNode createLoadNode(LLVMInteropType.ValueKind kind) {
        switch (kind) {
            case I1: {
                return LLVMI1LoadNode.create();
            }
            case I8: {
                return LLVMI8LoadNode.create();
            }
            case I16: {
                return LLVMI16LoadNode.create();
            }
            case I32: {
                return LLVMI32LoadNode.create();
            }
            case I64: {
                return LLVMI64LoadNode.create();
            }
            case FLOAT: {
                return LLVMFloatLoadNode.create();
            }
            case DOUBLE: {
                return LLVMDoubleLoadNode.create();
            }
            case POINTER: {
                return LLVMDirectLoadNode.LLVMPointerDirectLoadNode.create();
            }
        }
        throw new IllegalStateException("unexpected interop kind " + (Object)((Object)kind));
    }

    public static LLVMLoadNode getUncachedLoadNode(LLVMInteropType.ValueKind kind) {
        switch (kind) {
            case I1: {
                return LLVMI1LoadNodeGen.getUncached();
            }
            case I8: {
                return LLVMI8LoadNodeGen.getUncached();
            }
            case I16: {
                return LLVMI16LoadNodeGen.getUncached();
            }
            case I32: {
                return LLVMI32LoadNodeGen.getUncached();
            }
            case I64: {
                return LLVMI64LoadNodeGen.getUncached();
            }
            case FLOAT: {
                return LLVMFloatLoadNodeGen.getUncached();
            }
            case DOUBLE: {
                return LLVMDoubleLoadNodeGen.getUncached();
            }
            case POINTER: {
                return LLVMDirectLoadNodeFactory.LLVMPointerDirectLoadNodeGen.getUncached();
            }
        }
        throw new IllegalStateException("unexpected interop kind " + (Object)((Object)kind));
    }

    public static LLVMStoreNode createStoreNode(LLVMInteropType.ValueKind kind) {
        switch (kind) {
            case I1: {
                return LLVMI1StoreNodeGen.create(null, null);
            }
            case I8: {
                return LLVMI8StoreNodeGen.create(null, null);
            }
            case I16: {
                return LLVMI16StoreNodeGen.create(null, null);
            }
            case I32: {
                return LLVMI32StoreNodeGen.create(null, null);
            }
            case I64: {
                return LLVMI64StoreNodeGen.create(null, null);
            }
            case FLOAT: {
                return LLVMFloatStoreNodeGen.create(null, null);
            }
            case DOUBLE: {
                return LLVMDoubleStoreNodeGen.create(null, null);
            }
            case POINTER: {
                return LLVMPointerStoreNodeGen.create(null, null);
            }
        }
        throw new IllegalStateException("unexpected interop kind " + (Object)((Object)kind));
    }

    public static LLVMStoreNode getUncachedStoreNode(LLVMInteropType.ValueKind kind) {
        switch (kind) {
            case I1: {
                return LLVMI1StoreNodeGen.getUncached();
            }
            case I8: {
                return LLVMI8StoreNodeGen.getUncached();
            }
            case I16: {
                return LLVMI16StoreNodeGen.getUncached();
            }
            case I32: {
                return LLVMI32StoreNodeGen.getUncached();
            }
            case I64: {
                return LLVMI64StoreNodeGen.getUncached();
            }
            case FLOAT: {
                return LLVMFloatStoreNodeGen.getUncached();
            }
            case DOUBLE: {
                return LLVMDoubleStoreNodeGen.getUncached();
            }
            case POINTER: {
                return LLVMPointerStoreNodeGen.getUncached();
            }
        }
        throw new IllegalStateException("unexpected interop kind " + (Object)((Object)kind));
    }

    public static TruffleObject toGenericDebuggerValue(Object llvmType, Object value, DataLayout dataLayout) {
        TruffleObject complexObject = CommonNodeFactory.asDebuggerIRValue(llvmType, value, dataLayout);
        if (complexObject != null) {
            return complexObject;
        }
        return LLVMDebugManagedValue.create(llvmType, value);
    }

    private static TruffleObject asDebuggerIRValue(Object llvmType, Object value, DataLayout dataLayout) {
        if (!(llvmType instanceof Type)) {
            return null;
        }
        Type type = (Type)llvmType;
        if (type instanceof MetaType) {
            return null;
        }
        LLVMSourceType sourceType = LLVMSourceTypeFactory.resolveType(type, dataLayout);
        if (sourceType == null) {
            return null;
        }
        if (value instanceof LLVMVector && ((LLVMVector)value).getLength() == 0) {
            return null;
        }
        if (value instanceof LLVMIVarBit && ((LLVMIVarBit)value).getBitSize() == 0) {
            return null;
        }
        LLVMDebugValue debugValue = CommonNodeFactory.createDebugValueBuilder().build(value);
        if (debugValue == LLVMDebugValue.UNAVAILABLE) {
            return null;
        }
        return LLVMDebugObject.create(sourceType, 0L, debugValue, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LLVMDebugObjectBuilder createDebugStaticValue(LLVMContext context, LLVMExpressionNode valueNode, boolean isGlobal) {
        LLVMDebugValue.Builder toDebugNode = CommonNodeFactory.createDebugValueBuilder();
        Object value = null;
        if (isGlobal) {
            assert (valueNode instanceof LLVMAccessSymbolNode);
            LLVMAccessSymbolNode node = (LLVMAccessSymbolNode)valueNode;
            LLVMSymbol symbol = node.getDescriptor();
            if (!symbol.isGlobalVariable()) throw new IllegalStateException(symbol.getKind() + " symbol: " + symbol.getName());
            value = new LLVMDebugGlobalVariable(symbol.asGlobalVariable(), context);
        } else {
            try {
                value = valueNode.executeGeneric(null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (value == null) return LLVMDebugObjectBuilder.UNAVAILABLE;
        return LLVMDebugSimpleObjectBuilder.create(toDebugNode, value);
    }

    public static LLVMExpressionNode createElementPointer(NodeFactory nodeFactory, long indexedTypeLength, Type currentType, LLVMExpressionNode currentAddress, LLVMExpressionNode indexNode, Type indexType, boolean wasVectorized) {
        if (wasVectorized) {
            if (indexType instanceof VectorType) {
                return nodeFactory.createVectorizedTypedElementPointer(indexedTypeLength, currentType, currentAddress, indexNode);
            }
            int length = ((VectorType)currentType).getNumberOfElementsInt();
            return nodeFactory.createVectorizedTypedElementPointer(indexedTypeLength, currentType, currentAddress, LLVMVectorizedGetElementPtrNodeGen.IndexVectorBroadcastNodeGen.create(length, indexNode));
        }
        if (indexType instanceof VectorType) {
            int length = ((VectorType)indexType).getNumberOfElementsInt();
            return nodeFactory.createVectorizedTypedElementPointer(indexedTypeLength, currentType, LLVMVectorizedGetElementPtrNodeGen.ResultVectorBroadcastNodeGen.create(length, currentAddress), indexNode);
        }
        return nodeFactory.createTypedElementPointer(indexedTypeLength, currentType, currentAddress, indexNode);
    }

    public static LLVMExpressionNode createNestedElementPointerNode(NodeFactory nodeFactory, DataLayout dataLayout, LLVMExpressionNode[] indexNodes, Long[] indexConstants, Type[] indexTypes, LLVMExpressionNode curAddress, Type curType) {
        try {
            LLVMExpressionNode currentAddress = curAddress;
            Type currentType = curType;
            boolean wasVectorized = currentType instanceof VectorType;
            if (wasVectorized) {
                VectorType vectorType = (VectorType)currentType;
                currentType = vectorType.getElementType();
            }
            for (int i = 0; i < indexNodes.length; ++i) {
                LLVMExpressionNode indexNode;
                AggregateType aggregate;
                Type indexType = indexTypes[i];
                Long indexInteger = indexConstants[i];
                if (indexInteger == null) {
                    if (currentType instanceof StructureType) {
                        throw new LLVMParserException("Indices on structs must be constant integers!");
                    }
                    aggregate = (AggregateType)currentType;
                    long indexedTypeLength = aggregate.getOffsetOf(1L, dataLayout);
                    currentType = aggregate.getElementType(1L);
                    currentAddress = CommonNodeFactory.createElementPointer(nodeFactory, indexedTypeLength, currentType, currentAddress, indexNodes[i], indexType, wasVectorized);
                    wasVectorized = currentAddress instanceof LLVMVectorizedGetElementPtrNodeGen;
                    continue;
                }
                aggregate = (AggregateType)currentType;
                long addressOffset = aggregate.getOffsetOf(indexInteger, dataLayout);
                currentType = aggregate.getElementType(indexInteger);
                if (addressOffset == 0L && i != indexNodes.length - 1) continue;
                if (indexType == PrimitiveType.I32) {
                    indexNode = nodeFactory.createLiteral(1, PrimitiveType.I32);
                } else if (indexType == PrimitiveType.I64) {
                    indexNode = nodeFactory.createLiteral(1L, PrimitiveType.I64);
                } else {
                    throw new AssertionError(indexType);
                }
                currentAddress = CommonNodeFactory.createElementPointer(nodeFactory, addressOffset, currentType, currentAddress, indexNode, indexType, wasVectorized);
                wasVectorized = currentAddress instanceof LLVMVectorizedGetElementPtrNodeGen;
            }
            return currentAddress;
        }
        catch (Type.TypeOverflowException e) {
            return Type.handleOverflowExpression(e);
        }
    }

    public static LLVMExpressionNode createFrameRead(Type llvmType, FrameSlot frameSlot) {
        if (llvmType instanceof PrimitiveType) {
            switch (((PrimitiveType)llvmType).getPrimitiveKind()) {
                case I1: {
                    return LLVMReadNodeFactory.LLVMI1ReadNodeGen.create(frameSlot);
                }
                case I8: {
                    return LLVMReadNodeFactory.LLVMI8ReadNodeGen.create(frameSlot);
                }
                case I16: {
                    return LLVMReadNodeFactory.LLVMI16ReadNodeGen.create(frameSlot);
                }
                case I32: {
                    return LLVMReadNodeFactory.LLVMI32ReadNodeGen.create(frameSlot);
                }
                case I64: {
                    return LLVMReadNodeFactory.LLVMI64ReadNodeGen.create(frameSlot);
                }
                case FLOAT: {
                    return LLVMReadNodeFactory.LLVMFloatReadNodeGen.create(frameSlot);
                }
                case DOUBLE: {
                    return LLVMReadNodeFactory.LLVMDoubleReadNodeGen.create(frameSlot);
                }
                case X86_FP80: {
                    return LLVMReadNodeFactory.LLVM80BitFloatReadNodeGen.create(frameSlot);
                }
            }
        } else if (llvmType instanceof VectorType) {
            Type elemType = ((VectorType)llvmType).getElementType();
            if (elemType instanceof PrimitiveType) {
                switch (((PrimitiveType)elemType).getPrimitiveKind()) {
                    case I1: {
                        return LLVMReadVectorNodeFactory.LLVMI1VectorReadNodeGen.create(frameSlot);
                    }
                    case I8: {
                        return LLVMReadVectorNodeFactory.LLVMI8VectorReadNodeGen.create(frameSlot);
                    }
                    case I16: {
                        return LLVMReadVectorNodeFactory.LLVMI16VectorReadNodeGen.create(frameSlot);
                    }
                    case I32: {
                        return LLVMReadVectorNodeFactory.LLVMI32VectorReadNodeGen.create(frameSlot);
                    }
                    case I64: {
                        return LLVMReadVectorNodeFactory.LLVMI64VectorReadNodeGen.create(frameSlot);
                    }
                    case FLOAT: {
                        return LLVMReadVectorNodeFactory.LLVMFloatVectorReadNodeGen.create(frameSlot);
                    }
                    case DOUBLE: {
                        return LLVMReadVectorNodeFactory.LLVMDoubleVectorReadNodeGen.create(frameSlot);
                    }
                }
            } else if (elemType instanceof PointerType || elemType instanceof FunctionType) {
                return LLVMReadVectorNodeFactory.LLVMI64VectorReadNodeGen.create(frameSlot);
            }
        } else {
            if (llvmType instanceof VariableBitWidthType) {
                return LLVMReadNodeFactory.LLVMIReadVarBitNodeGen.create(frameSlot);
            }
            if (llvmType instanceof PointerType || llvmType instanceof FunctionType) {
                return LLVMReadNodeFactory.LLVMAddressReadNodeGen.create(frameSlot);
            }
            if (llvmType instanceof StructureType || llvmType instanceof ArrayType) {
                return LLVMReadNodeFactory.LLVMAddressReadNodeGen.create(frameSlot);
            }
            if (llvmType instanceof VoidType) {
                return LLVMUnsupportedInstructionNode.createExpression(LLVMUnsupportedException.UnsupportedReason.PARSER_ERROR_VOID_SLOT);
            }
            if (llvmType == MetaType.DEBUG) {
                return LLVMReadNodeFactory.LLVMDebugReadNodeGen.create(frameSlot);
            }
        }
        throw new AssertionError((Object)(llvmType + " for " + frameSlot.getIdentifier()));
    }

    public static LLVMLoadNode createLoad(Type resolvedResultType, LLVMExpressionNode loadTarget) {
        if (resolvedResultType instanceof VectorType) {
            return CommonNodeFactory.createLoadVector((VectorType)resolvedResultType, loadTarget, ((VectorType)resolvedResultType).getNumberOfElementsInt());
        }
        int bits = resolvedResultType instanceof VariableBitWidthType ? ((VariableBitWidthType)resolvedResultType).getBitSizeInt() : 0;
        return CommonNodeFactory.createLoad(resolvedResultType, loadTarget, bits);
    }

    private static LLVMLoadNode createLoadVector(VectorType resultType, LLVMExpressionNode loadTarget, int size) {
        Type elemType = resultType.getElementType();
        if (elemType instanceof PrimitiveType) {
            switch (((PrimitiveType)elemType).getPrimitiveKind()) {
                case I1: {
                    return LLVMLoadVectorNodeFactory.LLVMLoadI1VectorNodeGen.create(loadTarget, size);
                }
                case I8: {
                    return LLVMLoadVectorNodeFactory.LLVMLoadI8VectorNodeGen.create(loadTarget, size);
                }
                case I16: {
                    return LLVMLoadVectorNodeFactory.LLVMLoadI16VectorNodeGen.create(loadTarget, size);
                }
                case I32: {
                    return LLVMLoadVectorNodeFactory.LLVMLoadI32VectorNodeGen.create(loadTarget, size);
                }
                case I64: {
                    return LLVMLoadVectorNodeFactory.LLVMLoadI64VectorNodeGen.create(loadTarget, size);
                }
                case FLOAT: {
                    return LLVMLoadVectorNodeFactory.LLVMLoadFloatVectorNodeGen.create(loadTarget, size);
                }
                case DOUBLE: {
                    return LLVMLoadVectorNodeFactory.LLVMLoadDoubleVectorNodeGen.create(loadTarget, size);
                }
            }
            throw new AssertionError((Object)(elemType + " vectors not supported"));
        }
        if (elemType instanceof PointerType || elemType instanceof FunctionType) {
            return LLVMLoadVectorNodeFactory.LLVMLoadPointerVectorNodeGen.create(loadTarget, size);
        }
        throw new AssertionError((Object)(elemType + " vectors not supported"));
    }

    private static LLVMLoadNode createLoad(Type resultType, LLVMExpressionNode loadTarget, int bits) {
        if (resultType instanceof PrimitiveType) {
            switch (((PrimitiveType)resultType).getPrimitiveKind()) {
                case I1: {
                    return LLVMI1LoadNodeGen.create(loadTarget);
                }
                case I8: {
                    return LLVMI8LoadNodeGen.create(loadTarget);
                }
                case I16: {
                    return LLVMI16LoadNodeGen.create(loadTarget);
                }
                case I32: {
                    return LLVMI32LoadNodeGen.create(loadTarget);
                }
                case I64: {
                    return LLVMI64LoadNodeGen.create(loadTarget);
                }
                case FLOAT: {
                    return LLVMFloatLoadNodeGen.create(loadTarget);
                }
                case DOUBLE: {
                    return LLVMDoubleLoadNodeGen.create(loadTarget);
                }
                case X86_FP80: {
                    return LLVMDirectLoadNodeFactory.LLVM80BitFloatDirectLoadNodeGen.create(loadTarget);
                }
            }
            throw new AssertionError(resultType);
        }
        if (resultType instanceof VariableBitWidthType) {
            return LLVMDirectLoadNodeFactory.LLVMIVarBitDirectLoadNodeGen.create(loadTarget, bits);
        }
        if (resultType instanceof StructureType || resultType instanceof ArrayType) {
            return LLVMDirectLoadNodeFactory.LLVMStructDirectLoadNodeGen.create(loadTarget);
        }
        if (resultType instanceof PointerType || resultType instanceof FunctionType) {
            return LLVMDirectLoadNodeFactory.LLVMPointerDirectLoadNodeGen.create(loadTarget);
        }
        throw new AssertionError(resultType);
    }

    public static ForeignToLLVM createForeignToLLVM(ForeignToLLVM.ForeignToLLVMType type) {
        switch (type) {
            case VOID: {
                return ToVoidLLVMNodeGen.create();
            }
            case ANY: {
                return ToAnyLLVMNodeGen.create();
            }
            case I1: {
                return ToI1NodeGen.create();
            }
            case I8: {
                return ToI8NodeGen.create();
            }
            case I16: {
                return ToI16NodeGen.create();
            }
            case I32: {
                return ToI32NodeGen.create();
            }
            case I64: {
                return ToI64NodeGen.create();
            }
            case FLOAT: {
                return ToFloatNodeGen.create();
            }
            case DOUBLE: {
                return ToDoubleNodeGen.create();
            }
            case POINTER: {
                return ToPointer.create();
            }
        }
        throw new IllegalStateException(type.toString());
    }

    public static ForeignToLLVM createForeignToLLVM(LLVMInteropType.Value type) {
        switch (type.getKind()) {
            case I1: {
                return ToI1NodeGen.create();
            }
            case I8: {
                return ToI8NodeGen.create();
            }
            case I16: {
                return ToI16NodeGen.create();
            }
            case I32: {
                return ToI32NodeGen.create();
            }
            case I64: {
                return ToI64NodeGen.create();
            }
            case FLOAT: {
                return ToFloatNodeGen.create();
            }
            case DOUBLE: {
                return ToDoubleNodeGen.create();
            }
            case POINTER: {
                return ToPointer.create(type.getBaseType());
            }
        }
        throw new IllegalStateException("unexpected interop kind " + (Object)((Object)type.getKind()));
    }

    public static LLVMExpressionNode createFunctionCall(LLVMExpressionNode functionNode, LLVMExpressionNode[] argNodes, FunctionType type) {
        LLVMCallNode callNode = LLVMCallNode.create(type, functionNode, argNodes, true);
        return LLVMValueProfilingNode.create(callNode, type.getReturnType());
    }

    public static LLVMStatementNode createDebugTrap() {
        return LLVMDebugTrapNodeGen.create();
    }

    public static LLVMDebugValue.Builder createDebugDeclarationBuilder() {
        return LLVMToDebugDeclaration.getInstance();
    }

    public static LLVMDebugValue.Builder createDebugValueBuilder() {
        return LLVMToDebugValueNodeGen.getUncached();
    }

    public static LLVMExpressionNode createArithmeticOp(ArithmeticOperation op, Type type, LLVMExpressionNode left, LLVMExpressionNode right) {
        if (type instanceof VectorType) {
            VectorType vectorType = (VectorType)type;
            LLVMArithmeticNode arithmeticNode = CommonNodeFactory.createScalarArithmeticOp(op, vectorType.getElementType(), null, null);
            return LLVMVectorArithmeticNodeGen.create(vectorType.getNumberOfElementsInt(), arithmeticNode, left, right);
        }
        return CommonNodeFactory.createScalarArithmeticOp(op, type, left, right);
    }

    public static LLVMArithmeticNode createScalarArithmeticOp(ArithmeticOperation op, Type type, LLVMExpressionNode left, LLVMExpressionNode right) {
        assert (!(type instanceof VectorType));
        if (type instanceof PrimitiveType) {
            switch (((PrimitiveType)type).getPrimitiveKind()) {
                case I1: {
                    return LLVMArithmeticNodeFactory.LLVMI1ArithmeticNodeGen.create(op, left, right);
                }
                case I8: {
                    return LLVMArithmeticNodeFactory.LLVMI8ArithmeticNodeGen.create(op, left, right);
                }
                case I16: {
                    return LLVMArithmeticNodeFactory.LLVMI16ArithmeticNodeGen.create(op, left, right);
                }
                case I32: {
                    return LLVMArithmeticNodeFactory.LLVMI32ArithmeticNodeGen.create(op, left, right);
                }
                case I64: {
                    return LLVMArithmeticNode.LLVMAbstractI64ArithmeticNode.create(op, left, right);
                }
                case FLOAT: {
                    return LLVMArithmeticNodeFactory.LLVMFloatArithmeticNodeGen.create(op, left, right);
                }
                case DOUBLE: {
                    return LLVMArithmeticNodeFactory.LLVMDoubleArithmeticNodeGen.create(op, left, right);
                }
                case X86_FP80: {
                    return LLVMArithmeticNodeFactory.LLVMFP80ArithmeticNodeGen.create(op, left, right);
                }
            }
            throw new AssertionError(type);
        }
        if (type instanceof VariableBitWidthType) {
            return LLVMArithmeticNodeFactory.LLVMIVarBitArithmeticNodeGen.create(op, left, right);
        }
        throw new AssertionError(type);
    }

    public static LLVMExpressionNode createComparison(CompareOperator operator, Type type, LLVMExpressionNode lhs, LLVMExpressionNode rhs) {
        if (type instanceof VectorType) {
            VectorType vectorType = (VectorType)type;
            LLVMAbstractCompareNode comparison = CommonNodeFactory.createScalarComparison(operator, vectorType.getElementType(), null, null);
            return LLVMVectorCompareNodeGen.create(vectorType.getNumberOfElementsInt(), comparison, lhs, rhs);
        }
        return CommonNodeFactory.createScalarComparison(operator, type, lhs, rhs);
    }

    private static LLVMAbstractCompareNode createScalarComparison(CompareOperator operator, Type type, LLVMExpressionNode lhs, LLVMExpressionNode rhs) {
        assert (!(type instanceof VectorType));
        if (CommonNodeFactory.usePointerComparison(type)) {
            return CommonNodeFactory.createPointerComparison(operator, lhs, rhs);
        }
        return CommonNodeFactory.createPrimitiveComparison(operator, lhs, rhs);
    }

    private static LLVMAbstractCompareNode createPointerComparison(CompareOperator operator, LLVMExpressionNode lhs, LLVMExpressionNode rhs) {
        switch (operator) {
            case INT_EQUAL: {
                return LLVMPointerCompareNode.create(LLVMPointerCompareNode.Kind.EQ, lhs, rhs);
            }
            case INT_NOT_EQUAL: {
                return LLVMPointerCompareNode.create(LLVMPointerCompareNode.Kind.NEQ, lhs, rhs);
            }
            case INT_UNSIGNED_GREATER_THAN: {
                return LLVMPointerCompareNode.LLVMNegateNode.create(LLVMPointerCompareNode.create(LLVMPointerCompareNode.Kind.ULE, lhs, rhs));
            }
            case INT_UNSIGNED_GREATER_OR_EQUAL: {
                return LLVMPointerCompareNode.LLVMNegateNode.create(LLVMPointerCompareNode.create(LLVMPointerCompareNode.Kind.ULT, lhs, rhs));
            }
            case INT_UNSIGNED_LESS_THAN: {
                return LLVMPointerCompareNode.create(LLVMPointerCompareNode.Kind.ULT, lhs, rhs);
            }
            case INT_UNSIGNED_LESS_OR_EQUAL: {
                return LLVMPointerCompareNode.create(LLVMPointerCompareNode.Kind.ULE, lhs, rhs);
            }
            case INT_SIGNED_GREATER_THAN: {
                return LLVMPointerCompareNode.LLVMNegateNode.create(LLVMPointerCompareNode.create(LLVMPointerCompareNode.Kind.SLE, lhs, rhs));
            }
            case INT_SIGNED_GREATER_OR_EQUAL: {
                return LLVMPointerCompareNode.LLVMNegateNode.create(LLVMPointerCompareNode.create(LLVMPointerCompareNode.Kind.SLT, lhs, rhs));
            }
            case INT_SIGNED_LESS_THAN: {
                return LLVMPointerCompareNode.create(LLVMPointerCompareNode.Kind.SLT, lhs, rhs);
            }
            case INT_SIGNED_LESS_OR_EQUAL: {
                return LLVMPointerCompareNode.create(LLVMPointerCompareNode.Kind.SLE, lhs, rhs);
            }
        }
        throw new AssertionError((Object)operator);
    }

    private static LLVMAbstractCompareNode createPrimitiveComparison(CompareOperator operator, LLVMExpressionNode lhs, LLVMExpressionNode rhs) {
        switch (operator) {
            case FP_FALSE: {
                return LLVMCompareNodeFactory.LLVMFalseCmpNodeGen.create(lhs, rhs);
            }
            case FP_ORDERED_EQUAL: {
                return LLVMCompareNodeFactory.LLVMOrderedEqNodeGen.create(lhs, rhs);
            }
            case FP_ORDERED_GREATER_THAN: {
                return LLVMCompareNodeFactory.LLVMOrderedGtNodeGen.create(lhs, rhs);
            }
            case FP_ORDERED_GREATER_OR_EQUAL: {
                return LLVMCompareNodeFactory.LLVMOrderedGeNodeGen.create(lhs, rhs);
            }
            case FP_ORDERED_LESS_THAN: {
                return LLVMCompareNodeFactory.LLVMOrderedLtNodeGen.create(lhs, rhs);
            }
            case FP_ORDERED_LESS_OR_EQUAL: {
                return LLVMCompareNodeFactory.LLVMOrderedLeNodeGen.create(lhs, rhs);
            }
            case FP_ORDERED_NOT_EQUAL: {
                return LLVMCompareNodeFactory.LLVMOrderedNeNodeGen.create(lhs, rhs);
            }
            case FP_ORDERED: {
                return LLVMCompareNodeFactory.LLVMOrderedNodeGen.create(lhs, rhs);
            }
            case FP_UNORDERED: {
                return LLVMCompareNodeFactory.LLVMUnorderedNodeGen.create(lhs, rhs);
            }
            case FP_UNORDERED_EQUAL: {
                return LLVMCompareNodeFactory.LLVMUnorderedEqNodeGen.create(lhs, rhs);
            }
            case FP_UNORDERED_GREATER_THAN: {
                return LLVMCompareNodeFactory.LLVMUnorderedGtNodeGen.create(lhs, rhs);
            }
            case FP_UNORDERED_GREATER_OR_EQUAL: {
                return LLVMCompareNodeFactory.LLVMUnorderedGeNodeGen.create(lhs, rhs);
            }
            case FP_UNORDERED_LESS_THAN: {
                return LLVMCompareNodeFactory.LLVMUnorderedLtNodeGen.create(lhs, rhs);
            }
            case FP_UNORDERED_LESS_OR_EQUAL: {
                return LLVMCompareNodeFactory.LLVMUnorderedLeNodeGen.create(lhs, rhs);
            }
            case FP_UNORDERED_NOT_EQUAL: {
                return LLVMCompareNodeFactory.LLVMUnorderedNeNodeGen.create(lhs, rhs);
            }
            case FP_TRUE: {
                return LLVMCompareNodeFactory.LLVMTrueCmpNodeGen.create(lhs, rhs);
            }
            case INT_EQUAL: {
                return LLVMCompareNodeFactory.LLVMEqNodeGen.create(lhs, rhs);
            }
            case INT_NOT_EQUAL: {
                return LLVMCompareNodeFactory.LLVMNeNodeGen.create(lhs, rhs);
            }
            case INT_UNSIGNED_GREATER_THAN: {
                return LLVMPointerCompareNode.LLVMNegateNode.create(LLVMCompareNodeFactory.LLVMUnsignedLeNodeGen.create(lhs, rhs));
            }
            case INT_UNSIGNED_GREATER_OR_EQUAL: {
                return LLVMPointerCompareNode.LLVMNegateNode.create(LLVMCompareNodeFactory.LLVMUnsignedLtNodeGen.create(lhs, rhs));
            }
            case INT_UNSIGNED_LESS_THAN: {
                return LLVMCompareNodeFactory.LLVMUnsignedLtNodeGen.create(lhs, rhs);
            }
            case INT_UNSIGNED_LESS_OR_EQUAL: {
                return LLVMCompareNodeFactory.LLVMUnsignedLeNodeGen.create(lhs, rhs);
            }
            case INT_SIGNED_GREATER_THAN: {
                return LLVMPointerCompareNode.LLVMNegateNode.create(LLVMCompareNodeFactory.LLVMSignedLeNodeGen.create(lhs, rhs));
            }
            case INT_SIGNED_GREATER_OR_EQUAL: {
                return LLVMPointerCompareNode.LLVMNegateNode.create(LLVMCompareNodeFactory.LLVMSignedLtNodeGen.create(lhs, rhs));
            }
            case INT_SIGNED_LESS_THAN: {
                return LLVMCompareNodeFactory.LLVMSignedLtNodeGen.create(lhs, rhs);
            }
            case INT_SIGNED_LESS_OR_EQUAL: {
                return LLVMCompareNodeFactory.LLVMSignedLeNodeGen.create(lhs, rhs);
            }
        }
        throw new RuntimeException("Missed a compare operator");
    }

    private static boolean usePointerComparison(Type type) {
        return type instanceof PointerType || type instanceof FunctionType || type instanceof PrimitiveType && ((PrimitiveType)type).getPrimitiveKind() == PrimitiveType.PrimitiveKind.I64;
    }

    public static LLVMExpressionNode createSimpleConstantNoArray(Object constant, Type type) {
        if (type instanceof VariableBitWidthType) {
            Number c = (Number)constant;
            try {
                if (Long.compareUnsigned(type.getBitSize(), 64L) <= 0) {
                    return LLVMSimpleLiteralNodeFactory.LLVMIVarBitLiteralNodeGen.create(LLVMIVarBit.fromLong(((VariableBitWidthType)type).getBitSizeInt(), c.longValue()));
                }
                return LLVMSimpleLiteralNodeFactory.LLVMIVarBitLiteralNodeGen.create(LLVMIVarBit.fromBigInteger(((VariableBitWidthType)type).getBitSizeInt(), (BigInteger)c));
            }
            catch (Type.TypeOverflowException e) {
                return Type.handleOverflowExpression(e);
            }
        }
        if (type instanceof PointerType || type instanceof FunctionType) {
            if (constant == null) {
                return LLVMSimpleLiteralNodeFactory.LLVMNativePointerLiteralNodeGen.create(LLVMNativePointer.create(0L));
            }
            throw new AssertionError((Object)("Not a Simple Constant: " + constant));
        }
        if (type instanceof PrimitiveType) {
            switch (((PrimitiveType)type).getPrimitiveKind()) {
                case I1: {
                    return LLVMSimpleLiteralNodeFactory.LLVMI1LiteralNodeGen.create((Boolean)constant);
                }
                case I8: {
                    return LLVMSimpleLiteralNodeFactory.LLVMI8LiteralNodeGen.create((Byte)constant);
                }
                case I16: {
                    return LLVMSimpleLiteralNodeFactory.LLVMI16LiteralNodeGen.create((Short)constant);
                }
                case I32: {
                    return LLVMSimpleLiteralNodeFactory.LLVMI32LiteralNodeGen.create((Integer)constant);
                }
                case FLOAT: {
                    return LLVMSimpleLiteralNodeFactory.LLVMFloatLiteralNodeGen.create(((Float)constant).floatValue());
                }
                case DOUBLE: {
                    return LLVMSimpleLiteralNodeFactory.LLVMDoubleLiteralNodeGen.create((Double)constant);
                }
                case X86_FP80: {
                    if (constant == null) {
                        return LLVMSimpleLiteralNodeFactory.LLVM80BitFloatLiteralNodeGen.create(LLVM80BitFloat.fromLong(0L));
                    }
                    return LLVMSimpleLiteralNodeFactory.LLVM80BitFloatLiteralNodeGen.create(LLVM80BitFloat.fromBytesBigEndian((byte[])constant));
                }
                case I64: {
                    return LLVMSimpleLiteralNodeFactory.LLVMI64LiteralNodeGen.create((Long)constant);
                }
            }
            throw new AssertionError(type);
        }
        if (type == MetaType.DEBUG) {
            return LLVMSimpleLiteralNodeFactory.LLVMNativePointerLiteralNodeGen.create(LLVMNativePointer.createNull());
        }
        throw new AssertionError(type);
    }

    public static LLVMExpressionNode createBitcast(LLVMExpressionNode fromNode, Type targetType, Type fromType) {
        assert (targetType != null);
        if (targetType instanceof PrimitiveType) {
            return CommonNodeFactory.createBitcast(fromNode, ((PrimitiveType)targetType).getPrimitiveKind());
        }
        if (targetType instanceof PointerType || targetType instanceof FunctionType) {
            return LLVMToAddressNodeGen.create(fromNode);
        }
        if (targetType instanceof VariableBitWidthType) {
            return LLVMToVarINodeGen.LLVMBitcastToIVarNodeGen.create(fromNode, ((VariableBitWidthType)targetType).getBitSizeInt());
        }
        if (targetType instanceof VectorType) {
            VectorType vectorType = (VectorType)targetType;
            Type elemType = vectorType.getElementType();
            int vectorLength = vectorType.getNumberOfElementsInt();
            if (elemType instanceof PrimitiveType) {
                switch (((PrimitiveType)elemType).getPrimitiveKind()) {
                    case I1: {
                        return LLVMToVectorNodeFactory.LLVMBitcastToI1VectorNodeGen.create(fromNode, vectorLength);
                    }
                    case I8: {
                        return LLVMToVectorNodeFactory.LLVMBitcastToI8VectorNodeGen.create(fromNode, vectorLength);
                    }
                    case I16: {
                        return LLVMToVectorNodeFactory.LLVMBitcastToI16VectorNodeGen.create(fromNode, vectorLength);
                    }
                    case I32: {
                        return LLVMToVectorNodeFactory.LLVMBitcastToI32VectorNodeGen.create(fromNode, vectorLength);
                    }
                    case I64: {
                        return LLVMToVectorNodeFactory.LLVMBitcastToI64VectorNodeGen.create(fromNode, vectorLength);
                    }
                    case FLOAT: {
                        return LLVMToVectorNodeFactory.LLVMBitcastToFloatVectorNodeGen.create(fromNode, vectorLength);
                    }
                    case DOUBLE: {
                        return LLVMToVectorNodeFactory.LLVMBitcastToDoubleVectorNodeGen.create(fromNode, vectorLength);
                    }
                }
            }
        }
        throw CommonNodeFactory.unsupportedCast(targetType);
    }

    private static LLVMExpressionNode createBitcast(LLVMExpressionNode fromNode, PrimitiveType.PrimitiveKind kind) {
        switch (kind) {
            case I1: {
                return LLVMToI1NodeGen.LLVMBitcastToI1NodeGen.create(fromNode);
            }
            case I8: {
                return LLVMToI8NodeGen.LLVMBitcastToI8NodeGen.create(fromNode);
            }
            case I16: {
                return LLVMToI16NodeGen.LLVMBitcastToI16NodeGen.create(fromNode);
            }
            case I32: {
                return LLVMToI32NodeGen.LLVMBitcastToI32NodeGen.create(fromNode);
            }
            case I64: {
                return LLVMToI64NodeGen.LLVMBitcastToI64NodeGen.create(fromNode);
            }
            case FLOAT: {
                return LLVMToFloatNodeGen.LLVMBitcastToFloatNodeGen.create(fromNode);
            }
            case DOUBLE: {
                return LLVMToDoubleNodeGen.LLVMBitcastToDoubleNodeGen.create(fromNode);
            }
            case X86_FP80: {
                return LLVMTo80BitFloatingNodeGen.LLVMBitcastToLLVM80BitFloatNodeGen.create(fromNode);
            }
        }
        throw CommonNodeFactory.unsupportedCast(kind);
    }

    public static LLVMExpressionNode createUnsignedCast(LLVMExpressionNode fromNode, Type targetType) {
        if (targetType instanceof PrimitiveType) {
            return CommonNodeFactory.createUnsignedCast(fromNode, ((PrimitiveType)targetType).getPrimitiveKind());
        }
        if (targetType instanceof PointerType || targetType instanceof FunctionType) {
            return LLVMToAddressNodeGen.create(fromNode);
        }
        if (targetType instanceof VariableBitWidthType) {
            return LLVMToVarINodeGen.LLVMUnsignedCastToIVarNodeGen.create(fromNode, ((VariableBitWidthType)targetType).getBitSizeInt());
        }
        if (targetType instanceof VectorType) {
            VectorType vectorType = (VectorType)targetType;
            Type elemType = vectorType.getElementType();
            int vectorLength = vectorType.getNumberOfElementsInt();
            if (elemType instanceof PrimitiveType) {
                switch (((PrimitiveType)elemType).getPrimitiveKind()) {
                    case I1: {
                        return LLVMToVectorZeroExtNodeFactory.LLVMUnsignedCastToI1VectorNodeGen.create(fromNode, vectorLength);
                    }
                    case I8: {
                        return LLVMToVectorZeroExtNodeFactory.LLVMUnsignedCastToI8VectorNodeGen.create(fromNode, vectorLength);
                    }
                    case I16: {
                        return LLVMToVectorZeroExtNodeFactory.LLVMUnsignedCastToI16VectorNodeGen.create(fromNode, vectorLength);
                    }
                    case I32: {
                        return LLVMToVectorZeroExtNodeFactory.LLVMUnsignedCastToI32VectorNodeGen.create(fromNode, vectorLength);
                    }
                    case I64: {
                        return LLVMToVectorZeroExtNodeFactory.LLVMUnsignedCastToI64VectorNodeGen.create(fromNode, vectorLength);
                    }
                    case FLOAT: {
                        return LLVMToVectorZeroExtNodeFactory.LLVMUnsignedCastToFloatVectorNodeGen.create(fromNode, vectorLength);
                    }
                    case DOUBLE: {
                        return LLVMToVectorZeroExtNodeFactory.LLVMUnsignedCastToDoubleVectorNodeGen.create(fromNode, vectorLength);
                    }
                }
            } else if (elemType instanceof PointerType) {
                return LLVMToVectorNodeFactory.LLVMBitcastToPointerVectorNodeGen.create(fromNode, vectorLength);
            }
        }
        throw CommonNodeFactory.unsupportedCast(targetType);
    }

    public static LLVMExpressionNode createUnsignedCast(LLVMExpressionNode fromNode, PrimitiveType.PrimitiveKind kind) {
        switch (kind) {
            case I1: {
                return LLVMToI1NodeGen.LLVMSignedCastToI1NodeGen.create(fromNode);
            }
            case I8: {
                return LLVMToI8NodeGen.LLVMUnsignedCastToI8NodeGen.create(fromNode);
            }
            case I16: {
                return LLVMToI16NodeGen.LLVMUnsignedCastToI16NodeGen.create(fromNode);
            }
            case I32: {
                return LLVMToI32NodeGen.LLVMUnsignedCastToI32NodeGen.create(fromNode);
            }
            case I64: {
                return LLVMToI64NodeGen.LLVMUnsignedCastToI64NodeGen.create(fromNode);
            }
            case FLOAT: {
                return LLVMToFloatNodeGen.LLVMUnsignedCastToFloatNodeGen.create(fromNode);
            }
            case DOUBLE: {
                return LLVMToDoubleNodeGen.LLVMUnsignedCastToDoubleNodeGen.create(fromNode);
            }
            case X86_FP80: {
                return LLVMTo80BitFloatingNodeGen.LLVMUnsignedCastToLLVM80BitFloatNodeGen.create(fromNode);
            }
        }
        throw CommonNodeFactory.unsupportedCast(kind);
    }

    public static LLVMExpressionNode createSignedCast(LLVMExpressionNode fromNode, Type targetType) {
        if (targetType instanceof PrimitiveType) {
            return CommonNodeFactory.createSignedCast(fromNode, ((PrimitiveType)targetType).getPrimitiveKind());
        }
        if (targetType instanceof VariableBitWidthType) {
            return LLVMToVarINodeGen.LLVMSignedCastToIVarNodeGen.create(fromNode, ((VariableBitWidthType)targetType).getBitSizeInt());
        }
        if (targetType instanceof VectorType) {
            VectorType vectorType = (VectorType)targetType;
            Type elemType = vectorType.getElementType();
            int vectorLength = vectorType.getNumberOfElementsInt();
            if (elemType instanceof PrimitiveType) {
                switch (((PrimitiveType)((VectorType)targetType).getElementType()).getPrimitiveKind()) {
                    case I1: {
                        return LLVMToVectorNodeFactory.LLVMSignedCastToI1VectorNodeGen.create(fromNode, vectorLength);
                    }
                    case I8: {
                        return LLVMToVectorNodeFactory.LLVMSignedCastToI8VectorNodeGen.create(fromNode, vectorLength);
                    }
                    case I16: {
                        return LLVMToVectorNodeFactory.LLVMSignedCastToI16VectorNodeGen.create(fromNode, vectorLength);
                    }
                    case I32: {
                        return LLVMToVectorNodeFactory.LLVMSignedCastToI32VectorNodeGen.create(fromNode, vectorLength);
                    }
                    case I64: {
                        return LLVMToVectorNodeFactory.LLVMSignedCastToI64VectorNodeGen.create(fromNode, vectorLength);
                    }
                    case FLOAT: {
                        return LLVMToVectorNodeFactory.LLVMSignedCastToFloatVectorNodeGen.create(fromNode, vectorLength);
                    }
                    case DOUBLE: {
                        return LLVMToVectorNodeFactory.LLVMSignedCastToDoubleVectorNodeGen.create(fromNode, vectorLength);
                    }
                }
            }
        }
        throw CommonNodeFactory.unsupportedCast(targetType);
    }

    public static LLVMExpressionNode createSignedCast(LLVMExpressionNode fromNode, PrimitiveType.PrimitiveKind kind) {
        switch (kind) {
            case I1: {
                return LLVMToI1NodeGen.LLVMSignedCastToI1NodeGen.create(fromNode);
            }
            case I8: {
                return LLVMToI8NodeGen.LLVMSignedCastToI8NodeGen.create(fromNode);
            }
            case I16: {
                return LLVMToI16NodeGen.LLVMSignedCastToI16NodeGen.create(fromNode);
            }
            case I32: {
                return LLVMToI32NodeGen.LLVMSignedCastToI32NodeGen.create(fromNode);
            }
            case I64: {
                return LLVMToI64NodeGen.LLVMSignedCastToI64NodeGen.create(fromNode);
            }
            case FLOAT: {
                return LLVMToFloatNodeGen.LLVMSignedCastToFloatNodeGen.create(fromNode);
            }
            case DOUBLE: {
                return LLVMToDoubleNodeGen.LLVMSignedCastToDoubleNodeGen.create(fromNode);
            }
            case X86_FP80: {
                return LLVMTo80BitFloatingNodeGen.LLVMSignedCastToLLVM80BitFloatNodeGen.create(fromNode);
            }
        }
        throw CommonNodeFactory.unsupportedCast(kind);
    }

    private static AssertionError unsupportedCast(Type targetType) {
        throw new LLVMParserException("Cannot cast to " + targetType);
    }

    private static AssertionError unsupportedCast(PrimitiveType.PrimitiveKind kind) {
        throw new LLVMParserException("Cannot cast to " + (Object)((Object)kind));
    }
}

