/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.text;

import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.llvm.parser.text.LLSourceMap;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import com.oracle.truffle.llvm.runtime.options.TargetStream;
import com.oracle.truffle.llvm.runtime.types.symbols.LLVMIdentifier;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class LLScanner {
    static final LLSourceMap NOT_FOUND = new LLSourceMap(null);
    private final LLSourceMap map;
    private int currentLine;
    private LLSourceMap.Function function;
    private static final Pattern FUNCTION_NAME_REGEX = Pattern.compile("define .* @((?<functionNameUnquoted>[^\\s(\"]+)|\"(?<functionNameQuoted>[^\"]+)\")\\(.*");
    private static final Pattern VALUE_NAME_REGEX = Pattern.compile("\\s*\"?(?<instructionName>\\S+)\"? .*");
    private static final Pattern OP_NAME_REGEX = Pattern.compile("\\s*(?<instructionName>\\S+).*");
    private static final Pattern GLOBAL_NAME_REGEX = Pattern.compile("@\"?(?<globalName>\\S+)\"? =.*");

    private static TruffleFile findMapping(Path canonicalBCPath, String pathMappings, LLVMContext context) {
        String[] mappings;
        if (pathMappings.isEmpty()) {
            return null;
        }
        for (String mapping : mappings = pathMappings.split(":")) {
            String[] splittedMapping = mapping.split("=");
            if (splittedMapping.length != 2) {
                throw new LLVMParserException("Malformed path mapping for *.ll files: " + pathMappings);
            }
            Path mappedBCFile = Paths.get(splittedMapping[0], new String[0]).normalize().toAbsolutePath();
            if (!mappedBCFile.equals(canonicalBCPath)) continue;
            Path mappedLLFile = Paths.get(splittedMapping[1], new String[0]).normalize().toAbsolutePath();
            return context.getEnv().getInternalTruffleFile(mappedLLFile.toUri());
        }
        return null;
    }

    private static TruffleFile findLLPathMapping(String bcPath, String pathMappings, LLVMContext context) {
        if (bcPath == null) {
            return null;
        }
        Path canonicalBCPath = Paths.get(bcPath, new String[0]).normalize().toAbsolutePath();
        TruffleFile mappedFile = LLScanner.findMapping(canonicalBCPath, pathMappings, context);
        if (mappedFile != null) {
            return mappedFile;
        }
        return context.getEnv().getInternalTruffleFile(LLScanner.getLLPath(canonicalBCPath.toString()));
    }

    private static String getLLPath(String canonicalBCPath) {
        if (canonicalBCPath.endsWith(".bc")) {
            return canonicalBCPath.substring(0, canonicalBCPath.length() - ".bc".length()) + ".ll";
        }
        return canonicalBCPath + ".ll";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static LLSourceMap findAndScanLLFile(String bcPath, String pathMappings, LLVMContext context) {
        if (bcPath == null) {
            return NOT_FOUND;
        }
        TruffleFile llFile = LLScanner.findLLPathMapping(bcPath, pathMappings, context);
        if (llFile == null || !llFile.exists(new LinkOption[0]) || !llFile.isReadable()) {
            TargetStream stream = context.llDebugVerboseStream();
            if (stream == null) return NOT_FOUND;
            stream.println("Cannot find .ll file for " + bcPath);
            return NOT_FOUND;
        }
        try (BufferedReader llReader = llFile.newBufferedReader();){
            Source llSource = Source.newBuilder((String)"llvm", (TruffleFile)llFile).mimeType("text/x-llvmir").build();
            LLSourceMap sourceMap = new LLSourceMap(llSource);
            LLScanner scanner = new LLScanner(sourceMap);
            String line = llReader.readLine();
            while (line != null && scanner.continueAfter(line)) {
                line = llReader.readLine();
            }
            LLSourceMap lLSourceMap = sourceMap;
            return lLSourceMap;
        }
        catch (IOException e) {
            throw new LLVMParserException("Error while reading from file: " + llFile.getPath());
        }
    }

    private LLScanner(LLSourceMap map) {
        this.map = map;
        this.currentLine = 0;
        this.function = null;
    }

    private boolean continueAfter(String line) {
        ++this.currentLine;
        if (line.isEmpty() || line.charAt(0) == ';') {
            return true;
        }
        if (line.startsWith("define")) {
            this.beginFunction(line);
        } else if (line.startsWith("}")) {
            this.endFunction();
        } else if (this.function != null) {
            this.parseInstruction(line);
        } else if (line.startsWith("@")) {
            this.parseGlobal(line);
        } else if (line.startsWith("!0")) {
            return false;
        }
        return true;
    }

    private void beginFunction(String line) {
        String functionName;
        assert (this.function == null);
        Matcher matcher = FUNCTION_NAME_REGEX.matcher(line);
        if (matcher.matches()) {
            functionName = matcher.group("functionNameUnquoted");
            if (functionName == null) {
                functionName = matcher.group("functionNameQuoted");
            }
        } else {
            throw new LLVMParserException(this.getErrorMessage("function", line));
        }
        functionName = LLVMIdentifier.toGlobalIdentifier(functionName);
        this.function = new LLSourceMap.Function(functionName, this.currentLine);
        this.map.registerFunction(functionName, this.function);
    }

    private void parseInstruction(String line) {
        assert (this.function != null);
        String id = null;
        Matcher matcher = VALUE_NAME_REGEX.matcher(line);
        if (matcher.matches()) {
            id = matcher.group("instructionName");
            id = LLVMIdentifier.toLocalIdentifier(id);
        }
        if ((matcher = OP_NAME_REGEX.matcher(line)).matches()) {
            id = matcher.group("instructionName");
        }
        if (id == null) {
            throw new LLVMParserException(this.getErrorMessage("instruction", line));
        }
        this.function.add(id, this.currentLine);
    }

    private void endFunction() {
        assert (this.function != null);
        this.function.setEndLine(this.currentLine);
        this.function = null;
    }

    private void parseGlobal(String line) {
        Matcher matcher = GLOBAL_NAME_REGEX.matcher(line);
        if (!matcher.matches()) {
            throw new LLVMParserException(this.getErrorMessage("global", line));
        }
        String globalName = matcher.group("globalName");
        globalName = LLVMIdentifier.toGlobalIdentifier(globalName);
        this.map.registerGlobal(globalName);
    }

    private String getErrorMessage(String parsing, String line) {
        return String.format("Could not parse %s name in *.ll file: line %d: >>%s<<", parsing, this.currentLine, line);
    }
}

