/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.constants;

import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.SymbolTable;
import com.oracle.truffle.llvm.parser.model.enums.BinaryOperator;
import com.oracle.truffle.llvm.parser.model.symbols.constants.AbstractConstant;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.types.VectorType;

public final class BinaryOperationConstant
extends AbstractConstant {
    private final BinaryOperator operator;
    private SymbolImpl lhs;
    private SymbolImpl rhs;

    private BinaryOperationConstant(Type type, BinaryOperator operator) {
        super(type);
        this.operator = operator;
        this.lhs = null;
        this.rhs = null;
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    public SymbolImpl getLHS() {
        return this.lhs;
    }

    public BinaryOperator getOperator() {
        return this.operator;
    }

    public SymbolImpl getRHS() {
        return this.rhs;
    }

    @Override
    public void replace(SymbolImpl original, SymbolImpl replacement) {
        if (this.lhs == original) {
            this.lhs = replacement;
        }
        if (this.rhs == original) {
            this.rhs = replacement;
        }
    }

    public static BinaryOperationConstant fromSymbols(SymbolTable symbols, Type type, int opcode, int lhs, int rhs) {
        boolean isFloatingPoint = Type.isFloatingpointType(type) || type instanceof VectorType && Type.isFloatingpointType(((VectorType)type).getElementType());
        BinaryOperator operator = BinaryOperator.decode(opcode, isFloatingPoint);
        BinaryOperationConstant constant = new BinaryOperationConstant(type, operator);
        constant.lhs = symbols.getForwardReferenced(lhs, constant);
        constant.rhs = symbols.getForwardReferenced(rhs, constant);
        return constant;
    }
}

