/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.enums;

public enum AtomicOrdering {
    NOT_ATOMIC(0L, ""),
    UNORDERED(1L, "unordered"),
    MONOTONIC(2L, "monotonic"),
    ACQUIRE(3L, "acquire"),
    RELEASE(4L, "release"),
    ACQUIRE_RELEASE(5L, "acq_rel"),
    SEQUENTIALLY_CONSISTENT(6L, "seq_cst");

    private static final AtomicOrdering[] VALUES;
    private final long encodedValue;
    private final String irString;

    private AtomicOrdering(long encodeValue, String irString) {
        this.encodedValue = encodeValue;
        this.irString = irString;
    }

    public long getEncodedValue() {
        return this.encodedValue;
    }

    public String getIrString() {
        return this.irString;
    }

    public static AtomicOrdering decode(long id) {
        for (AtomicOrdering atomicOrdering : VALUES) {
            if (atomicOrdering.getEncodedValue() != id) continue;
            return atomicOrdering;
        }
        return SEQUENTIALLY_CONSISTENT;
    }

    public static AtomicOrdering getOrStrongestFailureOrdering(long id, AtomicOrdering successOrdering) {
        for (AtomicOrdering atomicOrdering : VALUES) {
            if (atomicOrdering.getEncodedValue() != id) continue;
            return atomicOrdering;
        }
        switch (successOrdering) {
            case RELEASE: 
            case MONOTONIC: {
                return MONOTONIC;
            }
            case ACQUIRE_RELEASE: 
            case ACQUIRE: {
                return ACQUIRE;
            }
            case SEQUENTIALLY_CONSISTENT: {
                return SEQUENTIALLY_CONSISTENT;
            }
        }
        throw new AssertionError((Object)("Invalid SuccessOrdering: " + (Object)((Object)successOrdering)));
    }

    static {
        VALUES = AtomicOrdering.values();
    }
}

