/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.listeners;

import com.oracle.truffle.llvm.parser.listeners.ParserListener;
import com.oracle.truffle.llvm.parser.listeners.Types;
import com.oracle.truffle.llvm.parser.metadata.MDAttachment;
import com.oracle.truffle.llvm.parser.metadata.MDBaseNode;
import com.oracle.truffle.llvm.parser.metadata.MDBasicType;
import com.oracle.truffle.llvm.parser.metadata.MDCommonBlock;
import com.oracle.truffle.llvm.parser.metadata.MDCompileUnit;
import com.oracle.truffle.llvm.parser.metadata.MDCompositeType;
import com.oracle.truffle.llvm.parser.metadata.MDDerivedType;
import com.oracle.truffle.llvm.parser.metadata.MDEnumerator;
import com.oracle.truffle.llvm.parser.metadata.MDExpression;
import com.oracle.truffle.llvm.parser.metadata.MDFile;
import com.oracle.truffle.llvm.parser.metadata.MDGenericDebug;
import com.oracle.truffle.llvm.parser.metadata.MDGlobalVariable;
import com.oracle.truffle.llvm.parser.metadata.MDGlobalVariableExpression;
import com.oracle.truffle.llvm.parser.metadata.MDImportedEntity;
import com.oracle.truffle.llvm.parser.metadata.MDKind;
import com.oracle.truffle.llvm.parser.metadata.MDLabel;
import com.oracle.truffle.llvm.parser.metadata.MDLexicalBlock;
import com.oracle.truffle.llvm.parser.metadata.MDLexicalBlockFile;
import com.oracle.truffle.llvm.parser.metadata.MDLocalVariable;
import com.oracle.truffle.llvm.parser.metadata.MDLocation;
import com.oracle.truffle.llvm.parser.metadata.MDMacro;
import com.oracle.truffle.llvm.parser.metadata.MDMacroFile;
import com.oracle.truffle.llvm.parser.metadata.MDModule;
import com.oracle.truffle.llvm.parser.metadata.MDNamedNode;
import com.oracle.truffle.llvm.parser.metadata.MDNamespace;
import com.oracle.truffle.llvm.parser.metadata.MDNode;
import com.oracle.truffle.llvm.parser.metadata.MDObjCProperty;
import com.oracle.truffle.llvm.parser.metadata.MDString;
import com.oracle.truffle.llvm.parser.metadata.MDSubprogram;
import com.oracle.truffle.llvm.parser.metadata.MDSubrange;
import com.oracle.truffle.llvm.parser.metadata.MDSubroutine;
import com.oracle.truffle.llvm.parser.metadata.MDTemplateType;
import com.oracle.truffle.llvm.parser.metadata.MDTemplateTypeParameter;
import com.oracle.truffle.llvm.parser.metadata.MDTemplateValue;
import com.oracle.truffle.llvm.parser.metadata.MDValue;
import com.oracle.truffle.llvm.parser.metadata.MetadataValueList;
import com.oracle.truffle.llvm.parser.metadata.ParseUtil;
import com.oracle.truffle.llvm.parser.model.IRScope;
import com.oracle.truffle.llvm.parser.records.DwTagRecord;
import com.oracle.truffle.llvm.parser.scanner.RecordBuffer;
import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import com.oracle.truffle.llvm.runtime.types.Type;
import java.util.HashSet;
import java.util.Set;

public class Metadata
implements ParserListener {
    private static final int METADATA_STRING = 1;
    private static final int METADATA_VALUE = 2;
    private static final int METADATA_NODE = 3;
    private static final int METADATA_NAME = 4;
    private static final int METADATA_DISTINCT_NODE = 5;
    private static final int METADATA_KIND = 6;
    private static final int METADATA_LOCATION = 7;
    private static final int METADATA_OLD_NODE = 8;
    private static final int METADATA_OLD_FN_NODE = 9;
    private static final int METADATA_NAMED_NODE = 10;
    private static final int METADATA_ATTACHMENT = 11;
    private static final int METADATA_GENERIC_DEBUG = 12;
    private static final int METADATA_SUBRANGE = 13;
    private static final int METADATA_ENUMERATOR = 14;
    private static final int METADATA_BASIC_TYPE = 15;
    private static final int METADATA_FILE = 16;
    private static final int METADATA_DERIVED_TYPE = 17;
    private static final int METADATA_COMPOSITE_TYPE = 18;
    private static final int METADATA_SUBROUTINE_TYPE = 19;
    private static final int METADATA_COMPILE_UNIT = 20;
    protected static final int METADATA_SUBPROGRAM = 21;
    private static final int METADATA_LEXICAL_BLOCK = 22;
    private static final int METADATA_LEXICAL_BLOCK_FILE = 23;
    private static final int METADATA_NAMESPACE = 24;
    private static final int METADATA_TEMPLATE_TYPE = 25;
    private static final int METADATA_TEMPLATE_VALUE = 26;
    private static final int METADATA_GLOBAL_VAR = 27;
    private static final int METADATA_LOCAL_VAR = 28;
    private static final int METADATA_EXPRESSION = 29;
    private static final int METADATA_OBJC_PROPERTY = 30;
    private static final int METADATA_IMPORTED_ENTITY = 31;
    private static final int METADATA_MODULE = 32;
    private static final int METADATA_MACRO = 33;
    private static final int METADATA_MACRO_FILE = 34;
    private static final int METADATA_STRINGS = 35;
    private static final int METADATA_GLOBAL_DECL_ATTACHMENT = 36;
    private static final int METADATA_GLOBAL_VAR_EXPR = 37;
    private static final int METADATA_INDEX_OFFSET = 38;
    private static final int METADATA_INDEX = 39;
    private static final int METADATA_LABEL = 40;
    private static final int METADATA_COMMON_BLOCK = 44;
    protected final IRScope scope;
    private final Set<MDCompositeType> compositeTypes;
    protected final Types types;
    protected final MetadataValueList metadata;
    private String lastParsedName = null;
    private static final int ARGINDEX_IDENT = 0;
    private static final int LEXICALBLOCK_DISTINCTOR_ARGINDEX = 2;

    public Type getTypeById(long id) {
        return this.types.get(id);
    }

    public IRScope getScope() {
        return this.scope;
    }

    Metadata(Types types, IRScope scope) {
        this.types = types;
        this.scope = scope;
        this.metadata = scope.getMetadata();
        this.compositeTypes = new HashSet<MDCompositeType>();
    }

    @Override
    public void record(RecordBuffer buffer) {
        long[] args = buffer.dumpArray();
        int opCode = buffer.getId();
        this.parseOpcode(buffer, args, opCode);
    }

    protected void parseOpcode(RecordBuffer buffer, long[] args, int opCode) {
        switch (opCode) {
            case 1: {
                this.metadata.add(MDString.create(buffer));
                break;
            }
            case 2: {
                buffer.skip();
                this.metadata.add(MDValue.create(buffer.read(), this.scope));
                break;
            }
            case 3: 
            case 5: {
                this.metadata.add(MDNode.create38(buffer, this.metadata));
                break;
            }
            case 4: {
                this.lastParsedName = buffer.readUnicodeString();
                break;
            }
            case 6: {
                this.metadata.addKind(MDKind.create(buffer.read(), buffer.readUnicodeString()));
                break;
            }
            case 7: {
                this.metadata.add(MDLocation.create38(buffer, this.metadata));
                break;
            }
            case 8: {
                this.createOldNode(buffer);
                break;
            }
            case 9: {
                buffer.skip();
                this.metadata.add(MDValue.create(buffer.read(), this.scope));
                break;
            }
            case 10: {
                this.createNamedNode(buffer);
                break;
            }
            case 11: {
                this.createAttachment(buffer, false);
                break;
            }
            case 12: {
                this.metadata.add(MDGenericDebug.create38(buffer, this.metadata));
                break;
            }
            case 13: {
                this.metadata.add(MDSubrange.createNewFormat(buffer, this.metadata));
                break;
            }
            case 14: {
                this.metadata.add(MDEnumerator.create38(args, this.metadata));
                break;
            }
            case 15: {
                this.metadata.add(MDBasicType.create38(args, this.metadata));
                break;
            }
            case 16: {
                this.metadata.add(MDFile.create38(args, this.metadata));
                break;
            }
            case 21: {
                this.metadata.add(MDSubprogram.createNewFormat(args, this.metadata));
                break;
            }
            case 19: {
                this.metadata.add(MDSubroutine.create38(args, this.metadata));
                break;
            }
            case 22: {
                this.metadata.add(MDLexicalBlock.create38(args, this.metadata));
                break;
            }
            case 23: {
                this.metadata.add(MDLexicalBlockFile.create38(args, this.metadata));
                break;
            }
            case 28: {
                MDLocalVariable md = MDLocalVariable.create38(args, this.metadata);
                this.metadata.add(md);
                this.metadata.registerLocal(md);
                break;
            }
            case 24: {
                MDNamespace namespace = MDNamespace.create38(args, this.metadata);
                this.metadata.registerExportedScope(namespace);
                this.metadata.add(namespace);
                break;
            }
            case 27: {
                this.metadata.add(MDGlobalVariable.create38(args, this.metadata));
                break;
            }
            case 17: {
                this.metadata.add(MDDerivedType.create38(args, this.metadata));
                break;
            }
            case 18: {
                MDCompositeType type = MDCompositeType.create38(args, this.metadata);
                this.metadata.add(type);
                this.compositeTypes.add(type);
                break;
            }
            case 20: {
                this.metadata.add(MDCompileUnit.create38(args, this.metadata));
                break;
            }
            case 25: {
                this.metadata.add(MDTemplateType.create38(args, this.metadata));
                break;
            }
            case 26: {
                this.metadata.add(MDTemplateValue.create38(args, this.metadata));
                break;
            }
            case 29: {
                this.metadata.add(MDExpression.create(args));
                break;
            }
            case 30: {
                this.metadata.add(MDObjCProperty.create38(args, this.metadata));
                break;
            }
            case 31: {
                this.metadata.add(MDImportedEntity.create38(args, this.metadata));
                break;
            }
            case 32: {
                MDModule module = MDModule.create38(args, this.metadata);
                this.metadata.registerExportedScope(module);
                this.metadata.add(module);
                break;
            }
            case 33: {
                this.metadata.add(MDMacro.create38(args, this.metadata));
                break;
            }
            case 34: {
                this.metadata.add(MDMacroFile.create38(args, this.metadata));
                break;
            }
            case 35: {
                MDString[] strings;
                for (MDString string : strings = MDString.createFromBlob(args)) {
                    this.metadata.add(string);
                }
                break;
            }
            case 37: {
                this.metadata.add(MDGlobalVariableExpression.create(args, this.metadata));
                break;
            }
            case 36: {
                this.createAttachment(buffer, true);
                break;
            }
            case 44: {
                this.metadata.add(MDCommonBlock.create(args, this.metadata));
                break;
            }
            case 40: {
                this.metadata.add(MDLabel.create(args, this.metadata));
                break;
            }
            case 38: 
            case 39: {
                break;
            }
            default: {
                this.metadata.add(null);
                throw new LLVMParserException("Unsupported opCode in metadata block: " + opCode);
            }
        }
    }

    private void createNamedNode(RecordBuffer buffer) {
        if (this.lastParsedName != null) {
            this.metadata.addNamedNode(MDNamedNode.create(this.lastParsedName, buffer.dumpArray(), this.metadata));
            this.lastParsedName = null;
        }
    }

    private void createAttachment(RecordBuffer buffer, boolean isGlobal) {
        long[] args = buffer.dumpArray();
        if (args.length > 0) {
            int offset = args.length % 2;
            int targetIndex = (int)args[0];
            for (int i = offset; i < args.length; i += 2) {
                MDKind kind = this.metadata.getKind(args[i]);
                MDAttachment attachment = MDAttachment.create(kind, args[i + 1], this.metadata);
                if (isGlobal) {
                    this.scope.attachGlobalMetadata(targetIndex, attachment);
                    continue;
                }
                if (offset == 0) {
                    this.scope.attachFunctionMetadata(attachment);
                    continue;
                }
                this.scope.attachInstructionMetadata(targetIndex, attachment);
            }
        }
    }

    private void createOldNode(RecordBuffer buffer) {
        long[] args = buffer.dumpArray();
        if (ParseUtil.isInteger(args, 0, this) && DwTagRecord.isDwarfDescriptor(ParseUtil.asLong(args, 0, this))) {
            int ident = ParseUtil.asInt(args, 0, this);
            DwTagRecord record = DwTagRecord.decode(ident);
            switch (record) {
                case DW_TAG_COMPILE_UNIT: {
                    this.metadata.add(MDCompileUnit.create32(args, this));
                    break;
                }
                case DW_TAG_FILE_TYPE: {
                    this.metadata.add(MDFile.create32(args, this));
                    break;
                }
                case DW_TAG_CONSTANT: 
                case DW_TAG_VARIABLE: {
                    this.metadata.add(MDGlobalVariable.create32(args, this));
                    break;
                }
                case DW_TAG_SUBPROGRAM: {
                    this.metadata.add(MDSubprogram.create32(args, this));
                    break;
                }
                case DW_TAG_LEXICAL_BLOCK: {
                    this.metadata.add(this.createLexicalBlock(args));
                    break;
                }
                case DW_TAG_BASE_TYPE: {
                    this.metadata.add(MDBasicType.create32(args, this));
                    break;
                }
                case DW_TAG_FORMAL_PARAMETER: 
                case DW_TAG_MEMBER: 
                case DW_TAG_POINTER_TYPE: 
                case DW_TAG_REFERENCE_TYPE: 
                case DW_TAG_TYPEDEF: 
                case DW_TAG_CONST_TYPE: 
                case DW_TAG_VOLATILE_TYPE: 
                case DW_TAG_RESTRICT_TYPE: 
                case DW_TAG_FRIEND: {
                    this.metadata.add(MDDerivedType.create32(args, this));
                    break;
                }
                case DW_TAG_CLASS_TYPE: 
                case DW_TAG_ARRAY_TYPE: 
                case DW_TAG_ENUMERATION_TYPE: 
                case DW_TAG_STRUCTURE_TYPE: 
                case DW_TAG_UNION_TYPE: 
                case DW_TAG_VECTOR_TYPE: 
                case DW_TAG_INHERITANCE: 
                case DW_TAG_SUBROUTINE_TYPE: {
                    MDCompositeType type = MDCompositeType.create32(args, this);
                    this.metadata.add(type);
                    this.compositeTypes.add(type);
                    break;
                }
                case DW_TAG_SUBRANGE_TYPE: {
                    this.metadata.add(MDSubrange.createOldFormat(args, this));
                    break;
                }
                case DW_TAG_ENUMERATOR: {
                    this.metadata.add(MDEnumerator.create32(args, this));
                    break;
                }
                case DW_TAG_AUTO_VARIABLE: 
                case DW_TAG_ARG_VARIABLE: 
                case DW_TAG_RETURN_VARIABLE: {
                    MDLocalVariable md = MDLocalVariable.create32(args, this);
                    this.metadata.registerLocal(md);
                    this.metadata.add(md);
                    break;
                }
                case DW_TAG_UNKNOWN: {
                    this.metadata.add(MDNode.create32(args, this));
                    break;
                }
                case DW_TAG_TEMPLATE_TYPE_PARAMETER: {
                    this.metadata.add(MDTemplateTypeParameter.create32(args, this));
                    break;
                }
                case DW_TAG_TEMPLATE_VALUE_PARAMETER: {
                    this.metadata.add(MDTemplateValue.create32(args, this));
                    break;
                }
                case DW_TAG_NAMESPACE: {
                    this.metadata.add(MDNamespace.create32(args, this));
                    break;
                }
                default: {
                    this.metadata.add(MDNode.create32(args, this));
                    break;
                }
            }
        } else {
            this.metadata.add(MDNode.create32(args, this));
        }
    }

    private MDBaseNode createLexicalBlock(long[] args) {
        if (ParseUtil.isInteger(args, 2, this)) {
            return MDLexicalBlock.create32(args, this);
        }
        return MDLexicalBlockFile.create32(args, this);
    }

    @Override
    public void exit() {
        for (MDCompositeType type : this.compositeTypes) {
            String identifier = MDString.getIfInstance(type.getIdentifier());
            this.metadata.registerType(identifier, type);
        }
    }
}

