/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.factories;

import com.oracle.truffle.llvm.parser.factories.BasicPlatformCapability;
import com.oracle.truffle.llvm.runtime.memory.LLVMSyscallOperationNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.syscall.LLVMAMD64SyscallArchPrctlNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.asm.syscall.LLVMAMD64SyscallBrkNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.asm.syscall.LLVMAMD64SyscallClockGetTimeNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.asm.syscall.LLVMAMD64SyscallFutexNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.asm.syscall.LLVMAMD64SyscallGetcwdNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.asm.syscall.LLVMAMD64SyscallMmapNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.asm.syscall.LLVMAMD64SyscallRtSigactionNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.asm.syscall.LLVMAMD64SyscallRtSigprocmaskNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.asm.syscall.LLVMAMD64SyscallSetTidAddressNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.asm.syscall.LLVMSyscallExitNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.syscall.LLVMUnknownSyscallNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.syscall.linux.amd64.LinuxAMD64Syscall;

final class LinuxAMD64PlatformCapability
extends BasicPlatformCapability<LinuxAMD64Syscall> {
    LinuxAMD64PlatformCapability(boolean loadCxxLibraries) {
        super(LinuxAMD64Syscall.class, loadCxxLibraries);
    }

    @Override
    protected LLVMSyscallOperationNode createSyscallNode(LinuxAMD64Syscall syscall) {
        switch (syscall) {
            case SYS_mmap: {
                return LLVMAMD64SyscallMmapNodeGen.create();
            }
            case SYS_brk: {
                return LLVMAMD64SyscallBrkNodeGen.create();
            }
            case SYS_rt_sigaction: {
                return LLVMAMD64SyscallRtSigactionNodeGen.create();
            }
            case SYS_rt_sigprocmask: {
                return LLVMAMD64SyscallRtSigprocmaskNodeGen.create();
            }
            case SYS_exit: 
            case SYS_exit_group: {
                return new LLVMSyscallExitNode();
            }
            case SYS_getcwd: {
                return LLVMAMD64SyscallGetcwdNodeGen.create();
            }
            case SYS_arch_prctl: {
                return LLVMAMD64SyscallArchPrctlNodeGen.create();
            }
            case SYS_futex: {
                return LLVMAMD64SyscallFutexNodeGen.create();
            }
            case SYS_set_tid_address: {
                return LLVMAMD64SyscallSetTidAddressNodeGen.create();
            }
            case SYS_clock_gettime: {
                return LLVMAMD64SyscallClockGetTimeNodeGen.create();
            }
        }
        return new LLVMUnknownSyscallNode(syscall);
    }
}

