/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.factories;

import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.nodes.RepeatingNode;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.llvm.asm.amd64.AsmParseException;
import com.oracle.truffle.llvm.asm.amd64.InlineAssemblyParser;
import com.oracle.truffle.llvm.parser.model.attributes.Attribute;
import com.oracle.truffle.llvm.parser.model.attributes.AttributesGroup;
import com.oracle.truffle.llvm.parser.model.functions.FunctionDeclaration;
import com.oracle.truffle.llvm.runtime.ArithmeticOperation;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.ExternalLibrary;
import com.oracle.truffle.llvm.runtime.GetStackSpaceFactory;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMFunctionCode;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LLVMIntrinsicProvider;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.LLVMUnsupportedException;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.UnaryOperation;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.except.LLVMAllocationFailureException;
import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import com.oracle.truffle.llvm.runtime.except.LLVMStackOverflowError;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;
import com.oracle.truffle.llvm.runtime.memory.LLVMAllocateNode;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemMoveNode;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemSetNode;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemoryOpNode;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.memory.LLVMUniquesRegionAllocNode;
import com.oracle.truffle.llvm.runtime.memory.LLVMUniquesRegionAllocNodeGen;
import com.oracle.truffle.llvm.runtime.memory.VarargsAreaStackAllocationNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMControlFlowNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMLazyException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import com.oracle.truffle.llvm.runtime.nodes.base.LLVMBasicBlockNode;
import com.oracle.truffle.llvm.runtime.nodes.cast.LLVMTo80BitFloatingNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.cast.LLVMToDoubleNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMBrUnconditionalNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMConditionalBranchNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMDispatchBasicBlockNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMDispatchBasicBlockNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMFunctionRootNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMFunctionRootNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMIndirectBranchNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMLoopDispatchNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMLoopNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMRetNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMSwitchNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMWritePhisNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMArgNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMArgNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMCallNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMFunctionStartNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMInlineAssemblyRootNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMInvokeNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMLandingpadNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMLandingpadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMResumeNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMTypeIdForExceptionNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.c.LLVMCMathsIntrinsicsFactory;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMTruffleGetArgCountNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMTruffleGetArgNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMAssumeNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMByteSwapFactory;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMExpectFactory;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMFrameAddressNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMI64ObjectSizeNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMInvariantEndNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMInvariantStartNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMIsConstantNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMLifetimeEndNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMLifetimeStartNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMMemCopyNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMMemMoveFactory;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMMemSetNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMMemoryIntrinsicFactory;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMNoOpNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMPrefetchNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMReturnAddressNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMStackRestoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMStackSaveNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMTrapNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.arith.LLVMArithmetic;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.arith.LLVMArithmeticFactory;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.bit.CountLeadingZeroesNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.bit.CountSetBitsNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.bit.CountTrailingZeroesNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.x86.LLVMX86_64BitVACopyNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.x86.LLVMX86_64BitVAEndNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.x86.LLVMX86_64VAStartNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.x86.LLVMX86_ComparisonNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.x86.LLVMX86_ConversionNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.x86.LLVMX86_MissingBuiltin;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.x86.LLVMX86_VectorMathNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.literals.LLVMSimpleLiteralNode;
import com.oracle.truffle.llvm.runtime.nodes.literals.LLVMSimpleLiteralNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.literals.LLVMVectorLiteralNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.memory.AllocateGlobalsBlockNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.AllocateReadOnlyGlobalsBlockNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.FreeReadOnlyGlobalsBlockNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMCompareExchangeNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMFenceNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMGetElementPtrNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMGetStackSpaceInstruction;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMGetStackSpaceInstructionFactory;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMInsertValueNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMNativeVarargsAreaStackAllocationNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMStructByValueNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMVarArgCompoundAddressNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMVectorizedGetElementPtrNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.NativeMemSetNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.NativeProfiledMemMoveNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.ProtectReadOnlyGlobalsBlockNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.literal.LLVMArrayLiteralNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.literal.LLVMArrayLiteralNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.literal.LLVMStructArrayLiteralNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDirectLoadNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDoubleLoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMFloatLoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI16LoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI1LoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI32LoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI64LoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI8LoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMLoadVectorNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.memory.rmw.LLVMI16RMWNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.memory.rmw.LLVMI1RMWNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.memory.rmw.LLVMI32RMWNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.memory.rmw.LLVMI64RMWNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.memory.rmw.LLVMI8RMWNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVM80BitFloatStoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMDoubleStoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMFloatStoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI16StoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI1StoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI32StoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI64StoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI8StoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMIVarBitStoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMPointerStoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMStoreNodeCommon;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMStoreVectorNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMStructStoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMArithmeticNode;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMArithmeticNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMUnaryNode;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMUnaryNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMVectorArithmeticNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMVectorUnaryNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMAccessSymbolNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMSelectNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMUnreachableNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMUnsupportedInstructionNode;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMValueProfilingNode;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMVectorSelectNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.vars.LLVMWriteNode;
import com.oracle.truffle.llvm.runtime.nodes.vars.LLVMWriteNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.vars.StructLiteralNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.vector.LLVMExtractElementNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.vector.LLVMInsertElementNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.vector.LLVMShuffleVectorNodeFactory;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.types.AggregateType;
import com.oracle.truffle.llvm.runtime.types.ArrayType;
import com.oracle.truffle.llvm.runtime.types.FunctionType;
import com.oracle.truffle.llvm.runtime.types.MetaType;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.StructureType;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.types.VariableBitWidthType;
import com.oracle.truffle.llvm.runtime.types.VectorType;
import com.oracle.truffle.llvm.runtime.types.symbols.LocalVariableDebugInfo;
import com.oracle.truffle.llvm.runtime.types.symbols.Symbol;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BasicNodeFactory
implements NodeFactory {
    protected final LLVMContext context;
    protected DataLayout dataLayout;
    private static final Pattern INTRINSIC_TYPE_SUFFIX_PATTERN = Pattern.compile("\\S+(?<suffix>\\.(?:[vp]\\d+)?[if]\\d+)$");

    public BasicNodeFactory(LLVMContext context, DataLayout dataLayout) {
        this.context = context;
        this.dataLayout = dataLayout;
    }

    @Override
    public LLVMExpressionNode createInsertElement(Type resultType, LLVMExpressionNode vector, LLVMExpressionNode element, LLVMExpressionNode index) {
        VectorType vectorType = (VectorType)resultType;
        int vectorLength = vectorType.getNumberOfElementsInt();
        if (vectorType.getElementType() instanceof PrimitiveType) {
            switch (((PrimitiveType)vectorType.getElementType()).getPrimitiveKind()) {
                case I1: {
                    return LLVMInsertElementNodeFactory.LLVMI1InsertElementNodeGen.create(vector, element, index, vectorLength);
                }
                case I8: {
                    return LLVMInsertElementNodeFactory.LLVMI8InsertElementNodeGen.create(vector, element, index, vectorLength);
                }
                case I16: {
                    return LLVMInsertElementNodeFactory.LLVMI16InsertElementNodeGen.create(vector, element, index, vectorLength);
                }
                case I32: {
                    return LLVMInsertElementNodeFactory.LLVMI32InsertElementNodeGen.create(vector, element, index, vectorLength);
                }
                case I64: {
                    return LLVMInsertElementNodeFactory.LLVMI64InsertElementNodeGen.create(vector, element, index, vectorLength);
                }
                case FLOAT: {
                    return LLVMInsertElementNodeFactory.LLVMFloatInsertElementNodeGen.create(vector, element, index, vectorLength);
                }
                case DOUBLE: {
                    return LLVMInsertElementNodeFactory.LLVMDoubleInsertElementNodeGen.create(vector, element, index, vectorLength);
                }
            }
            throw new AssertionError((Object)("vector type " + vectorType + "  is not supported for insertelement"));
        }
        if (vectorType.getElementType() instanceof PointerType || vectorType.getElementType() instanceof FunctionType) {
            return LLVMInsertElementNodeFactory.LLVMI64InsertElementNodeGen.create(vector, element, index, vectorLength);
        }
        throw new AssertionError((Object)("vector type " + vectorType + "  is not supported for insertelement"));
    }

    @Override
    public LLVMExpressionNode createExtractElement(Type resultType, LLVMExpressionNode vector, LLVMExpressionNode index) {
        if (resultType instanceof PrimitiveType) {
            PrimitiveType resultType1 = (PrimitiveType)resultType;
            switch (resultType1.getPrimitiveKind()) {
                case I1: {
                    return LLVMExtractElementNodeFactory.LLVMI1ExtractElementNodeGen.create(vector, index);
                }
                case I8: {
                    return LLVMExtractElementNodeFactory.LLVMI8ExtractElementNodeGen.create(vector, index);
                }
                case I16: {
                    return LLVMExtractElementNodeFactory.LLVMI16ExtractElementNodeGen.create(vector, index);
                }
                case I32: {
                    return LLVMExtractElementNodeFactory.LLVMI32ExtractElementNodeGen.create(vector, index);
                }
                case I64: {
                    return LLVMExtractElementNodeFactory.LLVMI64ExtractElementNodeGen.create(vector, index);
                }
                case FLOAT: {
                    return LLVMExtractElementNodeFactory.LLVMFloatExtractElementNodeGen.create(vector, index);
                }
                case DOUBLE: {
                    return LLVMExtractElementNodeFactory.LLVMDoubleExtractElementNodeGen.create(vector, index);
                }
            }
            throw new AssertionError((Object)(resultType1 + " is not supported for extractelement"));
        }
        if (resultType instanceof PointerType || resultType instanceof FunctionType) {
            return LLVMExtractElementNodeFactory.LLVMI64ExtractElementNodeGen.create(vector, index);
        }
        throw new AssertionError((Object)(resultType + " is not supported for extractelement"));
    }

    @Override
    public LLVMExpressionNode createShuffleVector(Type llvmType, LLVMExpressionNode vector1, LLVMExpressionNode vector2, LLVMExpressionNode mask) {
        VectorType resultType = (VectorType)llvmType;
        int resultLength = resultType.getNumberOfElementsInt();
        if (resultType.getElementType() instanceof PrimitiveType) {
            switch (((PrimitiveType)resultType.getElementType()).getPrimitiveKind()) {
                case I1: {
                    return LLVMShuffleVectorNodeFactory.LLVMShuffleI1VectorNodeGen.create(vector1, vector2, mask, resultLength);
                }
                case I8: {
                    return LLVMShuffleVectorNodeFactory.LLVMShuffleI8VectorNodeGen.create(vector1, vector2, mask, resultLength);
                }
                case I16: {
                    return LLVMShuffleVectorNodeFactory.LLVMShuffleI16VectorNodeGen.create(vector1, vector2, mask, resultLength);
                }
                case I32: {
                    return LLVMShuffleVectorNodeFactory.LLVMShuffleI32VectorNodeGen.create(vector1, vector2, mask, resultLength);
                }
                case I64: {
                    return LLVMShuffleVectorNodeFactory.LLVMShuffleI64VectorNodeGen.create(vector1, vector2, mask, resultLength);
                }
                case FLOAT: {
                    return LLVMShuffleVectorNodeFactory.LLVMShuffleFloatVectorNodeGen.create(vector1, vector2, mask, resultLength);
                }
                case DOUBLE: {
                    return LLVMShuffleVectorNodeFactory.LLVMShuffleDoubleVectorNodeGen.create(vector1, vector2, mask, resultLength);
                }
            }
            throw new AssertionError((Object)(resultType + " is not supported for shufflevector"));
        }
        if (resultType.getElementType() instanceof PointerType || resultType.getElementType() instanceof FunctionType) {
            return LLVMShuffleVectorNodeFactory.LLVMShuffleI64VectorNodeGen.create(vector1, vector2, mask, resultLength);
        }
        throw new AssertionError((Object)(resultType + " is not supported for shufflevector"));
    }

    @Override
    public LLVMStatementNode createStore(LLVMExpressionNode pointerNode, LLVMExpressionNode valueNode, Type type) {
        try {
            return this.createStore(pointerNode, valueNode, type, this.getByteSize(type));
        }
        catch (Type.TypeOverflowException e) {
            return Type.handleOverflowStatement(e);
        }
    }

    @Override
    public LLVMExpressionNode createRMWXchg(LLVMExpressionNode pointerNode, LLVMExpressionNode valueNode, Type type) {
        switch (((PrimitiveType)type).getPrimitiveKind()) {
            case I1: {
                return LLVMI1RMWNodeFactory.LLVMI1RMWXchgNodeGen.create(pointerNode, valueNode);
            }
            case I8: {
                return LLVMI8RMWNodeFactory.LLVMI8RMWXchgNodeGen.create(pointerNode, valueNode);
            }
            case I16: {
                return LLVMI16RMWNodeFactory.LLVMI16RMWXchgNodeGen.create(pointerNode, valueNode);
            }
            case I32: {
                return LLVMI32RMWNodeFactory.LLVMI32RMWXchgNodeGen.create(pointerNode, valueNode);
            }
            case I64: {
                return LLVMI64RMWNodeFactory.LLVMI64RMWXchgNodeGen.create(pointerNode, valueNode);
            }
        }
        throw new AssertionError((Object)("unsupported for atomicrmw xchg: " + type));
    }

    @Override
    public LLVMExpressionNode createRMWAdd(LLVMExpressionNode pointerNode, LLVMExpressionNode valueNode, Type type) {
        switch (((PrimitiveType)type).getPrimitiveKind()) {
            case I1: {
                return LLVMI1RMWNodeFactory.LLVMI1RMWAddNodeGen.create(pointerNode, valueNode);
            }
            case I8: {
                return LLVMI8RMWNodeFactory.LLVMI8RMWAddNodeGen.create(pointerNode, valueNode);
            }
            case I16: {
                return LLVMI16RMWNodeFactory.LLVMI16RMWAddNodeGen.create(pointerNode, valueNode);
            }
            case I32: {
                return LLVMI32RMWNodeFactory.LLVMI32RMWAddNodeGen.create(pointerNode, valueNode);
            }
            case I64: {
                return LLVMI64RMWNodeFactory.LLVMI64RMWAddNodeGen.create(pointerNode, valueNode);
            }
        }
        throw new AssertionError((Object)("unsupported add atomicrmw xchg: " + type));
    }

    @Override
    public LLVMExpressionNode createRMWSub(LLVMExpressionNode pointerNode, LLVMExpressionNode valueNode, Type type) {
        switch (((PrimitiveType)type).getPrimitiveKind()) {
            case I1: {
                return LLVMI1RMWNodeFactory.LLVMI1RMWSubNodeGen.create(pointerNode, valueNode);
            }
            case I8: {
                return LLVMI8RMWNodeFactory.LLVMI8RMWSubNodeGen.create(pointerNode, valueNode);
            }
            case I16: {
                return LLVMI16RMWNodeFactory.LLVMI16RMWSubNodeGen.create(pointerNode, valueNode);
            }
            case I32: {
                return LLVMI32RMWNodeFactory.LLVMI32RMWSubNodeGen.create(pointerNode, valueNode);
            }
            case I64: {
                return LLVMI64RMWNodeFactory.LLVMI64RMWSubNodeGen.create(pointerNode, valueNode);
            }
        }
        throw new AssertionError((Object)("unsupported sub atomicrmw xchg: " + type));
    }

    @Override
    public LLVMExpressionNode createRMWAnd(LLVMExpressionNode pointerNode, LLVMExpressionNode valueNode, Type type) {
        switch (((PrimitiveType)type).getPrimitiveKind()) {
            case I1: {
                return LLVMI1RMWNodeFactory.LLVMI1RMWAndNodeGen.create(pointerNode, valueNode);
            }
            case I8: {
                return LLVMI8RMWNodeFactory.LLVMI8RMWAndNodeGen.create(pointerNode, valueNode);
            }
            case I16: {
                return LLVMI16RMWNodeFactory.LLVMI16RMWAndNodeGen.create(pointerNode, valueNode);
            }
            case I32: {
                return LLVMI32RMWNodeFactory.LLVMI32RMWAndNodeGen.create(pointerNode, valueNode);
            }
            case I64: {
                return LLVMI64RMWNodeFactory.LLVMI64RMWAndNodeGen.create(pointerNode, valueNode);
            }
        }
        throw new AssertionError((Object)("unsupported for atomicrmw and: " + type));
    }

    @Override
    public LLVMExpressionNode createRMWNand(LLVMExpressionNode pointerNode, LLVMExpressionNode valueNode, Type type) {
        switch (((PrimitiveType)type).getPrimitiveKind()) {
            case I1: {
                return LLVMI1RMWNodeFactory.LLVMI1RMWNandNodeGen.create(pointerNode, valueNode);
            }
            case I8: {
                return LLVMI8RMWNodeFactory.LLVMI8RMWNandNodeGen.create(pointerNode, valueNode);
            }
            case I16: {
                return LLVMI16RMWNodeFactory.LLVMI16RMWNandNodeGen.create(pointerNode, valueNode);
            }
            case I32: {
                return LLVMI32RMWNodeFactory.LLVMI32RMWNandNodeGen.create(pointerNode, valueNode);
            }
            case I64: {
                return LLVMI64RMWNodeFactory.LLVMI64RMWNandNodeGen.create(pointerNode, valueNode);
            }
        }
        throw new AssertionError((Object)("unsupported for atomicrmw nand: " + type));
    }

    @Override
    public LLVMExpressionNode createRMWOr(LLVMExpressionNode pointerNode, LLVMExpressionNode valueNode, Type type) {
        switch (((PrimitiveType)type).getPrimitiveKind()) {
            case I1: {
                return LLVMI1RMWNodeFactory.LLVMI1RMWOrNodeGen.create(pointerNode, valueNode);
            }
            case I8: {
                return LLVMI8RMWNodeFactory.LLVMI8RMWOrNodeGen.create(pointerNode, valueNode);
            }
            case I16: {
                return LLVMI16RMWNodeFactory.LLVMI16RMWOrNodeGen.create(pointerNode, valueNode);
            }
            case I32: {
                return LLVMI32RMWNodeFactory.LLVMI32RMWOrNodeGen.create(pointerNode, valueNode);
            }
            case I64: {
                return LLVMI64RMWNodeFactory.LLVMI64RMWOrNodeGen.create(pointerNode, valueNode);
            }
        }
        throw new AssertionError((Object)("unsupported for atomicrmw or: " + type));
    }

    @Override
    public LLVMExpressionNode createRMWXor(LLVMExpressionNode pointerNode, LLVMExpressionNode valueNode, Type type) {
        switch (((PrimitiveType)type).getPrimitiveKind()) {
            case I1: {
                return LLVMI1RMWNodeFactory.LLVMI1RMWXorNodeGen.create(pointerNode, valueNode);
            }
            case I8: {
                return LLVMI8RMWNodeFactory.LLVMI8RMWXorNodeGen.create(pointerNode, valueNode);
            }
            case I16: {
                return LLVMI16RMWNodeFactory.LLVMI16RMWXorNodeGen.create(pointerNode, valueNode);
            }
            case I32: {
                return LLVMI32RMWNodeFactory.LLVMI32RMWXorNodeGen.create(pointerNode, valueNode);
            }
            case I64: {
                return LLVMI64RMWNodeFactory.LLVMI64RMWXorNodeGen.create(pointerNode, valueNode);
            }
        }
        throw new AssertionError((Object)("unsupported for atomicrmw xor: " + type));
    }

    @Override
    public LLVMStatementNode createFence() {
        return LLVMFenceNodeGen.create();
    }

    @Override
    public LLVMExpressionNode createVectorLiteralNode(List<LLVMExpressionNode> listValues, Type type) {
        LLVMExpressionNode[] vals = listValues.toArray(LLVMExpressionNode.NO_EXPRESSIONS);
        Type llvmType = ((VectorType)type).getElementType();
        if (llvmType instanceof PrimitiveType) {
            switch (((PrimitiveType)llvmType).getPrimitiveKind()) {
                case I1: {
                    return LLVMVectorLiteralNodeFactory.LLVMI1VectorLiteralNodeGen.create(vals);
                }
                case I8: {
                    return LLVMVectorLiteralNodeFactory.LLVMI8VectorLiteralNodeGen.create(vals);
                }
                case I16: {
                    return LLVMVectorLiteralNodeFactory.LLVMI16VectorLiteralNodeGen.create(vals);
                }
                case I32: {
                    return LLVMVectorLiteralNodeFactory.LLVMI32VectorLiteralNodeGen.create(vals);
                }
                case I64: {
                    return LLVMVectorLiteralNodeFactory.LLVMI64VectorLiteralNodeGen.create(vals);
                }
                case FLOAT: {
                    return LLVMVectorLiteralNodeFactory.LLVMFloatVectorLiteralNodeGen.create(vals);
                }
                case DOUBLE: {
                    return LLVMVectorLiteralNodeFactory.LLVMDoubleVectorLiteralNodeGen.create(vals);
                }
            }
            throw new AssertionError();
        }
        if (llvmType instanceof PointerType || llvmType instanceof FunctionType) {
            return LLVMVectorLiteralNodeFactory.LLVMPointerVectorLiteralNodeGen.create(vals);
        }
        throw new AssertionError((Object)(llvmType + " not yet supported"));
    }

    @Override
    public LLVMControlFlowNode createRetVoid() {
        return LLVMRetNodeFactory.LLVMVoidReturnNodeGen.create();
    }

    @Override
    public LLVMControlFlowNode createNonVoidRet(LLVMExpressionNode retValue, Type type) {
        if (retValue == null) {
            throw new AssertionError();
        }
        if (type instanceof VectorType) {
            return LLVMRetNodeFactory.LLVMVectorRetNodeGen.create(retValue);
        }
        if (type instanceof VariableBitWidthType) {
            return LLVMRetNodeFactory.LLVMIVarBitRetNodeGen.create(retValue);
        }
        if (type instanceof PointerType || type instanceof FunctionType) {
            return LLVMRetNodeFactory.LLVMAddressRetNodeGen.create(retValue);
        }
        if (type instanceof StructureType) {
            try {
                long size = this.getByteSize(type);
                return LLVMRetNodeFactory.LLVMStructRetNodeGen.create(this.createMemMove(), retValue, size);
            }
            catch (Type.TypeOverflowException e) {
                return LLVMRetNodeFactory.LLVMStructRetNodeGen.create(this.createMemMove(), Type.handleOverflowExpression(e), 0L);
            }
        }
        if (type instanceof PrimitiveType) {
            switch (((PrimitiveType)type).getPrimitiveKind()) {
                case I1: {
                    return LLVMRetNodeFactory.LLVMI1RetNodeGen.create(retValue);
                }
                case I8: {
                    return LLVMRetNodeFactory.LLVMI8RetNodeGen.create(retValue);
                }
                case I16: {
                    return LLVMRetNodeFactory.LLVMI16RetNodeGen.create(retValue);
                }
                case I32: {
                    return LLVMRetNodeFactory.LLVMI32RetNodeGen.create(retValue);
                }
                case I64: {
                    return LLVMRetNodeFactory.LLVMI64RetNodeGen.create(retValue);
                }
                case FLOAT: {
                    return LLVMRetNodeFactory.LLVMFloatRetNodeGen.create(retValue);
                }
                case DOUBLE: {
                    return LLVMRetNodeFactory.LLVMDoubleRetNodeGen.create(retValue);
                }
                case X86_FP80: {
                    return LLVMRetNodeFactory.LLVM80BitFloatRetNodeGen.create(retValue);
                }
            }
            throw new AssertionError(type);
        }
        throw new AssertionError(type);
    }

    @Override
    public LLVMExpressionNode createFunctionArgNode(int argIndex, Type paramType) {
        if (argIndex < 0) {
            throw new AssertionError();
        }
        LLVMArgNode argNode = LLVMArgNodeGen.create(argIndex);
        if (argIndex < 1) {
            return argNode;
        }
        return LLVMValueProfilingNode.create(argNode, paramType);
    }

    @Override
    public LLVMWriteNode createFrameWrite(Type llvmType, LLVMExpressionNode result, FrameSlot slot) {
        if (llvmType instanceof VectorType) {
            return LLVMWriteNodeFactory.LLVMWriteVectorNodeGen.create(slot, result);
        }
        if (llvmType instanceof PrimitiveType) {
            switch (((PrimitiveType)llvmType).getPrimitiveKind()) {
                case I1: {
                    return LLVMWriteNodeFactory.LLVMWriteI1NodeGen.create(slot, result);
                }
                case I8: {
                    return LLVMWriteNodeFactory.LLVMWriteI8NodeGen.create(slot, result);
                }
                case I16: {
                    return LLVMWriteNodeFactory.LLVMWriteI16NodeGen.create(slot, result);
                }
                case I32: {
                    return LLVMWriteNodeFactory.LLVMWriteI32NodeGen.create(slot, result);
                }
                case I64: {
                    return LLVMWriteNodeFactory.LLVMWriteI64NodeGen.create(slot, result);
                }
                case FLOAT: {
                    return LLVMWriteNodeFactory.LLVMWriteFloatNodeGen.create(slot, result);
                }
                case DOUBLE: {
                    return LLVMWriteNodeFactory.LLVMWriteDoubleNodeGen.create(slot, result);
                }
                case X86_FP80: {
                    return LLVMWriteNodeFactory.LLVMWrite80BitFloatingNodeGen.create(slot, result);
                }
            }
            throw new AssertionError(llvmType);
        }
        if (llvmType instanceof VariableBitWidthType) {
            return LLVMWriteNodeFactory.LLVMWriteIVarBitNodeGen.create(slot, result);
        }
        if (llvmType instanceof PointerType || llvmType instanceof FunctionType) {
            return LLVMWriteNodeFactory.LLVMWritePointerNodeGen.create(slot, result);
        }
        if (llvmType instanceof StructureType || llvmType instanceof ArrayType) {
            return LLVMWriteNodeFactory.LLVMWritePointerNodeGen.create(slot, result);
        }
        throw new AssertionError(llvmType);
    }

    @Override
    public LLVMLoadNode createExtractValue(Type type, LLVMExpressionNode targetAddress) {
        if (type instanceof PrimitiveType) {
            switch (((PrimitiveType)type).getPrimitiveKind()) {
                case I1: {
                    return LLVMI1LoadNodeGen.create(targetAddress);
                }
                case I8: {
                    return LLVMI8LoadNodeGen.create(targetAddress);
                }
                case I16: {
                    return LLVMI16LoadNodeGen.create(targetAddress);
                }
                case I32: {
                    return LLVMI32LoadNodeGen.create(targetAddress);
                }
                case I64: {
                    return LLVMI64LoadNodeGen.create(targetAddress);
                }
                case FLOAT: {
                    return LLVMFloatLoadNodeGen.create(targetAddress);
                }
                case DOUBLE: {
                    return LLVMDoubleLoadNodeGen.create(targetAddress);
                }
                case X86_FP80: {
                    return LLVMDirectLoadNodeFactory.LLVM80BitFloatDirectLoadNodeGen.create(targetAddress);
                }
            }
            throw new AssertionError(type);
        }
        if (type instanceof VectorType) {
            VectorType vectorType = (VectorType)type;
            int vectorLength = vectorType.getNumberOfElementsInt();
            Type elementType = vectorType.getElementType();
            if (elementType instanceof PrimitiveType) {
                switch (((PrimitiveType)elementType).getPrimitiveKind()) {
                    case I1: {
                        return LLVMLoadVectorNodeFactory.LLVMLoadI1VectorNodeGen.create(targetAddress, vectorLength);
                    }
                    case I8: {
                        return LLVMLoadVectorNodeFactory.LLVMLoadI8VectorNodeGen.create(targetAddress, vectorLength);
                    }
                    case I16: {
                        return LLVMLoadVectorNodeFactory.LLVMLoadI16VectorNodeGen.create(targetAddress, vectorLength);
                    }
                    case I32: {
                        return LLVMLoadVectorNodeFactory.LLVMLoadI32VectorNodeGen.create(targetAddress, vectorLength);
                    }
                    case I64: {
                        return LLVMLoadVectorNodeFactory.LLVMLoadI64VectorNodeGen.create(targetAddress, vectorLength);
                    }
                    case FLOAT: {
                        return LLVMLoadVectorNodeFactory.LLVMLoadFloatVectorNodeGen.create(targetAddress, vectorLength);
                    }
                    case DOUBLE: {
                        return LLVMLoadVectorNodeFactory.LLVMLoadDoubleVectorNodeGen.create(targetAddress, vectorLength);
                    }
                }
                throw new AssertionError(type);
            }
            if (elementType instanceof PointerType || elementType instanceof FunctionType) {
                return LLVMLoadVectorNodeFactory.LLVMLoadPointerVectorNodeGen.create(targetAddress, vectorLength);
            }
            throw new AssertionError(type);
        }
        if (type instanceof PointerType || type instanceof StructureType || type instanceof ArrayType) {
            return LLVMDirectLoadNodeFactory.LLVMPointerDirectLoadNodeGen.create(targetAddress);
        }
        throw new AssertionError((Object)(type + " is not supported for extractvalue"));
    }

    @Override
    public LLVMExpressionNode createTypedElementPointer(long indexedTypeLength, Type targetType, LLVMExpressionNode aggregateAddress, LLVMExpressionNode index) {
        return LLVMGetElementPtrNodeGen.create(indexedTypeLength, targetType, aggregateAddress, index);
    }

    @Override
    public LLVMExpressionNode createVectorizedTypedElementPointer(long indexedTypeLength, Type targetType, LLVMExpressionNode aggregateAddress, LLVMExpressionNode index) {
        return LLVMVectorizedGetElementPtrNodeGen.create(indexedTypeLength, targetType, aggregateAddress, index);
    }

    @Override
    public LLVMExpressionNode createSelect(Type type, LLVMExpressionNode condition, LLVMExpressionNode trueValue, LLVMExpressionNode falseValue) {
        if (type instanceof VectorType) {
            VectorType vectorType = (VectorType)type;
            Type elementType = vectorType.getElementType();
            int vectorLength = vectorType.getNumberOfElementsInt();
            if (elementType == PrimitiveType.I1) {
                return LLVMVectorSelectNodeFactory.LLVMI1VectorSelectNodeGen.create(condition, trueValue, falseValue, vectorLength);
            }
            if (elementType == PrimitiveType.I8) {
                return LLVMVectorSelectNodeFactory.LLVMI8VectorSelectNodeGen.create(condition, trueValue, falseValue, vectorLength);
            }
            if (elementType == PrimitiveType.I16) {
                return LLVMVectorSelectNodeFactory.LLVMI16VectorSelectNodeGen.create(condition, trueValue, falseValue, vectorLength);
            }
            if (elementType == PrimitiveType.I32) {
                return LLVMVectorSelectNodeFactory.LLVMI32VectorSelectNodeGen.create(condition, trueValue, falseValue, vectorLength);
            }
            if (elementType == PrimitiveType.I64 || elementType instanceof PointerType || elementType instanceof FunctionType) {
                return LLVMVectorSelectNodeFactory.LLVMI64VectorSelectNodeGen.create(condition, trueValue, falseValue, vectorLength);
            }
            if (elementType == PrimitiveType.FLOAT) {
                return LLVMVectorSelectNodeFactory.LLVMFloatVectorSelectNodeGen.create(condition, trueValue, falseValue, vectorLength);
            }
            if (elementType == PrimitiveType.DOUBLE) {
                return LLVMVectorSelectNodeFactory.LLVMDoubleVectorSelectNodeGen.create(condition, trueValue, falseValue, vectorLength);
            }
            throw new AssertionError((Object)("Cannot create vector select for type: " + type));
        }
        if (type instanceof PrimitiveType) {
            switch (((PrimitiveType)type).getPrimitiveKind()) {
                case I1: {
                    return LLVMSelectNodeFactory.LLVMI1SelectNodeGen.create(condition, trueValue, falseValue);
                }
                case I8: {
                    return LLVMSelectNodeFactory.LLVMI8SelectNodeGen.create(condition, trueValue, falseValue);
                }
                case I16: {
                    return LLVMSelectNodeFactory.LLVMI16SelectNodeGen.create(condition, trueValue, falseValue);
                }
                case I32: {
                    return LLVMSelectNodeFactory.LLVMI32SelectNodeGen.create(condition, trueValue, falseValue);
                }
                case I64: {
                    return LLVMSelectNodeFactory.LLVMI64SelectNodeGen.create(condition, trueValue, falseValue);
                }
                case FLOAT: {
                    return LLVMSelectNodeFactory.LLVMFloatSelectNodeGen.create(condition, trueValue, falseValue);
                }
                case DOUBLE: {
                    return LLVMSelectNodeFactory.LLVMDoubleSelectNodeGen.create(condition, trueValue, falseValue);
                }
                case X86_FP80: {
                    return LLVMSelectNodeFactory.LLVM80BitFloatSelectNodeGen.create(condition, trueValue, falseValue);
                }
            }
        }
        return LLVMSelectNodeFactory.LLVMGenericSelectNodeGen.create(condition, trueValue, falseValue);
    }

    @Override
    public LLVMExpressionNode createZeroVectorInitializer(int nrElements, VectorType llvmType) {
        Type llvmType1 = llvmType.getElementType();
        if (llvmType1 instanceof PrimitiveType) {
            switch (((PrimitiveType)llvmType1).getPrimitiveKind()) {
                case I1: {
                    LLVMExpressionNode[] i1Vals = BasicNodeFactory.createI1LiteralNodes(nrElements, false);
                    return LLVMVectorLiteralNodeFactory.LLVMI1VectorLiteralNodeGen.create(i1Vals);
                }
                case I8: {
                    LLVMExpressionNode[] i8Vals = BasicNodeFactory.createI8LiteralNodes(nrElements, (byte)0);
                    return LLVMVectorLiteralNodeFactory.LLVMI8VectorLiteralNodeGen.create(i8Vals);
                }
                case I16: {
                    LLVMExpressionNode[] i16Vals = BasicNodeFactory.createI16LiteralNodes(nrElements, (short)0);
                    return LLVMVectorLiteralNodeFactory.LLVMI16VectorLiteralNodeGen.create(i16Vals);
                }
                case I32: {
                    LLVMExpressionNode[] i32Vals = BasicNodeFactory.createI32LiteralNodes(nrElements, 0);
                    return LLVMVectorLiteralNodeFactory.LLVMI32VectorLiteralNodeGen.create(i32Vals);
                }
                case I64: {
                    LLVMExpressionNode[] i64Vals = BasicNodeFactory.createI64LiteralNodes(nrElements, 0L);
                    return LLVMVectorLiteralNodeFactory.LLVMI64VectorLiteralNodeGen.create(i64Vals);
                }
                case FLOAT: {
                    LLVMExpressionNode[] floatVals = BasicNodeFactory.createFloatLiteralNodes(nrElements, 0.0f);
                    return LLVMVectorLiteralNodeFactory.LLVMFloatVectorLiteralNodeGen.create(floatVals);
                }
                case DOUBLE: {
                    LLVMExpressionNode[] doubleVals = BasicNodeFactory.createDoubleLiteralNodes(nrElements, 0.0);
                    return LLVMVectorLiteralNodeFactory.LLVMDoubleVectorLiteralNodeGen.create(doubleVals);
                }
            }
            throw new AssertionError(llvmType1);
        }
        if (llvmType1 instanceof PointerType) {
            LLVMExpressionNode[] addressVals = BasicNodeFactory.createNullAddressLiteralNodes(nrElements);
            return LLVMVectorLiteralNodeFactory.LLVMPointerVectorLiteralNodeGen.create(addressVals);
        }
        throw new AssertionError((Object)(llvmType1 + " not yet supported"));
    }

    @Override
    public LLVMExpressionNode createLiteral(Object value, Type type) {
        if (type instanceof PointerType || type instanceof FunctionType) {
            if (LLVMNativePointer.isInstance(value)) {
                return LLVMSimpleLiteralNodeFactory.LLVMNativePointerLiteralNodeGen.create(LLVMNativePointer.cast(value));
            }
            if (LLVMManagedPointer.isInstance(value)) {
                return LLVMSimpleLiteralNodeFactory.LLVMManagedPointerLiteralNodeGen.create(LLVMManagedPointer.cast(value));
            }
            if (value instanceof LLVMGlobal || value instanceof LLVMFunction) {
                return LLVMAccessSymbolNodeGen.create((LLVMSymbol)value);
            }
            throw new AssertionError(value.getClass());
        }
        if (type instanceof PrimitiveType) {
            switch (((PrimitiveType)type).getPrimitiveKind()) {
                case I1: {
                    return LLVMSimpleLiteralNodeFactory.LLVMI1LiteralNodeGen.create((Boolean)value);
                }
                case I8: {
                    return LLVMSimpleLiteralNodeFactory.LLVMI8LiteralNodeGen.create((Byte)value);
                }
                case I16: {
                    return LLVMSimpleLiteralNodeFactory.LLVMI16LiteralNodeGen.create((Short)value);
                }
                case I32: {
                    return LLVMSimpleLiteralNodeFactory.LLVMI32LiteralNodeGen.create((Integer)value);
                }
                case I64: {
                    return LLVMSimpleLiteralNodeFactory.LLVMI64LiteralNodeGen.create((Long)value);
                }
                case FLOAT: {
                    return LLVMSimpleLiteralNodeFactory.LLVMFloatLiteralNodeGen.create(((Float)value).floatValue());
                }
                case DOUBLE: {
                    return LLVMSimpleLiteralNodeFactory.LLVMDoubleLiteralNodeGen.create((Double)value);
                }
            }
            throw new AssertionError((Object)(value + " " + type));
        }
        throw new AssertionError((Object)(value + " " + type));
    }

    @Override
    public LLVMControlFlowNode createUnreachableNode() {
        return LLVMUnreachableNodeGen.create();
    }

    @Override
    public LLVMControlFlowNode createIndirectBranch(LLVMExpressionNode value, int[] labelTargets, LLVMStatementNode[] phiWrites) {
        return LLVMIndirectBranchNode.create(value, labelTargets, phiWrites);
    }

    @Override
    public LLVMControlFlowNode createSwitch(LLVMExpressionNode cond, int[] successors, LLVMExpressionNode[] cases, Type llvmType, LLVMStatementNode[] phiWriteNodes) {
        LLVMExpressionNode[] caseNodes = (LLVMExpressionNode[])Arrays.copyOf(cases, cases.length, LLVMExpressionNode[].class);
        return LLVMSwitchNode.create(successors, phiWriteNodes, cond, caseNodes);
    }

    @Override
    public LLVMControlFlowNode createConditionalBranch(int trueIndex, int falseIndex, LLVMExpressionNode conditionNode, LLVMStatementNode truePhiWriteNodes, LLVMStatementNode falsePhiWriteNodes) {
        return LLVMConditionalBranchNode.create(trueIndex, falseIndex, truePhiWriteNodes, falsePhiWriteNodes, conditionNode);
    }

    @Override
    public LLVMControlFlowNode createUnconditionalBranch(int unconditionalIndex, LLVMStatementNode phiWrites) {
        return LLVMBrUnconditionalNode.create(unconditionalIndex, phiWrites);
    }

    @Override
    public LLVMExpressionNode createArrayLiteral(LLVMExpressionNode[] arrayValues, ArrayType arrayType, GetStackSpaceFactory arrayGetStackSpaceFactory) {
        assert (arrayType.getNumberOfElements() == (long)arrayValues.length);
        LLVMExpressionNode arrayGetStackSpace = arrayGetStackSpaceFactory.createGetStackSpace(this, arrayType);
        Type elementType = arrayType.getElementType();
        try {
            long elementSize = this.getByteSize(elementType);
            if (elementSize == 0L) {
                throw new Type.TypeOverflowException(elementType + " has size of 0!");
            }
            if (elementType instanceof PrimitiveType || elementType instanceof PointerType || elementType instanceof FunctionType || elementType instanceof VariableBitWidthType) {
                return LLVMArrayLiteralNodeGen.create(arrayValues, elementSize, this.createMemoryStore(elementType), arrayGetStackSpace);
            }
            if (elementType instanceof ArrayType || elementType instanceof StructureType) {
                return LLVMStructArrayLiteralNodeGen.create(arrayValues, this.createMemMove(), elementSize, arrayGetStackSpace);
            }
        }
        catch (Type.TypeOverflowException e) {
            return Type.handleOverflowExpression(e);
        }
        throw new AssertionError(elementType);
    }

    @Override
    public LLVMExpressionNode createAlloca(Type type) {
        try {
            int alignment = this.getByteAlignment(type);
            long byteSize = this.getByteSize(type);
            LLVMGetStackSpaceInstruction.LLVMAllocaConstInstruction alloc = LLVMGetStackSpaceInstructionFactory.LLVMAllocaConstInstructionNodeGen.create(byteSize, alignment, type);
            return this.createGetStackSpace(type, alloc, byteSize);
        }
        catch (Type.TypeOverflowException e) {
            return Type.handleOverflowExpression(e);
        }
    }

    @Override
    public LLVMExpressionNode createAlloca(Type type, int alignment) {
        try {
            long byteSize = this.getByteSize(type);
            LLVMGetStackSpaceInstruction.LLVMAllocaConstInstruction alloc = LLVMGetStackSpaceInstructionFactory.LLVMAllocaConstInstructionNodeGen.create(byteSize, alignment, type);
            return this.createGetStackSpace(type, alloc, byteSize);
        }
        catch (Type.TypeOverflowException e) {
            return Type.handleOverflowExpression(e);
        }
    }

    @Override
    public LLVMExpressionNode createGetUniqueStackSpace(Type type, LLVMStack.UniquesRegion uniquesRegion) {
        try {
            int alignment = this.getByteAlignment(type);
            long byteSize = this.getByteSize(type);
            LLVMStack.UniquesRegion.UniqueSlot slot = uniquesRegion.addSlot(byteSize, alignment);
            LLVMGetStackSpaceInstruction.LLVMGetUniqueStackSpaceInstruction getStackSpace = LLVMGetStackSpaceInstructionFactory.LLVMGetUniqueStackSpaceInstructionNodeGen.create(byteSize, alignment, type, slot);
            return this.createGetStackSpace(type, getStackSpace, byteSize);
        }
        catch (LLVMStackOverflowError soe) {
            return LLVMLazyException.createExpressionNode(LLVMAllocationFailureException::new, soe);
        }
        catch (Type.TypeOverflowException e) {
            return Type.handleOverflowExpression(e);
        }
    }

    protected LLVMExpressionNode createGetStackSpace(Type type, LLVMGetStackSpaceInstruction.LLVMGetStackForConstInstruction getStackSpace, long byteSize) {
        if (type instanceof StructureType) {
            StructureType struct = (StructureType)type;
            long[] offsets = new long[struct.getNumberOfElementsInt()];
            Type[] types = new Type[struct.getNumberOfElementsInt()];
            long currentOffset = 0L;
            try {
                int i = 0;
                while ((long)i < struct.getNumberOfElements()) {
                    Type elemType = struct.getElementType(i);
                    if (!struct.isPacked()) {
                        currentOffset = Type.addUnsignedExact(currentOffset, this.getBytePadding(currentOffset, elemType));
                    }
                    offsets[i] = currentOffset;
                    types[i] = elemType;
                    currentOffset = Type.addUnsignedExact(currentOffset, this.getByteSize(elemType));
                    ++i;
                }
            }
            catch (Type.TypeOverflowException e) {
                return Type.handleOverflowExpression(e);
            }
            assert (currentOffset <= byteSize) : "currentOffset " + currentOffset + " vs. byteSize " + byteSize;
            getStackSpace.setTypes(types);
            getStackSpace.setOffsets(offsets);
        }
        return getStackSpace;
    }

    @Override
    public LLVMExpressionNode createAllocaArray(Type elementType, LLVMExpressionNode numElements, int alignment) {
        try {
            long byteSize = this.getByteSize(elementType);
            return LLVMGetStackSpaceInstructionFactory.LLVMAllocaInstructionNodeGen.create(byteSize, alignment, elementType, numElements);
        }
        catch (Type.TypeOverflowException e) {
            return Type.handleOverflowExpression(e);
        }
    }

    @Override
    public VarargsAreaStackAllocationNode createVarargsAreaStackAllocation() {
        return LLVMNativeVarargsAreaStackAllocationNodeGen.create();
    }

    @Override
    public LLVMExpressionNode createInsertValue(LLVMExpressionNode resultAggregate, LLVMExpressionNode sourceAggregate, long size, long offset, LLVMExpressionNode valueToInsert, Type llvmType) {
        LLVMStoreNodeCommon store;
        block15: {
            block14: {
                if (!(llvmType instanceof PrimitiveType)) break block14;
                switch (((PrimitiveType)llvmType).getPrimitiveKind()) {
                    case I1: {
                        store = LLVMI1StoreNodeGen.create(null, null);
                        break block15;
                    }
                    case I8: {
                        store = LLVMI8StoreNodeGen.create(null, null);
                        break block15;
                    }
                    case I16: {
                        store = LLVMI16StoreNodeGen.create(null, null);
                        break block15;
                    }
                    case I32: {
                        store = LLVMI32StoreNodeGen.create(null, null);
                        break block15;
                    }
                    case I64: {
                        store = LLVMI64StoreNodeGen.create(null, null);
                        break block15;
                    }
                    case FLOAT: {
                        store = LLVMFloatStoreNodeGen.create(null, null);
                        break block15;
                    }
                    case DOUBLE: {
                        store = LLVMDoubleStoreNodeGen.create(null, null);
                        break block15;
                    }
                    case X86_FP80: {
                        store = LLVM80BitFloatStoreNodeGen.create(null, null);
                        break block15;
                    }
                    default: {
                        throw new AssertionError((Object)(llvmType + " is not supported for insertvalue"));
                    }
                }
            }
            if (llvmType instanceof VectorType) {
                store = LLVMStoreVectorNodeGen.create(null, null, ((VectorType)llvmType).getNumberOfElementsInt());
            } else if (llvmType instanceof PointerType) {
                store = LLVMPointerStoreNodeGen.create(null, null);
            } else {
                throw new AssertionError((Object)(llvmType + " is not supported for insertvalue"));
            }
        }
        return LLVMInsertValueNodeGen.create(store, this.createMemMove(), size, offset, sourceAggregate, resultAggregate, valueToInsert);
    }

    @Override
    public LLVMExpressionNode createZeroNode(LLVMExpressionNode addressNode, long size) {
        return LLVMMemSetNodeGen.create(this.createMemSet(), addressNode, LLVMSimpleLiteralNodeFactory.LLVMI8LiteralNodeGen.create((byte)0), LLVMSimpleLiteralNodeFactory.LLVMI64LiteralNodeGen.create(size), LLVMSimpleLiteralNodeFactory.LLVMI1LiteralNodeGen.create(false));
    }

    @Override
    public LLVMExpressionNode createStructureConstantNode(Type structType, GetStackSpaceFactory getStackSpaceFactory, boolean packed, Type[] types, LLVMExpressionNode[] constants) {
        long[] offsets = new long[types.length];
        LLVMStoreNode[] nodes = new LLVMStoreNode[types.length];
        long currentOffset = 0L;
        LLVMExpressionNode getStackSpace = getStackSpaceFactory.createGetStackSpace(this, structType);
        try {
            for (int i = 0; i < types.length; ++i) {
                Type resolvedType = types[i];
                if (!packed) {
                    currentOffset = Type.addUnsignedExact(currentOffset, this.getBytePadding(currentOffset, resolvedType));
                }
                offsets[i] = currentOffset;
                long byteSize = this.getByteSize(resolvedType);
                nodes[i] = this.createMemoryStore(resolvedType);
                currentOffset = Type.addUnsignedExact(currentOffset, byteSize);
            }
        }
        catch (Type.TypeOverflowException e) {
            return Type.handleOverflowExpression(e);
        }
        return StructLiteralNodeGen.create(offsets, nodes, constants, getStackSpace);
    }

    private LLVMStoreNode createMemoryStore(Type resolvedType) throws Type.TypeOverflowException {
        if (resolvedType instanceof ArrayType || resolvedType instanceof StructureType) {
            long byteSize = this.getByteSize(resolvedType);
            return LLVMStructStoreNodeGen.create(this.createMemMove(), null, null, byteSize);
        }
        if (resolvedType instanceof PrimitiveType) {
            switch (((PrimitiveType)resolvedType).getPrimitiveKind()) {
                case I8: {
                    return LLVMI8StoreNodeGen.create(null, null);
                }
                case I16: {
                    return LLVMI16StoreNodeGen.create(null, null);
                }
                case I32: {
                    return LLVMI32StoreNodeGen.create(null, null);
                }
                case I64: {
                    return LLVMI64StoreNodeGen.create(null, null);
                }
                case FLOAT: {
                    return LLVMFloatStoreNodeGen.create(null, null);
                }
                case DOUBLE: {
                    return LLVMDoubleStoreNodeGen.create(null, null);
                }
                case X86_FP80: {
                    return LLVM80BitFloatStoreNodeGen.create(null, null);
                }
            }
            throw new AssertionError(resolvedType);
        }
        if (resolvedType instanceof PointerType || resolvedType instanceof FunctionType) {
            return LLVMPointerStoreNodeGen.create(null, null);
        }
        if (resolvedType instanceof VariableBitWidthType) {
            return LLVMIVarBitStoreNodeGen.create(null, null);
        }
        throw new AssertionError(resolvedType);
    }

    @Override
    public LLVMExpressionNode createFunctionBlockNode(FrameSlot exceptionValueSlot, LLVMBasicBlockNode[] allFunctionNodes, LLVMStack.UniquesRegion.UniquesRegionAllocator uniquesRegionAllocator, LLVMStatementNode[] copyArgumentsToFrame, LLVMSourceLocation location, FrameDescriptor frameDescriptor, FrameSlot loopSuccessorSlot, LocalVariableDebugInfo debugInfo) {
        LLVMUniquesRegionAllocNode uniquesRegionAllocNode = LLVMUniquesRegionAllocNodeGen.create(uniquesRegionAllocator);
        LLVMDispatchBasicBlockNode body = LLVMDispatchBasicBlockNodeGen.create(exceptionValueSlot, allFunctionNodes, loopSuccessorSlot, debugInfo);
        body.setSourceLocation(LLVMSourceLocation.orDefault(location));
        LLVMFunctionRootNode functionRoot = LLVMFunctionRootNodeGen.create(uniquesRegionAllocNode, copyArgumentsToFrame, body, frameDescriptor);
        functionRoot.setSourceLocation(LLVMSourceLocation.orDefault(location));
        return functionRoot;
    }

    @Override
    public RootNode createFunctionStartNode(LLVMExpressionNode functionBodyNode, FrameDescriptor frame, String name, String originalName, int argumentCount, Source bcSource, LLVMSourceLocation location) {
        return new LLVMFunctionStartNode(this.context.getLanguage(), functionBodyNode, frame, name, argumentCount, originalName, bcSource, location, this.dataLayout);
    }

    @Override
    public LLVMExpressionNode createInlineAssemblerExpression(ExternalLibrary library, String asmExpression, String asmFlags, LLVMExpressionNode[] args, Type.TypeArrayBuilder argTypes, Type retType) {
        LLVMInlineAssemblyRootNode assemblyRoot;
        Type[] retTypes = null;
        long[] retOffsets = null;
        if (retType instanceof StructureType) {
            assert (args[1] instanceof LLVMGetStackSpaceInstruction.LLVMGetStackForConstInstruction);
            LLVMGetStackSpaceInstruction.LLVMGetStackForConstInstruction getStackSpace = (LLVMGetStackSpaceInstruction.LLVMGetStackForConstInstruction)args[1];
            retTypes = getStackSpace.getTypes();
            retOffsets = getStackSpace.getOffsets();
        }
        try {
            assemblyRoot = InlineAssemblyParser.parseInlineAssembly(this.context.getLanguage(), asmExpression, asmFlags, argTypes, retType, retTypes, retOffsets);
        }
        catch (AsmParseException e) {
            assemblyRoot = this.getLazyUnsupportedInlineRootNode(asmExpression, e);
        }
        LLVMFunctionCode.LLVMIRFunction function = new LLVMFunctionCode.LLVMIRFunction(Truffle.getRuntime().createCallTarget((RootNode)assemblyRoot), null);
        LLVMFunction functionDetail = LLVMFunction.create("<asm>", library, function, new FunctionType((Type)MetaType.UNKNOWN, 0, false), -1, -1, false);
        LLVMFunctionDescriptor asm = this.context.createFunctionDescriptor(functionDetail);
        LLVMSimpleLiteralNode.LLVMManagedPointerLiteralNode asmFunction = LLVMSimpleLiteralNodeFactory.LLVMManagedPointerLiteralNodeGen.create(LLVMManagedPointer.create(asm));
        return LLVMCallNode.create(new FunctionType((Type)MetaType.UNKNOWN, argTypes, false), asmFunction, args, false);
    }

    private LLVMInlineAssemblyRootNode getLazyUnsupportedInlineRootNode(String asmExpression, AsmParseException e) {
        String message = asmExpression + ": " + e.getMessage();
        LLVMInlineAssemblyRootNode assemblyRoot = new LLVMInlineAssemblyRootNode(this.context.getLanguage(), new FrameDescriptor(), Collections.singletonList(LLVMUnsupportedInstructionNode.create(LLVMUnsupportedException.UnsupportedReason.INLINE_ASSEMBLER, message)), Collections.emptyList(), null);
        return assemblyRoot;
    }

    @Override
    public LLVMControlFlowNode createFunctionInvoke(LLVMWriteNode writeResult, LLVMExpressionNode functionNode, LLVMExpressionNode[] argNodes, FunctionType type, int normalIndex, int unwindIndex, LLVMStatementNode normalPhiWriteNodes, LLVMStatementNode unwindPhiWriteNodes) {
        return LLVMInvokeNode.create(type, writeResult, functionNode, argNodes, normalIndex, unwindIndex, normalPhiWriteNodes, unwindPhiWriteNodes);
    }

    @Override
    public LLVMExpressionNode createLandingPad(LLVMExpressionNode allocateLandingPadValue, FrameSlot exceptionValueSlot, boolean cleanup, long[] clauseKinds, LLVMExpressionNode[] entries, LLVMExpressionNode getStack) {
        LLVMLandingpadNode.LandingpadEntryNode[] landingpadEntries = new LLVMLandingpadNode.LandingpadEntryNode[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            if (clauseKinds[i] == 0L) {
                landingpadEntries[i] = BasicNodeFactory.getLandingpadCatchEntry(entries[i]);
                continue;
            }
            if (clauseKinds[i] == 1L) {
                landingpadEntries[i] = BasicNodeFactory.getLandingpadFilterEntry(entries[i]);
                continue;
            }
            throw new IllegalStateException();
        }
        return LLVMLandingpadNodeGen.create(getStack, allocateLandingPadValue, exceptionValueSlot, cleanup, landingpadEntries);
    }

    private static LLVMLandingpadNode.LandingpadEntryNode getLandingpadCatchEntry(LLVMExpressionNode exp) {
        return LLVMLandingpadNode.createCatchEntry(exp);
    }

    private static LLVMLandingpadNode.LandingpadEntryNode getLandingpadFilterEntry(LLVMExpressionNode exp) {
        LLVMExpressionNode arrayNode = exp;
        LLVMArrayLiteralNode array = (LLVMArrayLiteralNode)arrayNode;
        LLVMExpressionNode[] types = array == null ? LLVMExpressionNode.NO_EXPRESSIONS : array.getValues();
        return LLVMLandingpadNode.createFilterEntry(types);
    }

    @Override
    public LLVMControlFlowNode createResumeInstruction(FrameSlot exceptionValueSlot) {
        return LLVMResumeNodeGen.create(exceptionValueSlot);
    }

    @Override
    public LLVMExpressionNode createCompareExchangeInstruction(AggregateType returnType, Type elementType, LLVMExpressionNode ptrNode, LLVMExpressionNode cmpNode, LLVMExpressionNode newNode) {
        try {
            return LLVMCompareExchangeNode.create(returnType, this.dataLayout, ptrNode, cmpNode, newNode);
        }
        catch (Type.TypeOverflowException e) {
            return Type.handleOverflowExpression(e);
        }
    }

    @Override
    public LLVMExpressionNode createLLVMBuiltin(Symbol target, LLVMExpressionNode[] args, Type.TypeArrayBuilder argsTypes, int callerArgumentCount) {
        if (target instanceof FunctionDeclaration) {
            FunctionDeclaration declaration = (FunctionDeclaration)target;
            String name = declaration.getName();
            if (name.startsWith("llvm.")) {
                return this.getLLVMBuiltin(declaration, args, callerArgumentCount);
            }
            if (name.startsWith("__builtin_")) {
                return this.getGccBuiltin(declaration, args);
            }
            if (name.equals("polyglot_get_arg")) {
                return LLVMTruffleGetArgNodeGen.create(args[1]);
            }
            if (name.equals("polyglot_get_arg_count")) {
                return LLVMTruffleGetArgCountNodeGen.create();
            }
            LLVMIntrinsicProvider intrinsicProvider = this.context.getLanguage().getCapability(LLVMIntrinsicProvider.class);
            return intrinsicProvider.generateIntrinsicNode(name, args, argsTypes, this);
        }
        return null;
    }

    private LLVMExpressionNode createMemsetIntrinsic(LLVMExpressionNode[] args) {
        if (args.length == 6) {
            return LLVMMemSetNodeGen.create(this.createMemSet(), args[1], args[2], args[3], args[5]);
        }
        if (args.length == 5) {
            return LLVMMemSetNodeGen.create(this.createMemSet(), args[1], args[2], args[3], args[4]);
        }
        throw new LLVMParserException("Illegal number of arguments to @llvm.memset.*: " + args.length);
    }

    private LLVMExpressionNode createMemcpyIntrinsic(LLVMExpressionNode[] args) {
        if (args.length == 6) {
            return LLVMMemCopyNodeGen.create(this.createMemMove(), args[1], args[2], args[3], args[5]);
        }
        if (args.length == 5) {
            return LLVMMemCopyNodeGen.create(this.createMemMove(), args[1], args[2], args[3], args[4]);
        }
        throw new LLVMParserException("Illegal number of arguments to @llvm.memcpy.*: " + args.length);
    }

    private LLVMExpressionNode createMemmoveIntrinsic(LLVMExpressionNode[] args) {
        if (args.length == 6) {
            return LLVMMemMoveFactory.LLVMMemMoveI64NodeGen.create(this.createMemMove(), args[1], args[2], args[3], args[5]);
        }
        if (args.length == 5) {
            return LLVMMemMoveFactory.LLVMMemMoveI64NodeGen.create(this.createMemMove(), args[1], args[2], args[3], args[4]);
        }
        throw new LLVMParserException("Illegal number of arguments to @llvm.memmove.*: " + args.length);
    }

    private static String getTypeSuffix(String intrinsicName) {
        assert (intrinsicName != null);
        Matcher typeSuffixMatcher = INTRINSIC_TYPE_SUFFIX_PATTERN.matcher(intrinsicName);
        if (typeSuffixMatcher.matches()) {
            return typeSuffixMatcher.group("suffix");
        }
        return null;
    }

    protected LLVMExpressionNode getLLVMBuiltin(FunctionDeclaration declaration, LLVMExpressionNode[] args, int callerArgumentCount) {
        String intrinsicName = declaration.getName();
        try {
            switch (intrinsicName) {
                case "llvm.memset.p0i8.i32": 
                case "llvm.memset.p0i8.i64": {
                    return this.createMemsetIntrinsic(args);
                }
                case "llvm.assume": {
                    return LLVMAssumeNodeGen.create(args[1]);
                }
                case "llvm.clear_cache": 
                case "llvm.donothing": {
                    return LLVMNoOpNodeGen.create();
                }
                case "llvm.prefetch": {
                    return LLVMPrefetchNodeGen.create(args[1], args[2], args[3], args[4]);
                }
                case "llvm.ctlz.i8": {
                    return CountLeadingZeroesNodeFactory.CountLeadingZeroesI8NodeGen.create(args[1], args[2]);
                }
                case "llvm.ctlz.i16": {
                    return CountLeadingZeroesNodeFactory.CountLeadingZeroesI16NodeGen.create(args[1], args[2]);
                }
                case "llvm.ctlz.i32": {
                    return CountLeadingZeroesNodeFactory.CountLeadingZeroesI32NodeGen.create(args[1], args[2]);
                }
                case "llvm.ctlz.i64": {
                    return CountLeadingZeroesNodeFactory.CountLeadingZeroesI64NodeGen.create(args[1], args[2]);
                }
                case "llvm.memcpy.p0i8.p0i8.i64": 
                case "llvm.memcpy.p0i8.p0i8.i32": {
                    return this.createMemcpyIntrinsic(args);
                }
                case "llvm.ctpop.i32": {
                    return CountSetBitsNodeFactory.CountSetBitsI32NodeGen.create(args[1]);
                }
                case "llvm.ctpop.i64": {
                    return CountSetBitsNodeFactory.CountSetBitsI64NodeGen.create(args[1]);
                }
                case "llvm.cttz.i8": {
                    return CountTrailingZeroesNodeFactory.CountTrailingZeroesI8NodeGen.create(args[1], args[2]);
                }
                case "llvm.cttz.i16": {
                    return CountTrailingZeroesNodeFactory.CountTrailingZeroesI16NodeGen.create(args[1], args[2]);
                }
                case "llvm.cttz.i32": {
                    return CountTrailingZeroesNodeFactory.CountTrailingZeroesI32NodeGen.create(args[1], args[2]);
                }
                case "llvm.cttz.i64": {
                    return CountTrailingZeroesNodeFactory.CountTrailingZeroesI64NodeGen.create(args[1], args[2]);
                }
                case "llvm.trap": {
                    return LLVMTrapNodeGen.create();
                }
                case "llvm.bswap.i16": {
                    return LLVMByteSwapFactory.LLVMByteSwapI16NodeGen.create(args[1]);
                }
                case "llvm.bswap.i32": {
                    return LLVMByteSwapFactory.LLVMByteSwapI32NodeGen.create(args[1]);
                }
                case "llvm.bswap.i64": {
                    return LLVMByteSwapFactory.LLVMByteSwapI64NodeGen.create(args[1]);
                }
                case "llvm.bswap.v8i16": {
                    return LLVMByteSwapFactory.LLVMByteSwapI16VectorNodeGen.create(8, args[1]);
                }
                case "llvm.bswap.v16i16": {
                    return LLVMByteSwapFactory.LLVMByteSwapI16VectorNodeGen.create(16, args[1]);
                }
                case "llvm.bswap.v4i32": {
                    return LLVMByteSwapFactory.LLVMByteSwapI32VectorNodeGen.create(4, args[1]);
                }
                case "llvm.bswap.v8i32": {
                    return LLVMByteSwapFactory.LLVMByteSwapI32VectorNodeGen.create(8, args[1]);
                }
                case "llvm.bswap.v2i64": {
                    return LLVMByteSwapFactory.LLVMByteSwapI64VectorNodeGen.create(2, args[1]);
                }
                case "llvm.bswap.v4i64": {
                    return LLVMByteSwapFactory.LLVMByteSwapI64VectorNodeGen.create(4, args[1]);
                }
                case "llvm.memmove.p0i8.p0i8.i64": {
                    return this.createMemmoveIntrinsic(args);
                }
                case "llvm.pow.f32": {
                    return LLVMCMathsIntrinsicsFactory.LLVMPowNodeGen.create(args[1], args[2]);
                }
                case "llvm.pow.f64": {
                    return LLVMCMathsIntrinsicsFactory.LLVMPowNodeGen.create(args[1], args[2]);
                }
                case "llvm.pow.f80": {
                    return LLVMCMathsIntrinsicsFactory.LLVMPowNodeGen.create(args[1], args[2]);
                }
                case "llvm.powi.f32": {
                    return LLVMCMathsIntrinsicsFactory.LLVMPowNodeGen.create(args[1], args[2]);
                }
                case "llvm.powi.f64": {
                    return LLVMCMathsIntrinsicsFactory.LLVMPowNodeGen.create(args[1], args[2]);
                }
                case "llvm.powi.f80": {
                    return LLVMCMathsIntrinsicsFactory.LLVMPowNodeGen.create(args[1], args[2]);
                }
                case "llvm.round.f32": 
                case "llvm.round.f64": 
                case "llvm.round.f80": {
                    return LLVMCMathsIntrinsicsFactory.LLVMRoundNodeGen.create(args[1]);
                }
                case "llvm.fabs.f32": 
                case "llvm.fabs.f64": 
                case "llvm.fabs.f80": {
                    return LLVMCMathsIntrinsicsFactory.LLVMFAbsNodeGen.create(args[1]);
                }
                case "llvm.fabs.v2f64": {
                    return LLVMCMathsIntrinsicsFactory.LLVMFAbsVectorNodeGen.create(args[1], 2);
                }
                case "llvm.minnum.f32": 
                case "llvm.minnum.f64": {
                    return LLVMCMathsIntrinsicsFactory.LLVMMinnumNodeGen.create(args[1], args[2]);
                }
                case "llvm.maxnum.f32": 
                case "llvm.maxnum.f64": {
                    return LLVMCMathsIntrinsicsFactory.LLVMMaxnumNodeGen.create(args[1], args[2]);
                }
                case "llvm.returnaddress": {
                    return LLVMReturnAddressNodeGen.create(args[1]);
                }
                case "llvm.lifetime.start.p0i8": 
                case "llvm.lifetime.start": {
                    return LLVMLifetimeStartNodeGen.create(args[1], args[2]);
                }
                case "llvm.lifetime.end.p0i8": 
                case "llvm.lifetime.end": {
                    return LLVMLifetimeEndNodeGen.create(args[1], args[2]);
                }
                case "llvm.invariant.start": 
                case "llvm.invariant.start.p0i8": {
                    return LLVMInvariantStartNodeGen.create(args[1], args[2]);
                }
                case "llvm.invariant.end": 
                case "llvm.invariant.end.p0i8": {
                    return LLVMInvariantEndNodeGen.create(args[1], args[2]);
                }
                case "llvm.stacksave": {
                    return this.createStackSave();
                }
                case "llvm.stackrestore": {
                    return this.createStackRestore(args[1]);
                }
                case "llvm.frameaddress": {
                    return LLVMFrameAddressNodeGen.create(args[1]);
                }
                case "llvm.va_start": {
                    return LLVMX86_64VAStartNodeGen.create(callerArgumentCount, this.createVarargsAreaStackAllocation(), this.createMemMove(), args[1]);
                }
                case "llvm.va_end": {
                    return LLVMX86_64BitVAEndNodeGen.create(args[1]);
                }
                case "llvm.va_copy": {
                    return LLVMX86_64BitVACopyNodeGen.create(args[1], args[2], callerArgumentCount);
                }
                case "llvm.eh.sjlj.longjmp": 
                case "llvm.eh.sjlj.setjmp": {
                    return LLVMUnsupportedInstructionNode.createExpression(LLVMUnsupportedException.UnsupportedReason.SET_JMP_LONG_JMP);
                }
                case "llvm.dbg.declare": 
                case "llvm.dbg.addr": 
                case "llvm.dbg.value": {
                    throw new IllegalStateException("Unhandled call to intrinsic function " + declaration.getName());
                }
                case "llvm.dbg.label": {
                    return LLVMNoOpNodeGen.create();
                }
                case "llvm.eh.typeid.for": {
                    return LLVMTypeIdForExceptionNodeGen.create(args[1]);
                }
                case "llvm.expect.i1": {
                    boolean expectedValue = LLVMTypesGen.asBoolean(args[2].executeGeneric(null));
                    LLVMExpressionNode actualValueNode = args[1];
                    return LLVMExpectFactory.LLVMExpectI1NodeGen.create(expectedValue, actualValueNode);
                }
                case "llvm.expect.i32": {
                    int expectedValue = LLVMTypesGen.asInteger(args[2].executeGeneric(null));
                    LLVMExpressionNode actualValueNode = args[1];
                    return LLVMExpectFactory.LLVMExpectI32NodeGen.create(expectedValue, actualValueNode);
                }
                case "llvm.expect.i64": {
                    long expectedValue = LLVMTypesGen.asLong(args[2].executeGeneric(null));
                    LLVMExpressionNode actualValueNode = args[1];
                    return LLVMExpectFactory.LLVMExpectI64NodeGen.create(expectedValue, actualValueNode);
                }
                case "llvm.objectsize.i64.p0i8": 
                case "llvm.objectsize.i64": {
                    return LLVMI64ObjectSizeNodeGen.create(args[1], args[2]);
                }
                case "llvm.copysign.f32": 
                case "llvm.copysign.f64": 
                case "llvm.copysign.f80": {
                    return LLVMCMathsIntrinsicsFactory.LLVMCopySignNodeGen.create(args[1], args[2]);
                }
                case "llvm.uadd.with.overflow.i8": 
                case "llvm.uadd.with.overflow.i16": 
                case "llvm.uadd.with.overflow.i32": 
                case "llvm.uadd.with.overflow.i64": {
                    return LLVMArithmeticFactory.LLVMArithmeticWithOverflowNodeGen.create(LLVMArithmetic.UNSIGNED_ADD, this.getOverflowFieldOffset(declaration), args[2], args[3], args[1]);
                }
                case "llvm.usub.with.overflow.i8": 
                case "llvm.usub.with.overflow.i16": 
                case "llvm.usub.with.overflow.i32": 
                case "llvm.usub.with.overflow.i64": {
                    return LLVMArithmeticFactory.LLVMArithmeticWithOverflowNodeGen.create(LLVMArithmetic.UNSIGNED_SUB, this.getOverflowFieldOffset(declaration), args[2], args[3], args[1]);
                }
                case "llvm.umul.with.overflow.i8": 
                case "llvm.umul.with.overflow.i16": 
                case "llvm.umul.with.overflow.i32": 
                case "llvm.umul.with.overflow.i64": {
                    return LLVMArithmeticFactory.LLVMArithmeticWithOverflowNodeGen.create(LLVMArithmetic.UNSIGNED_MUL, this.getOverflowFieldOffset(declaration), args[2], args[3], args[1]);
                }
                case "llvm.sadd.with.overflow.i8": 
                case "llvm.sadd.with.overflow.i16": 
                case "llvm.sadd.with.overflow.i32": 
                case "llvm.sadd.with.overflow.i64": {
                    return LLVMArithmeticFactory.LLVMArithmeticWithOverflowNodeGen.create(LLVMArithmetic.SIGNED_ADD, this.getOverflowFieldOffset(declaration), args[2], args[3], args[1]);
                }
                case "llvm.ssub.with.overflow.i8": 
                case "llvm.ssub.with.overflow.i16": 
                case "llvm.ssub.with.overflow.i32": 
                case "llvm.ssub.with.overflow.i64": {
                    return LLVMArithmeticFactory.LLVMArithmeticWithOverflowNodeGen.create(LLVMArithmetic.SIGNED_SUB, this.getOverflowFieldOffset(declaration), args[2], args[3], args[1]);
                }
                case "llvm.smul.with.overflow.i8": 
                case "llvm.smul.with.overflow.i16": 
                case "llvm.smul.with.overflow.i32": 
                case "llvm.smul.with.overflow.i64": {
                    return LLVMArithmeticFactory.LLVMArithmeticWithOverflowNodeGen.create(LLVMArithmetic.SIGNED_MUL, this.getOverflowFieldOffset(declaration), args[2], args[3], args[1]);
                }
                case "llvm.exp2.f32": 
                case "llvm.exp2.f64": {
                    return LLVMCMathsIntrinsicsFactory.LLVMExp2NodeGen.create(args[1]);
                }
                case "llvm.sqrt.f32": 
                case "llvm.sqrt.f64": {
                    return LLVMCMathsIntrinsicsFactory.LLVMSqrtNodeGen.create(args[1]);
                }
                case "llvm.sqrt.v2f64": {
                    return LLVMCMathsIntrinsicsFactory.LLVMSqrtVectorNodeGen.create(args[1], 2);
                }
                case "llvm.sin.f32": 
                case "llvm.sin.f64": {
                    return LLVMCMathsIntrinsicsFactory.LLVMSinNodeGen.create(args[1]);
                }
                case "llvm.cos.f32": 
                case "llvm.cos.f64": {
                    return LLVMCMathsIntrinsicsFactory.LLVMCosNodeGen.create(args[1]);
                }
                case "llvm.exp.f32": 
                case "llvm.exp.f64": {
                    return LLVMCMathsIntrinsicsFactory.LLVMExpNodeGen.create(args[1]);
                }
                case "llvm.log.f32": 
                case "llvm.log.f64": {
                    return LLVMCMathsIntrinsicsFactory.LLVMLogNodeGen.create(args[1]);
                }
                case "llvm.log2.f32": 
                case "llvm.log2.f64": {
                    return LLVMCMathsIntrinsicsFactory.LLVMLog2NodeGen.create(args[1]);
                }
                case "llvm.log10.f32": 
                case "llvm.log10.f64": {
                    return LLVMCMathsIntrinsicsFactory.LLVMLog10NodeGen.create(args[1]);
                }
                case "llvm.floor.f32": 
                case "llvm.floor.f64": {
                    return LLVMCMathsIntrinsicsFactory.LLVMFloorNodeGen.create(args[1]);
                }
                case "llvm.ceil.f32": 
                case "llvm.ceil.f64": {
                    return LLVMCMathsIntrinsicsFactory.LLVMCeilNodeGen.create(args[1]);
                }
                case "llvm.rint.f32": 
                case "llvm.rint.f64": {
                    return LLVMCMathsIntrinsicsFactory.LLVMRintNodeGen.create(args[1]);
                }
                case "llvm.x86.sse.cvtss2si": {
                    return LLVMX86_ConversionNodeFactory.LLVMX86_ConversionFloatToIntNodeGen.create(args[1]);
                }
                case "llvm.x86.sse.cmp.ss": {
                    return LLVMX86_ComparisonNodeFactory.LLVMX86_CmpssNodeGen.create(args[1], args[2], args[3]);
                }
                case "llvm.x86.sse2.cvtsd2si": {
                    return LLVMX86_ConversionNodeFactory.LLVMX86_ConversionDoubleToIntNodeGen.create(args[1]);
                }
                case "llvm.x86.sse2.sqrt.pd": {
                    return LLVMX86_VectorMathNodeFactory.LLVMX86_VectorSquareRootNodeGen.create(args[1]);
                }
                case "llvm.x86.sse2.max.pd": {
                    return LLVMX86_VectorMathNodeFactory.LLVMX86_VectorMaxNodeGen.create(args[1], args[2]);
                }
                case "llvm.x86.sse2.max.sd": {
                    return LLVMX86_VectorMathNodeFactory.LLVMX86_VectorMaxsdNodeGen.create(args[1], args[2]);
                }
                case "llvm.x86.sse2.min.pd": {
                    return LLVMX86_VectorMathNodeFactory.LLVMX86_VectorMinNodeGen.create(args[1], args[2]);
                }
                case "llvm.x86.sse2.cmp.sd": {
                    return LLVMX86_VectorMathNodeFactory.LLVMX86_VectorCmpNodeGen.create(args[1], args[2], args[3]);
                }
                case "llvm.x86.sse2.packssdw.128": 
                case "llvm.x86.sse2.packsswb.128": {
                    return LLVMX86_VectorMathNodeFactory.LLVMX86_VectorPackNodeGen.create(args[1], args[2]);
                }
                case "llvm.x86.sse2.pmovmskb.128": {
                    return LLVMX86_ConversionNodeFactory.LLVMX86_Pmovmskb128NodeGen.create(args[1]);
                }
                case "llvm.x86.sse2.movmsk.pd": {
                    return LLVMX86_ConversionNodeFactory.LLVMX86_MovmskpdNodeGen.create(args[1]);
                }
                case "llvm.experimental.constrained.fpext.f64": 
                case "llvm.experimental.constrained.fpext.f64.f32": {
                    return LLVMToDoubleNodeGen.LLVMSignedCastToDoubleNodeGen.create(args[1]);
                }
                case "llvm.experimental.constrained.fpext.f80": 
                case "llvm.experimental.constrained.fpext.f80.f64": {
                    return LLVMTo80BitFloatingNodeGen.LLVMSignedCastToLLVM80BitFloatNodeGen.create(args[1]);
                }
                case "llvm.experimental.constrained.fadd.f32": {
                    return LLVMArithmeticNodeFactory.LLVMFloatArithmeticNodeGen.create(ArithmeticOperation.ADD, args[1], args[2]);
                }
                case "llvm.experimental.constrained.fadd.f64": {
                    return LLVMArithmeticNodeFactory.LLVMDoubleArithmeticNodeGen.create(ArithmeticOperation.ADD, args[1], args[2]);
                }
                case "llvm.experimental.constrained.fadd.f80": {
                    return LLVMArithmeticNodeFactory.LLVMFP80ArithmeticNodeGen.create(ArithmeticOperation.ADD, args[1], args[2]);
                }
                case "llvm.experimental.constrained.fsub.f32": {
                    return LLVMArithmeticNodeFactory.LLVMFloatArithmeticNodeGen.create(ArithmeticOperation.SUB, args[1], args[2]);
                }
                case "llvm.experimental.constrained.fsub.f64": {
                    return LLVMArithmeticNodeFactory.LLVMDoubleArithmeticNodeGen.create(ArithmeticOperation.SUB, args[1], args[2]);
                }
                case "llvm.experimental.constrained.fsub.f80": {
                    return LLVMArithmeticNodeFactory.LLVMFP80ArithmeticNodeGen.create(ArithmeticOperation.SUB, args[1], args[2]);
                }
                case "llvm.experimental.constrained.fmul.f32": {
                    return LLVMArithmeticNodeFactory.LLVMFloatArithmeticNodeGen.create(ArithmeticOperation.MUL, args[1], args[2]);
                }
                case "llvm.experimental.constrained.fmul.f64": {
                    return LLVMArithmeticNodeFactory.LLVMDoubleArithmeticNodeGen.create(ArithmeticOperation.MUL, args[1], args[2]);
                }
                case "llvm.experimental.constrained.fmul.f80": {
                    return LLVMArithmeticNodeFactory.LLVMFP80ArithmeticNodeGen.create(ArithmeticOperation.MUL, args[1], args[2]);
                }
                case "llvm.experimental.constrained.fdiv.f32": {
                    return LLVMArithmeticNodeFactory.LLVMFloatArithmeticNodeGen.create(ArithmeticOperation.DIV, args[1], args[2]);
                }
                case "llvm.experimental.constrained.fdiv.f64": {
                    return LLVMArithmeticNodeFactory.LLVMDoubleArithmeticNodeGen.create(ArithmeticOperation.DIV, args[1], args[2]);
                }
                case "llvm.experimental.constrained.fdiv.f80": {
                    return LLVMArithmeticNodeFactory.LLVMFP80ArithmeticNodeGen.create(ArithmeticOperation.DIV, args[1], args[2]);
                }
                case "llvm.experimental.constrained.frem.f32": {
                    return LLVMArithmeticNodeFactory.LLVMFloatArithmeticNodeGen.create(ArithmeticOperation.REM, args[1], args[2]);
                }
                case "llvm.experimental.constrained.frem.f64": {
                    return LLVMArithmeticNodeFactory.LLVMDoubleArithmeticNodeGen.create(ArithmeticOperation.REM, args[1], args[2]);
                }
                case "llvm.experimental.constrained.frem.f80": {
                    return LLVMArithmeticNodeFactory.LLVMFP80ArithmeticNodeGen.create(ArithmeticOperation.REM, args[1], args[2]);
                }
            }
        }
        catch (Type.TypeOverflowException e) {
            return Type.handleOverflowExpression(e);
        }
        String typeSuffix = BasicNodeFactory.getTypeSuffix(intrinsicName);
        if (typeSuffix != null) {
            intrinsicName = intrinsicName.substring(0, intrinsicName.length() - typeSuffix.length());
        }
        if ("llvm.prefetch".equals(intrinsicName)) {
            return LLVMPrefetchNodeGen.create(args[1], args[2], args[3], args[4]);
        }
        if ("llvm.is.constant".equals(intrinsicName)) {
            return LLVMIsConstantNodeGen.create(args[1]);
        }
        return LLVMX86_MissingBuiltin.create(declaration.getName());
    }

    @Override
    public LLVMExpressionNode createStackSave() {
        return LLVMStackSaveNodeGen.create();
    }

    @Override
    public LLVMExpressionNode createArithmeticOp(ArithmeticOperation op, Type type, LLVMExpressionNode left, LLVMExpressionNode right) {
        if (type instanceof VectorType) {
            VectorType vectorType = (VectorType)type;
            LLVMArithmeticNode arithmeticNode = this.createScalarArithmeticOp(op, vectorType.getElementType(), null, null);
            return LLVMVectorArithmeticNodeGen.create(vectorType.getNumberOfElementsInt(), arithmeticNode, left, right);
        }
        return this.createScalarArithmeticOp(op, type, left, right);
    }

    protected LLVMArithmeticNode createScalarArithmeticOp(ArithmeticOperation op, Type type, LLVMExpressionNode left, LLVMExpressionNode right) {
        assert (!(type instanceof VectorType));
        if (type instanceof PrimitiveType) {
            switch (((PrimitiveType)type).getPrimitiveKind()) {
                case I1: {
                    return LLVMArithmeticNodeFactory.LLVMI1ArithmeticNodeGen.create(op, left, right);
                }
                case I8: {
                    return LLVMArithmeticNodeFactory.LLVMI8ArithmeticNodeGen.create(op, left, right);
                }
                case I16: {
                    return LLVMArithmeticNodeFactory.LLVMI16ArithmeticNodeGen.create(op, left, right);
                }
                case I32: {
                    return LLVMArithmeticNodeFactory.LLVMI32ArithmeticNodeGen.create(op, left, right);
                }
                case I64: {
                    return LLVMArithmeticNode.LLVMAbstractI64ArithmeticNode.create(op, left, right);
                }
                case FLOAT: {
                    return LLVMArithmeticNodeFactory.LLVMFloatArithmeticNodeGen.create(op, left, right);
                }
                case DOUBLE: {
                    return LLVMArithmeticNodeFactory.LLVMDoubleArithmeticNodeGen.create(op, left, right);
                }
                case X86_FP80: {
                    return LLVMArithmeticNodeFactory.LLVMFP80ArithmeticNodeGen.create(op, left, right);
                }
            }
            throw new AssertionError((Object)("Unknown primitive type: " + type));
        }
        if (type instanceof VariableBitWidthType) {
            return LLVMArithmeticNodeFactory.LLVMIVarBitArithmeticNodeGen.create(op, left, right);
        }
        throw new AssertionError((Object)("Unknown type: " + type));
    }

    @Override
    public LLVMExpressionNode createUnaryOp(UnaryOperation op, Type type, LLVMExpressionNode operand) {
        if (type instanceof VectorType) {
            VectorType vectorType = (VectorType)type;
            LLVMUnaryNode unaryNode = this.createScalarUnaryOp(op, vectorType.getElementType(), null);
            return LLVMVectorUnaryNodeGen.create(vectorType.getNumberOfElementsInt(), unaryNode, operand);
        }
        return this.createScalarUnaryOp(op, type, operand);
    }

    protected LLVMUnaryNode createScalarUnaryOp(UnaryOperation op, Type type, LLVMExpressionNode operand) {
        assert (!(type instanceof VectorType));
        if (type instanceof PrimitiveType) {
            switch (((PrimitiveType)type).getPrimitiveKind()) {
                case FLOAT: {
                    return LLVMUnaryNodeFactory.LLVMFloatUnaryNodeGen.create(op, operand);
                }
                case DOUBLE: {
                    return LLVMUnaryNodeFactory.LLVMDoubleUnaryNodeGen.create(op, operand);
                }
                case X86_FP80: {
                    return LLVMUnaryNodeFactory.LLVMFP80UnaryNodeGen.create(op, operand);
                }
            }
            throw new UnsupportedOperationException("Type is unsupported for scalar unary operation: " + type);
        }
        throw new AssertionError((Object)("Unknown type: " + type));
    }

    @Override
    public LLVMExpressionNode createBitcast(LLVMExpressionNode fromNode, Type targetType, Type fromType) {
        return CommonNodeFactory.createBitcast(fromNode, targetType, fromType);
    }

    @Override
    public LLVMExpressionNode createStackRestore(LLVMExpressionNode stackPointer) {
        return LLVMStackRestoreNodeGen.create(stackPointer);
    }

    private long getOverflowFieldOffset(FunctionDeclaration declaration) throws Type.TypeOverflowException {
        return this.getIndexOffset(1L, (AggregateType)declaration.getType().getReturnType());
    }

    protected LLVMExpressionNode getGccBuiltin(FunctionDeclaration declaration, LLVMExpressionNode[] args) {
        switch (declaration.getName()) {
            case "__builtin_addcb": 
            case "__builtin_addcs": 
            case "__builtin_addc": 
            case "__builtin_addcl": {
                return LLVMArithmeticFactory.LLVMArithmeticWithOverflowAndCarryNodeGen.create(LLVMArithmetic.CARRY_ADD, args[1], args[2], args[3], args[4]);
            }
            case "__builtin_subcb": 
            case "__builtin_subcs": 
            case "__builtin_subc": 
            case "__builtin_subcl": {
                return LLVMArithmeticFactory.LLVMArithmeticWithOverflowAndCarryNodeGen.create(LLVMArithmetic.CARRY_SUB, args[1], args[2], args[3], args[4]);
            }
            case "__builtin_add_overflow": {
                if (BasicNodeFactory.isZeroExtendArithmeticBuiltin(declaration)) {
                    throw new IllegalStateException("Missing GCC builtin: " + declaration.getName());
                }
                return LLVMArithmeticFactory.GCCArithmeticNodeGen.create(LLVMArithmetic.SIGNED_ADD, args[1], args[2], args[3]);
            }
            case "__builtin_sub_overflow": {
                if (BasicNodeFactory.isZeroExtendArithmeticBuiltin(declaration)) {
                    throw new IllegalStateException("Missing GCC builtin: " + declaration.getName());
                }
                return LLVMArithmeticFactory.GCCArithmeticNodeGen.create(LLVMArithmetic.SIGNED_SUB, args[1], args[2], args[3]);
            }
            case "__builtin_mul_overflow": {
                if (BasicNodeFactory.isZeroExtendArithmeticBuiltin(declaration)) {
                    return LLVMArithmeticFactory.GCCArithmeticNodeGen.create(LLVMArithmetic.UNSIGNED_MUL, args[1], args[2], args[3]);
                }
                return LLVMArithmeticFactory.GCCArithmeticNodeGen.create(LLVMArithmetic.SIGNED_MUL, args[1], args[2], args[3]);
            }
        }
        throw new IllegalStateException("Missing GCC builtin: " + declaration.getName());
    }

    private static boolean isZeroExtendArithmeticBuiltin(FunctionDeclaration declaration) {
        AttributesGroup group = declaration.getParameterAttributesGroup(0);
        if (group == null) {
            return false;
        }
        for (Attribute a : group.getAttributes()) {
            if (!(a instanceof Attribute.KnownAttribute) || ((Attribute.KnownAttribute)a).getAttr() != Attribute.Kind.ZEROEXT) continue;
            return true;
        }
        return false;
    }

    @Override
    public LLVMStatementNode createPhi(LLVMExpressionNode[] cycleFrom, LLVMWriteNode[] cycleWrites, LLVMWriteNode[] ordinaryWrites) {
        assert (ordinaryWrites.length > 0 && cycleFrom.length == cycleWrites.length);
        return LLVMWritePhisNodeGen.create(cycleFrom, cycleWrites, ordinaryWrites);
    }

    @Override
    public LLVMExpressionNode createCopyStructByValue(Type type, GetStackSpaceFactory getStackSpaceFactory, LLVMExpressionNode parameterNode) {
        try {
            LLVMExpressionNode getStackSpaceNode = getStackSpaceFactory.createGetStackSpace(this, type);
            return LLVMStructByValueNodeGen.create(this.createMemMove(), getStackSpaceNode, parameterNode, this.getByteSize(type));
        }
        catch (Type.TypeOverflowException e) {
            return Type.handleOverflowExpression(e);
        }
    }

    @Override
    public LLVMExpressionNode createVarArgCompoundValue(long length, int alignment, LLVMExpressionNode parameterNode) {
        return LLVMVarArgCompoundAddressNodeGen.create(parameterNode, length, alignment);
    }

    @Override
    public LLVMMemMoveNode createMemMove() {
        return NativeProfiledMemMoveNodeGen.create();
    }

    @Override
    public LLVMAllocateNode createAllocateGlobalsBlock(StructureType structType, boolean readOnly) {
        try {
            if (readOnly) {
                return new AllocateReadOnlyGlobalsBlockNode(this.context, structType, this.dataLayout);
            }
            return AllocateGlobalsBlockNode.create(structType, this.dataLayout);
        }
        catch (Type.TypeOverflowException e) {
            return Type.handleOverflowAllocate(e);
        }
    }

    @Override
    public LLVMMemoryOpNode createProtectGlobalsBlock() {
        return new ProtectReadOnlyGlobalsBlockNode(this.context);
    }

    @Override
    public LLVMMemoryOpNode createFreeGlobalsBlock(boolean readOnly) {
        if (readOnly) {
            return new FreeReadOnlyGlobalsBlockNode(this.context);
        }
        return LLVMMemoryIntrinsicFactory.LLVMFreeNodeGen.create(null);
    }

    @Override
    public LLVMMemSetNode createMemSet() {
        return NativeMemSetNodeGen.create();
    }

    private static LLVMExpressionNode[] createDoubleLiteralNodes(int nrElements, double value) {
        LLVMExpressionNode[] doubleZeroInits = new LLVMExpressionNode[nrElements];
        for (int i = 0; i < nrElements; ++i) {
            doubleZeroInits[i] = LLVMSimpleLiteralNodeFactory.LLVMDoubleLiteralNodeGen.create(value);
        }
        return doubleZeroInits;
    }

    private static LLVMExpressionNode[] createFloatLiteralNodes(int nrElements, float value) {
        LLVMExpressionNode[] floatZeroInits = new LLVMExpressionNode[nrElements];
        for (int i = 0; i < nrElements; ++i) {
            floatZeroInits[i] = LLVMSimpleLiteralNodeFactory.LLVMFloatLiteralNodeGen.create(value);
        }
        return floatZeroInits;
    }

    private static LLVMExpressionNode[] createI64LiteralNodes(int nrElements, long value) {
        LLVMExpressionNode[] i64ZeroInits = new LLVMExpressionNode[nrElements];
        for (int i = 0; i < nrElements; ++i) {
            i64ZeroInits[i] = LLVMSimpleLiteralNodeFactory.LLVMI64LiteralNodeGen.create(value);
        }
        return i64ZeroInits;
    }

    private static LLVMExpressionNode[] createI32LiteralNodes(int nrElements, int value) {
        LLVMExpressionNode[] i32ZeroInits = new LLVMExpressionNode[nrElements];
        for (int i = 0; i < nrElements; ++i) {
            i32ZeroInits[i] = LLVMSimpleLiteralNodeFactory.LLVMI32LiteralNodeGen.create(value);
        }
        return i32ZeroInits;
    }

    private static LLVMExpressionNode[] createI16LiteralNodes(int nrElements, short value) {
        LLVMExpressionNode[] i16ZeroInits = new LLVMExpressionNode[nrElements];
        for (int i = 0; i < nrElements; ++i) {
            i16ZeroInits[i] = LLVMSimpleLiteralNodeFactory.LLVMI16LiteralNodeGen.create(value);
        }
        return i16ZeroInits;
    }

    private static LLVMExpressionNode[] createI8LiteralNodes(int nrElements, byte value) {
        LLVMExpressionNode[] i8ZeroInits = new LLVMExpressionNode[nrElements];
        for (int i = 0; i < nrElements; ++i) {
            i8ZeroInits[i] = LLVMSimpleLiteralNodeFactory.LLVMI8LiteralNodeGen.create(value);
        }
        return i8ZeroInits;
    }

    private static LLVMExpressionNode[] createI1LiteralNodes(int nrElements, boolean value) {
        LLVMExpressionNode[] i1ZeroInits = new LLVMExpressionNode[nrElements];
        for (int i = 0; i < nrElements; ++i) {
            i1ZeroInits[i] = LLVMSimpleLiteralNodeFactory.LLVMI1LiteralNodeGen.create(value);
        }
        return i1ZeroInits;
    }

    private static LLVMExpressionNode[] createNullAddressLiteralNodes(int nrElements) {
        LLVMExpressionNode[] addressZeroInits = new LLVMExpressionNode[nrElements];
        for (int i = 0; i < nrElements; ++i) {
            addressZeroInits[i] = LLVMSimpleLiteralNodeFactory.LLVMNativePointerLiteralNodeGen.create(LLVMNativePointer.createNull());
        }
        return addressZeroInits;
    }

    private LLVMStatementNode createStore(LLVMExpressionNode pointerNode, LLVMExpressionNode valueNode, Type type, long size) {
        if (type instanceof PrimitiveType) {
            switch (((PrimitiveType)type).getPrimitiveKind()) {
                case I1: {
                    return LLVMI1StoreNodeGen.create(pointerNode, valueNode);
                }
                case I8: {
                    return LLVMI8StoreNodeGen.create(pointerNode, valueNode);
                }
                case I16: {
                    return LLVMI16StoreNodeGen.create(pointerNode, valueNode);
                }
                case I32: {
                    return LLVMI32StoreNodeGen.create(pointerNode, valueNode);
                }
                case I64: {
                    return LLVMI64StoreNodeGen.create(pointerNode, valueNode);
                }
                case FLOAT: {
                    return LLVMFloatStoreNodeGen.create(pointerNode, valueNode);
                }
                case DOUBLE: {
                    return LLVMDoubleStoreNodeGen.create(pointerNode, valueNode);
                }
                case X86_FP80: {
                    return LLVM80BitFloatStoreNodeGen.create(pointerNode, valueNode);
                }
            }
            throw new AssertionError(type);
        }
        if (type instanceof VariableBitWidthType) {
            return LLVMIVarBitStoreNodeGen.create(pointerNode, valueNode);
        }
        if (type instanceof StructureType || type instanceof ArrayType) {
            return LLVMStructStoreNodeGen.create(this.createMemMove(), pointerNode, valueNode, size);
        }
        if (type instanceof PointerType || type instanceof FunctionType) {
            return LLVMPointerStoreNodeGen.create(pointerNode, valueNode);
        }
        if (type instanceof VectorType) {
            VectorType vectorType = (VectorType)type;
            return LLVMStoreVectorNodeGen.create(pointerNode, valueNode, vectorType.getNumberOfElementsInt());
        }
        throw new AssertionError(type);
    }

    public int getByteAlignment(Type type) {
        return type.getAlignment(this.dataLayout);
    }

    public long getByteSize(Type type) throws Type.TypeOverflowException {
        return type.getSize(this.dataLayout);
    }

    public int getBytePadding(long offset, Type type) {
        return Type.getPadding(offset, type, this.dataLayout);
    }

    public long getIndexOffset(long index, AggregateType type) throws Type.TypeOverflowException {
        return type.getOffsetOf(index, this.dataLayout);
    }

    @Override
    public LLVMControlFlowNode createLoop(RepeatingNode body, int[] successorIDs) {
        return LLVMLoopNode.create(body, successorIDs);
    }

    @Override
    public RepeatingNode createLoopDispatchNode(FrameSlot exceptionValueSlot, List<? extends LLVMStatementNode> bodyNodes, LLVMBasicBlockNode[] originalBodyNodes, int headerId, int[] indexMapping, int[] successors, FrameSlot successorSlot) {
        return new LLVMLoopDispatchNode(exceptionValueSlot, bodyNodes.toArray(new LLVMBasicBlockNode[bodyNodes.size()]), originalBodyNodes, headerId, indexMapping, successors, successorSlot);
    }
}

