/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser;

import com.oracle.truffle.llvm.runtime.ExternalLibrary;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMScope;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;

public final class LLVMParserRuntime {
    private final LLVMContext context;
    private final ExternalLibrary library;
    private final LLVMScope fileScope;
    private final NodeFactory nodeFactory;
    private final int bitcodeID;

    public LLVMParserRuntime(LLVMContext context, ExternalLibrary library, LLVMScope fileScope, NodeFactory nodeFactory, int bitcodeID) {
        this.context = context;
        this.library = library;
        this.fileScope = fileScope;
        this.nodeFactory = nodeFactory;
        this.bitcodeID = bitcodeID;
    }

    public ExternalLibrary getLibrary() {
        return this.library;
    }

    public LLVMContext getContext() {
        return this.context;
    }

    public LLVMScope getFileScope() {
        return this.fileScope;
    }

    public NodeFactory getNodeFactory() {
        return this.nodeFactory;
    }

    public int getBitcodeID() {
        return this.bitcodeID;
    }

    public LLVMFunction lookupFunction(String name) {
        LLVMSymbol symbol = this.fileScope.get(name);
        if (symbol != null && symbol.isFunction()) {
            return symbol.asFunction();
        }
        throw new IllegalStateException("Retrieving unknown function symbol in LLVMParserRuntime: " + name);
    }

    public LLVMGlobal lookupGlobal(String name) {
        LLVMSymbol symbol = this.fileScope.get(name);
        if (symbol != null && symbol.isGlobalVariable()) {
            return symbol.asGlobalVariable();
        }
        throw new IllegalStateException("Retrieving unknown global symbol in LLVMParserRuntime: " + name);
    }

    public LLVMSymbol lookupSymbol(String name) {
        LLVMSymbol symbol = this.fileScope.get(name);
        if (symbol != null) {
            return symbol;
        }
        throw new IllegalStateException("Unknown symbol: " + name);
    }
}

