/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedContext;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.utilities.AssumedValue;
import com.oracle.truffle.llvm.CXXDemangler;
import com.oracle.truffle.llvm.DefaultLoader;
import com.oracle.truffle.llvm.ParseContext;
import com.oracle.truffle.llvm.RunnerFactory;
import com.oracle.truffle.llvm.parser.LLVMParser;
import com.oracle.truffle.llvm.parser.LLVMParserResult;
import com.oracle.truffle.llvm.parser.LLVMParserRuntime;
import com.oracle.truffle.llvm.parser.StackManager;
import com.oracle.truffle.llvm.parser.binary.BinaryParser;
import com.oracle.truffle.llvm.parser.binary.BinaryParserResult;
import com.oracle.truffle.llvm.parser.model.GlobalSymbol;
import com.oracle.truffle.llvm.parser.model.ModelModule;
import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.functions.FunctionSymbol;
import com.oracle.truffle.llvm.parser.model.symbols.constants.aggregate.ArrayConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.aggregate.StructureConstant;
import com.oracle.truffle.llvm.parser.model.symbols.globals.GlobalVariable;
import com.oracle.truffle.llvm.parser.model.target.TargetDataLayout;
import com.oracle.truffle.llvm.parser.nodes.LLVMSymbolReadResolver;
import com.oracle.truffle.llvm.parser.scanner.LLVMScanner;
import com.oracle.truffle.llvm.parser.util.Pair;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.ExternalLibrary;
import com.oracle.truffle.llvm.runtime.GetStackSpaceFactory;
import com.oracle.truffle.llvm.runtime.LLVMAlias;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMFunctionCode;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LLVMIntrinsicProvider;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.LLVMLocalScope;
import com.oracle.truffle.llvm.runtime.LLVMScope;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.LLVMUnsupportedException;
import com.oracle.truffle.llvm.runtime.LibraryLocator;
import com.oracle.truffle.llvm.runtime.NFIContextExtension;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.PlatformCapability;
import com.oracle.truffle.llvm.runtime.SulongLibrary;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.debug.LLVMSourceContext;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceSymbol;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugObjectBuilder;
import com.oracle.truffle.llvm.runtime.except.LLVMLinkerException;
import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobalContainer;
import com.oracle.truffle.llvm.runtime.memory.LLVMAllocateNode;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemoryOpNode;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMHasDatalayoutNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMVoidStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMVoidStatementNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMGlobalRootNode;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMAccessSymbolNode;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMCheckSymbolNode;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMCheckSymbolNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMStatementRootNode;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMWriteSymbolNode;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMWriteSymbolNodeGen;
import com.oracle.truffle.llvm.runtime.options.SulongEngineOption;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.types.ArrayType;
import com.oracle.truffle.llvm.runtime.types.FunctionType;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.StructureType;
import com.oracle.truffle.llvm.runtime.types.Type;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.polyglot.io.ByteSequence;

final class Runner {
    private static final String MAIN_METHOD_NAME = "main";
    private static final String START_METHOD_NAME = "_start";
    private static final int LEAST_CONSTRUCTOR_PRIORITY = 65535;
    private static final Comparator<Pair<Integer, ?>> ASCENDING_PRIORITY = (p1, p2) -> (Integer)p1.getFirst() - (Integer)p2.getFirst();
    private static final Comparator<Pair<Integer, ?>> DESCENDING_PRIORITY = (p1, p2) -> (Integer)p2.getFirst() - (Integer)p1.getFirst();
    private final LLVMContext context;
    private final DefaultLoader loader;
    private final LLVMLanguage language;
    private final AtomicInteger nextFreeBitcodeID;
    static final String SULONG_RENAME_MARKER = "___sulong_import_";
    static final int SULONG_RENAME_MARKER_LEN = "___sulong_import_".length();

    public static CallTarget parse(LLVMContext context, DefaultLoader loader, AtomicInteger bitcodeID, Source source) {
        return new Runner(context, loader, bitcodeID).parseWithDependencies(source);
    }

    private Runner(LLVMContext context, DefaultLoader loader, AtomicInteger moduleID) {
        this.context = context;
        this.loader = loader;
        this.language = context.getLanguage();
        this.nextFreeBitcodeID = moduleID;
    }

    private CallTarget parseWithDependencies(Source source) {
        ExternalLibrary library;
        ByteSequence bytes;
        if (source.hasBytes()) {
            bytes = source.getBytes();
            library = source.getPath() != null ? ExternalLibrary.createFromFile(this.context.getEnv().getInternalTruffleFile(source.getPath()), false, source.isInternal()) : ExternalLibrary.createFromName("<STREAM-" + UUID.randomUUID().toString() + ">", false, source.isInternal());
        } else {
            if (source.hasCharacters()) {
                throw new LLVMParserException("Unexpected character-based source with mime type: " + source.getMimeType());
            }
            throw new LLVMParserException("Should not reach here: Source is neither char-based nor byte-based!");
        }
        return this.parseWithDependencies(source, bytes, library);
    }

    private CallTarget parseWithDependencies(Source source, ByteSequence bytes, ExternalLibrary library) {
        ParseContext parseContext = ParseContext.create();
        this.parseLibraryWithSource(source, library, bytes, parseContext);
        assert (!library.isNative() && !parseContext.parserResultsIsEmpty());
        ExternalLibrary[] sulongLibraries = this.parseDependencies(parseContext);
        assert (parseContext.dependencyQueueIsEmpty());
        for (LLVMParserResult parserResult : parseContext.getParserResults()) {
            if (!this.context.isInternalLibrary(parserResult.getRuntime().getLibrary())) continue;
            Runner.resolveRenamedSymbols(parserResult, parseContext);
        }
        List<LLVMParserResult> parserResults = parseContext.getParserResults();
        Runner.addExternalSymbolsToScopes(parserResults);
        InitializationOrder initializationOrder = Runner.computeInitializationOrder(parserResults, sulongLibraries);
        return this.createLibraryCallTarget(source.getName(), parserResults, initializationOrder);
    }

    private static void addPaddingTypes(ArrayList<Type> result, int padding) {
        int size;
        assert (padding >= 0);
        for (int remaining = padding; remaining > 0; remaining -= size) {
            size = Math.min(8, Integer.highestOneBit(remaining));
            result.add(PrimitiveType.getIntegerType(size * 8));
        }
    }

    private static int getAlignment(DataLayout dataLayout, GlobalVariable global, Type type) {
        return global.getAlign() > 0 ? 1 << global.getAlign() - 1 : type.getAlignment(dataLayout);
    }

    private static boolean isSpecialGlobalSlot(Type type) {
        return type instanceof PointerType;
    }

    private ExternalLibrary[] parseDefaultLibraries(ParseContext parseContext) {
        String[] sulongLibraryNames = this.language.getCapability(PlatformCapability.class).getSulongDefaultLibraries();
        ExternalLibrary[] sulongLibraries = new ExternalLibrary[sulongLibraryNames.length];
        for (int i = 0; i < sulongLibraries.length; ++i) {
            sulongLibraries[i] = this.context.addInternalLibrary(sulongLibraryNames[i], "<default bitcode library>");
        }
        List<String> externals = SulongEngineOption.getPolyglotOptionExternalLibraries(this.context.getEnv());
        for (String external : externals) {
            ExternalLibrary lib = this.context.addExternalLibraryDefaultLocator(external, "<command line>");
            if (lib == null) continue;
            this.parseLibrary(lib, parseContext);
        }
        LLVMParserResult[] sulongLibraryResults = new LLVMParserResult[sulongLibraries.length];
        for (int i = 0; i < sulongLibraries.length; ++i) {
            sulongLibraryResults[i] = this.parseLibrary(sulongLibraries[i], parseContext);
            if (!sulongLibraries[i].getName().startsWith("libsulong.")) continue;
            this.context.addLibsulongDataLayout(sulongLibraryResults[i].getDataLayout());
        }
        while (!parseContext.dependencyQueueIsEmpty()) {
            ExternalLibrary lib = parseContext.dependencyQueueRemoveFirst();
            this.parseLibrary(lib, parseContext);
        }
        return sulongLibraries;
    }

    private ExternalLibrary[] parseDependencies(ParseContext parseContext) {
        ExternalLibrary lib;
        int directDependencies = parseContext.dependencyQueueSize();
        for (int i = 0; i < directDependencies; ++i) {
            lib = parseContext.dependencyQueueRemoveFirst();
            this.parseLibrary(lib, parseContext);
        }
        ExternalLibrary[] sulongLibraries = this.getDefaultDependencies(parseContext);
        while (!parseContext.dependencyQueueIsEmpty()) {
            lib = parseContext.dependencyQueueRemoveFirst();
            this.parseLibrary(lib, parseContext);
        }
        return sulongLibraries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExternalLibrary[] getDefaultDependencies(ParseContext parseContext) {
        if (this.loader.getCachedDefaultDependencies() == null) {
            DefaultLoader defaultLoader = this.loader;
            synchronized (defaultLoader) {
                if (this.loader.getCachedDefaultDependencies() == null) {
                    ParseContext newParseContext = ParseContext.create();
                    ExternalLibrary[] defaultLibraries = this.parseDefaultLibraries(newParseContext);
                    List<LLVMParserResult> parserResults = newParseContext.getParserResults();
                    this.loader.setDefaultLibraries(defaultLibraries, parserResults);
                }
            }
        }
        parseContext.parserResultsAddAll(this.loader.getCachedDefaultDependencies());
        return this.loader.getCachedSulongLibraries();
    }

    private static void resolveRenamedSymbols(LLVMParserResult parserResult, ParseContext parseContext) {
        EconomicMap libToRes = EconomicMap.create();
        for (LLVMParserResult res : parseContext.getParserResults()) {
            libToRes.put((Object)res.getRuntime().getLibrary(), (Object)res);
        }
        EconomicMap scopes = EconomicMap.create();
        EconomicMap libs = EconomicMap.create();
        ArrayDeque<ExternalLibrary> dependencyQueue = new ArrayDeque<ExternalLibrary>(parserResult.getDependencies());
        EconomicSet visited = EconomicSet.create((Equivalence)Equivalence.IDENTITY);
        visited.addAll(parserResult.getDependencies());
        while (!dependencyQueue.isEmpty()) {
            ExternalLibrary dep = dependencyQueue.removeFirst();
            LLVMParserResult depResult = (LLVMParserResult)libToRes.get((Object)dep);
            if (depResult == null) continue;
            String libraryName = Runner.getSimpleLibraryName(dep.getName());
            scopes.put((Object)libraryName, (Object)depResult.getRuntime().getFileScope());
            libs.put((Object)libraryName, (Object)dep);
            for (ExternalLibrary transDep : depResult.getDependencies()) {
                if (visited.contains((Object)transDep)) continue;
                dependencyQueue.addLast(transDep);
                visited.add((Object)transDep);
            }
        }
        ListIterator<FunctionSymbol> it = parserResult.getExternalFunctions().listIterator();
        while (it.hasNext()) {
            LLVMFunction originalSymbol;
            String originalName;
            LLVMScope scope;
            String lib;
            FunctionSymbol external = it.next();
            String name = external.getName();
            if (name.startsWith(SULONG_RENAME_MARKER)) {
                int idx = name.indexOf(95, SULONG_RENAME_MARKER_LEN);
                if (idx <= 0) continue;
                lib = name.substring(SULONG_RENAME_MARKER_LEN, idx);
                scope = (LLVMScope)scopes.get((Object)lib);
                if (scope != null) {
                    originalName = name.substring(idx + 1);
                    originalSymbol = scope.getFunction(originalName);
                    if (originalSymbol == null) {
                        throw new LLVMLinkerException(String.format("The symbol %s could not be imported because the symbol %s was not found in library %s", external.getName(), originalName, libs.get((Object)lib)));
                    }
                    LLVMFunction newFunction = LLVMFunction.create(name, originalSymbol.getLibrary(), originalSymbol.getFunction(), originalSymbol.getType(), parserResult.getRuntime().getBitcodeID(), external.getIndex(), external.isExported());
                    parserResult.getRuntime().getFileScope().register(newFunction);
                    it.remove();
                    parserResult.getDefinedFunctions().add(external);
                    continue;
                }
                throw new LLVMLinkerException(String.format("The symbol %s could not be imported because library %s was not found", external.getName(), libs.get((Object)lib)));
            }
            if (!CXXDemangler.isRenamedNamespaceSymbol(name)) continue;
            ArrayList<String> namespaces = CXXDemangler.decodeNamespace(name);
            lib = CXXDemangler.getAndRemoveLibraryName(namespaces);
            scope = (LLVMScope)scopes.get((Object)lib);
            if (scope != null) {
                originalName = CXXDemangler.encodeNamespace(namespaces);
                originalSymbol = scope.getFunction(originalName);
                if (originalSymbol == null) {
                    throw new LLVMLinkerException(String.format("The symbol %s could not be imported because the symbol %s was not found in library %s", external.getName(), originalName, libs.get((Object)lib)));
                }
                LLVMAlias alias = new LLVMAlias(parserResult.getRuntime().getLibrary(), name, originalSymbol, originalSymbol.isExported());
                parserResult.getRuntime().getFileScope().register(alias);
                it.remove();
                continue;
            }
            throw new LLVMLinkerException(String.format("The symbol %s could not be imported because library %s was not found", external.getName(), lib));
        }
    }

    private static String getSimpleLibraryName(String name) {
        int index = name.indexOf(".");
        if (index == -1) {
            return name;
        }
        return name.substring(0, index);
    }

    private LLVMParserResult parseLibrary(ExternalLibrary lib, ParseContext parseContext) {
        Source source;
        if (lib.hasFile() && !lib.getFile().isRegularFile(new LinkOption[0]) || lib.getPath() == null || !lib.getPath().toFile().isFile()) {
            if (!lib.isNative()) {
                throw new LLVMParserException("'" + lib.getPath() + "' is not a file or does not exist.");
            }
            return null;
        }
        TruffleFile file = lib.hasFile() ? lib.getFile() : this.context.getEnv().getInternalTruffleFile(lib.getPath().toUri());
        try {
            source = Source.newBuilder((String)"llvm", (TruffleFile)file).internal(lib.isInternal()).build();
        }
        catch (IOException | OutOfMemoryError | SecurityException ex) {
            throw new LLVMParserException("Error reading file " + lib.getPath() + ".");
        }
        return this.parseLibraryWithSource(source, lib, source.getBytes(), parseContext);
    }

    private LLVMParserResult parseBinary(BinaryParserResult binaryParserResult, ExternalLibrary library) {
        ModelModule module = new ModelModule();
        Source source = binaryParserResult.getSource();
        LLVMScanner.parseBitcode(binaryParserResult.getBitcode(), module, source, this.context);
        TargetDataLayout layout = module.getTargetDataLayout();
        DataLayout targetDataLayout = new DataLayout(layout.getDataLayout());
        NodeFactory nodeFactory = this.context.getLanguage().getActiveConfiguration().createNodeFactory(this.context, targetDataLayout);
        LLVMScope fileScope = new LLVMScope();
        int bitcodeID = this.nextFreeBitcodeID.getAndIncrement();
        LLVMParserRuntime runtime = new LLVMParserRuntime(this.context, library, fileScope, nodeFactory, bitcodeID);
        LLVMParser parser = new LLVMParser(source, runtime);
        LLVMParserResult result = parser.parse(module, targetDataLayout);
        this.createDebugInfo(module, new LLVMSymbolReadResolver(runtime, StackManager.createRootFrame(), GetStackSpaceFactory.createAllocaFactory(), targetDataLayout, false));
        return result;
    }

    private void createDebugInfo(ModelModule model, LLVMSymbolReadResolver symbolResolver) {
        LLVMSourceContext sourceContext = this.context.getSourceContext();
        model.getSourceGlobals().forEach((symbol, irValue) -> {
            LLVMExpressionNode node = symbolResolver.resolve((SymbolImpl)irValue);
            LLVMDebugObjectBuilder value = CommonNodeFactory.createDebugStaticValue(this.context, node, irValue instanceof GlobalVariable);
            sourceContext.registerStatic((LLVMSourceSymbol)symbol, value);
        });
        model.getSourceStaticMembers().forEach((type, symbol) -> {
            LLVMExpressionNode node = symbolResolver.resolve((SymbolImpl)symbol);
            LLVMDebugObjectBuilder value = CommonNodeFactory.createDebugStaticValue(this.context, node, symbol instanceof GlobalVariable);
            type.setValue(value);
        });
    }

    private LLVMParserResult parseLibraryWithSource(Source source, ExternalLibrary library, ByteSequence bytes, ParseContext parseContext) {
        BinaryParserResult binaryParserResult = BinaryParser.parse(bytes, source, this.context);
        if (binaryParserResult != null) {
            library.makeBitcodeLibrary();
            this.context.ensureExternalLibraryAdded(library);
            this.context.addLibraryPaths(binaryParserResult.getLibraryPaths());
            ArrayList<ExternalLibrary> dependencies = this.processDependencies(library, binaryParserResult, parseContext);
            LLVMParserResult parserResult = this.parseBinary(binaryParserResult, library);
            parserResult.setDependencies(dependencies);
            parseContext.parserResultsAdd(parserResult);
            return parserResult;
        }
        if (!library.isNative()) {
            throw new LLVMParserException("The file '" + source.getName() + "' is not a bitcode file nor an ELF or Mach-O object file with an embedded bitcode section.");
        }
        LibraryLocator.traceDelegateNative(this.context, library);
        return null;
    }

    private ArrayList<ExternalLibrary> processDependencies(ExternalLibrary library, BinaryParserResult binaryParserResult, ParseContext parseContext) {
        ArrayList<ExternalLibrary> dependencies = new ArrayList<ExternalLibrary>();
        for (String lib : this.context.preprocessDependencies(library, binaryParserResult.getLibraries())) {
            ExternalLibrary dependency = this.context.findExternalLibrary(lib, library, binaryParserResult.getLocator());
            if (dependency != null) {
                dependencies.add(dependency);
                continue;
            }
            dependency = this.context.addExternalLibrary(lib, library, binaryParserResult.getLocator());
            if (dependency == null) continue;
            parseContext.dependencyQueueAddLast(dependency);
            dependencies.add(dependency);
        }
        return dependencies;
    }

    private static void addExternalSymbolsToScopes(List<LLVMParserResult> parserResults) {
        for (LLVMParserResult parserResult : parserResults) {
            LLVMScope fileScope = parserResult.getRuntime().getFileScope();
            for (FunctionSymbol function : parserResult.getExternalFunctions()) {
                if (fileScope.contains(function.getName())) continue;
                fileScope.register(LLVMFunction.create(function.getName(), null, new LLVMFunctionCode.UnresolvedFunction(), function.getType(), parserResult.getRuntime().getBitcodeID(), function.getIndex(), false));
            }
            for (GlobalVariable global : parserResult.getExternalGlobals()) {
                if (fileScope.contains(global.getName())) continue;
                fileScope.register(LLVMGlobal.create(global.getName(), global.getType(), global.getSourceSymbol(), global.isReadOnly(), global.getIndex(), parserResult.getRuntime().getBitcodeID(), false));
            }
        }
    }

    private static InitializationOrder computeInitializationOrder(List<LLVMParserResult> parserResults, ExternalLibrary[] defaultLibraries) {
        List<ExternalLibrary> sulongExternalLibraries = Arrays.asList(defaultLibraries);
        InitializationOrder initializationOrder = new InitializationOrder();
        EconomicMap dependencyToParserResult = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
        EconomicSet visited = EconomicSet.create((Equivalence)Equivalence.IDENTITY);
        for (LLVMParserResult parserResult : parserResults) {
            ExternalLibrary library = parserResult.getRuntime().getLibrary();
            dependencyToParserResult.put((Object)library, (Object)parserResult);
            if (sulongExternalLibraries.contains(library)) {
                initializationOrder.addSulongLibraries(parserResult);
                visited.add((Object)parserResult);
                continue;
            }
            initializationOrder.addScopeInitializationLibraries(parserResult);
        }
        for (LLVMParserResult otherlib : initializationOrder.getScopeInitializationOrderLibraries()) {
            if (visited.contains((Object)otherlib)) continue;
            Runner.addModuleToInitializationOrder(otherlib, initializationOrder, (EconomicMap<ExternalLibrary, LLVMParserResult>)dependencyToParserResult, (EconomicSet<LLVMParserResult>)visited);
            assert (initializationOrder.getModuleInitializationOrderLibraries().contains(otherlib));
        }
        assert (initializationOrder.getModuleInitializationOrderLibraries().containsAll(initializationOrder.getScopeInitializationOrderLibraries()));
        return initializationOrder;
    }

    private static void addModuleToInitializationOrder(LLVMParserResult module, InitializationOrder initializationOrder, EconomicMap<ExternalLibrary, LLVMParserResult> dependencyToParserResult, EconomicSet<LLVMParserResult> visited) {
        if (visited.contains((Object)module)) {
            return;
        }
        visited.add((Object)module);
        for (ExternalLibrary dep : module.getDependencies()) {
            LLVMParserResult depLib = (LLVMParserResult)dependencyToParserResult.get((Object)dep);
            if (depLib == null) continue;
            Runner.addModuleToInitializationOrder(depLib, initializationOrder, dependencyToParserResult, visited);
        }
        initializationOrder.addModuleInitializationLibraries(module);
    }

    private static StaticInitsNode createGlobalVariableInitializer(FrameDescriptor rootFrame, LLVMParserResult parserResult, Object moduleName) {
        LLVMParserRuntime runtime = parserResult.getRuntime();
        LLVMSymbolReadResolver symbolResolver = new LLVMSymbolReadResolver(runtime, rootFrame, GetStackSpaceFactory.createAllocaFactory(), parserResult.getDataLayout(), false);
        ArrayList<LLVMStatementNode> globalNodes = new ArrayList<LLVMStatementNode>();
        for (GlobalVariable global : parserResult.getDefinedGlobals()) {
            LLVMStatementNode store = Runner.createGlobalInitialization(runtime, symbolResolver, global, parserResult.getDataLayout());
            if (store == null) continue;
            globalNodes.add(store);
        }
        LLVMStatementNode[] initNodes = globalNodes.toArray(LLVMStatementNode.NO_STATEMENTS);
        return RunnerFactory.StaticInitsNodeGen.create(initNodes, "global variable initializers", moduleName);
    }

    private static LLVMStatementNode createGlobalInitialization(LLVMParserRuntime runtime, LLVMSymbolReadResolver symbolResolver, GlobalVariable global, DataLayout dataLayout) {
        if (global == null || global.getValue() == null) {
            return null;
        }
        LLVMExpressionNode constant = symbolResolver.resolve(global.getValue());
        if (constant != null) {
            try {
                Type type = global.getType().getPointeeType();
                long size = type.getSize(dataLayout);
                LLVMGlobal globalDescriptor = runtime.getFileScope().getGlobalVariable(global.getName());
                assert (globalDescriptor != null);
                LLVMExpressionNode globalVarAddress = runtime.getNodeFactory().createLiteral(globalDescriptor, new PointerType(global.getType()));
                if (size != 0L) {
                    if (type instanceof ArrayType || type instanceof StructureType) {
                        return runtime.getNodeFactory().createStore(globalVarAddress, constant, type);
                    }
                    Type t = global.getValue().getType();
                    return runtime.getNodeFactory().createStore(globalVarAddress, constant, t);
                }
            }
            catch (Type.TypeOverflowException e) {
                return Type.handleOverflowStatement(e);
            }
        }
        return null;
    }

    private static StaticInitsNode createConstructor(LLVMParserResult parserResult, Object moduleName) {
        return RunnerFactory.StaticInitsNodeGen.create(Runner.createStructor("llvm.global_ctors", parserResult, ASCENDING_PRIORITY), "init", moduleName);
    }

    private RootCallTarget createDestructor(LLVMParserResult parserResult, Object moduleName) {
        LLVMStatementNode[] destructor = Runner.createStructor("llvm.global_dtors", parserResult, DESCENDING_PRIORITY);
        if (destructor.length > 0) {
            LLVMStatementRootNode root = new LLVMStatementRootNode(this.language, RunnerFactory.StaticInitsNodeGen.create(destructor, "fini", moduleName), StackManager.createRootFrame());
            return Truffle.getRuntime().createCallTarget((RootNode)root);
        }
        return null;
    }

    private static LLVMStatementNode[] createStructor(String name, LLVMParserResult parserResult, Comparator<Pair<Integer, ?>> priorityComparator) {
        for (GlobalVariable globalVariable : parserResult.getDefinedGlobals()) {
            if (!globalVariable.getName().equals(name)) continue;
            return Runner.resolveStructor(parserResult.getRuntime().getFileScope(), globalVariable, priorityComparator, parserResult.getDataLayout(), parserResult.getRuntime().getNodeFactory());
        }
        return LLVMStatementNode.NO_STATEMENTS;
    }

    private static LLVMStatementNode[] resolveStructor(LLVMScope fileScope, GlobalVariable globalSymbol, Comparator<Pair<Integer, ?>> priorityComparator, DataLayout dataLayout, NodeFactory nodeFactory) {
        if (!(globalSymbol.getValue() instanceof ArrayConstant)) {
            return LLVMStatementNode.NO_STATEMENTS;
        }
        LLVMGlobal global = (LLVMGlobal)fileScope.get(globalSymbol.getName());
        ArrayConstant arrayConstant = (ArrayConstant)globalSymbol.getValue();
        int elemCount = arrayConstant.getElementCount();
        StructureType elementType = (StructureType)arrayConstant.getType().getElementType();
        try {
            long elementSize = elementType.getSize(dataLayout);
            FunctionType functionType = (FunctionType)((PointerType)elementType.getElementType(1L)).getPointeeType();
            int indexedTypeLength = functionType.getAlignment(dataLayout);
            ArrayList<Pair<Integer, LLVMVoidStatementNode>> structors = new ArrayList<Pair<Integer, LLVMVoidStatementNode>>(elemCount);
            FrameDescriptor rootFrame = StackManager.createRootFrame();
            for (int i = 0; i < elemCount; ++i) {
                LLVMExpressionNode globalVarAddress = nodeFactory.createLiteral(global, new PointerType(globalSymbol.getType()));
                LLVMExpressionNode iNode = nodeFactory.createLiteral(i, PrimitiveType.I32);
                LLVMExpressionNode structPointer = nodeFactory.createTypedElementPointer(elementSize, elementType, globalVarAddress, iNode);
                LLVMLoadNode loadedStruct = CommonNodeFactory.createLoad(elementType, structPointer);
                LLVMExpressionNode oneLiteralNode = nodeFactory.createLiteral(1, PrimitiveType.I32);
                LLVMExpressionNode functionLoadTarget = nodeFactory.createTypedElementPointer(indexedTypeLength, functionType, loadedStruct, oneLiteralNode);
                LLVMLoadNode loadedFunction = CommonNodeFactory.createLoad(functionType, functionLoadTarget);
                LLVMExpressionNode[] argNodes = new LLVMExpressionNode[]{CommonNodeFactory.createFrameRead(PointerType.VOID, rootFrame.findFrameSlot((Object)"<stackpointer>"))};
                LLVMVoidStatementNode functionCall = LLVMVoidStatementNodeGen.create(CommonNodeFactory.createFunctionCall(loadedFunction, argNodes, functionType));
                StructureConstant structorDefinition = (StructureConstant)arrayConstant.getElement(i);
                SymbolImpl prioritySymbol = structorDefinition.getElement(0);
                Integer priority = LLVMSymbolReadResolver.evaluateIntegerConstant(prioritySymbol);
                structors.add(new Pair<Integer, LLVMVoidStatementNode>(priority != null ? priority : 65535, functionCall));
            }
            return (LLVMStatementNode[])structors.stream().sorted(priorityComparator).map(Pair::getSecond).toArray(LLVMStatementNode[]::new);
        }
        catch (Type.TypeOverflowException e) {
            return new LLVMStatementNode[]{Type.handleOverflowStatement(e)};
        }
    }

    private CallTarget createLibraryCallTarget(String name, List<LLVMParserResult> parserResults, InitializationOrder initializationOrder) {
        RootCallTarget mainFunctionCallTarget = null;
        LLVMFunctionDescriptor startFunctionDescriptor = this.findAndSetSulongSpecificFunctions(initializationOrder.sulongLibraries);
        LLVMFunction mainFunction = Runner.findMainFunction(parserResults);
        if (startFunctionDescriptor != null && mainFunction != null) {
            RootCallTarget startCallTarget = startFunctionDescriptor.getFunctionCode().getLLVMIRFunctionSlowPath();
            Path applicationPath = mainFunction.getLibrary().getPath();
            LLVMGlobalRootNode rootNode = new LLVMGlobalRootNode(this.language, StackManager.createRootFrame(), mainFunction, (CallTarget)startCallTarget, Objects.toString(applicationPath, ""));
            mainFunctionCallTarget = Truffle.getRuntime().createCallTarget((RootNode)rootNode);
        }
        if (((Boolean)this.context.getEnv().getOptions().get(SulongEngineOption.PARSE_ONLY)).booleanValue()) {
            return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode((Object)0));
        }
        LLVMScope scope = Runner.combineScopes(parserResults);
        SulongLibrary lib = new SulongLibrary(name, scope, (CallTarget)mainFunctionCallTarget, this.context);
        FrameDescriptor rootFrame = StackManager.createRootFrame();
        boolean lazyParsing = (Boolean)this.context.getEnv().getOptions().get(SulongEngineOption.LAZY_PARSING);
        LoadModulesNode loadModules = LoadModulesNode.create(this, rootFrame, initializationOrder, lib, lazyParsing, this.context);
        return Truffle.getRuntime().createCallTarget((RootNode)loadModules);
    }

    private static LLVMFunction findMainFunction(List<LLVMParserResult> parserResults) {
        for (LLVMParserResult parserResult : parserResults) {
            LLVMFunction mainFunction;
            LLVMScope fileScope = parserResult.getRuntime().getFileScope();
            LLVMSymbol mainSymbol = fileScope.get(MAIN_METHOD_NAME);
            if (mainSymbol == null || !mainSymbol.isFunction() || !mainSymbol.isDefined() || !((mainFunction = mainSymbol.asFunction()).getFunction() instanceof LLVMFunctionCode.LLVMIRFunction) && !(mainFunction.getFunction() instanceof LLVMFunctionCode.LazyLLVMIRFunction)) continue;
            return mainFunction;
        }
        return null;
    }

    private LLVMFunctionDescriptor findAndSetSulongSpecificFunctions(List<LLVMParserResult> sulongLibraries) {
        LLVMFunctionDescriptor startFunction = null;
        LLVMSymbol initContext = null;
        LLVMSymbol disposeContext = null;
        for (LLVMParserResult parserResult : sulongLibraries) {
            LLVMSymbol tmpDisposeContext;
            LLVMSymbol tmpInitContext;
            LLVMSymbol function;
            if (startFunction != null && initContext != null && disposeContext != null) break;
            LLVMScope fileScope = parserResult.getRuntime().getFileScope();
            if (startFunction == null && (function = fileScope.get(START_METHOD_NAME)) != null && function.isDefined()) {
                startFunction = this.context.createFunctionDescriptor(function.asFunction());
            }
            if (initContext == null && (tmpInitContext = fileScope.get("__sulong_init_context")) != null && tmpInitContext.isDefined() && tmpInitContext.isFunction()) {
                initContext = tmpInitContext;
            }
            if (disposeContext != null || (tmpDisposeContext = fileScope.get("__sulong_dispose_context")) == null || !tmpDisposeContext.isDefined() || !tmpDisposeContext.isFunction()) continue;
            disposeContext = tmpDisposeContext;
        }
        if (initContext == null) {
            throw new IllegalStateException("Context cannot be initialized: __sulong_init_context was not found in sulong libraries");
        }
        if (disposeContext == null) {
            throw new IllegalStateException("Context cannot be initialized: __sulong_dispose_context was not found in sulong libraries");
        }
        this.context.setSulongInitContext(initContext.asFunction());
        this.context.setSulongDisposeContext(disposeContext.asFunction());
        return startFunction;
    }

    private static LLVMScope combineScopes(List<LLVMParserResult> parserResults) {
        LLVMScope result = new LLVMScope();
        for (LLVMParserResult parserResult : parserResults) {
            LLVMScope scope = parserResult.getRuntime().getFileScope();
            result.addMissingEntries(scope);
        }
        return result;
    }

    private static final class InitializationOrder {
        private final ArrayList<LLVMParserResult> sulongLibraries = new ArrayList();
        private final ArrayList<LLVMParserResult> moduleInitializationOrderLibraries = new ArrayList();
        private final ArrayList<LLVMParserResult> scopeInitializationOrderLibraries = new ArrayList();

        private InitializationOrder() {
        }

        public ArrayList<LLVMParserResult> getSulongLibraries() {
            return this.sulongLibraries;
        }

        public ArrayList<LLVMParserResult> getModuleInitializationOrderLibraries() {
            return this.moduleInitializationOrderLibraries;
        }

        public ArrayList<LLVMParserResult> getScopeInitializationOrderLibraries() {
            return this.scopeInitializationOrderLibraries;
        }

        public void addSulongLibraries(LLVMParserResult sulongLibrary) {
            this.sulongLibraries.add(sulongLibrary);
        }

        public void addModuleInitializationLibraries(LLVMParserResult moduleInitializationLibrary) {
            this.moduleInitializationOrderLibraries.add(moduleInitializationLibrary);
        }

        public void addScopeInitializationLibraries(LLVMParserResult scopeInitializationLibrary) {
            this.scopeInitializationOrderLibraries.add(scopeInitializationLibrary);
        }
    }

    private static final class InitializeModuleNode
    extends LLVMNode
    implements LLVMHasDatalayoutNode {
        private final RootCallTarget destructor;
        private final DataLayout dataLayout;
        @Node.Child
        StaticInitsNode constructor;

        InitializeModuleNode(Runner runner, LLVMParserResult parserResult, Object moduleName) {
            this.destructor = runner.createDestructor(parserResult, moduleName);
            this.dataLayout = parserResult.getDataLayout();
            this.constructor = Runner.createConstructor(parserResult, moduleName);
        }

        void execute(VirtualFrame frame, LLVMContext ctx) {
            if (this.destructor != null) {
                ctx.registerDestructorFunctions(this.destructor);
            }
            this.constructor.execute(frame);
        }

        @Override
        public DataLayout getDatalayout() {
            return this.dataLayout;
        }
    }

    private static final class InitializeGlobalNode
    extends LLVMNode
    implements LLVMHasDatalayoutNode {
        private final DataLayout dataLayout;
        @Node.Child
        StaticInitsNode globalVarInit;
        @Node.Child
        LLVMMemoryOpNode protectRoData;

        InitializeGlobalNode(FrameDescriptor rootFrame, LLVMParserResult parserResult, Object moduleName) {
            this.dataLayout = parserResult.getDataLayout();
            this.globalVarInit = Runner.createGlobalVariableInitializer(rootFrame, parserResult, moduleName);
            this.protectRoData = parserResult.getRuntime().getNodeFactory().createProtectGlobalsBlock();
        }

        void execute(VirtualFrame frame, LLVMPointer roDataBase) {
            this.globalVarInit.execute(frame);
            if (roDataBase != null) {
                this.protectRoData.execute(roDataBase);
            }
        }

        @Override
        public DataLayout getDatalayout() {
            return this.dataLayout;
        }
    }

    private static final class InitializeOverwriteNode
    extends LLVMNode {
        @Node.Children
        final AllocExternalSymbolNode[] allocExternalSymbols;
        @Node.Child
        LLVMWriteSymbolNode writeSymbols = LLVMWriteSymbolNodeGen.create();

        InitializeOverwriteNode(LLVMParserResult result) {
            ArrayList<AllocExistingLocalSymbolsNode> allocExternaSymbolsList = new ArrayList<AllocExistingLocalSymbolsNode>();
            LLVMScope fileScope = result.getRuntime().getFileScope();
            for (FunctionSymbol functionSymbol : result.getDefinedFunctions()) {
                if (!functionSymbol.isOverridable()) continue;
                LLVMFunction function = fileScope.getFunction(functionSymbol.getName());
                allocExternaSymbolsList.add(RunnerFactory.AllocExistingLocalSymbolsNodeGen.create(function));
            }
            for (GlobalSymbol globalSymbol : result.getDefinedGlobals()) {
                if (!globalSymbol.isOverridable() || globalSymbol.isIntrinsicGlobalVariable()) continue;
                LLVMGlobal global = fileScope.getGlobalVariable(globalSymbol.getName());
                allocExternaSymbolsList.add(RunnerFactory.AllocExternalGlobalNodeGen.create(global));
            }
            this.allocExternalSymbols = allocExternaSymbolsList.toArray(AllocExternalSymbolNode.EMPTY);
        }

        @ExplodeLoop
        void execute(LLVMContext context, LLVMLocalScope localScope) {
            LLVMScope globalScope = context.getGlobalScope();
            for (int i = 0; i < this.allocExternalSymbols.length; ++i) {
                AllocExternalSymbolNode allocSymbol = this.allocExternalSymbols[i];
                LLVMPointer pointer = allocSymbol.execute(localScope, globalScope, null, null);
                if (pointer == null) continue;
                this.writeSymbols.execute(pointer, allocSymbol.symbol);
            }
        }
    }

    private static final class InitializeExternalNode
    extends LLVMNode {
        @Node.Child
        LLVMWriteSymbolNode writeSymbols;
        @Node.Children
        AllocExternalSymbolNode[] allocExternalSymbols;
        private final NodeFactory nodeFactory;

        InitializeExternalNode(LLVMParserResult result) {
            this.nodeFactory = result.getRuntime().getNodeFactory();
            LLVMScope fileScope = result.getRuntime().getFileScope();
            ArrayList<AllocExistingGlobalSymbolsNode> allocExternaSymbolsList = new ArrayList<AllocExistingGlobalSymbolsNode>();
            for (FunctionSymbol functionSymbol : result.getExternalFunctions()) {
                String name = functionSymbol.getName();
                LLVMFunction function = fileScope.getFunction(name);
                if (name.startsWith("llvm.") || name.startsWith("__builtin_") || name.equals("polyglot_get_arg") || name.equals("polyglot_get_arg_count")) continue;
                allocExternaSymbolsList.add(RunnerFactory.AllocExternalFunctionNodeGen.create(function, this.nodeFactory));
            }
            for (GlobalSymbol globalSymbol : result.getExternalGlobals()) {
                LLVMGlobal global = fileScope.getGlobalVariable(globalSymbol.getName());
                allocExternaSymbolsList.add(RunnerFactory.AllocExternalGlobalNodeGen.create(global));
            }
            this.writeSymbols = LLVMWriteSymbolNodeGen.create();
            this.allocExternalSymbols = allocExternaSymbolsList.toArray(AllocExternalSymbolNode.EMPTY);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExplodeLoop
        void execute(LLVMContext context, LLVMLocalScope localScope) {
            LLVMScope globalScope = context.getGlobalScope();
            LLVMIntrinsicProvider intrinsicProvider = LLVMLanguage.getLanguage().getCapability(LLVMIntrinsicProvider.class);
            NFIContextExtension nfiContextExtension = InitializeExternalNode.getNfiContextExtension(context);
            LLVMContext lLVMContext = context;
            synchronized (lLVMContext) {
                for (int i = 0; i < this.allocExternalSymbols.length; ++i) {
                    AllocExternalSymbolNode function = this.allocExternalSymbols[i];
                    LLVMPointer pointer = function.execute(localScope, globalScope, intrinsicProvider, nfiContextExtension);
                    if (pointer == null) continue;
                    this.writeSymbols.execute(pointer, function.symbol);
                }
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static NFIContextExtension getNfiContextExtension(LLVMContext context) {
            return context.getContextExtensionOrNull(NFIContextExtension.class);
        }
    }

    private static final class InitializeScopeNode
    extends LLVMNode {
        @Node.Children
        final AllocScopeNode[] allocScopes;
        private final int bitcodeID;
        private final LLVMScope fileScope;

        InitializeScopeNode(LLVMParserResult result, int bitcodeID) {
            this.bitcodeID = bitcodeID;
            this.fileScope = result.getRuntime().getFileScope();
            ArrayList<AllocScopeNode> allocScopesList = new ArrayList<AllocScopeNode>();
            for (LLVMSymbol symbol : this.fileScope.values()) {
                if (!symbol.isExported()) continue;
                allocScopesList.add(new AllocScopeNode(symbol));
            }
            this.allocScopes = allocScopesList.toArray(AllocScopeNode.EMPTY);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void execute(LLVMContext context, LLVMLocalScope localScope) {
            LLVMContext lLVMContext = context;
            synchronized (lLVMContext) {
                for (int i = 0; i < this.allocScopes.length; ++i) {
                    AllocScopeNode allocScope = this.allocScopes[i];
                    allocScope.allocateScope(context, localScope);
                }
            }
        }

        public int getBitcodeID() {
            return this.bitcodeID;
        }

        public boolean shouldInitialize(LLVMContext ctx) {
            return !ctx.isScopeLoadedForScopes(this.fileScope);
        }

        public void initializeScope(LLVMContext context) {
            context.registerScopeForScopes(this.fileScope);
        }
    }

    static abstract class StaticInitsNode
    extends LLVMStatementNode {
        @Node.Children
        final LLVMStatementNode[] statements;
        final Object moduleName;
        final String prefix;

        StaticInitsNode(LLVMStatementNode[] statements, String prefix, Object moduleName) {
            this.statements = statements;
            this.prefix = prefix;
            this.moduleName = moduleName;
        }

        @ExplodeLoop
        @Specialization
        public void doInit(VirtualFrame frame, @CachedContext(value=LLVMLanguage.class) LLVMContext ctx) {
            if (ctx.loaderTraceStream() != null) {
                this.traceExecution(ctx);
            }
            for (LLVMStatementNode stmt : this.statements) {
                stmt.execute(frame);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private void traceExecution(LLVMContext ctx) {
            LibraryLocator.traceStaticInits(ctx, this.prefix, this.moduleName, String.format("[%d inst]", this.statements.length));
        }
    }

    private static final class InitializeSymbolsNode
    extends LLVMNode {
        @Node.Child
        LLVMAllocateNode allocRoSection;
        @Node.Child
        LLVMAllocateNode allocRwSection;
        @Node.Child
        LLVMCheckSymbolNode checkGlobals;
        @Node.Child
        LLVMWriteSymbolNode writeSymbols;
        @Node.Children
        final AllocGlobalNode[] allocGlobals;
        final String moduleName;
        @Node.Children
        final AllocSymbolNode[] allocFuncs;
        private final LLVMScope fileScope;
        private NodeFactory nodeFactory;
        private final int bitcodeID;
        private final int globalLength;

        InitializeSymbolsNode(LLVMParserResult result, NodeFactory nodeFactory, boolean lazyParsing, boolean isInternalSulongLibrary, String moduleName) throws Type.TypeOverflowException {
            DataLayout dataLayout = result.getDataLayout();
            this.nodeFactory = nodeFactory;
            this.fileScope = result.getRuntime().getFileScope();
            this.checkGlobals = LLVMCheckSymbolNodeGen.create();
            this.globalLength = result.getSymbolTableSize();
            this.bitcodeID = result.getRuntime().getBitcodeID();
            this.moduleName = moduleName;
            DataSection roSection = new DataSection(dataLayout);
            DataSection rwSection = new DataSection(dataLayout);
            ArrayList<AllocGlobalNode> allocGlobalsList = new ArrayList<AllocGlobalNode>();
            LLVMIntrinsicProvider intrinsicProvider = LLVMLanguage.getLanguage().getCapability(LLVMIntrinsicProvider.class);
            for (GlobalVariable global : result.getDefinedGlobals()) {
                Type type = global.getType().getPointeeType();
                if (Runner.isSpecialGlobalSlot(type)) {
                    allocGlobalsList.add(new AllocPointerGlobalNode(global));
                    continue;
                }
                if (type.getSize(dataLayout) == 0L) {
                    type = PrimitiveType.getIntegerType(8);
                }
                allocGlobalsList.add(new AllocOtherGlobalNode(global, type, roSection, rwSection));
            }
            ArrayList<AllocSymbolNode> allocFuncsAndAliasesList = new ArrayList<AllocSymbolNode>();
            for (FunctionSymbol functionSymbol : result.getDefinedFunctions()) {
                LLVMFunction function = this.fileScope.getFunction(functionSymbol.getName());
                if (isInternalSulongLibrary && intrinsicProvider.isIntrinsified(function.getName())) {
                    allocFuncsAndAliasesList.add(new AllocIntrinsicFunctionNode(function, nodeFactory, intrinsicProvider));
                    continue;
                }
                if (lazyParsing) {
                    allocFuncsAndAliasesList.add(new AllocLLVMFunctionNode(function));
                    continue;
                }
                allocFuncsAndAliasesList.add(new AllocLLVMEagerFunctionNode(function));
            }
            this.allocRoSection = roSection.getAllocateNode(nodeFactory, "roglobals_struct", true);
            this.allocRwSection = rwSection.getAllocateNode(nodeFactory, "rwglobals_struct", false);
            this.allocGlobals = allocGlobalsList.toArray(AllocGlobalNode.EMPTY);
            this.allocFuncs = allocFuncsAndAliasesList.toArray(AllocSymbolNode.EMPTY);
            this.writeSymbols = LLVMWriteSymbolNodeGen.create();
        }

        public boolean shouldInitialize(LLVMContext ctx) {
            return !ctx.isScopeLoaded(this.fileScope);
        }

        public void initializeSymbolTable(LLVMContext context) {
            context.registerSymbolTable(this.bitcodeID, new AssumedValue[this.globalLength]);
            context.registerScope(this.fileScope);
        }

        public LLVMPointer execute(LLVMContext ctx) {
            if (ctx.loaderTraceStream() != null) {
                LibraryLocator.traceStaticInits(ctx, "symbol initializers", this.moduleName);
            }
            LLVMPointer roBase = InitializeSymbolsNode.allocOrNull(this.allocRoSection);
            LLVMPointer rwBase = InitializeSymbolsNode.allocOrNull(this.allocRwSection);
            this.allocGlobals(ctx, roBase, rwBase);
            this.allocFunctions(ctx);
            if (this.allocRoSection != null) {
                ctx.registerReadOnlyGlobals(roBase, this.nodeFactory);
            }
            if (this.allocRwSection != null) {
                ctx.registerGlobals(rwBase, this.nodeFactory);
            }
            return roBase;
        }

        @ExplodeLoop
        private void allocGlobals(LLVMContext context, LLVMPointer roBase, LLVMPointer rwBase) {
            for (int i = 0; i < this.allocGlobals.length; ++i) {
                AllocGlobalNode allocGlobal = this.allocGlobals[i];
                LLVMGlobal descriptor = this.fileScope.getGlobalVariable(allocGlobal.name);
                if (descriptor == null) {
                    CompilerDirectives.transferToInterpreter();
                    throw new IllegalStateException(String.format("Global variable %s not found", allocGlobal.name));
                }
                if (this.checkGlobals.execute(descriptor)) continue;
                LLVMPointer ref = allocGlobal.allocate(context, roBase, rwBase);
                this.writeSymbols.execute(ref, descriptor);
                ArrayList<LLVMSymbol> list = new ArrayList<LLVMSymbol>();
                list.add(descriptor);
                context.registerSymbolReverseMap(list, ref);
            }
        }

        @ExplodeLoop
        private void allocFunctions(LLVMContext ctx) {
            for (int i = 0; i < this.allocFuncs.length; ++i) {
                AllocSymbolNode allocSymbol = this.allocFuncs[i];
                LLVMPointer pointer = allocSymbol.allocate(ctx);
                this.writeSymbols.execute(pointer, allocSymbol.symbol);
                ArrayList<LLVMSymbol> list = new ArrayList<LLVMSymbol>();
                list.add(allocSymbol.symbol);
                ctx.registerSymbolReverseMap(list, pointer);
            }
        }

        private static LLVMPointer allocOrNull(LLVMAllocateNode allocNode) {
            if (allocNode != null) {
                return allocNode.executeWithTarget();
            }
            return null;
        }
    }

    private static final class DataSection {
        final DataLayout dataLayout;
        final ArrayList<Type> types = new ArrayList();
        private long offset = 0L;

        DataSection(DataLayout dataLayout) {
            this.dataLayout = dataLayout;
        }

        long add(GlobalVariable global, Type type) throws Type.TypeOverflowException {
            int alignment = Runner.getAlignment(this.dataLayout, global, type);
            int padding = Type.getPadding(this.offset, alignment);
            Runner.addPaddingTypes(this.types, padding);
            long ret = this.offset = Type.addUnsignedExact(this.offset, padding);
            this.types.add(type);
            this.offset = Type.addUnsignedExact(this.offset, type.getSize(this.dataLayout));
            return ret;
        }

        LLVMAllocateNode getAllocateNode(NodeFactory factory, String typeName, boolean readOnly) {
            if (this.offset > 0L) {
                StructureType structType = StructureType.createNamedFromList(typeName, true, this.types);
                return factory.createAllocateGlobalsBlock(structType, readOnly);
            }
            return null;
        }
    }

    private static final class AllocOtherGlobalNode
    extends AllocGlobalNode {
        final boolean readOnly;
        final long offset;

        AllocOtherGlobalNode(GlobalVariable global, Type type, DataSection roSection, DataSection rwSection) throws Type.TypeOverflowException {
            super(global);
            this.readOnly = global.isReadOnly();
            DataSection dataSection = this.readOnly ? roSection : rwSection;
            this.offset = dataSection.add(global, type);
        }

        @Override
        LLVMPointer allocate(LLVMContext context, LLVMPointer roBase, LLVMPointer rwBase) {
            LLVMPointer base = this.readOnly ? roBase : rwBase;
            return base.increment(this.offset);
        }
    }

    private static final class AllocPointerGlobalNode
    extends AllocGlobalNode {
        AllocPointerGlobalNode(GlobalVariable global) {
            super(global);
        }

        @Override
        LLVMPointer allocate(LLVMContext context, LLVMPointer roBase, LLVMPointer rwBase) {
            return LLVMManagedPointer.create(new LLVMGlobalContainer());
        }
    }

    private static abstract class AllocGlobalNode
    extends LLVMNode {
        static final AllocGlobalNode[] EMPTY = new AllocGlobalNode[0];
        final String name;

        AllocGlobalNode(GlobalVariable global) {
            this.name = global.getName();
        }

        abstract LLVMPointer allocate(LLVMContext var1, LLVMPointer var2, LLVMPointer var3);

        @Override
        public String toString() {
            return "AllocGlobal: " + this.name;
        }
    }

    private static final class AllocIntrinsicFunctionNode
    extends AllocSymbolNode {
        private NodeFactory nodeFactory;
        LLVMIntrinsicProvider intrinsicProvider;

        AllocIntrinsicFunctionNode(LLVMFunction function, NodeFactory nodeFactory, LLVMIntrinsicProvider intrinsicProvider) {
            super(function);
            this.nodeFactory = nodeFactory;
            this.intrinsicProvider = intrinsicProvider;
        }

        @CompilerDirectives.TruffleBoundary
        private LLVMFunctionDescriptor createAndDefine(LLVMContext context) {
            LLVMFunctionDescriptor functionDescriptor = context.createFunctionDescriptor(this.symbol.asFunction());
            if (this.intrinsicProvider.isIntrinsified(this.symbol.getName())) {
                functionDescriptor.getFunctionCode().define(this.intrinsicProvider, this.nodeFactory);
                return functionDescriptor;
            }
            throw new IllegalStateException("Failed to allocate intrinsic function " + this.symbol.getName());
        }

        @Override
        LLVMPointer allocate(LLVMContext context) {
            LLVMFunctionDescriptor functionDescriptor = this.createAndDefine(context);
            return LLVMManagedPointer.create(functionDescriptor);
        }
    }

    private static final class AllocLLVMEagerFunctionNode
    extends AllocSymbolNode {
        AllocLLVMEagerFunctionNode(LLVMFunction function) {
            super(function);
        }

        @CompilerDirectives.TruffleBoundary
        private LLVMFunctionDescriptor createAndResolve(LLVMContext context) {
            LLVMFunctionDescriptor functionDescriptor = context.createFunctionDescriptor(this.symbol.asFunction());
            functionDescriptor.getFunctionCode().resolveIfLazyLLVMIRFunction();
            return functionDescriptor;
        }

        @Override
        LLVMPointer allocate(LLVMContext context) {
            LLVMFunctionDescriptor functionDescriptor = this.createAndResolve(context);
            return LLVMManagedPointer.create(functionDescriptor);
        }
    }

    private static final class AllocLLVMFunctionNode
    extends AllocSymbolNode {
        AllocLLVMFunctionNode(LLVMFunction function) {
            super(function);
        }

        @CompilerDirectives.TruffleBoundary
        private LLVMFunctionDescriptor createAndResolve(LLVMContext context) {
            return context.createFunctionDescriptor(this.symbol.asFunction());
        }

        @Override
        LLVMPointer allocate(LLVMContext context) {
            LLVMFunctionDescriptor functionDescriptor = this.createAndResolve(context);
            return LLVMManagedPointer.create(functionDescriptor);
        }
    }

    private static abstract class AllocSymbolNode
    extends LLVMNode {
        static final AllocSymbolNode[] EMPTY = new AllocSymbolNode[0];
        final LLVMSymbol symbol;

        AllocSymbolNode(LLVMSymbol symbol) {
            this.symbol = symbol;
        }

        abstract LLVMPointer allocate(LLVMContext var1);
    }

    static abstract class AllocExternalGlobalNode
    extends AllocExistingGlobalSymbolsNode {
        AllocExternalGlobalNode(LLVMSymbol symbol) {
            super(symbol);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"localScope.get(symbol.getName()) == null", "globalScope.get(symbol.getName()) == null", "!symbol.isDefined()", "!intrinsicProvider.isIntrinsified(symbol.getName())", "nfiContextExtension != null", "symbol.isGlobalVariable()"})
        LLVMPointer allocateNativeGlobal(LLVMLocalScope localScope, LLVMScope globalScope, LLVMIntrinsicProvider intrinsicProvider, NFIContextExtension nfiContextExtension, @CachedContext(value=LLVMLanguage.class) LLVMContext context) {
            NFIContextExtension.NativePointerIntoLibrary pointer = nfiContextExtension.getNativeHandle(context, this.symbol.getName());
            if (pointer != null) {
                if (!this.symbol.isDefined()) {
                    this.symbol.asGlobalVariable().define(pointer.getLibrary());
                }
                return LLVMNativePointer.create(pointer.getAddress());
            }
            return null;
        }

        @Override
        public abstract LLVMPointer execute(LLVMLocalScope var1, LLVMScope var2, LLVMIntrinsicProvider var3, NFIContextExtension var4);
    }

    static abstract class AllocExternalFunctionNode
    extends AllocExistingGlobalSymbolsNode {
        private final NodeFactory nodeFactory;

        AllocExternalFunctionNode(LLVMSymbol symbol, NodeFactory nodeFactory) {
            super(symbol);
            this.nodeFactory = nodeFactory;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"intrinsicProvider != null", "localScope.get(symbol.getName()) == null", "globalScope.get(symbol.getName()) == null", "!symbol.isDefined()", "intrinsicProvider.isIntrinsified(symbol.getName())", "symbol.isFunction()"})
        LLVMPointer allocateIntrinsicFunction(LLVMLocalScope localScope, LLVMScope globalScope, LLVMIntrinsicProvider intrinsicProvider, NFIContextExtension nfiContextExtension, @CachedContext(value=LLVMLanguage.class) LLVMContext context) {
            LLVMFunctionDescriptor functionDescriptor = context.createFunctionDescriptor(this.symbol.asFunction());
            functionDescriptor.getFunctionCode().define(intrinsicProvider, this.nodeFactory);
            return LLVMManagedPointer.create(functionDescriptor);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"localScope.get(symbol.getName()) == null", "globalScope.get(symbol.getName()) == null", "!symbol.isDefined()", "!intrinsicProvider.isIntrinsified(symbol.getName())", "nfiContextExtension != null", "symbol.isFunction()"})
        LLVMPointer allocateNativeFunction(LLVMLocalScope localScope, LLVMScope globalScope, LLVMIntrinsicProvider intrinsicProvider, NFIContextExtension nfiContextExtension, @CachedContext(value=LLVMLanguage.class) LLVMContext context) {
            NFIContextExtension.NativeLookupResult nativeFunction = nfiContextExtension.getNativeFunctionOrNull(context, this.symbol.getName());
            if (nativeFunction != null) {
                LLVMFunctionDescriptor functionDescriptor = context.createFunctionDescriptor(this.symbol.asFunction());
                functionDescriptor.getFunctionCode().define(nativeFunction.getLibrary(), new LLVMFunctionCode.NativeFunction(nativeFunction.getObject()));
                return LLVMManagedPointer.create(functionDescriptor);
            }
            return null;
        }

        @Override
        public abstract LLVMPointer execute(LLVMLocalScope var1, LLVMScope var2, LLVMIntrinsicProvider var3, NFIContextExtension var4);
    }

    static abstract class AllocExistingGlobalSymbolsNode
    extends AllocExistingLocalSymbolsNode {
        AllocExistingGlobalSymbolsNode(LLVMSymbol symbol) {
            super(symbol);
        }

        @Specialization(guards={"localScope.get(symbol.getName()) == null", "cachedGlobalSymbol != null", "globalScope.get(symbol.getName()) == cachedGlobalSymbol", "!(containsSymbol(cachedGlobalSymbol))"})
        LLVMPointer allocateFromGlobalScopeCached(LLVMLocalScope localScope, LLVMScope globalScope, LLVMIntrinsicProvider intrinsicProvider, NFIContextExtension nfiContextExtension, @Cached(value="globalScope.get(symbol.getName())") LLVMSymbol cachedGlobalSymbol, @Cached(value="create(cachedGlobalSymbol)") LLVMAccessSymbolNode accessSymbol, @CachedContext(value=LLVMLanguage.class) LLVMContext context) {
            LLVMPointer pointer = accessSymbol.execute();
            context.registerSymbol(this.symbol, pointer);
            return pointer;
        }

        @Specialization(replaces={"allocateFromGlobalScopeCached"}, guards={"localScope.get(symbol.getName()) == null", "globalScope.get(symbol.getName()) != null", "!(containsSymbol(globalScope.get(symbol.getName())))"})
        LLVMPointer allocateFromGlobalScope(LLVMLocalScope localScope, LLVMScope globalScope, LLVMIntrinsicProvider intrinsicProvider, NFIContextExtension nfiContextExtension, @CachedContext(value=LLVMLanguage.class) LLVMContext context) {
            LLVMSymbol function = globalScope.get(this.symbol.getName());
            assert (function.isFunction());
            while (function.isAlias()) {
                function = ((LLVMAlias)function).getTarget();
            }
            AssumedValue<LLVMPointer>[] symbolTable = context.findSymbolTable(function.getBitcodeID(false));
            LLVMPointer pointer = (LLVMPointer)symbolTable[function.getSymbolIndex(false)].get();
            context.registerSymbol(this.symbol, pointer);
            return pointer;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        protected boolean containsSymbol(LLVMSymbol globalSymbol) {
            return this.symbol.equals(globalSymbol);
        }

        @Override
        public abstract LLVMPointer execute(LLVMLocalScope var1, LLVMScope var2, LLVMIntrinsicProvider var3, NFIContextExtension var4);
    }

    static abstract class AllocExistingLocalSymbolsNode
    extends AllocExternalSymbolNode {
        AllocExistingLocalSymbolsNode(LLVMSymbol symbol) {
            super(symbol);
        }

        @Specialization(guards={"cachedLocalSymbol != null", "localScope.get(symbol.getName()) == cachedLocalSymbol", "!(containsSymbol(cachedLocalSymbol))"})
        LLVMPointer allocateFromLocalScopeCached(LLVMLocalScope localScope, LLVMScope globalScope, LLVMIntrinsicProvider intrinsicProvider, NFIContextExtension nfiContextExtension, @Cached(value="localScope.get(symbol.getName())") LLVMSymbol cachedLocalSymbol, @Cached(value="create(cachedLocalSymbol)") LLVMAccessSymbolNode accessSymbol, @CachedContext(value=LLVMLanguage.class) LLVMContext context) {
            LLVMPointer pointer = accessSymbol.execute();
            context.registerSymbol(this.symbol, pointer);
            return pointer;
        }

        @Specialization(replaces={"allocateFromLocalScopeCached"}, guards={"localScope.get(symbol.getName()) != null", "!(containsSymbol(localScope.get(symbol.getName())))"})
        LLVMPointer allocateFromLocalScope(LLVMLocalScope localScope, LLVMScope globalScope, LLVMIntrinsicProvider intrinsicProvider, NFIContextExtension nfiContextExtension, @CachedContext(value=LLVMLanguage.class) LLVMContext context) {
            LLVMSymbol function = localScope.get(this.symbol.getName());
            while (function.isAlias()) {
                function = ((LLVMAlias)function).getTarget();
            }
            AssumedValue<LLVMPointer>[] symbolTable = context.findSymbolTable(function.getBitcodeID(false));
            LLVMPointer pointer = (LLVMPointer)symbolTable[function.getSymbolIndex(false)].get();
            context.registerSymbol(this.symbol, pointer);
            return pointer;
        }

        @CompilerDirectives.TruffleBoundary
        protected boolean containsSymbol(LLVMSymbol localSymbol) {
            return this.symbol.equals(localSymbol);
        }

        @Fallback
        LLVMPointer allocateFromLocalScopeFallback(LLVMLocalScope localScope, LLVMScope globalScope, LLVMIntrinsicProvider intrinsicProvider, NFIContextExtension nfiContextExtension) {
            return null;
        }

        @Override
        public abstract LLVMPointer execute(LLVMLocalScope var1, LLVMScope var2, LLVMIntrinsicProvider var3, NFIContextExtension var4);
    }

    static abstract class AllocExternalSymbolNode
    extends LLVMNode {
        static final AllocExternalSymbolNode[] EMPTY = new AllocExternalSymbolNode[0];
        final LLVMSymbol symbol;

        AllocExternalSymbolNode(LLVMSymbol symbol) {
            this.symbol = symbol;
        }

        public abstract LLVMPointer execute(LLVMLocalScope var1, LLVMScope var2, LLVMIntrinsicProvider var3, NFIContextExtension var4);
    }

    private static final class AllocScopeNode
    extends LLVMNode {
        static final AllocScopeNode[] EMPTY = new AllocScopeNode[0];
        final LLVMSymbol symbol;

        AllocScopeNode(LLVMSymbol symbol) {
            this.symbol = symbol;
        }

        void allocateScope(LLVMContext context, LLVMLocalScope localScope) {
            LLVMSymbol exportedSymbolFromLocal;
            LLVMScope globalScope = context.getGlobalScope();
            LLVMSymbol exportedSymbol = globalScope.get(this.symbol.getName());
            if (exportedSymbol == null) {
                globalScope.register(this.symbol);
            }
            if ((exportedSymbolFromLocal = localScope.get(this.symbol.getName())) == null) {
                localScope.register(this.symbol);
            }
        }
    }

    private static final class LoadModulesNode
    extends RootNode {
        final SulongLibrary sulongLibrary;
        final FrameSlot stackPointerSlot;
        @CompilerDirectives.CompilationFinal
        TruffleLanguage.ContextReference<LLVMContext> ctxRef;
        @Node.Child
        LLVMStatementNode initContext;
        @Node.Children
        final InitializeSymbolsNode[] initSymbols;
        @Node.Children
        final InitializeScopeNode[] initScopes;
        @Node.Children
        final InitializeExternalNode[] initExternals;
        @Node.Children
        final InitializeGlobalNode[] initGlobals;
        @Node.Children
        final InitializeOverwriteNode[] initOverwrite;
        @Node.Children
        final InitializeModuleNode[] initModules;

        private LoadModulesNode(Runner runner, FrameDescriptor rootFrame, InitializationOrder order, SulongLibrary sulongLibrary) {
            super((TruffleLanguage)runner.language, rootFrame);
            this.sulongLibrary = sulongLibrary;
            this.stackPointerSlot = rootFrame.findFrameSlot((Object)"<stackpointer>");
            this.initContext = runner.context.createInitializeContextNode(rootFrame);
            int libCount = order.getSulongLibraries().size() + order.moduleInitializationOrderLibraries.size();
            this.initSymbols = new InitializeSymbolsNode[libCount];
            this.initScopes = new InitializeScopeNode[libCount];
            this.initExternals = new InitializeExternalNode[libCount];
            this.initGlobals = new InitializeGlobalNode[libCount];
            this.initOverwrite = new InitializeOverwriteNode[libCount];
            this.initModules = new InitializeModuleNode[libCount];
        }

        static LoadModulesNode create(Runner runner, FrameDescriptor rootFrame, InitializationOrder order, SulongLibrary sulongLibrary, boolean lazyParsing, LLVMContext context) {
            LoadModulesNode node = new LoadModulesNode(runner, rootFrame, order, sulongLibrary);
            try {
                LoadModulesNode.createNodes(runner, rootFrame, order.getSulongLibraries(), 0, node.initSymbols, node.initOverwrite, node.initExternals, node.initGlobals, node.initModules, lazyParsing, context);
                LoadModulesNode.createNodes(runner, rootFrame, order.moduleInitializationOrderLibraries, order.getSulongLibraries().size(), node.initSymbols, node.initOverwrite, node.initExternals, node.initGlobals, node.initModules, lazyParsing, context);
                LoadModulesNode.initializeScopeNodes(order.getSulongLibraries(), 0, node.initScopes);
                LoadModulesNode.initializeScopeNodes(order.scopeInitializationOrderLibraries, order.getSulongLibraries().size(), node.initScopes);
                return node;
            }
            catch (Type.TypeOverflowException e) {
                throw new LLVMUnsupportedException((Node)node, LLVMUnsupportedException.UnsupportedReason.UNSUPPORTED_VALUE_RANGE, (Throwable)e);
            }
        }

        private static void createNodes(Runner runner, FrameDescriptor rootFrame, List<LLVMParserResult> parserResults, int offset, InitializeSymbolsNode[] initSymbols, InitializeOverwriteNode[] initOverwrite, InitializeExternalNode[] initExternals, InitializeGlobalNode[] initGlobals, InitializeModuleNode[] initModules, boolean lazyParsing, LLVMContext context) throws Type.TypeOverflowException {
            for (int i = 0; i < parserResults.size(); ++i) {
                LLVMParserResult res = parserResults.get(i);
                String moduleName = res.getRuntime().getLibrary().toString();
                initSymbols[offset + i] = new InitializeSymbolsNode(res, res.getRuntime().getNodeFactory(), lazyParsing, LoadModulesNode.isInternalSulongLibrary(context, res.getRuntime().getLibrary()), moduleName);
                initExternals[offset + i] = new InitializeExternalNode(res);
                initGlobals[offset + i] = new InitializeGlobalNode(rootFrame, res, moduleName);
                initOverwrite[offset + i] = new InitializeOverwriteNode(res);
                initModules[offset + i] = new InitializeModuleNode(runner, res, moduleName);
            }
        }

        private static void initializeScopeNodes(List<LLVMParserResult> parserResults, int offset, InitializeScopeNode[] initScopes) {
            for (int i = 0; i < parserResults.size(); ++i) {
                LLVMParserResult res = parserResults.get(i);
                initScopes[offset + i] = new InitializeScopeNode(res, res.getRuntime().getBitcodeID());
            }
        }

        public Object execute(VirtualFrame frame) {
            LLVMLocalScope localScope = LoadModulesNode.createLocalScope();
            if (this.ctxRef == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.ctxRef = this.lookupContextReference(LLVMLanguage.class);
            }
            LLVMContext ctx = (LLVMContext)this.ctxRef.get();
            ctx.addLocalScope(localScope);
            try (LLVMStack.StackPointer stackPointer = ((LLVMContext)this.ctxRef.get()).getThreadingStack().getStack().newFrame();){
                frame.setObject(this.stackPointerSlot, (Object)stackPointer);
                BitSet shouldInit = this.createBitset();
                LLVMPointer[] roSections = new LLVMPointer[this.initSymbols.length];
                this.doInitSymbols(ctx, shouldInit, roSections);
                this.doInitScope(ctx, localScope);
                this.doInitExternal(ctx, shouldInit, localScope);
                this.doInitGlobals(frame, shouldInit, roSections);
                this.doInitOverwrite(ctx, shouldInit, localScope);
                this.initContext.execute(frame);
                this.doInitModules(frame, ctx, shouldInit);
                SulongLibrary sulongLibrary = this.sulongLibrary;
                return sulongLibrary;
            }
        }

        @CompilerDirectives.TruffleBoundary
        private BitSet createBitset() {
            return new BitSet(this.initSymbols.length);
        }

        @ExplodeLoop
        private void doInitSymbols(LLVMContext ctx, BitSet shouldInit, LLVMPointer[] roSections) {
            int i;
            for (i = 0; i < this.initSymbols.length; ++i) {
                if (!this.initSymbols[i].shouldInitialize(ctx)) continue;
                shouldInit.set(i);
                this.initSymbols[i].initializeSymbolTable(ctx);
            }
            for (i = 0; i < this.initSymbols.length; ++i) {
                if (!shouldInit.get(i)) continue;
                roSections[i] = this.initSymbols[i].execute(ctx);
            }
        }

        @ExplodeLoop
        private void doInitScope(LLVMContext ctx, LLVMLocalScope localScope) {
            for (int i = 0; i < this.initScopes.length; ++i) {
                if (!this.initScopes[i].shouldInitialize(ctx)) continue;
                LoadModulesNode.addIDToLocalScope(localScope, this.initScopes[i].getBitcodeID());
                this.initScopes[i].execute(ctx, localScope);
                this.initScopes[i].initializeScope(ctx);
            }
        }

        @ExplodeLoop
        private void doInitExternal(LLVMContext ctx, BitSet shouldInit, LLVMLocalScope localScope) {
            for (int i = 0; i < this.initExternals.length; ++i) {
                if (!shouldInit.get(i)) continue;
                this.initExternals[i].execute(ctx, localScope);
            }
        }

        @ExplodeLoop
        private void doInitGlobals(VirtualFrame frame, BitSet shouldInit, LLVMPointer[] roSections) {
            for (int i = 0; i < this.initGlobals.length; ++i) {
                if (!shouldInit.get(i)) continue;
                this.initGlobals[i].execute(frame, roSections[i]);
            }
        }

        @ExplodeLoop
        private void doInitOverwrite(LLVMContext ctx, BitSet shouldInit, LLVMLocalScope localScope) {
            for (int i = 0; i < this.initOverwrite.length; ++i) {
                if (!shouldInit.get(i)) continue;
                this.initOverwrite[i].execute(ctx, localScope);
            }
        }

        @ExplodeLoop
        private void doInitModules(VirtualFrame frame, LLVMContext ctx, BitSet shouldInit) {
            for (int i = 0; i < this.initModules.length; ++i) {
                if (!shouldInit.get(i)) continue;
                this.initModules[i].execute(frame, ctx);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static void addIDToLocalScope(LLVMLocalScope localScope, int id) {
            localScope.addID(id);
        }

        @CompilerDirectives.TruffleBoundary
        private static LLVMLocalScope createLocalScope() {
            return new LLVMLocalScope();
        }

        private static boolean isInternalSulongLibrary(LLVMContext context, ExternalLibrary library) {
            Path internalPath = context.getInternalLibraryPath();
            return library.getPath().startsWith(internalPath);
        }
    }
}

