/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.trufflenode;

import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.trufflenode.NativeAccess;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import sun.misc.Cleaner;

final class Deallocator {
    private static final boolean USE_CLEANER;
    private static final Class<?> DIRECT_BYTE_BUFFER_CLASS;
    private static final Field CLEANER_FIELD;
    private final ReferenceQueue<ByteBuffer> queue;
    private final Set<ReferenceWithPointer> enqueued = Collections.synchronizedSet(new HashSet());
    private boolean cleanupThreadStarted = false;

    Deallocator() {
        this.queue = new ReferenceQueue();
    }

    public void register(ByteBuffer buffer, long pointer) {
        if (buffer.getClass() == DIRECT_BYTE_BUFFER_CLASS) {
            try {
                CLEANER_FIELD.set(buffer, Cleaner.create((Object)buffer, () -> NativeAccess.deallocate(pointer)));
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                ex.printStackTrace();
            }
        } else {
            if (!this.cleanupThreadStarted) {
                this.startCleanupThread();
            }
            this.enqueued.add(new ReferenceWithPointer(buffer, pointer));
        }
    }

    private synchronized void startCleanupThread() {
        if (this.cleanupThreadStarted) {
            return;
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    while (true) {
                        ReferenceWithPointer reference = (ReferenceWithPointer)Deallocator.this.queue.remove();
                        Deallocator.this.enqueued.remove(reference);
                        reference.deallocate();
                    }
                }
                catch (InterruptedException iex) {
                    iex.printStackTrace();
                    return;
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
        this.cleanupThreadStarted = true;
    }

    static {
        Field field;
        Class<?> clazz;
        USE_CLEANER = Boolean.parseBoolean(System.getProperty("truffle.node.js.deallocateUsingCleaner", "true"));
        if (!JSConfig.SubstrateVM && USE_CLEANER) {
            try {
                clazz = Class.forName("java.nio.DirectByteBuffer");
                field = clazz.getDeclaredField("cleaner");
                field.setAccessible(true);
            }
            catch (ClassNotFoundException | NoSuchFieldException ex) {
                clazz = null;
                field = null;
            }
        } else {
            clazz = null;
            field = null;
        }
        DIRECT_BYTE_BUFFER_CLASS = clazz;
        CLEANER_FIELD = field;
    }

    final class ReferenceWithPointer
    extends WeakReference<ByteBuffer> {
        private final long pointer;

        ReferenceWithPointer(ByteBuffer object, long pointer) {
            super(object, Deallocator.this.queue);
            this.pointer = pointer;
        }

        void deallocate() {
            NativeAccess.deallocate(this.pointer);
        }
    }
}

