/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.libgraal.jni;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.EnumSet;
import jdk.vm.ci.services.Services;
import org.graalvm.compiler.debug.TTY;
import org.graalvm.compiler.serviceprovider.IsolateUtil;
import org.graalvm.libgraal.jni.JNI;
import org.graalvm.libgraal.jni.JNILibGraalScope;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CLongPointer;
import org.graalvm.nativeimage.c.type.CShortPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.c.type.VoidPointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

public final class JNIUtil {
    private static final String CLASS_SERVICES = "jdk/vm/ci/services/Services";
    private static final String[] METHOD_GET_JVMCI_CLASS_LOADER = new String[]{"getJVMCIClassLoader", "()Ljava/lang/ClassLoader;"};
    private static final String[] METHOD_GET_PLATFORM_CLASS_LOADER = new String[]{"getPlatformClassLoader", "()Ljava/lang/ClassLoader;"};
    private static final String[] METHOD_LOAD_CLASS = new String[]{"loadClass", "(Ljava/lang/String;)Ljava/lang/Class;"};
    private static Integer traceLevel;
    private static final String JNI_LIBGRAAL_TRACE_LEVEL_PROPERTY_NAME = "JNI_LIBGRAAL_TRACE_LEVEL";

    public static boolean IsSameObject(JNI.JNIEnv env, JNI.JObject ref1, JNI.JObject ref2) {
        JNIUtil.traceJNI("IsSameObject");
        return env.getFunctions().getIsSameObject().call(env, ref1, ref2);
    }

    public static void DeleteLocalRef(JNI.JNIEnv env, JNI.JObject ref) {
        JNIUtil.traceJNI("DeleteLocalRef");
        env.getFunctions().getDeleteLocalRef().call(env, ref);
    }

    public static int PushLocalFrame(JNI.JNIEnv env, int capacity) {
        JNIUtil.traceJNI("PushLocalFrame");
        return env.getFunctions().getPushLocalFrame().call(env, capacity);
    }

    public static JNI.JObject PopLocalFrame(JNI.JNIEnv env, JNI.JObject result) {
        JNIUtil.traceJNI("PopLocalFrame");
        return env.getFunctions().getPopLocalFrame().call(env, result);
    }

    public static JNI.JClass DefineClass(JNI.JNIEnv env, CCharPointer name, JNI.JObject loader, CCharPointer buf, int bufLen) {
        return env.getFunctions().getDefineClass().call(env, name, loader, buf, bufLen);
    }

    public static JNI.JClass FindClass(JNI.JNIEnv env, CCharPointer name) {
        JNIUtil.traceJNI("FindClass");
        return env.getFunctions().getFindClass().call(env, name);
    }

    public static JNI.JClass GetObjectClass(JNI.JNIEnv env, JNI.JObject object) {
        JNIUtil.traceJNI("GetObjectClass");
        return env.getFunctions().getGetObjectClass().call(env, object);
    }

    public static JNI.JMethodID GetStaticMethodID(JNI.JNIEnv env, JNI.JClass clazz, CCharPointer name, CCharPointer sig) {
        JNIUtil.traceJNI("GetStaticMethodID");
        return env.getFunctions().getGetStaticMethodID().call(env, clazz, name, sig);
    }

    public static JNI.JMethodID GetMethodID(JNI.JNIEnv env, JNI.JClass clazz, CCharPointer name, CCharPointer sig) {
        JNIUtil.traceJNI("GetMethodID");
        return env.getFunctions().getGetMethodID().call(env, clazz, name, sig);
    }

    public static JNI.JFieldID GetStaticFieldID(JNI.JNIEnv env, JNI.JClass clazz, CCharPointer name, CCharPointer sig) {
        JNIUtil.traceJNI("GetStaticFieldID");
        return env.getFunctions().getGetStaticFieldID().call(env, clazz, name, sig);
    }

    public static JNI.JObjectArray NewObjectArray(JNI.JNIEnv env, int len, JNI.JClass componentClass, JNI.JObject initialElement) {
        JNIUtil.traceJNI("NewObjectArray");
        return env.getFunctions().getNewObjectArray().call(env, len, componentClass, initialElement);
    }

    public static JNI.JByteArray NewByteArray(JNI.JNIEnv env, int len) {
        JNIUtil.traceJNI("NewByteArray");
        return env.getFunctions().getNewByteArray().call(env, len);
    }

    public static JNI.JLongArray NewLongArray(JNI.JNIEnv env, int len) {
        JNIUtil.traceJNI("NewLongArray");
        return env.getFunctions().getNewLongArray().call(env, len);
    }

    public static int GetArrayLength(JNI.JNIEnv env, JNI.JArray array) {
        JNIUtil.traceJNI("GetArrayLength");
        return env.getFunctions().getGetArrayLength().call(env, array);
    }

    public static void SetObjectArrayElement(JNI.JNIEnv env, JNI.JObjectArray array, int index, JNI.JObject value) {
        JNIUtil.traceJNI("SetObjectArrayElement");
        env.getFunctions().getSetObjectArrayElement().call(env, array, index, value);
    }

    public static JNI.JObject GetObjectArrayElement(JNI.JNIEnv env, JNI.JObjectArray array, int index) {
        JNIUtil.traceJNI("GetObjectArrayElement");
        return env.getFunctions().getGetObjectArrayElement().call(env, array, index);
    }

    public static CLongPointer GetLongArrayElements(JNI.JNIEnv env, JNI.JLongArray array, JNI.JValue isCopy) {
        JNIUtil.traceJNI("GetLongArrayElements");
        return env.getFunctions().getGetLongArrayElements().call(env, array, isCopy);
    }

    public static void ReleaseLongArrayElements(JNI.JNIEnv env, JNI.JLongArray array, CLongPointer elems, int mode) {
        JNIUtil.traceJNI("ReleaseLongArrayElements");
        env.getFunctions().getReleaseLongArrayElements().call(env, array, elems, mode);
    }

    public static CCharPointer GetByteArrayElements(JNI.JNIEnv env, JNI.JByteArray array, JNI.JValue isCopy) {
        JNIUtil.traceJNI("GetByteArrayElements");
        return env.getFunctions().getGetByteArrayElements().call(env, array, isCopy);
    }

    public static void ReleaseByteArrayElements(JNI.JNIEnv env, JNI.JByteArray array, CCharPointer elems, int mode) {
        JNIUtil.traceJNI("ReleaseByteArrayElements");
        env.getFunctions().getReleaseByteArrayElements().call(env, array, elems, mode);
    }

    public static void Throw(JNI.JNIEnv env, JNI.JThrowable throwable) {
        JNIUtil.traceJNI("Throw");
        env.getFunctions().getThrow().call(env, throwable);
    }

    public static boolean ExceptionCheck(JNI.JNIEnv env) {
        JNIUtil.traceJNI("ExceptionCheck");
        return env.getFunctions().getExceptionCheck().call(env);
    }

    public static void ExceptionClear(JNI.JNIEnv env) {
        JNIUtil.traceJNI("ExceptionClear");
        env.getFunctions().getExceptionClear().call(env);
    }

    public static void ExceptionDescribe(JNI.JNIEnv env) {
        JNIUtil.traceJNI("ExceptionDescribe");
        env.getFunctions().getExceptionDescribe().call(env);
    }

    public static JNI.JThrowable ExceptionOccurred(JNI.JNIEnv env) {
        JNIUtil.traceJNI("ExceptionOccurred");
        return env.getFunctions().getExceptionOccurred().call(env);
    }

    public static <T extends JNI.JObject> T NewGlobalRef(JNI.JNIEnv env, T ref, String type) {
        JNIUtil.traceJNI("NewGlobalRef");
        JNI.JObject res = env.getFunctions().getNewGlobalRef().call(env, ref);
        if (JNIUtil.tracingAt(3)) {
            JNIUtil.trace(3, "New global reference for 0x%x of type %s -> 0x%x", ref.rawValue(), type, res.rawValue());
        }
        return (T)res;
    }

    public static void DeleteGlobalRef(JNI.JNIEnv env, JNI.JObject ref) {
        JNIUtil.traceJNI("DeleteGlobalRef");
        if (JNIUtil.tracingAt(3)) {
            JNIUtil.trace(3, "Delete global reference 0x%x", ref.rawValue());
        }
        env.getFunctions().getDeleteGlobalRef().call(env, ref);
    }

    public static VoidPointer GetDirectBufferAddress(JNI.JNIEnv env, JNI.JObject buf) {
        JNIUtil.traceJNI("GetDirectBufferAddress");
        return env.getFunctions().getGetDirectBufferAddress().call(env, buf);
    }

    private static void traceJNI(String function) {
        JNIUtil.trace(2, "LIBGRAAL->JNI: %s", function);
    }

    private JNIUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createString(JNI.JNIEnv env, JNI.JString hsString) {
        if (hsString.isNull()) {
            return null;
        }
        int len = env.getFunctions().getGetStringLength().call(env, hsString);
        CShortPointer unicode = env.getFunctions().getGetStringChars().call(env, hsString, (JNI.JValue)WordFactory.nullPointer());
        try {
            char[] data = new char[len];
            for (int i = 0; i < len; ++i) {
                data[i] = (char)unicode.read(i);
            }
            String string = new String(data);
            return string;
        }
        finally {
            env.getFunctions().getReleaseStringChars().call(env, hsString, unicode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JNI.JString createHSString(JNI.JNIEnv env, String string) {
        if (string == null) {
            return (JNI.JString)WordFactory.nullPointer();
        }
        int len = string.length();
        CShortPointer buffer = (CShortPointer)UnmanagedMemory.malloc((int)(len << 1));
        try {
            for (int i = 0; i < len; ++i) {
                buffer.write(i, (short)string.charAt(i));
            }
            JNI.JString jString = env.getFunctions().getNewString().call(env, buffer, len);
            return jString;
        }
        finally {
            UnmanagedMemory.free((PointerBase)buffer);
        }
    }

    public static String getInternalName(String fqn) {
        return "L" + JNIUtil.getBinaryName(fqn) + ";";
    }

    public static String getBinaryName(String fqn) {
        return fqn.replace('.', '/');
    }

    public static JNI.JClass findClass(JNI.JNIEnv env, String binaryName) {
        try (CTypeConversion.CCharPointerHolder name = CTypeConversion.toCString((CharSequence)binaryName);){
            JNI.JClass jClass = JNIUtil.FindClass(env, name.get());
            return jClass;
        }
    }

    public static JNI.JClass findClass(JNI.JNIEnv env, JNI.JObject classLoader, String binaryName) {
        if (classLoader.isNull()) {
            throw new IllegalArgumentException("ClassLoader must be non null.");
        }
        JNIUtil.trace(1, "LIBGRAAL->HS: findClass", new Object[0]);
        JNI.JMethodID findClassId = JNIUtil.findMethod(env, JNIUtil.GetObjectClass(env, classLoader), false, false, METHOD_LOAD_CLASS);
        JNI.JValue params = (JNI.JValue)StackValue.get((int)1, JNI.JValue.class);
        params.addressOf(0).setJObject(JNIUtil.createHSString(env, binaryName.replace('/', '.')));
        return (JNI.JClass)env.getFunctions().getCallObjectMethodA().call(env, classLoader, findClassId, params);
    }

    public static JNI.JObject getJVMCIClassLoader(JNI.JNIEnv env) {
        JNI.JClass clazz;
        try (CTypeConversion.CCharPointerHolder className = CTypeConversion.toCString((CharSequence)CLASS_SERVICES);){
            clazz = JNIUtil.FindClass(env, className.get());
        }
        if (clazz.isNull()) {
            throw new InternalError("No such class jdk/vm/ci/services/Services");
        }
        JNI.JMethodID getClassLoaderId = JNIUtil.findMethod(env, clazz, true, true, METHOD_GET_JVMCI_CLASS_LOADER);
        if (getClassLoaderId.isNonNull()) {
            return env.getFunctions().getCallStaticObjectMethodA().call(env, clazz, getClassLoaderId, (JNI.JValue)WordFactory.nullPointer());
        }
        try (CTypeConversion.CCharPointerHolder className = CTypeConversion.toCString((CharSequence)JNIUtil.getBinaryName(ClassLoader.class.getName()));){
            clazz = JNIUtil.FindClass(env, className.get());
        }
        if (clazz.isNull()) {
            throw new InternalError("No such class " + ClassLoader.class.getName());
        }
        getClassLoaderId = JNIUtil.findMethod(env, clazz, true, true, METHOD_GET_PLATFORM_CLASS_LOADER);
        if (getClassLoaderId.isNonNull()) {
            return env.getFunctions().getCallStaticObjectMethodA().call(env, clazz, getClassLoaderId, (JNI.JValue)WordFactory.nullPointer());
        }
        return (JNI.JObject)WordFactory.nullPointer();
    }

    /*
     * Exception decompiling
     */
    private static JNI.JMethodID findMethod(JNI.JNIEnv env, JNI.JClass clazz, boolean staticMethod, boolean optional, String[] descriptor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static int traceLevel() {
        if (traceLevel == null) {
            String var = (String)Services.getSavedProperties().get(JNI_LIBGRAAL_TRACE_LEVEL_PROPERTY_NAME);
            if (var != null) {
                try {
                    traceLevel = Integer.parseInt(var);
                }
                catch (NumberFormatException e) {
                    TTY.printf("Invalid value for %s: %s%n", JNI_LIBGRAAL_TRACE_LEVEL_PROPERTY_NAME, e);
                    traceLevel = 0;
                }
            } else {
                traceLevel = 0;
            }
        }
        return traceLevel;
    }

    public static boolean tracingAt(int level) {
        return JNIUtil.traceLevel() >= level;
    }

    public static void trace(int level, String format, Object ... args) {
        if (JNIUtil.traceLevel() >= level) {
            JNILibGraalScope<?> scope = JNILibGraalScope.scopeOrNull();
            String indent = scope == null ? "" : new String(new char[2 + scope.depth() * 2]).replace('\u0000', ' ');
            String prefix = "[" + IsolateUtil.getIsolateID() + ":" + Thread.currentThread().getName() + "]";
            TTY.printf(prefix + indent + format + "%n", args);
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void checkToLibGraalCalls(Class<?> toLibGraalEntryPointsClass, Class<?> toLibGraalCallsClass, Class<? extends Annotation> annotationClass) throws InternalError {
        try {
            Method valueMethod = annotationClass.getDeclaredMethod("value", new Class[0]);
            Type t = valueMethod.getGenericReturnType();
            JNIUtil.check(t instanceof Class && ((Class)t).isEnum(), "Annotation value must be enum.", new Object[0]);
            EnumSet<Enum> unimplemented = EnumSet.allOf(((Class)t).asSubclass(Enum.class));
            for (Method libGraalMethod : toLibGraalEntryPointsClass.getDeclaredMethods()) {
                Annotation call = libGraalMethod.getAnnotation(annotationClass);
                if (call == null) continue;
                JNIUtil.check(Modifier.isStatic(libGraalMethod.getModifiers()), "Method annotated by %s must be static: %s", annotationClass, libGraalMethod);
                CEntryPoint ep = libGraalMethod.getAnnotation(CEntryPoint.class);
                JNIUtil.check(ep != null, "Method annotated by %s must also be annotated by %s: %s", annotationClass, CEntryPoint.class, libGraalMethod);
                String name = ep.name();
                String prefix = "Java_" + toLibGraalCallsClass.getName().replace('.', '_') + '_';
                JNIUtil.check(name.startsWith(prefix), "Method must be a JNI entry point for a method in %s: %s", toLibGraalCallsClass, libGraalMethod);
                name = name.substring(prefix.length());
                Method hsMethod = JNIUtil.findHSMethod(toLibGraalCallsClass, name, annotationClass);
                Class<?>[] libGraalParameters = libGraalMethod.getParameterTypes();
                Class<?>[] hsParameters = hsMethod.getParameterTypes();
                JNIUtil.check(hsParameters.length + 2 == libGraalParameters.length, "%s should have 2 more parameters than %s", libGraalMethod, hsMethod);
                JNIUtil.check(libGraalParameters.length >= 3, "Expect at least 3 parameters: %s", libGraalMethod);
                JNIUtil.check(libGraalParameters[0] == JNI.JNIEnv.class, "Parameter 0 must be of type %s: %s", JNI.JNIEnv.class, libGraalMethod);
                JNIUtil.check(libGraalParameters[1] == JNI.JClass.class, "Parameter 1 must be of type %s: %s", JNI.JClass.class, libGraalMethod);
                JNIUtil.check(libGraalParameters[2] == Long.TYPE, "Parameter 2 must be of type long: %s", libGraalMethod);
                JNIUtil.check(hsParameters[0] == Long.TYPE, "Parameter 0 must be of type long: %s", hsMethod);
                int i = 3;
                int j = 1;
                while (i < libGraalParameters.length) {
                    Class<Object> hsExpect;
                    Class<?> libgraal = libGraalParameters[i];
                    Class<?> hs = hsParameters[j];
                    if (hs.isPrimitive()) {
                        hsExpect = libgraal;
                    } else if (libgraal == JNI.JString.class) {
                        hsExpect = String.class;
                    } else if (libgraal == JNI.JByteArray.class) {
                        hsExpect = byte[].class;
                    } else if (libgraal == JNI.JLongArray.class) {
                        hsExpect = long[].class;
                    } else if (libgraal == JNI.JObjectArray.class) {
                        hsExpect = Object[].class;
                    } else {
                        JNIUtil.check(libgraal == JNI.JObject.class, "must be", new Object[0]);
                        hsExpect = Object.class;
                    }
                    JNIUtil.check(hsExpect.isAssignableFrom(hs), "HotSpot parameter %d (%s) incompatible with libgraal parameter %d (%s): %s", j, hs.getName(), i, libgraal.getName(), hsMethod);
                    ++i;
                    ++j;
                }
                unimplemented.remove(valueMethod.invoke((Object)call, new Object[0]));
            }
            JNIUtil.check(unimplemented.isEmpty(), "Unimplemented libgraal calls: %s", unimplemented);
        }
        catch (ReflectiveOperationException e) {
            throw new InternalError(e);
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static void check(boolean condition, String format, Object ... args) {
        if (!condition) {
            throw new InternalError(String.format(format, args));
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static Method findHSMethod(Class<?> hsClass, String name, Class<? extends Annotation> annotationClass) {
        Method res = null;
        for (Method m : hsClass.getDeclaredMethods()) {
            if (!m.getName().equals(name)) continue;
            JNIUtil.check(res == null, "More than one method named \"%s\" in %s", name, hsClass);
            Annotation call = m.getAnnotation(annotationClass);
            JNIUtil.check(call != null, "Method must be annotated by %s: %s", annotationClass, m);
            JNIUtil.check(Modifier.isStatic(m.getModifiers()) && Modifier.isNative(m.getModifiers()), "Method must be static and native: %s", m);
            res = m;
        }
        JNIUtil.check(res != null, "Could not find method named \"%s\" in %s", name, hsClass);
        return res;
    }
}

