/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.libgraal.jni;

import org.graalvm.compiler.debug.TTY;
import org.graalvm.libgraal.jni.FromLibGraalCalls;
import org.graalvm.libgraal.jni.JNI;
import org.graalvm.libgraal.jni.JNIExceptionWrapperGen;
import org.graalvm.libgraal.jni.JNIUtil;
import org.graalvm.libgraal.jni.annotation.JNIFromLibGraal;
import org.graalvm.libgraal.jni.annotation.JNIFromLibGraalRepeated;
import org.graalvm.word.WordFactory;

public final class JNIExceptionWrapper
extends RuntimeException {
    private static final String HS_ENTRYPOINTS_CLASS = "org.graalvm.libgraal.jni.JNIFromLibGraalEntryPoints";
    private static final long serialVersionUID = 1L;
    private final JNI.JThrowable throwableHandle;
    private final boolean throwableRequiresStackTraceUpdate;
    private static JNI.JClass fromLibGraalEntryPoints;

    private JNIExceptionWrapper(JNI.JNIEnv env, JNI.JThrowable throwableHandle) {
        super(JNIExceptionWrapper.formatExceptionMessage(JNIExceptionWrapper.getClassName(env, throwableHandle), JNIExceptionWrapper.getMessage(env, throwableHandle)));
        this.throwableHandle = throwableHandle;
        this.throwableRequiresStackTraceUpdate = this.createMergedStackTrace(env);
    }

    private void throwInHotSpot(JNI.JNIEnv env) {
        JNI.JThrowable toThrow = this.throwableRequiresStackTraceUpdate ? JNIExceptionWrapper.updateStackTrace(env, this.throwableHandle, JNIExceptionWrapper.encode(this.getStackTrace())) : this.throwableHandle;
        JNIUtil.Throw(env, toThrow);
    }

    private boolean createMergedStackTrace(JNI.JNIEnv env) {
        boolean res;
        StackTraceElement[] mergedStack;
        StackTraceElement[] hsStack = JNIExceptionWrapper.getJNIExceptionStackTrace(env, this.throwableHandle);
        if (JNIExceptionWrapper.containsHotSpotCall(hsStack)) {
            mergedStack = hsStack;
            res = false;
        } else {
            StackTraceElement[] libGraalStack = this.getStackTrace();
            mergedStack = JNIExceptionWrapper.mergeStackTraces(hsStack, libGraalStack, 0, JNIExceptionWrapper.getIndexOfPropagateJNIExceptionFrame(libGraalStack), true);
            res = true;
        }
        this.setStackTrace(mergedStack);
        return res;
    }

    @SafeVarargs
    public static void wrapAndThrowPendingJNIException(JNI.JNIEnv env, Class<? extends Throwable> ... allowedExceptions) {
        if (JNIUtil.ExceptionCheck(env)) {
            JNI.JThrowable exception = JNIUtil.ExceptionOccurred(env);
            if (JNIUtil.tracingAt(1) && exception.isNonNull()) {
                JNIUtil.ExceptionDescribe(env);
            }
            JNIUtil.ExceptionClear(env);
            JNI.JClass exceptionClass = JNIUtil.GetObjectClass(env, exception);
            boolean allowed = false;
            for (Class<? extends Throwable> allowedException : allowedExceptions) {
                JNI.JClass allowedExceptionClass = JNIUtil.findClass(env, JNIUtil.getBinaryName(allowedException.getName()));
                if (!allowedExceptionClass.isNonNull() || !JNIUtil.IsSameObject(env, exceptionClass, allowedExceptionClass)) continue;
                allowed = true;
                break;
            }
            if (!allowed) {
                throw new JNIExceptionWrapper(env, exception);
            }
        }
    }

    public static void throwInHotSpot(JNI.JNIEnv env, Throwable original) {
        try {
            if (JNIUtil.tracingAt(1)) {
                original.printStackTrace(TTY.out);
            }
            if (original.getClass() == JNIExceptionWrapper.class) {
                ((JNIExceptionWrapper)original).throwInHotSpot(env);
            } else {
                String message = JNIExceptionWrapper.formatExceptionMessage(original.getClass().getName(), original.getMessage());
                JNI.JString hsMessage = JNIUtil.createHSString(env, message);
                JNI.JThrowable hsThrowable = (JNI.JThrowable)JNIExceptionWrapperGen.callCreateException(env, hsMessage);
                StackTraceElement[] hsStack = JNIExceptionWrapper.getJNIExceptionStackTrace(env, hsThrowable);
                StackTraceElement[] libGraalStack = original.getStackTrace();
                String[] merged = JNIExceptionWrapper.encode(JNIExceptionWrapper.mergeStackTraces(hsStack, libGraalStack, 1, 0, false));
                JNIUtil.Throw(env, JNIExceptionWrapper.updateStackTrace(env, hsThrowable, merged));
            }
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw t;
            }
            original.addSuppressed(t);
            original.printStackTrace();
        }
    }

    private static StackTraceElement[] mergeStackTraces(StackTraceElement[] hotSpotStackTrace, StackTraceElement[] libGraalStackTrace, int hotSpotStackStartIndex, int libGraalStackStartIndex, boolean originatedInHotSpot) {
        int targetIndex = 0;
        StackTraceElement[] merged = new StackTraceElement[hotSpotStackTrace.length - hotSpotStackStartIndex + libGraalStackTrace.length - libGraalStackStartIndex];
        boolean startingHotSpotFrame = true;
        boolean startingLibGraalFrame = true;
        boolean useHotSpotStack = originatedInHotSpot;
        int hotSpotStackIndex = hotSpotStackStartIndex;
        int libGraalStackIndex = libGraalStackStartIndex;
        while (hotSpotStackIndex < hotSpotStackTrace.length || libGraalStackIndex < libGraalStackTrace.length) {
            if (useHotSpotStack) {
                while (hotSpotStackIndex < hotSpotStackTrace.length && (startingHotSpotFrame || !hotSpotStackTrace[hotSpotStackIndex].isNativeMethod())) {
                    startingHotSpotFrame = false;
                    merged[targetIndex++] = hotSpotStackTrace[hotSpotStackIndex++];
                }
                startingHotSpotFrame = true;
            } else {
                useHotSpotStack = true;
            }
            while (libGraalStackIndex < libGraalStackTrace.length && (startingLibGraalFrame || !FromLibGraalCalls.isHotSpotCall(libGraalStackTrace[libGraalStackIndex]))) {
                startingLibGraalFrame = false;
                merged[targetIndex++] = libGraalStackTrace[libGraalStackIndex++];
            }
            startingLibGraalFrame = true;
        }
        return merged;
    }

    private static String[] encode(StackTraceElement[] stackTrace) {
        String[] res = new String[stackTrace.length];
        for (int i = 0; i < stackTrace.length; ++i) {
            String className = stackTrace[i].getClassName();
            String methodName = stackTrace[i].getMethodName();
            String fileName = stackTrace[i].getFileName();
            int lineNumber = stackTrace[i].getLineNumber();
            res[i] = String.format("%s|%s|%s|%d", className == null ? "" : className.replace('|', '!'), methodName == null ? "" : methodName.replace('|', '!'), fileName == null ? "" : fileName.replace('|', '!'), lineNumber);
        }
        return res;
    }

    @JNIFromLibGraalRepeated(value={@JNIFromLibGraal(value=JNIFromLibGraal.Id.GetStackTrace), @JNIFromLibGraal(value=JNIFromLibGraal.Id.GetStackTraceElementClassName), @JNIFromLibGraal(value=JNIFromLibGraal.Id.GetStackTraceElementMethodName), @JNIFromLibGraal(value=JNIFromLibGraal.Id.GetStackTraceElementFileName), @JNIFromLibGraal(value=JNIFromLibGraal.Id.GetStackTraceElementLineNumber)})
    private static StackTraceElement[] getJNIExceptionStackTrace(JNI.JNIEnv env, JNI.JObject throwableHandle) {
        JNI.JObjectArray elements = (JNI.JObjectArray)JNIExceptionWrapperGen.callGetStackTrace(env, throwableHandle);
        int len = JNIUtil.GetArrayLength(env, elements);
        StackTraceElement[] res = new StackTraceElement[len];
        for (int i = 0; i < len; ++i) {
            JNI.JObject element = JNIUtil.GetObjectArrayElement(env, elements, i);
            String className = JNIUtil.createString(env, (JNI.JString)JNIExceptionWrapperGen.callGetStackTraceElementClassName(env, element));
            String methodName = JNIUtil.createString(env, (JNI.JString)JNIExceptionWrapperGen.callGetStackTraceElementMethodName(env, element));
            String fileName = JNIUtil.createString(env, (JNI.JString)JNIExceptionWrapperGen.callGetStackTraceElementFileName(env, element));
            int lineNumber = JNIExceptionWrapperGen.callGetStackTraceElementLineNumber(env, element);
            res[i] = new StackTraceElement(className, methodName, fileName, lineNumber);
        }
        return res;
    }

    private static boolean containsHotSpotCall(StackTraceElement[] stackTrace) {
        for (StackTraceElement e : stackTrace) {
            if (!FromLibGraalCalls.isHotSpotCall(e)) continue;
            return true;
        }
        return false;
    }

    private static JNI.JThrowable updateStackTrace(JNI.JNIEnv env, JNI.JThrowable throwableHandle, String[] encodedStackTrace) {
        JNI.JClass string = FromLibGraalCalls.getJNIClass(env, String.class);
        JNI.JObjectArray stackTraceHandle = JNIUtil.NewObjectArray(env, encodedStackTrace.length, string, (JNI.JObject)WordFactory.nullPointer());
        for (int i = 0; i < encodedStackTrace.length; ++i) {
            JNI.JString element = JNIUtil.createHSString(env, encodedStackTrace[i]);
            JNIUtil.SetObjectArrayElement(env, stackTraceHandle, i, element);
        }
        return (JNI.JThrowable)JNIExceptionWrapperGen.callUpdateStackTrace(env, throwableHandle, stackTraceHandle);
    }

    private static String getMessage(JNI.JNIEnv env, JNI.JThrowable throwableHandle) {
        JNI.JString message = (JNI.JString)JNIExceptionWrapperGen.callGetThrowableMessage(env, throwableHandle);
        return JNIUtil.createString(env, message);
    }

    private static String getClassName(JNI.JNIEnv env, JNI.JThrowable throwableHandle) {
        JNI.JClass classHandle = JNIUtil.GetObjectClass(env, throwableHandle);
        JNI.JString className = (JNI.JString)JNIExceptionWrapperGen.callGetClassName(env, classHandle);
        return JNIUtil.createString(env, className);
    }

    private static String formatExceptionMessage(String className, String message) {
        StringBuilder builder = new StringBuilder(className);
        if (message != null) {
            builder.append(": ").append(message);
        }
        return builder.toString();
    }

    private static int getIndexOfPropagateJNIExceptionFrame(StackTraceElement[] stackTrace) {
        for (int i = 0; i < stackTrace.length; ++i) {
            if (!JNIExceptionWrapper.isStackFrame(stackTrace[i], JNIExceptionWrapper.class, "wrapAndThrowPendingJNIException")) continue;
            return i + 1;
        }
        return 0;
    }

    private static boolean isStackFrame(StackTraceElement stackTraceElement, Class<?> clazz, String methodName) {
        return clazz.getName().equals(stackTraceElement.getClassName()) && methodName.equals(stackTraceElement.getMethodName());
    }

    static JNI.JClass getHotSpotEntryPoints(JNI.JNIEnv env) {
        if (fromLibGraalEntryPoints.isNull()) {
            String binaryName = JNIUtil.getBinaryName(HS_ENTRYPOINTS_CLASS);
            JNI.JObject classLoader = JNIUtil.getJVMCIClassLoader(env);
            JNI.JClass entryPoints = classLoader.isNonNull() ? JNIUtil.findClass(env, classLoader, binaryName) : JNIUtil.findClass(env, binaryName);
            if (entryPoints.isNull()) {
                JNIUtil.ExceptionClear(env);
                throw new InternalError("Failed to load org.graalvm.libgraal.jni.JNIFromLibGraalEntryPoints");
            }
            fromLibGraalEntryPoints = JNIUtil.NewGlobalRef(env, entryPoints, "Class<org.graalvm.libgraal.jni.JNIFromLibGraalEntryPoints>");
        }
        return fromLibGraalEntryPoints;
    }
}

