/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.libgraal.jni;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import jdk.vm.ci.services.Services;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.function.InvokeCFunctionPointer;
import org.graalvm.nativeimage.c.struct.CField;
import org.graalvm.nativeimage.c.struct.CStruct;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CLongPointer;
import org.graalvm.nativeimage.c.type.CShortPointer;
import org.graalvm.nativeimage.c.type.VoidPointer;
import org.graalvm.word.PointerBase;

public final class JNI {
    private JNI() {
        throw new IllegalStateException("No instance allowed");
    }

    static class JNIHeaderDirectives
    implements CContext.Directives {
        private static final String[] INCLUDES = new String[]{"jni.h", "jni_md.h"};

        JNIHeaderDirectives() {
        }

        public List<String> getOptions() {
            return Arrays.stream(JNIHeaderDirectives.findJNIHeaders()).map(p -> "-I" + p.getParent()).collect(Collectors.toList());
        }

        public List<String> getHeaderFiles() {
            return Arrays.stream(JNIHeaderDirectives.findJNIHeaders()).map(p -> '<' + p.toString() + '>').collect(Collectors.toList());
        }

        private static Path[] findJNIHeaders() {
            Path parent;
            Path javaHome = Paths.get((String)Services.getSavedProperties().get("java.home"), new String[0]);
            Path includeFolder = javaHome.resolve("include");
            if (!Files.exists(includeFolder, new LinkOption[0]) && (parent = javaHome.getParent()) != null) {
                javaHome = parent;
            }
            if (!Files.exists(includeFolder = javaHome.resolve("include"), new LinkOption[0])) {
                throw new IllegalStateException("Cannot find 'include' folder in JDK.");
            }
            Path[] res = new Path[INCLUDES.length];
            try {
                for (int i = 0; i < INCLUDES.length; ++i) {
                    String include = INCLUDES[i];
                    Optional<Path> includeFile = Files.find(includeFolder, 2, (p, attrs) -> include.equals(p.getFileName().toString()), new FileVisitOption[0]).findFirst();
                    if (!includeFile.isPresent()) {
                        throw new IllegalStateException("Include: " + res[i] + " does not exist.");
                    }
                    res[i] = includeFile.get();
                }
                return res;
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
    }

    public static interface SetStaticBooleanField
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void call(JNIEnv var1, JClass var2, JFieldID var3, boolean var4);
    }

    public static interface GetStaticBooleanField
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public boolean call(JNIEnv var1, JClass var2, JFieldID var3);
    }

    public static interface GetStaticFieldID
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public JFieldID call(JNIEnv var1, JClass var2, CCharPointer var3, CCharPointer var4);
    }

    public static interface GetDirectBufferAddress
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public VoidPointer call(JNIEnv var1, JObject var2);
    }

    public static interface Throw
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public int call(JNIEnv var1, JThrowable var2);
    }

    public static interface SetObjectArrayElement
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void call(JNIEnv var1, JObjectArray var2, int var3, JObject var4);
    }

    public static interface ReleaseStringUTFChars
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void call(JNIEnv var1, JString var2, CCharPointer var3);
    }

    public static interface ReleaseStringChars
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void call(JNIEnv var1, JString var2, CShortPointer var3);
    }

    public static interface ReleaseLongArrayElements
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void call(JNIEnv var1, JLongArray var2, CLongPointer var3, int var4);
    }

    public static interface ReleaseByteArrayElements
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void call(JNIEnv var1, JByteArray var2, CCharPointer var3, int var4);
    }

    public static interface NewStringUTF8
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public JString call(JNIEnv var1, CCharPointer var2);
    }

    public static interface NewString
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public JString call(JNIEnv var1, CShortPointer var2, int var3);
    }

    public static interface NewObjectArray
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public JObjectArray call(JNIEnv var1, int var2, JClass var3, JObject var4);
    }

    public static interface NewObjectA
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public JObject call(JClass var1, JMethodID var2, JValue var3);
    }

    public static interface NewGlobalRef
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public JObject call(JNIEnv var1, JObject var2);
    }

    public static interface NewLongArray
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public JLongArray call(JNIEnv var1, int var2);
    }

    public static interface NewByteArray
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public JByteArray call(JNIEnv var1, int var2);
    }

    public static interface IsSameObject
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public boolean call(JNIEnv var1, JObject var2, JObject var3);
    }

    public static interface GetStringUTFLength
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public int call(JNIEnv var1, JString var2);
    }

    public static interface GetStringUTFChars
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public CCharPointer call(JNIEnv var1, JString var2, JValue var3);
    }

    public static interface GetStringLength
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public int call(JNIEnv var1, JString var2);
    }

    public static interface GetStringChars
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public CShortPointer call(JNIEnv var1, JString var2, JValue var3);
    }

    public static interface GetStaticMethodID
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public JMethodID call(JNIEnv var1, JClass var2, CCharPointer var3, CCharPointer var4);
    }

    public static interface GetObjectRefType
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public int call(JNIEnv var1, JObject var2);
    }

    public static interface GetObjectClass
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public JClass call(JNIEnv var1, JObject var2);
    }

    public static interface GetObjectArrayElement
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public JObject call(JNIEnv var1, JObjectArray var2, int var3);
    }

    public static interface GetMethodID
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public JMethodID call(JNIEnv var1, JClass var2, CCharPointer var3, CCharPointer var4);
    }

    public static interface GetLongArrayElements
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public CLongPointer call(JNIEnv var1, JLongArray var2, JValue var3);
    }

    public static interface GetByteArrayElements
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public CCharPointer call(JNIEnv var1, JByteArray var2, JValue var3);
    }

    public static interface GetArrayLength
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public int call(JNIEnv var1, JArray var2);
    }

    public static interface DefineClass
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public JClass call(JNIEnv var1, CCharPointer var2, JObject var3, CCharPointer var4, long var5);
    }

    public static interface FindClass
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public JClass call(JNIEnv var1, CCharPointer var2);
    }

    public static interface ExceptionOccurred
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public JThrowable call(JNIEnv var1);
    }

    public static interface ExceptionDescribe
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void call(JNIEnv var1);
    }

    public static interface ExceptionClear
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void call(JNIEnv var1);
    }

    public static interface ExceptionCheck
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public boolean call(JNIEnv var1);
    }

    public static interface PopLocalFrame
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public JObject call(JNIEnv var1, JObject var2);
    }

    public static interface PushLocalFrame
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public int call(JNIEnv var1, int var2);
    }

    public static interface DeleteLocalRef
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void call(JNIEnv var1, JObject var2);
    }

    public static interface DeleteGlobalRef
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void call(JNIEnv var1, JObject var2);
    }

    public static interface CallObjectMethodA
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public JObject call(JNIEnv var1, JObject var2, JMethodID var3, JValue var4);
    }

    public static interface CallStaticLongMethodA
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public long call(JNIEnv var1, JClass var2, JMethodID var3, JValue var4);
    }

    public static interface CallStaticObjectMethodA
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public JObject call(JNIEnv var1, JClass var2, JMethodID var3, JValue var4);
    }

    public static interface CallStaticVoidMethodA
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void call(JNIEnv var1, JClass var2, JMethodID var3, JValue var4);
    }

    public static interface CallStaticBooleanMethodA
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public boolean call(JNIEnv var1, JClass var2, JMethodID var3, JValue var4);
    }

    public static interface CallStaticIntMethodA
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public int call(JNIEnv var1, JClass var2, JMethodID var3, JValue var4);
    }

    @CContext(value=JNIHeaderDirectives.class)
    @CStruct(value="JNINativeInterface_", addStructKeyword=true)
    public static interface JNINativeInterface
    extends PointerBase {
        @CField(value="NewString")
        public NewString getNewString();

        @CField(value="GetStringLength")
        public GetStringLength getGetStringLength();

        @CField(value="GetStringChars")
        public GetStringChars getGetStringChars();

        @CField(value="ReleaseStringChars")
        public ReleaseStringChars getReleaseStringChars();

        @CField(value="NewStringUTF")
        public NewStringUTF8 getNewStringUTF();

        @CField(value="GetStringUTFLength")
        public GetStringUTFLength getGetStringUTFLength();

        @CField(value="GetStringUTFChars")
        public GetStringUTFChars getGetStringUTFChars();

        @CField(value="ReleaseStringUTFChars")
        public ReleaseStringUTFChars getReleaseStringUTFChars();

        @CField(value="GetArrayLength")
        public GetArrayLength getGetArrayLength();

        @CField(value="NewObjectArray")
        public NewObjectArray getNewObjectArray();

        @CField(value="NewByteArray")
        public NewByteArray getNewByteArray();

        @CField(value="NewLongArray")
        public NewLongArray getNewLongArray();

        @CField(value="GetObjectArrayElement")
        public GetObjectArrayElement getGetObjectArrayElement();

        @CField(value="SetObjectArrayElement")
        public SetObjectArrayElement getSetObjectArrayElement();

        @CField(value="GetByteArrayElements")
        public GetByteArrayElements getGetByteArrayElements();

        @CField(value="GetLongArrayElements")
        public GetLongArrayElements getGetLongArrayElements();

        @CField(value="ReleaseByteArrayElements")
        public ReleaseByteArrayElements getReleaseByteArrayElements();

        @CField(value="ReleaseLongArrayElements")
        public ReleaseLongArrayElements getReleaseLongArrayElements();

        @CField(value="FindClass")
        public FindClass getFindClass();

        @CField(value="DefineClass")
        public DefineClass getDefineClass();

        @CField(value="IsSameObject")
        public IsSameObject getIsSameObject();

        @CField(value="GetObjectClass")
        public GetObjectClass getGetObjectClass();

        @CField(value="NewGlobalRef")
        public NewGlobalRef getNewGlobalRef();

        @CField(value="DeleteGlobalRef")
        public DeleteGlobalRef getDeleteGlobalRef();

        @CField(value="DeleteLocalRef")
        public DeleteLocalRef getDeleteLocalRef();

        @CField(value="PushLocalFrame")
        public PushLocalFrame getPushLocalFrame();

        @CField(value="PopLocalFrame")
        public PopLocalFrame getPopLocalFrame();

        @CField(value="NewObjectA")
        public NewObjectA getNewObjectA();

        @CField(value="GetStaticMethodID")
        public GetStaticMethodID getGetStaticMethodID();

        @CField(value="GetMethodID")
        public GetMethodID getGetMethodID();

        @CField(value="GetStaticFieldID")
        public GetStaticFieldID getGetStaticFieldID();

        @CField(value="CallStaticBooleanMethodA")
        public CallStaticBooleanMethodA getCallStaticBooleanMethodA();

        @CField(value="CallStaticIntMethodA")
        public CallStaticIntMethodA getCallStaticIntMethodA();

        @CField(value="CallStaticVoidMethodA")
        public CallStaticVoidMethodA getCallStaticVoidMethodA();

        @CField(value="CallStaticObjectMethodA")
        public CallStaticObjectMethodA getCallStaticObjectMethodA();

        @CField(value="CallStaticLongMethodA")
        public CallStaticLongMethodA getCallStaticLongMethodA();

        @CField(value="CallObjectMethodA")
        public CallObjectMethodA getCallObjectMethodA();

        @CField(value="GetStaticBooleanField")
        public GetStaticBooleanField getGetStaticBooleanField();

        @CField(value="SetStaticBooleanField")
        public SetStaticBooleanField getSetStaticBooleanField();

        @CField(value="ExceptionCheck")
        public ExceptionCheck getExceptionCheck();

        @CField(value="ExceptionOccurred")
        public ExceptionOccurred getExceptionOccurred();

        @CField(value="ExceptionClear")
        public ExceptionClear getExceptionClear();

        @CField(value="ExceptionDescribe")
        public ExceptionDescribe getExceptionDescribe();

        @CField(value="Throw")
        public Throw getThrow();

        @CField(value="GetObjectRefType")
        public GetObjectRefType getGetObjectRefType();

        @CField(value="GetDirectBufferAddress")
        public GetDirectBufferAddress getGetDirectBufferAddress();
    }

    @CContext(value=JNIHeaderDirectives.class)
    @CStruct(value="JNIEnv_", addStructKeyword=true)
    public static interface JNIEnv
    extends PointerBase {
        @CField(value="functions")
        public JNINativeInterface getFunctions();
    }

    @CContext(value=JNIHeaderDirectives.class)
    @CStruct(value="jvalue")
    public static interface JValue
    extends PointerBase {
        @CField(value="z")
        public boolean getBoolean();

        @CField(value="b")
        public byte getByte();

        @CField(value="c")
        public char getChar();

        @CField(value="s")
        public short getShort();

        @CField(value="i")
        public int getInt();

        @CField(value="j")
        public long getLong();

        @CField(value="f")
        public float getFloat();

        @CField(value="d")
        public double getDouble();

        @CField(value="l")
        public JObject getJObject();

        @CField(value="z")
        public void setBoolean(boolean var1);

        @CField(value="b")
        public void setByte(byte var1);

        @CField(value="c")
        public void setChar(char var1);

        @CField(value="s")
        public void setShort(short var1);

        @CField(value="i")
        public void setInt(int var1);

        @CField(value="j")
        public void setLong(long var1);

        @CField(value="f")
        public void setFloat(float var1);

        @CField(value="d")
        public void setDouble(double var1);

        @CField(value="l")
        public void setJObject(JObject var1);

        public JValue addressOf(int var1);
    }

    public static interface JThrowable
    extends JObject {
    }

    public static interface JString
    extends JObject {
    }

    public static interface JClass
    extends JObject {
    }

    public static interface JObjectArray
    extends JArray {
    }

    public static interface JLongArray
    extends JArray {
    }

    public static interface JByteArray
    extends JArray {
    }

    public static interface JArray
    extends JObject {
        public static final int MODE_WRITE_RELEASE = 0;
        public static final int MODE_WRITE = 1;
        public static final int MODE_RELEASE = 2;
    }

    public static interface JObject
    extends PointerBase {
    }

    public static interface JFieldID
    extends PointerBase {
    }

    public static interface JMethodID
    extends PointerBase {
    }
}

