/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.libgraal;

import org.graalvm.libgraal.LibGraal;
import org.graalvm.libgraal.LibGraalIsolate;
import org.graalvm.libgraal.LibGraalScope;

public class LibGraalObject {
    private final long handle;
    private final LibGraalIsolate isolate;

    protected LibGraalObject(long handle) {
        this.handle = handle;
        this.isolate = LibGraalScope.current().getIsolate();
        this.isolate.register(this, handle);
    }

    public long getHandle() {
        if (!this.isolate.isValid()) {
            throw new IllegalArgumentException(this.toString());
        }
        return this.handle;
    }

    static native boolean releaseHandle(long var0, long var2);

    public String toString() {
        String name = this.getClass().getSimpleName();
        for (Class<?> outer = this.getClass().getDeclaringClass(); outer != null; outer = outer.getDeclaringClass()) {
            name = outer.getSimpleName() + '.' + name;
        }
        return String.format("%s[%d]", name, this.handle);
    }

    static {
        if (LibGraal.isAvailable()) {
            LibGraal.registerNativeMethods(LibGraalObject.class);
        }
    }
}

