/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.libgraal;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.graalvm.libgraal.LibGraalObject;
import org.graalvm.libgraal.LibGraalScope;

public final class LibGraalIsolate {
    final long address;
    private static final Map<Long, LibGraalIsolate> isolates = new HashMap<Long, LibGraalIsolate>();
    private final Map<Class<?>, Object> singletons = new HashMap();
    private final Set<Cleaner> cleaners = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ReferenceQueue<LibGraalObject> cleanersQueue = new ReferenceQueue();
    private boolean destroyed;

    static synchronized LibGraalIsolate forAddress(long isolateAddress) {
        return isolates.computeIfAbsent(isolateAddress, a -> new LibGraalIsolate((long)a));
    }

    private LibGraalIsolate(long address) {
        this.address = address;
    }

    public static LibGraalIsolate current() {
        return LibGraalScope.current().getIsolate();
    }

    public synchronized <T> T getSingleton(Class<T> key, Supplier<T> supplier) {
        if (!this.singletons.containsKey(key)) {
            this.singletons.put(key, supplier.get());
        }
        return (T)this.singletons.get(key);
    }

    void register(LibGraalObject obj, long handle) {
        this.cleanHandles();
        Cleaner cref = new Cleaner(this.cleanersQueue, obj, handle);
        this.cleaners.add(cref);
    }

    private void cleanHandles() {
        Cleaner cleaner;
        while ((cleaner = (Cleaner)this.cleanersQueue.poll()) != null) {
            this.cleaners.remove(cleaner);
            if (cleaner.clean()) continue;
            new Exception(String.format("Error releasing handle %d in isolate 0x%x", cleaner.handle, this.address)).printStackTrace(System.out);
        }
    }

    static synchronized void remove(LibGraalIsolate isolate) {
        isolate.destroyed = true;
        LibGraalIsolate removed = isolates.remove(isolate.address);
        assert (removed == isolate) : "isolate already removed or overwritten: " + isolate;
    }

    public String toString() {
        return String.format("%s[0x%x]", this.getClass().getSimpleName(), this.address);
    }

    public boolean isValid() {
        return !this.destroyed;
    }

    private static final class Cleaner
    extends WeakReference<LibGraalObject> {
        private final long handle;

        Cleaner(ReferenceQueue<LibGraalObject> cleanersQueue, LibGraalObject referent, long handle) {
            super(referent, cleanersQueue);
            this.handle = handle;
        }

        boolean clean() {
            return LibGraalObject.releaseHandle(LibGraalScope.getIsolateThread(), this.handle);
        }
    }
}

