/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.graphio;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.graalvm.graphio.DefaultGraphBlocks;
import org.graalvm.graphio.DefaultGraphTypes;
import org.graalvm.graphio.GraphBlocks;
import org.graalvm.graphio.GraphElements;
import org.graalvm.graphio.GraphLocations;
import org.graalvm.graphio.GraphProtocol;
import org.graalvm.graphio.GraphStructure;
import org.graalvm.graphio.GraphTypes;
import org.graalvm.graphio.ProtocolImpl;

public final class GraphOutput<G, M>
implements Closeable,
WritableByteChannel {
    private final GraphProtocol<G, ?, ?, ?, ?, M, ?, ?, ?, ?> printer;
    public static final String ATTR_VM_ID = "vm.uuid";

    private GraphOutput(GraphProtocol<G, ?, ?, ?, ?, M, ?, ?, ?, ?> p) {
        this.printer = p;
    }

    public static <G, N, C, P> Builder<G, N, ?> newBuilder(GraphStructure<G, N, C, P> structure) {
        return new Builder(structure);
    }

    public void beginGroup(G forGraph, String name, String shortName, M method, int bci, Map<? extends Object, ? extends Object> properties) throws IOException {
        this.printer.beginGroup(forGraph, name, shortName, method, bci, properties);
    }

    public void print(G graph, Map<? extends Object, ? extends Object> properties, int id, String format, Object ... args) throws IOException {
        this.printer.print(graph, properties, id, format, args);
    }

    public void endGroup() throws IOException {
        this.printer.endGroup();
    }

    @Override
    public void close() {
        this.printer.close();
    }

    @Override
    public boolean isOpen() {
        return this.printer.isOpen();
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.printer.write(src);
    }

    private static final class StackLocations<M, P>
    implements GraphLocations<M, P, StackTraceElement> {
        private final GraphElements<M, ?, ?, P> graphElements;

        StackLocations(GraphElements<M, ?, ?, P> graphElements) {
            this.graphElements = graphElements;
        }

        @Override
        public Iterable<StackTraceElement> methodLocation(M method, int bci, P pos) {
            StackTraceElement ste = this.graphElements.methodStackTraceElement(method, bci, pos);
            return Collections.singleton(ste);
        }

        @Override
        public URI locationURI(StackTraceElement location) {
            String path = location.getFileName();
            try {
                return path == null ? null : new URI(null, null, path, null);
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException(ex);
            }
        }

        @Override
        public int locationLineNumber(StackTraceElement location) {
            return location.getLineNumber();
        }

        @Override
        public String locationLanguage(StackTraceElement location) {
            return "Java";
        }

        @Override
        public int locationOffsetStart(StackTraceElement location) {
            return -1;
        }

        @Override
        public int locationOffsetEnd(StackTraceElement location) {
            return -1;
        }
    }

    private static final class ElementsAndLocations<M, P, L> {
        final GraphElements<M, ?, ?, P> elements;
        final GraphLocations<M, P, L> locations;

        ElementsAndLocations(GraphElements<M, ?, ?, P> elements, GraphLocations<M, P, L> locations) {
            elements.getClass();
            locations.getClass();
            this.elements = elements;
            this.locations = locations;
        }
    }

    public static final class Builder<G, N, M> {
        private static final int DEFAULT_MAJOR_VERSION = 7;
        private static final int DEFAULT_MINOR_VERSION = 0;
        private final GraphStructure<G, N, ?, ?> structure;
        private ElementsAndLocations<M, ?, ?> elementsAndLocations;
        private GraphTypes types = DefaultGraphTypes.DEFAULT;
        private GraphBlocks<G, ?, N> blocks = DefaultGraphBlocks.empty();
        private int major = 0;
        private int minor = 0;
        private boolean explicitVersionSet;
        private boolean embeddedGraphOutput;
        private Map<String, Object> properties;

        Builder(GraphStructure<G, N, ?, ?> structure) {
            this.structure = structure;
        }

        public Builder<G, N, M> protocolVersion(int majorVersion, int minorVersion) {
            assert (majorVersion >= 1) : "Major must be positive";
            assert (minorVersion >= 0) : "Minor must not be negative";
            if (!(this.explicitVersionSet || majorVersion == 0 || majorVersion > this.major || majorVersion == this.major && minorVersion >= this.minor)) {
                throw new IllegalArgumentException("Cannot downgrade from minimum required version " + -this.major + "." + this.minor);
            }
            this.major = majorVersion;
            this.minor = minorVersion;
            this.explicitVersionSet = true;
            return this;
        }

        private void requireVersion(int reqMajor, int reqMinor) {
            assert (reqMajor >= 1) : "Major must be positive";
            assert (reqMinor >= 0) : "Minor must not be negative";
            if (this.explicitVersionSet) {
                if (this.major < reqMajor || this.major == reqMajor && this.minor < reqMinor) {
                    throw new IllegalStateException("Feature unsupported in version " + this.major + "." + this.minor);
                }
            } else if (this.major < reqMajor) {
                this.major = reqMajor;
                this.minor = reqMinor;
            } else if (this.major == reqMajor) {
                this.minor = Math.max(this.minor, reqMinor);
            }
        }

        public Builder<G, N, M> embedded(boolean embedded) {
            this.embeddedGraphOutput = embedded;
            return this;
        }

        public Builder<G, N, M> types(GraphTypes graphTypes) {
            this.types = graphTypes;
            return this;
        }

        public Builder<G, N, M> blocks(GraphBlocks<G, ?, N> graphBlocks) {
            this.blocks = graphBlocks;
            return this;
        }

        public <E, P> Builder<G, N, E> elements(GraphElements<E, ?, ?, P> graphElements) {
            StackLocations<E, P> loc = new StackLocations<E, P>(graphElements);
            return this.elementsAndLocations(graphElements, loc);
        }

        public <E, P> Builder<G, N, E> elementsAndLocations(GraphElements<E, ?, ?, P> graphElements, GraphLocations<E, P, ?> graphLocations) {
            ElementsAndLocations both = new ElementsAndLocations(graphElements, graphLocations);
            this.elementsAndLocations = both;
            return this;
        }

        public Builder<G, N, M> attr(String name, Object value) {
            this.requireVersion(7, 0);
            if (this.properties == null) {
                this.properties = new HashMap<String, Object>(5);
            }
            this.properties.put(name, value);
            return this;
        }

        public GraphOutput<G, M> build(WritableByteChannel channel) throws IOException {
            return this.buildImpl(this.elementsAndLocations, channel);
        }

        public GraphOutput<G, M> build(GraphOutput<?, ?> parent) {
            return this.buildImpl(this.elementsAndLocations, parent);
        }

        private <L, P> GraphOutput<G, M> buildImpl(ElementsAndLocations<M, L, P> e, WritableByteChannel channel) throws IOException {
            int m = this.major;
            int n = this.minor;
            if (m == 0) {
                m = 7;
                n = 0;
            }
            ProtocolImpl p = new ProtocolImpl(m, n, this.embeddedGraphOutput, this.structure, this.types, this.blocks, e == null ? null : e.elements, e == null ? null : e.locations, channel);
            if (this.properties != null) {
                p.startDocument(this.properties);
            }
            return new GraphOutput(p);
        }

        private <L, P> GraphOutput<G, M> buildImpl(ElementsAndLocations<M, L, P> e, GraphOutput<?, ?> parent) {
            ProtocolImpl p = new ProtocolImpl(((GraphOutput)parent).printer, this.structure, this.types, this.blocks, e == null ? null : e.elements, e == null ? null : e.locations);
            return new GraphOutput(p);
        }
    }
}

